/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.Response;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.tools.SerializationUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.UniqueID;
import com.uwyn.rife.tools.UniqueIDGenerator;
import com.uwyn.rife.tools.exceptions.SerializationUtilsErrorException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StateStoreSession
implements StateStore {
    static final String IDENTIFIER = "session";

    StateStoreSession() {
    }

    @Override
    public String exportQueryUrl(String url, HashMap<String, String[]> parameters, Request request, Response response, ElementInfo source, String type, String name) {
        StringBuffer query_parameters;
        HttpSession session = request.getHttpServletRequest().getSession();
        if (0 == parameters.size()) {
            return response.getHttpServletResponse().encodeURL(url);
        }
        UniqueID id = UniqueIDGenerator.generate(request.getHttpServletRequest().getRemoteAddr());
        try {
            session.setAttribute(id.toString(), (Object)SerializationUtils.serializeToString(parameters));
        }
        catch (SerializationUtilsErrorException e) {
            throw new EngineException(e);
        }
        StringBuffer stringBuffer = query_parameters = new StringBuffer("?");
        synchronized (stringBuffer) {
            query_parameters.append("stateid");
            query_parameters.append("=");
            query_parameters.append(StringUtils.encodeUrlValue(id.toString()));
        }
        return response.getHttpServletResponse().encodeURL(new StringBuffer().append(url).append(query_parameters.toString()).toString());
    }

    @Override
    public String exportFormParameters(HashMap<String, String[]> parameters, Request request, Response response) {
        StringBuffer form_parameters;
        HttpSession session = request.getHttpServletRequest().getSession();
        if (0 == parameters.size()) {
            return "";
        }
        UniqueID id = UniqueIDGenerator.generate(request.getHttpServletRequest().getRemoteAddr());
        try {
            session.setAttribute(id.toString(), (Object)SerializationUtils.serializeToString(parameters));
        }
        catch (SerializationUtilsErrorException e) {
            throw new EngineException(e);
        }
        StringBuffer stringBuffer = form_parameters = new StringBuffer();
        synchronized (stringBuffer) {
            form_parameters.append("<input name=\"");
            form_parameters.append(StringUtils.encodeHtml("stateid"));
            form_parameters.append("\" type=\"hidden\" value=\"");
            form_parameters.append(StringUtils.encodeHtml(id.toString()));
            form_parameters.append("\" />");
        }
        return form_parameters.toString();
    }

    @Override
    public Map<String, String[]> restoreParameters(Request request) {
        String[] value = request.getParameters().get("stateid");
        if (value == null || 0 == value.length) {
            return null;
        }
        String state_id = value[0];
        HttpSession session = request.getHttpServletRequest().getSession(false);
        if (session == null) {
            return null;
        }
        String serialized_state = (String)session.getAttribute(state_id);
        if (serialized_state == null) {
            return null;
        }
        try {
            HashMap result = (HashMap)SerializationUtils.deserializeFromString(serialized_state);
            String[] values = null;
            for (Map.Entry entry : (Collection)request.getParameters().entrySet()) {
                values = (String[])entry.getValue();
                if (values == null || values.length <= 1 && (values[0] == null || values[0].trim().length() <= 0)) continue;
                result.put((String)entry.getKey(), values);
            }
            return result;
        }
        catch (SerializationUtilsErrorException e) {
            throw new EngineException(e);
        }
    }

    @Override
    public String exportFormUrl(String url, Request request, Response response) {
        return response.getHttpServletResponse().encodeURL(url);
    }
}

