/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.Response;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.StateStoreFactory;
import com.uwyn.rife.tools.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StateStoreQuery
implements StateStore {
    static final int MAX_URL_LENGTH = 2048;
    static final String IDENTIFIER = "query";

    StateStoreQuery() {
    }

    @Override
    public String exportQueryUrl(String url, HashMap<String, String[]> parameters, Request request, Response response, ElementInfo source, String type, String name) {
        StringBuffer query_parameters;
        if (0 == parameters.size()) {
            return url;
        }
        StringBuffer stringBuffer = query_parameters = new StringBuffer("?");
        synchronized (stringBuffer) {
            Iterator<String> parameter_names_it = parameters.keySet().iterator();
            String parameter_name = null;
            String[] parameter_values = null;
            while (parameter_names_it.hasNext()) {
                parameter_name = parameter_names_it.next();
                parameter_values = parameters.get(parameter_name);
                int i = 0;
                while (i < parameter_values.length) {
                    query_parameters.append(StringUtils.encodeUrlValue(parameter_name));
                    query_parameters.append("=");
                    query_parameters.append(StringUtils.encodeUrlValue(parameter_values[i]));
                    if (i + 1 < parameter_values.length) {
                        query_parameters.append("&");
                    }
                    ++i;
                }
                if (!parameter_names_it.hasNext()) continue;
                query_parameters.append("&");
            }
        }
        String result = new StringBuffer().append(url).append(query_parameters.toString()).toString();
        if (result.length() <= 2048) {
            return result;
        }
        Logger.getLogger("com.uwyn.rife.engine").warning(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The ").append(type).toString()).append(" '").toString()).append(name).toString()).append("' of element '").toString()).append(source.getId()).toString()).append("' generated an URL whose length of ").toString()).append(result.length()).toString()).append(" exceeds the maximum length of ").toString()).append(2048).toString()).append(" bytes, using session state store instead. The generated URL was '").toString()).append(result).toString()).append("'.").toString());
        return StateStoreFactory.getInstance("session").exportQueryUrl(url, parameters, request, response, source, type, name);
    }

    @Override
    public String exportFormParameters(HashMap<String, String[]> parameters, Request request, Response response) {
        StringBuffer form_parameters;
        if (0 == parameters.size()) {
            return "";
        }
        StringBuffer stringBuffer = form_parameters = new StringBuffer();
        synchronized (stringBuffer) {
            String[] parameter_values = null;
            for (String parameter_name : (Collection)parameters.keySet()) {
                String[] stringArray = parameter_values = parameters.get(parameter_name);
                int n = 0;
                while (n < stringArray.length) {
                    String parameter_value = stringArray[n];
                    form_parameters.append("<input name=\"");
                    form_parameters.append(StringUtils.encodeHtml(parameter_name));
                    form_parameters.append("\" type=\"hidden\" value=\"");
                    form_parameters.append(StringUtils.encodeHtml(parameter_value));
                    form_parameters.append("\" />");
                    ++n;
                }
            }
        }
        return form_parameters.toString();
    }

    @Override
    public Map<String, String[]> restoreParameters(Request request) {
        if (request.getParameters().containsKey("stateid")) {
            return StateStoreFactory.getInstance("session").restoreParameters(request);
        }
        return null;
    }

    @Override
    public String exportFormUrl(String url, Request request, Response response) {
        return url;
    }
}

