/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ContinuationManager;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.exceptions.DuplicateElementIdException;
import com.uwyn.rife.engine.exceptions.ElementIdNotFoundException;
import com.uwyn.rife.engine.exceptions.FallbackUrlExistsException;
import com.uwyn.rife.engine.exceptions.UrlExistsException;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Site {
    private String mDeclarationName = null;
    private HashMap<String, ElementInfo> mUrlMapping = new HashMap();
    private HashMap<String, ElementInfo> mPathinfoUrlMapping = new HashMap();
    private ArrayList<String> mUrls = null;
    private HashMap<String, ElementInfo> mFallbackUrlMapping = new HashMap();
    private HashMap<String, ElementInfo> mIdMapping = new HashMap();
    private ContinuationManager mContinuationManager = new ContinuationManager();
    private ResourceFinder mResourceFinder = null;
    private HashMap<URL, Long> mResourceModificationTimes = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    Site() {
    }

    void setDeclarationName(String declarationName) {
        if (!$assertionsDisabled && declarationName == null) {
            throw new AssertionError();
        }
        this.mDeclarationName = declarationName;
    }

    void setResourceFinder(ResourceFinder resourceFinder) {
        if (!$assertionsDisabled && resourceFinder == null) {
            throw new AssertionError();
        }
        this.mResourceFinder = resourceFinder;
    }

    void addResourceModificationTime(URL location, long modificationTime) {
        if (this.mResourceModificationTimes == null) {
            this.mResourceModificationTimes = new HashMap();
        }
        this.mResourceModificationTimes.put(location, new Long(modificationTime));
    }

    private boolean isModified() {
        if (this.mResourceModificationTimes != null) {
            long current_modification_time = 0;
            for (Map.Entry resource_entry : (Collection)this.mResourceModificationTimes.entrySet()) {
                try {
                    current_modification_time = this.mResourceFinder.getModificationTime((URL)resource_entry.getKey());
                }
                catch (ResourceFinderErrorException e) {
                    return false;
                }
                if ((Long)resource_entry.getValue() == current_modification_time) continue;
                return true;
            }
        }
        return false;
    }

    private void checkModification() {
        if (this.mResourceModificationTimes != null) {
            Site site = this;
            synchronized (site) {
                if (this.isModified()) {
                    SiteBuilder builder = new SiteBuilder(this.mDeclarationName, this.mResourceFinder);
                    Site new_site = null;
                    new_site = builder.getSite();
                    this.mUrlMapping = new_site.mUrlMapping;
                    this.mPathinfoUrlMapping = new_site.mPathinfoUrlMapping;
                    this.mFallbackUrlMapping = new_site.mFallbackUrlMapping;
                    this.mIdMapping = new_site.mIdMapping;
                    this.mResourceFinder = new_site.mResourceFinder;
                    this.mResourceModificationTimes = new_site.mResourceModificationTimes;
                }
            }
        }
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantSite");
    }

    public static Site getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantSite");
        if (participant == null) {
            return null;
        }
        return (Site)participant.getObject();
    }

    ContinuationManager getContinuationManager() {
        return this.mContinuationManager;
    }

    void addElementInfo(String id, ElementInfo elementInfo, String url) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        if (this.mIdMapping.containsKey(id)) {
            throw new DuplicateElementIdException(id);
        }
        elementInfo.setId(id);
        this.mIdMapping.put(id, elementInfo);
        elementInfo.setSite(this);
        if (url != null) {
            if (0 == url.length()) {
                url = "/";
            }
            elementInfo.setUrl(url);
            this.mapElementId(id, url);
        }
    }

    void mapElementId(String id, String url) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        ElementInfo element_info = this.mIdMapping.get(id);
        if (element_info == null) {
            throw new ElementIdNotFoundException(id);
        }
        if (0 == url.length()) {
            url = "/";
        }
        this.mUrls = null;
        if (element_info.isPathInfoUsed()) {
            if (this.mPathinfoUrlMapping.containsKey(url)) {
                throw new UrlExistsException(id, url, this.mPathinfoUrlMapping.get(url).getId());
            }
            this.mPathinfoUrlMapping.put(url, element_info);
        } else {
            if (this.mUrlMapping.containsKey(url)) {
                throw new UrlExistsException(id, url, this.mUrlMapping.get(url).getId());
            }
            this.mUrlMapping.put(url, element_info);
        }
    }

    void addFallback(ElementInfo elementInfo, String url) {
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        if (url != null) {
            if (this.mFallbackUrlMapping.containsKey(url)) {
                throw new FallbackUrlExistsException(url);
            }
            this.mFallbackUrlMapping.put(url, elementInfo);
        }
    }

    public ElementInfo searchFallback(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null;");
        }
        this.checkModification();
        String best_match = null;
        if (0 == url.length()) {
            url = "/";
        }
        for (String fallback_url : (Collection)this.mFallbackUrlMapping.keySet()) {
            if (!url.startsWith(fallback_url) || best_match != null && fallback_url.length() <= best_match.length()) continue;
            best_match = fallback_url;
        }
        if (best_match != null) {
            return this.mFallbackUrlMapping.get(best_match);
        }
        return null;
    }

    public boolean containsUrl(String url) {
        String stripped_url;
        if (url == null) {
            throw new IllegalArgumentException("url can't be null;");
        }
        this.checkModification();
        if (0 == url.length()) {
            url = "/";
        }
        if (this.mUrlMapping.containsKey(url)) {
            return true;
        }
        if (url.length() > 0 && '/' == url.charAt(url.length() - 1) && (stripped_url = url.substring(0, url.length() - 1)).lastIndexOf(46) <= stripped_url.lastIndexOf(47) && this.mUrlMapping.containsKey(stripped_url)) {
            return true;
        }
        return this.mPathinfoUrlMapping.containsKey(url);
    }

    public ElementInfo resolveUrl(String url) {
        String stripped_url;
        ElementInfo result;
        if (url == null) {
            throw new IllegalArgumentException("url can't be null;");
        }
        this.checkModification();
        if (0 == url.length()) {
            url = "/";
        }
        if ((result = this.mUrlMapping.get(url)) != null) {
            return result;
        }
        if (url.length() > 0 && '/' == url.charAt(url.length() - 1) && (stripped_url = url.substring(0, url.length() - 1)).lastIndexOf(46) <= stripped_url.lastIndexOf(47) && (result = this.mUrlMapping.get(stripped_url)) != null) {
            return result;
        }
        result = this.mPathinfoUrlMapping.get(url);
        if (result != null) {
            return result;
        }
        return null;
    }

    public ElementInfo resolvePathInfoUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null;");
        }
        this.checkModification();
        if (0 == url.length()) {
            url = "/";
        }
        return this.mPathinfoUrlMapping.get(url);
    }

    public Collection<String> getUrls() {
        if (this.mUrls == null) {
            ArrayList<String> urls = new ArrayList<String>(this.mUrlMapping.keySet());
            urls.addAll(this.mPathinfoUrlMapping.keySet());
            this.mUrls = urls;
        }
        return this.mUrls;
    }

    public boolean containsId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        if (0 == id.length()) {
            throw new IllegalArgumentException("id can't be empty.");
        }
        return this.mIdMapping.containsKey(id);
    }

    public ElementInfo resolveId(String id) {
        return this.resolveId(id, null);
    }

    public ElementInfo resolveId(String id, ElementInfo reference) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        if (0 == id.length()) {
            throw new IllegalArgumentException("id can't be empty.");
        }
        this.checkModification();
        String absolute_id = Site.getCanonicalId(Site.getAbsoluteId(id, reference));
        return this.mIdMapping.get(absolute_id);
    }

    public static String getAbsoluteId(String id, ElementInfo reference) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        if (0 == id.length()) {
            throw new IllegalArgumentException("id can't be empty.");
        }
        if (!id.startsWith(".")) {
            StringBuffer absolute_id;
            if (reference == null) {
                throw new IllegalArgumentException("reference can't be null for a relative element id.");
            }
            String path_id = reference.getId().substring(0, reference.getId().lastIndexOf(".") + 1);
            StringBuffer stringBuffer = absolute_id = new StringBuffer(path_id);
            synchronized (stringBuffer) {
                absolute_id.append(id);
                id = absolute_id.toString();
            }
        }
        return id;
    }

    public static String getCanonicalId(String id) {
        StringBuffer canonical_id;
        if (id == null) {
            return null;
        }
        StringBuffer stringBuffer = canonical_id = new StringBuffer();
        synchronized (stringBuffer) {
            StringTokenizer id_tok = new StringTokenizer(id, ".^", true);
            String token = null;
            int seperator_index = -1;
            while (id_tok.hasMoreTokens()) {
                token = id_tok.nextToken();
                if (token.equals(".")) continue;
                if (token.equals("^")) {
                    seperator_index = canonical_id.lastIndexOf(".");
                    if (seperator_index == -1) continue;
                    canonical_id.setLength(seperator_index);
                    continue;
                }
                canonical_id.append(".");
                canonical_id.append(token);
            }
            if (id.endsWith(".")) {
                canonical_id.append(".");
            }
            return canonical_id.toString();
        }
    }

    public Collection<String> getIds() {
        return this.mIdMapping.keySet();
    }

    Collection<ElementInfo> getElementInfos() {
        return this.mIdMapping.values();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.Site");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

