/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.asm.AnnotationVisitor;
import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.Label;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.asm.Opcodes;
import com.uwyn.rife.engine.ContinuationDebug;
import com.uwyn.rife.engine.TypesClassVisitor;
import com.uwyn.rife.engine.TypesContext;
import com.uwyn.rife.tools.StringUtils;
import java.util.Stack;
import java.util.logging.Level;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResumableMethodAdapter
implements MethodVisitor,
Opcodes {
    private TypesClassVisitor mTypes = null;
    private MethodVisitor mMethodVisitor = null;
    private String mClassName = null;
    private String mClassNameInternal = null;
    private boolean mVisit = false;
    private boolean mAdapt = false;
    private int mContextIndex = -1;
    private int mCallNameIndex = -1;
    private int mTempIndex = -1;
    private Label mDefaultLabel = null;
    private Label mRethrowLabel = null;
    private boolean mUseRethrowLabel = false;
    private Label[] mLabels = null;
    private int mLabelIndex = 0;
    private int mMaxLocalIndex = 0;
    private TypesContext mLabelContext = null;
    private boolean mDisableCodeguideBackInTime = false;
    private boolean mDisabledCodeguideBackInTime = false;

    private void debugMessage(String message) {
    }

    ResumableMethodAdapter(TypesClassVisitor types, MethodVisitor methodVisitor, String className, boolean adapt, int maxLocals, int pauseCount) {
        this.mTypes = types;
        this.mMethodVisitor = methodVisitor;
        this.mClassName = className;
        if (className != null) {
            this.mClassNameInternal = this.mClassName.replace('.', '/');
        }
        this.mVisit = this.mMethodVisitor != null;
        this.mAdapt = adapt;
        this.mContextIndex = maxLocals;
        this.mCallNameIndex = this.mContextIndex + 1;
        this.mTempIndex = this.mCallNameIndex + 1;
        if (this.mAdapt) {
            if (pauseCount > 0) {
                this.mDefaultLabel = new Label();
                this.mRethrowLabel = new Label();
                this.mLabels = new Label[pauseCount];
                int i = 0;
                while (i < pauseCount) {
                    this.mLabels[i] = new Label();
                    ++i;
                }
            }
            this.debugMessage("CONT: context initializing");
            this.mMethodVisitor.visitMethodInsn(184, "com/uwyn/rife/engine/ContinuationContext", "getContext", "()Lcom/uwyn/rife/engine/ContinuationContext;");
            this.mMethodVisitor.visitVarInsn(58, this.mContextIndex);
            this.debugMessage("CONT: context set up");
            if (pauseCount > 0) {
                this.debugMessage("CONT: context obtain label");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLabel", "()I");
                this.debugMessage("CONT: evaluate tableswitch");
                this.mMethodVisitor.visitTableSwitchInsn(0, pauseCount - 1, this.mDefaultLabel, this.mLabels);
                this.mMethodVisitor.visitLabel(this.mDefaultLabel);
                this.debugMessage("CONT: begin of code");
            }
        }
    }

    private void addIntegerConst(int value) {
        switch (value) {
            case 0: {
                this.mMethodVisitor.visitInsn(3);
                break;
            }
            case 1: {
                this.mMethodVisitor.visitInsn(4);
                break;
            }
            case 2: {
                this.mMethodVisitor.visitInsn(5);
                break;
            }
            case 3: {
                this.mMethodVisitor.visitInsn(6);
                break;
            }
            case 4: {
                this.mMethodVisitor.visitInsn(7);
                break;
            }
            case 5: {
                this.mMethodVisitor.visitInsn(8);
                break;
            }
            default: {
                this.mMethodVisitor.visitLdcInsn(new Integer(value));
                break;
            }
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitVarInsn            (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", ").toString()).append(var).toString()).append(")").toString());
        }
        if (this.mAdapt) {
            this.mMethodVisitor.visitVarInsn(opcode, var);
            if (this.mLabelContext != null && 1 == this.mLabelContext.getSort() && 58 == opcode) {
                Label label = new Label();
                this.mMethodVisitor.visitVarInsn(25, var);
                this.mMethodVisitor.visitTypeInsn(193, "com/uwyn/rife/engine/exceptions/PauseException");
                this.mMethodVisitor.visitJumpInsn(153, label);
                this.mMethodVisitor.visitVarInsn(25, var);
                this.mMethodVisitor.visitJumpInsn(167, this.mRethrowLabel);
                this.mMethodVisitor.visitLabel(label);
                this.mUseRethrowLabel = true;
            }
            if (opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58) {
                if (var > this.mMaxLocalIndex) {
                    this.mMaxLocalIndex = var;
                }
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.addIntegerConst(var);
                switch (opcode) {
                    case 54: {
                        this.mMethodVisitor.visitVarInsn(21, var);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "storeInt", "(II)V");
                        break;
                    }
                    case 55: {
                        this.mMethodVisitor.visitVarInsn(22, var);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "storeLong", "(IJ)V");
                        break;
                    }
                    case 56: {
                        this.mMethodVisitor.visitVarInsn(23, var);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "storeFloat", "(IF)V");
                        break;
                    }
                    case 57: {
                        this.mMethodVisitor.visitVarInsn(24, var);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "storeDouble", "(ID)V");
                        break;
                    }
                    case 58: {
                        this.mMethodVisitor.visitVarInsn(25, var);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "storeReference", "(ILjava/lang/Object;)V");
                        break;
                    }
                }
            }
            if (this.mLabelContext != null && 1 == this.mLabelContext.getSort() && 58 == opcode) {
                this.restoreLocalStack(this.mLabelContext);
                this.mLabelContext.setSort(0);
            }
        } else if (this.mVisit) {
            this.mMethodVisitor.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        String owner_classname;
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitMethodInsn         (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", \"").toString()).append(owner).toString()).append("\", \"").toString()).append(name).toString()).append("\", \"").toString()).append(desc).toString()).append("\")").toString());
        }
        if (this.mAdapt && ("com.uwyn.rife.engine.ElementSupport".equals(owner_classname = owner.replace('/', '.')) || this.mClassName.equals(owner_classname))) {
            if ("pause".equals(name) && "()V".equals(desc)) {
                this.debugMessage("CONT: pause : undoing method call");
                this.mMethodVisitor.visitInsn(87);
                TypesContext context = this.mTypes.nextPauseContext();
                Stack<String> stack = context.getStackClone();
                this.debugMessage("CONT: pause : saving operand stack");
                this.saveOperandStack(stack);
                this.debugMessage("CONT: pause : storing resume label");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.addIntegerConst(this.mLabelIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "setLabel", "(I)V");
                this.debugMessage("CONT: pause : throwing pause exception");
                this.mMethodVisitor.visitTypeInsn(187, "com/uwyn/rife/engine/exceptions/PauseException");
                this.mMethodVisitor.visitInsn(89);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(183, "com/uwyn/rife/engine/exceptions/PauseException", "<init>", "(Lcom/uwyn/rife/engine/ContinuationContext;)V");
                this.mMethodVisitor.visitInsn(191);
                this.mMethodVisitor.visitLabel(this.mLabels[this.mLabelIndex]);
                this.debugMessage("CONT: pause : resumed execution");
                this.debugMessage("CONT: pause : restoring local stack");
                this.restoreLocalStack(context);
                this.debugMessage("CONT: pause : restoring operand stack");
                this.restoreOperandStack(stack);
                ++this.mLabelIndex;
                return;
            }
            if ("call".equals(name) && "(Ljava/lang/String;)Ljava/lang/Object;".equals(desc)) {
                this.debugMessage("CONT: call : storing exit name");
                this.mMethodVisitor.visitVarInsn(58, this.mCallNameIndex);
                this.debugMessage("CONT: call : undoing method call");
                this.mMethodVisitor.visitInsn(87);
                TypesContext context = this.mTypes.nextPauseContext();
                Stack<String> stack = context.getStackClone();
                stack.pop();
                this.debugMessage("CONT: call : saving operand stack");
                this.saveOperandStack(stack);
                this.debugMessage("CONT: call : storing resume label");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.addIntegerConst(this.mLabelIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "setLabel", "(I)V");
                this.debugMessage("CONT: call : throwing call exception");
                this.mMethodVisitor.visitTypeInsn(187, "com/uwyn/rife/engine/exceptions/CallException");
                this.mMethodVisitor.visitInsn(89);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mCallNameIndex);
                this.mMethodVisitor.visitMethodInsn(183, "com/uwyn/rife/engine/exceptions/CallException", "<init>", "(Lcom/uwyn/rife/engine/ContinuationContext;Ljava/lang/String;)V");
                this.mMethodVisitor.visitInsn(191);
                this.mMethodVisitor.visitLabel(this.mLabels[this.mLabelIndex]);
                this.debugMessage("CONT: call : resumed execution");
                this.debugMessage("CONT: call : restoring local stack");
                this.restoreLocalStack(context);
                this.debugMessage("CONT: call : restoring operand stack");
                this.restoreOperandStack(stack);
                this.debugMessage("CONT: call : retrieving call answer");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getCallAnswer", "()Ljava/lang/Object;");
                ++this.mLabelIndex;
                return;
            }
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private void restoreLocalStack(TypesContext context) {
        int i = 1;
        while (i <= this.mMaxLocalIndex) {
            if (context.hasVar(i)) {
                switch (context.getVarType(i)) {
                    case 5: {
                        this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore local : ").append(i).toString()).append(", int").toString());
                        this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                        this.addIntegerConst(i);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "getInt", "(I)I");
                        this.mMethodVisitor.visitVarInsn(54, i);
                        break;
                    }
                    case 6: {
                        this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore local : ").append(i).toString()).append(", float").toString());
                        this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                        this.addIntegerConst(i);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "getFloat", "(I)F");
                        this.mMethodVisitor.visitVarInsn(56, i);
                        break;
                    }
                    case 10: {
                        this.debugMessage(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("CONT: restore local : ").append(i).toString()).append(", ").toString()).append(context.getVar(i)).toString()).append("").toString());
                        String type = context.getVar(i);
                        if ("NULL" == type) {
                            this.mMethodVisitor.visitInsn(1);
                            this.mMethodVisitor.visitVarInsn(58, i);
                            break;
                        }
                        this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                        this.addIntegerConst(i);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "getReference", "(I)Ljava/lang/Object;");
                        this.mMethodVisitor.visitTypeInsn(192, type);
                        this.mMethodVisitor.visitVarInsn(58, i);
                        break;
                    }
                }
            }
            ++i;
        }
        i = 1;
        while (i <= this.mMaxLocalIndex) {
            if (context.hasVar(i)) {
                switch (context.getVarType(i)) {
                    case 7: {
                        this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore local : ").append(i).toString()).append(", long").toString());
                        this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                        this.addIntegerConst(i);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "getLong", "(I)J");
                        this.mMethodVisitor.visitVarInsn(55, i);
                        break;
                    }
                    case 8: {
                        this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore local : ").append(i).toString()).append(", double").toString());
                        this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                        this.addIntegerConst(i);
                        this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "getDouble", "(I)D");
                        this.mMethodVisitor.visitVarInsn(57, i);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void saveOperandStack(Stack<String> stack) {
        String tupe = null;
        int i = stack.size() - 1;
        while (i >= 0) {
            tupe = (String)stack.get(i);
            if (tupe.equals("1Z") || tupe.equals("1C") || tupe.equals("1B") || tupe.equals("1S") || tupe.equals("1I")) {
                this.mMethodVisitor.visitVarInsn(54, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(21, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "pushInt", "(I)V");
            } else if (tupe.equals("1F")) {
                this.mMethodVisitor.visitVarInsn(56, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(23, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "pushFloat", "(F)V");
            } else if (tupe.equals("2D")) {
                this.mMethodVisitor.visitVarInsn(57, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(24, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "pushDouble", "(D)V");
            } else if (tupe.equals("2J")) {
                this.mMethodVisitor.visitVarInsn(55, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(22, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "pushLong", "(J)V");
            } else {
                if (tupe.equals("1A")) {
                    throw new RuntimeException("Invalid local stack type");
                }
                this.mMethodVisitor.visitVarInsn(58, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(25, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "pushReference", "(Ljava/lang/Object;)V");
            }
            --i;
        }
    }

    private void restoreOperandStack(Stack<String> stack) {
        String type = null;
        int i = 0;
        while (i < stack.size()) {
            type = (String)stack.get(i);
            if (type.equals("1Z") || type.equals("1C") || type.equals("1B") || type.equals("1S") || type.equals("1I")) {
                this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore operand : ").append(i).toString()).append(", int").toString());
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "popInt", "()I");
            } else if (type.equals("1F")) {
                this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore operand : ").append(i).toString()).append(", float").toString());
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "popFloat", "()F");
            } else if (type.equals("2D")) {
                this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore operand : ").append(i).toString()).append(", double").toString());
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "popDouble", "()D");
            } else if (type.equals("2J")) {
                this.debugMessage(new StringBuffer().append(new StringBuffer().append("CONT: restore operand : ").append(i).toString()).append(", long").toString());
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "popLong", "()J");
            } else {
                if (type.equals("1A")) {
                    throw new RuntimeException("Invalid local stack type");
                }
                this.debugMessage(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("CONT: restore operand : ").append(i).toString()).append(", ").toString()).append(type).toString());
                if ("NULL" == type) {
                    this.mMethodVisitor.visitInsn(1);
                    this.mMethodVisitor.visitVarInsn(58, i);
                } else {
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalStack", "()Lcom/uwyn/rife/engine/ContinuationStack;");
                    this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "popReference", "()Ljava/lang/Object;");
                    this.mMethodVisitor.visitTypeInsn(192, type);
                }
            }
            ++i;
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitTypeInsn           (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", \"").toString()).append(desc).toString()).append("\")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTypeInsn(opcode, desc);
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(" Code:visitLdcInsn            (").append(cst).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLdcInsn(cst);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitMultiANewArrayInsn (\"").append(desc).toString()).append("\", ").toString()).append(dims).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMultiANewArrayInsn(desc, dims);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(" Code:visitInsn               (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(")").toString());
        }
        if (this.mAdapt && 177 == opcode) {
            this.debugMessage("CONT: context removal");
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "remove", "()V");
            this.mMethodVisitor.visitInsn(opcode);
            if (this.mUseRethrowLabel) {
                this.mMethodVisitor.visitLabel(this.mRethrowLabel);
                this.debugMessage("CONT: rethrowing exception");
                this.mMethodVisitor.visitInsn(191);
            }
        } else if (this.mVisit) {
            this.mMethodVisitor.visitInsn(opcode);
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitIincInsn           (").append(var).toString()).append(", ").toString()).append(increment).toString()).append(")").toString());
        }
        if (this.mAdapt) {
            this.mMethodVisitor.visitIincInsn(var, increment);
            if (var > this.mMaxLocalIndex) {
                this.mMaxLocalIndex = var;
            }
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationContext", "getLocalVars", "()Lcom/uwyn/rife/engine/ContinuationStack;");
            this.addIntegerConst(var);
            this.addIntegerConst(increment);
            this.mMethodVisitor.visitMethodInsn(182, "com/uwyn/rife/engine/ContinuationStack", "incrementInt", "(II)V");
        } else if (this.mVisit) {
            this.mMethodVisitor.visitIincInsn(var, increment);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitFieldInsn          (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", \"").toString()).append(owner).toString()).append("\", \"").toString()).append(name).toString()).append("\", \"").toString()).append(desc).toString()).append("\")").toString());
        }
        if (this.mAdapt && !this.mDisabledCodeguideBackInTime && opcode == 178 && this.mClassNameInternal.equals(owner) && name.startsWith("debugEnabled$") && "Z".equals(desc)) {
            this.mDisableCodeguideBackInTime = true;
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitIntInsn            (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", ").toString()).append(operand).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitIntInsn(opcode, operand);
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitTryCatchBlock      (").append(start).toString()).append(", ").toString()).append(end).toString()).append(", ").toString()).append(handler).toString()).append(", \"").toString()).append(type).toString()).append("\")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTryCatchBlock(start, end, handler, type);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitLookupSwitchInsn   (").append(dflt).toString()).append(", ").toString()).append(keys == null ? null : StringUtils.join(keys, ",")).toString()).append(", ").toString()).append(labels == null ? null : StringUtils.join(labels, ",")).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitJumpInsn           (").append(ContinuationDebug.OPCODES[opcode]).toString()).append(", ").toString()).append(label).toString()).append(")").toString());
        }
        if (this.mAdapt && this.mDisableCodeguideBackInTime && opcode == 153) {
            this.mMethodVisitor.visitInsn(87);
            this.mMethodVisitor.visitJumpInsn(167, label);
            this.mDisableCodeguideBackInTime = false;
            this.mDisabledCodeguideBackInTime = true;
        } else if (this.mVisit) {
            this.mMethodVisitor.visitJumpInsn(opcode, label);
        }
    }

    @Override
    public void visitLabel(Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(" Code:visitLabel              (").append(label).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLabel(label);
        }
        if (this.mAdapt) {
            this.mLabelContext = this.mTypes.nextLabelTypes();
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitTableSwitchInsn    (").append(min).toString()).append(", ").toString()).append(max).toString()).append(", ").toString()).append(dflt).toString()).append(", ").toString()).append(labels == null ? null : StringUtils.join(labels, ",")).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitMaxs               (").append(maxStack).toString()).append(", ").toString()).append(maxLocals).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMaxs(maxStack, maxLocals);
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitLocalVariable      (\"").append(name).toString()).append("\", \"").toString()).append(desc).toString()).append(", \"").toString()).append(signature).toString()).append("\", ").toString()).append(start).toString()).append(", ").toString()).append(end).toString()).append(", ").toString()).append(index).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitLineNumber         (").append(line).toString()).append(", ").toString()).append(start).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLineNumber(line, start);
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(" Code:visitAttribute          (").append(attr).toString()).append(")").toString());
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitAttribute(attr);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitAnnotationDefault  ()");
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitAnnotationDefault();
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitAnnotation         (\"").append(desc).toString()).append("\", ").toString()).append(visible).toString()).append(")").toString());
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitAnnotation(desc, visible);
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(" Code:visitAnnotation         (").append(parameter).toString()).append(", \"").toString()).append(desc).toString()).append("\", ").toString()).append(visible).toString()).append(")").toString());
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitParameterAnnotation(parameter, desc, visible);
        }
        return null;
    }

    @Override
    public void visitEnd() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitEnd                ()");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitEnd();
        }
    }
}

