/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.asm.AnnotationVisitor;
import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.ClassVisitor;
import com.uwyn.rife.asm.FieldVisitor;
import com.uwyn.rife.asm.MethodAdapter;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.engine.ContinuationDebug;
import com.uwyn.rife.engine.MetricsClassVisitor;
import com.uwyn.rife.engine.ResumableMethodAdapter;
import com.uwyn.rife.engine.TypesClassVisitor;
import com.uwyn.rife.tools.StringUtils;
import java.util.logging.Level;

class ResumableClassAdapter
implements ClassVisitor {
    private MetricsClassVisitor mMetrics = null;
    private TypesClassVisitor mTypes = null;
    private String mClassName = null;
    private String mEntryMethod = null;
    private ClassVisitor mClassVisitor = null;
    private boolean mAdapt = false;

    ResumableClassAdapter(MetricsClassVisitor metrics, TypesClassVisitor types, String className, String entryMethod, ClassVisitor classVisitor) {
        this.mMetrics = metrics;
        this.mTypes = types;
        this.mClassName = className;
        this.mEntryMethod = entryMethod;
        this.mClassVisitor = classVisitor;
        this.mAdapt = classVisitor != null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visit                   (" + access + ", \"" + name + "\", \"" + signature + "\", \"" + superName + "\", " + (interfaces == null ? null : StringUtils.join(interfaces, ",")) + ")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visit(version, access, name, signature, superName, interfaces);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitField              (" + access + ", \"" + name + "\", \"" + desc + "\", " + signature + ", " + value + ")");
        }
        if (this.mAdapt) {
            return this.mClassVisitor.visitField(access, name, desc, signature, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitMethod             (" + access + ", \"" + name + "\", \"" + desc + "\", \"" + signature + "\", " + (exceptions == null ? null : StringUtils.join(exceptions, ",")) + ")");
        }
        if (this.mEntryMethod.equals(name + desc)) {
            if (this.mAdapt) {
                int pause_count = this.mMetrics.getPauseCount();
                if (0 == pause_count) {
                    return new ResumableMethodAdapter(null, this.mClassVisitor.visitMethod(access, name, desc, signature, exceptions), this.mClassName, false, -1, 0);
                }
                return new ResumableMethodAdapter(this.mTypes, this.mClassVisitor.visitMethod(access, name, desc, signature, exceptions), this.mClassName, true, this.mMetrics.getMaxLocals(), pause_count);
            }
            return new ResumableMethodAdapter(null, null, null, false, -1, 0);
        }
        if (this.mClassVisitor == null) {
            return null;
        }
        return new MethodAdapter(this.mClassVisitor.visitMethod(access, name, desc, signature, exceptions));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitInnerClass         (\"" + name + "\", \"" + outerName + "\", \"" + innerName + ", " + access + ")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public void visitAttribute(Attribute attr) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitAttribute          (" + attr + ")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitAttribute(attr);
        }
    }

    public void visitSource(String source, String debug) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitSource             (\"" + source + "\", \"" + debug + "\")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitSource(source, debug);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitOuterClass         (\"" + owner + "\", \"" + name + "\", \"" + desc + "\")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitOuterClass(owner, name, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitAnnotation         (\"" + desc + "\", " + visible + ")");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitAnnotation(desc, visible);
        }
        return null;
    }

    public void visitEnd() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("Class:visitEnd                ()");
        }
        if (this.mAdapt) {
            this.mClassVisitor.visitEnd();
        }
    }
}

