/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.MultipartRequest;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.UploadedFile;
import com.uwyn.rife.tools.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Request {
    private HttpServletRequest mHttpServletRequest = null;
    private Map<String, String[]> mParameters = null;
    private Map<String, UploadedFile[]> mFiles = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    Request(HttpServletRequest request, StateStore stateStore) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && stateStore == null) {
            throw new AssertionError();
        }
        this.mHttpServletRequest = request;
        if (MultipartRequest.isValidContentType(this.mHttpServletRequest.getContentType())) {
            MultipartRequest multipart_request = new MultipartRequest(this.mHttpServletRequest);
            this.mParameters = multipart_request.getParameterMap();
            this.mFiles = multipart_request.getFileMap();
        } else {
            this.mParameters = new HashMap<String, String[]>();
            try {
                this.mHttpServletRequest.setCharacterEncoding(StringUtils.ENCODING_UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            Enumeration parameter_names = this.mHttpServletRequest.getParameterNames();
            String parameter_name = null;
            String[] parameter_values = null;
            while (parameter_names.hasMoreElements()) {
                parameter_name = (String)parameter_names.nextElement();
                if (StringUtils.doesUrlValueNeedDecoding(parameter_name)) {
                    parameter_name = StringUtils.decodeUrlValue(parameter_name);
                }
                parameter_values = this.mHttpServletRequest.getParameterValues(parameter_name);
                int i = 0;
                while (i < parameter_values.length) {
                    if (StringUtils.doesUrlValueNeedDecoding(parameter_values[i])) {
                        parameter_values[i] = StringUtils.decodeUrlValue(parameter_values[i]);
                    }
                    ++i;
                }
                this.mParameters.put(parameter_name, parameter_values);
            }
        }
        Map<String, String[]> parameters = stateStore.restoreParameters(this);
        if (parameters != null) {
            this.mParameters = parameters;
        }
    }

    RequestMethod getMethod() {
        return RequestMethod.getMethod(this.mHttpServletRequest.getMethod());
    }

    HttpServletRequest getHttpServletRequest() {
        return this.mHttpServletRequest;
    }

    Map<String, String[]> getParameters() {
        return this.mParameters;
    }

    boolean hasUploadedFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mFiles == null) {
            return false;
        }
        if (!this.mFiles.containsKey(name)) {
            return false;
        }
        UploadedFile[] uploaded_files = this.mFiles.get(name);
        if (0 == uploaded_files.length) {
            return false;
        }
        UploadedFile[] uploadedFileArray = uploaded_files;
        int n = 0;
        while (n < uploadedFileArray.length) {
            UploadedFile uploaded_file = uploadedFileArray[n];
            if (uploaded_file != null && uploaded_file.getName() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    UploadedFile getUploadedFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mFiles == null) {
            return null;
        }
        UploadedFile[] files = this.mFiles.get(name);
        if (files == null) {
            return null;
        }
        return files[0];
    }

    UploadedFile[] getUploadedFiles(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mFiles == null) {
            return null;
        }
        return this.mFiles.get(name);
    }

    boolean hasCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        Cookie[] cookies = this.mHttpServletRequest.getCookies();
        if (cookies == null) {
            return false;
        }
        Cookie[] cookieArray = cookies;
        int n = 0;
        while (n < cookieArray.length) {
            Cookie cookie = cookieArray[n];
            if (cookie.getName().equals(name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Cookie getCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        Cookie[] cookies = this.mHttpServletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie[] cookieArray = cookies;
        int n = 0;
        while (n < cookieArray.length) {
            Cookie cookie = cookieArray[n];
            if (cookie.getName().equals(name)) {
                return cookie;
            }
            ++n;
        }
        return null;
    }

    Cookie[] getCookies() {
        return this.mHttpServletRequest.getCookies();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.Request");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

