/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.Base64;
import com.uwyn.rife.tools.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterMapEncoder {
    private static final String SEP_PARAMETER = "p\u0000";
    private static final String SEP_PARAMETER_NAME = "n\u0000";
    private static final String SEP_VALUE = "v\u0000";
    private static final byte[] SEP_PARAMETER_BYTES;
    private static final byte[] SEP_PARAMETER_NAME_BYTES;
    private static final byte[] SEP_VALUE_BYTES;

    static String encodeToBase64String(Map<String, String[]> map) {
        return Base64.encodeToString(ParameterMapEncoder.encodeToBytes(map), false);
    }

    static byte[] encodeToBytes(Map<String, String[]> map) {
        byte[] map_bytes;
        block5: {
            Set<Map.Entry<String, String[]>> parameter_entries;
            map_bytes = new byte[]{};
            if (map == null || (parameter_entries = map.entrySet()).size() <= 0) break block5;
            try {
                Iterator<Map.Entry<String, String[]>> parameter_entries_it = parameter_entries.iterator();
                Map.Entry<String, String[]> parameter_entry = null;
                String[] parameter_values = null;
                while (parameter_entries_it.hasNext()) {
                    parameter_entry = parameter_entries_it.next();
                    map_bytes = ArrayUtils.join(map_bytes, parameter_entry.getKey().getBytes("UTF-8"));
                    map_bytes = ArrayUtils.join(map_bytes, SEP_PARAMETER_NAME_BYTES);
                    parameter_values = parameter_entry.getValue();
                    int i = 0;
                    while (i < parameter_values.length) {
                        map_bytes = ArrayUtils.join(map_bytes, parameter_values[i].getBytes("UTF-8"));
                        if (i < parameter_values.length - 1) {
                            map_bytes = ArrayUtils.join(map_bytes, SEP_VALUE_BYTES);
                        }
                        ++i;
                    }
                    if (!parameter_entries_it.hasNext()) continue;
                    map_bytes = ArrayUtils.join(map_bytes, SEP_PARAMETER_BYTES);
                }
            }
            catch (UnsupportedEncodingException e) {}
        }
        return map_bytes;
    }

    static Map<String, String[]> decodeFromBase64String(String base64Encoded) {
        if (base64Encoded == null) {
            return new HashMap<String, String[]>();
        }
        try {
            byte[] decoded_bytes = Base64.decode(base64Encoded);
            if (decoded_bytes == null) {
                return new HashMap<String, String[]>();
            }
            String decoded_map = new String(decoded_bytes, "UTF-8");
            return ParameterMapEncoder.decodeFromString(decoded_map);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static Map<String, String[]> decodeFromString(String encoded) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        if (encoded != null & encoded.length() > 0 && encoded.length() > 0) {
            ArrayList<String> parameter_entries = null;
            parameter_entries = StringUtils.split(encoded, SEP_PARAMETER);
            ArrayList<String> parameter_parts = null;
            String[] parameter_values = null;
            for (String parameter_entry : (Collection)parameter_entries) {
                parameter_parts = StringUtils.split(parameter_entry, SEP_PARAMETER_NAME);
                parameter_values = StringUtils.splitToArray(parameter_parts.get(1), SEP_VALUE);
                parameters.put(parameter_parts.get(0), parameter_values);
            }
        }
        return parameters;
    }

    static {
        byte[] parameter_bytes = null;
        byte[] parameter_name_bytes = null;
        byte[] value_bytes = null;
        try {
            parameter_bytes = SEP_PARAMETER.getBytes("UTF-8");
            parameter_name_bytes = SEP_PARAMETER_NAME.getBytes("UTF-8");
            value_bytes = SEP_VALUE.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        SEP_PARAMETER_BYTES = parameter_bytes;
        SEP_PARAMETER_NAME_BYTES = parameter_name_bytes;
        SEP_VALUE_BYTES = value_bytes;
    }
}

