/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.ElementDeclaration;
import com.uwyn.rife.engine.GlobalExit;
import com.uwyn.rife.engine.GlobalVar;
import com.uwyn.rife.engine.ReservedParameters;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.exceptions.GlobalCookieExistsException;
import com.uwyn.rife.engine.exceptions.GlobalCookiesLockedException;
import com.uwyn.rife.engine.exceptions.GlobalExitExistsException;
import com.uwyn.rife.engine.exceptions.GlobalExitOverriddenException;
import com.uwyn.rife.engine.exceptions.GlobalExitsLockedException;
import com.uwyn.rife.engine.exceptions.GlobalVarExistsException;
import com.uwyn.rife.engine.exceptions.GlobalVarsLockedException;
import com.uwyn.rife.engine.exceptions.NamedGlobalBeanExistsException;
import com.uwyn.rife.engine.exceptions.ReservedGlobalVarNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupDeclaration {
    private IdSequence mIdSequence = null;
    private int mGroupId = -1;
    private SiteBuilder mDeclaringSiteBuilder = null;
    private SiteBuilder mActiveSiteBuilder = null;
    private String mDeclarationName = null;
    private GroupDeclaration mParent = null;
    private ArrayList<GroupDeclaration> mChildGroupDeclarations = null;
    private ArrayList<ElementDeclaration> mElementDeclarations = null;
    private LinkedHashMap<String, GlobalVar> mGlobalVarsLocal = null;
    private LinkedHashMap<String, GlobalVar> mGlobalVarsMerged = null;
    private LinkedHashMap<String, GlobalExit> mGlobalExitsLocal = null;
    private LinkedHashMap<String, GlobalExit> mGlobalExitsMerged = null;
    private LinkedHashMap<String, String> mGlobalCookiesLocal = null;
    private LinkedHashMap<String, String> mGlobalCookiesMerged = null;
    private LinkedHashMap<String, BeanDeclaration> mNamedGlobalBeansLocal = null;
    private LinkedHashMap<String, BeanDeclaration> mNamedGlobalBeansMerged = null;
    private String mInherits = null;
    private String mPre = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    GroupDeclaration(SiteBuilder declaringSiteBuilder, String declarationName) {
        this(declaringSiteBuilder, declarationName, null);
    }

    GroupDeclaration(SiteBuilder declaringSiteBuilder, String declarationName, GroupDeclaration parent) {
        this.mDeclaringSiteBuilder = declaringSiteBuilder;
        this.mActiveSiteBuilder = declaringSiteBuilder;
        this.mDeclarationName = declarationName;
        this.mParent = parent;
        this.mChildGroupDeclarations = new ArrayList();
        this.mElementDeclarations = new ArrayList();
        this.mGlobalVarsLocal = new LinkedHashMap();
        this.mGlobalCookiesLocal = new LinkedHashMap();
        this.mGlobalExitsLocal = new LinkedHashMap();
        this.mNamedGlobalBeansLocal = new LinkedHashMap();
        if (parent == null) {
            this.mIdSequence = new IdSequence();
        } else {
            this.mIdSequence = parent.mIdSequence;
            parent.addChildGroupDeclaration(this);
        }
        this.mGroupId = this.mIdSequence.getNextId();
    }

    GroupDeclaration getParent() {
        return this.mParent;
    }

    void setInherits(String inherits) {
        this.mInherits = inherits;
    }

    void setPre(String pre) {
        this.mPre = pre;
    }

    String getInherits() {
        return this.mInherits;
    }

    String getPre() {
        return this.mPre;
    }

    int getGroupId() {
        return this.mGroupId;
    }

    SiteBuilder getDeclaringSiteBuilder() {
        return this.mDeclaringSiteBuilder;
    }

    void setActiveSiteBuilder(SiteBuilder activeSiteBuilder) {
        this.mActiveSiteBuilder = activeSiteBuilder;
    }

    SiteBuilder getActiveSiteBuilder() {
        return this.mActiveSiteBuilder;
    }

    String getDeclarationName() {
        return this.mDeclarationName;
    }

    private void addChildGroupDeclaration(GroupDeclaration child) {
        this.mChildGroupDeclarations.add(child);
    }

    Collection<GroupDeclaration> getChildGroupDeclarations() {
        return this.mChildGroupDeclarations;
    }

    void addElementDeclaration(ElementDeclaration elementDeclaration) {
        this.mElementDeclarations.add(elementDeclaration);
    }

    boolean removeElementDeclaration(ElementDeclaration elementDeclaration) {
        return this.mElementDeclarations.remove(elementDeclaration);
    }

    Collection<ElementDeclaration> getElementDeclarations() {
        return this.mElementDeclarations;
    }

    void addGlobalVar(String name, GlobalVar globalVar) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && globalVar == null) {
            throw new AssertionError();
        }
        if (this.mGlobalVarsMerged != null) {
            throw new GlobalVarsLockedException(this.getDeclarationName(), name);
        }
        if (ReservedParameters.RESERVED_NAMES_LIST.contains(name)) {
            throw new ReservedGlobalVarNameException(this.getDeclarationName(), name);
        }
        if (this.mGlobalVarsLocal.containsKey(name)) {
            throw new GlobalVarExistsException(this.getDeclarationName(), name);
        }
        globalVar.setGroupId(this.mGroupId);
        this.mGlobalVarsLocal.put(name, globalVar);
    }

    void addGlobalCookie(String name, String defaultVal) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mGlobalCookiesMerged != null) {
            throw new GlobalCookiesLockedException(this.getDeclarationName(), name);
        }
        if (this.mGlobalVarsLocal.containsKey(name)) {
            throw new GlobalCookieExistsException(this.getDeclarationName(), name);
        }
        this.mGlobalCookiesLocal.put(name, defaultVal);
    }

    void addGlobalExit(String name, GlobalExit globalExit) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && globalExit == null) {
            throw new AssertionError();
        }
        if (this.mGlobalExitsMerged != null) {
            throw new GlobalExitsLockedException(this.getDeclarationName(), name);
        }
        if (this.mGlobalExitsLocal.containsKey(name)) {
            throw new GlobalExitExistsException(this.getDeclarationName(), name);
        }
        globalExit.setGroupId(this.mGroupId);
        this.mGlobalExitsLocal.put(name, globalExit);
    }

    void addNamedGlobalBean(String name, BeanDeclaration bean) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bean == null) {
            throw new AssertionError();
        }
        if (this.mNamedGlobalBeansLocal.containsKey(name)) {
            throw new NamedGlobalBeanExistsException(this.getDeclarationName(), name);
        }
        this.mNamedGlobalBeansLocal.put(name, bean);
    }

    LinkedHashMap<String, GlobalVar> getGlobalVarsLocal() {
        return this.mGlobalVarsLocal;
    }

    LinkedHashMap<String, GlobalVar> getGlobalVarsMerged() {
        if (this.mGlobalVarsMerged == null) {
            this.mGlobalVarsMerged = new LinkedHashMap();
            this.mGlobalVarsMerged.putAll(this.mGlobalVarsLocal);
            if (this.getParent() != null) {
                LinkedHashMap<String, GlobalVar> globalvars = this.getParent().getGlobalVarsMerged();
                String globalvar_name = null;
                for (Map.Entry globalvar_entry : (Collection)globalvars.entrySet()) {
                    globalvar_name = (String)globalvar_entry.getKey();
                    if (this.mGlobalVarsMerged.containsKey(globalvar_name) && this.mGlobalVarsMerged.get(globalvar_name) != null) continue;
                    this.mGlobalVarsMerged.put(globalvar_name, (GlobalVar)globalvar_entry.getValue());
                }
            }
        }
        return this.mGlobalVarsMerged;
    }

    LinkedHashMap<String, String> getGlobalCookiesMerged() {
        if (this.mGlobalCookiesMerged == null) {
            this.mGlobalCookiesMerged = new LinkedHashMap();
            this.mGlobalCookiesMerged.putAll(this.mGlobalCookiesLocal);
            if (this.getParent() != null) {
                LinkedHashMap<String, String> globalcookies = this.getParent().getGlobalCookiesMerged();
                String globalcookie_name = null;
                for (Map.Entry globalcookie_entry : (Collection)globalcookies.entrySet()) {
                    globalcookie_name = (String)globalcookie_entry.getKey();
                    if (this.mGlobalCookiesMerged.containsKey(globalcookie_name) && this.mGlobalCookiesMerged.get(globalcookie_name) != null) continue;
                    this.mGlobalCookiesMerged.put(globalcookie_name, (String)globalcookie_entry.getValue());
                }
            }
        }
        return this.mGlobalCookiesMerged;
    }

    LinkedHashMap<String, GlobalExit> getGlobalExitsMerged() {
        if (this.mGlobalExitsMerged == null) {
            this.mGlobalExitsMerged = new LinkedHashMap();
            for (Map.Entry globalexit : (Collection)this.mGlobalExitsLocal.entrySet()) {
                ((GlobalExit)globalexit.getValue()).makeAbsoluteDestId(this.mActiveSiteBuilder);
                this.mGlobalExitsMerged.put((String)globalexit.getKey(), (GlobalExit)globalexit.getValue());
            }
            if (this.getParent() != null) {
                LinkedHashMap<String, GlobalExit> globalexits = this.getParent().getGlobalExitsMerged();
                String globalexit_name = null;
                for (Map.Entry globalexit_entry : (Collection)globalexits.entrySet()) {
                    globalexit_name = (String)globalexit_entry.getKey();
                    if (!this.mGlobalExitsMerged.containsKey(globalexit_name) || this.mGlobalExitsMerged.get(globalexit_name) == null) {
                        this.mGlobalExitsMerged.put(globalexit_name, (GlobalExit)globalexit_entry.getValue());
                        continue;
                    }
                    throw new GlobalExitOverriddenException(this.getDeclarationName(), globalexit_name);
                }
            }
        }
        return this.mGlobalExitsMerged;
    }

    LinkedHashMap<String, BeanDeclaration> getNamedGlobalBeansMerged() {
        if (this.mNamedGlobalBeansMerged == null) {
            this.mNamedGlobalBeansMerged = new LinkedHashMap();
            this.mNamedGlobalBeansMerged.putAll(this.mNamedGlobalBeansLocal);
            if (this.getParent() != null) {
                LinkedHashMap<String, BeanDeclaration> globalbeans = this.getParent().getNamedGlobalBeansMerged();
                String globalbean_name = null;
                for (Map.Entry globalbean_entry : (Collection)globalbeans.entrySet()) {
                    globalbean_name = (String)globalbean_entry.getKey();
                    if (this.mNamedGlobalBeansMerged.containsKey(globalbean_name) && this.mNamedGlobalBeansMerged.get(globalbean_name) != null) continue;
                    this.mNamedGlobalBeansMerged.put(globalbean_name, (BeanDeclaration)globalbean_entry.getValue());
                }
            }
        }
        return this.mNamedGlobalBeansMerged;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.GroupDeclaration");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private class IdSequence {
        private int mId = 0;

        synchronized int getNextId() {
            return this.mId++;
        }

        static /* synthetic */ GroupDeclaration access$0(IdSequence idSequence) {
            return idSequence.GroupDeclaration.this;
        }
    }
}

