/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.SiteProcessor;
import com.uwyn.rife.engine.exceptions.NotFoundProcessingErrorException;
import com.uwyn.rife.engine.exceptions.ParsingErrorException;
import com.uwyn.rife.engine.exceptions.ProcessingErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.InputStreamUser;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovy.util.BuilderSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

class Groovy2Site
implements SiteProcessor {
    Groovy2Site() {
    }

    public void processSite(SiteBuilder builder, String declarationName, ResourceFinder resourceFinder) {
        GroovyProcessor processor = new GroovyProcessor(builder);
        String processed_path = null;
        try {
            try {
                processed_path = declarationName;
                processor.processGroovy(processed_path, resourceFinder);
            }
            catch (NotFoundProcessingErrorException e) {
                processed_path = "sites/" + declarationName;
                processor.processGroovy(processed_path, resourceFinder);
            }
        }
        catch (Exception e) {
            throw new ProcessingErrorException("site", declarationName, e);
        }
        if (RifeConfig.Engine.getSiteAutoReload()) {
            URL resource = resourceFinder.getResource(processed_path);
            if (resource == null) {
                throw new NotFoundProcessingErrorException("site", processed_path, null);
            }
            try {
                builder.addResourceModificationTime(resource, resourceFinder.getModificationTime(resource));
            }
            catch (ResourceFinderErrorException e) {
                throw new ProcessingErrorException("site", declarationName, "Error while retrieving the modification time.", e);
            }
        }
    }

    private class GroovyProcessor
    extends BuilderSupport {
        private SiteBuilder mSiteBuilder = null;
        private String mGroovyPath = null;
        private ResourceFinder mResourceFinder = null;
        private ElementInfoBuilder mCurrentElementInfoBuilder = null;
        private String mCurrentGlobalVar = null;
        private ArrayList<String> mCurrentGlobalVarDefaults = null;
        private String mCurrentGlobalCookie = null;
        private String mCurrentGlobalCookieDefault = null;

        GroovyProcessor(SiteBuilder builder) {
            this.mSiteBuilder = builder;
        }

        public synchronized void processGroovy(String groovyPath, ResourceFinder resourceFinder) {
            if (groovyPath == null) {
                throw new IllegalArgumentException("groovyPath can't be null.");
            }
            if (groovyPath.length() == 0) {
                throw new IllegalArgumentException("groovyPath can't be empty.");
            }
            if (resourceFinder == null) {
                throw new IllegalArgumentException("resourceFinder can't be null.");
            }
            this.mGroovyPath = groovyPath;
            this.mResourceFinder = resourceFinder;
            Class script_class = null;
            try {
                script_class = (Class)this.mResourceFinder.useStream(groovyPath, (InputStreamUser)new 1(groovyPath));
            }
            catch (ResourceFinderErrorException e) {
                throw new NotFoundProcessingErrorException("site", groovyPath, e);
            }
            Binding binding = new Binding();
            binding.setVariable("processor", (Object)this);
            binding.setVariable("builder", (Object)this.mSiteBuilder);
            Script script = InvokerHelper.createScript((Class)script_class, (Binding)binding);
            script.run();
        }

        protected void setParent(Object parent, Object child) {
        }

        protected Object createNode(Object name) {
            return this.createNode(name, null, null);
        }

        protected Object createNode(Object node, Object value) {
            return this.createNode(node, null, value);
        }

        protected Object createNode(Object node, Map attributes) {
            return this.createNode(node, attributes, null);
        }

        protected Object createNode(Object node, Map atts, Object value) {
            if (atts == null) {
                atts = new HashMap();
            }
            if (node.equals("site")) {
                this.mSiteBuilder.setFallback(Convert.toString(atts.get("fallbackid")));
            } else if (node.equals("subsite")) {
                this.mSiteBuilder.enterSubsite(Convert.toString(atts.get("file"))).setId(Convert.toString(atts.get("id"))).setUrlPrefix(Convert.toString(atts.get("urlprefix"))).setInherits(Convert.toString(atts.get("inherits"))).setPre(Convert.toString(atts.get("pre"))).leaveSubsite();
            } else if (node.equals("group")) {
                String inherits = Convert.toString(atts.get("inherits"));
                String pre = Convert.toString(atts.get("pre"));
                this.mSiteBuilder.enterGroup().setInherits(inherits).setPre(pre);
            } else if (node.equals("globalvar")) {
                this.mCurrentGlobalVar = Convert.toString(atts.get("name"));
                this.mCurrentGlobalVarDefaults = new ArrayList();
            } else if (node.equals("globalcookie")) {
                this.mCurrentGlobalCookie = Convert.toString(atts.get("name"));
                this.mCurrentGlobalCookieDefault = null;
            } else if (node.equals("globalbean")) {
                String classname = Convert.toString(atts.get("classname"));
                String prefix = Convert.toString(atts.get("prefix"));
                String name = Convert.toString(atts.get("name"));
                this.mSiteBuilder.addGlobalBean(classname, prefix, name);
            } else if (node.equals("globalexit")) {
                String name = Convert.toString(atts.get("name"));
                String destid = Convert.toString(atts.get("destid"));
                boolean reflective = Convert.toBoolean(atts.get("reflect"), false);
                boolean snapback = Convert.toBoolean(atts.get("snapback"), false);
                boolean redirect = Convert.toBoolean(atts.get("redirect"), false);
                boolean cancel_inheritance = false;
                String inheritance = Convert.toString(atts.get("inheritance"));
                if (inheritance != null && inheritance.equals("cancel")) {
                    cancel_inheritance = true;
                }
                this.mSiteBuilder.addGlobalExit(name, destid, reflective, snapback, cancel_inheritance, redirect);
            } else if (node.equals("arrival")) {
                this.mSiteBuilder.setArrival(Convert.toString(atts.get("destid")));
            } else if (node.equals("departure")) {
                this.mSiteBuilder.addDeparture(Convert.toString(atts.get("srcid")));
            } else if (node.equals("state")) {
                this.mSiteBuilder.enterState(Convert.toString(atts.get("store")));
            } else if (node.equals("element")) {
                this.mCurrentElementInfoBuilder = this.mSiteBuilder.enterElement(Convert.toString(atts.get("file"))).setId(Convert.toString(atts.get("id"))).setUrl(Convert.toString(atts.get("url"))).setInherits(Convert.toString(atts.get("inherits"))).setPre(Convert.toString(atts.get("pre")));
            } else if (node.equals("datalink")) {
                String srcoutput = Convert.toString(atts.get("srcoutput"));
                String srcoutbean = Convert.toString(atts.get("srcoutbean"));
                String dest_id = Convert.toString(atts.get("destid"));
                boolean snapback = Convert.toBoolean(atts.get("snapback"), false);
                String destinput = Convert.toString(atts.get("destinput"));
                String destinbean = Convert.toString(atts.get("destinbean"));
                this.mCurrentElementInfoBuilder.addDataLink(srcoutput, srcoutbean, dest_id, snapback, destinput, destinbean);
            } else if (node.equals("flowlink")) {
                String srcexit = Convert.toString(atts.get("srcexit"));
                String destid = Convert.toString(atts.get("destid"));
                boolean snapback = Convert.toBoolean(atts.get("snapback"), false);
                boolean redirect = Convert.toBoolean(atts.get("redirect"), false);
                boolean cancel_inheritance = false;
                String inheritance = Convert.toString(atts.get("inheritance"));
                if (inheritance != null && inheritance.equals("cancel")) {
                    cancel_inheritance = true;
                }
                this.mCurrentElementInfoBuilder.addFlowLink(srcexit, destid, snapback, cancel_inheritance, redirect);
            } else if (node.equals("prop")) {
                this.mCurrentElementInfoBuilder.addProperty(Convert.toString(atts.get("name")), value);
            } else if (node.equals("defaultvalue")) {
                if (this.mCurrentGlobalCookie != null) {
                    this.mCurrentGlobalCookieDefault = (String)value;
                } else if (this.mCurrentGlobalVar != null) {
                    this.mCurrentGlobalVarDefaults.add((String)value);
                }
            } else {
                throw new ParsingErrorException("site", this.mGroovyPath, "Unsupport element name '" + node + "'.", null);
            }
            return node;
        }

        protected void nodeCompleted(Object parent, Object node) {
            if (node.equals("element")) {
                this.mCurrentElementInfoBuilder.leaveElement();
                this.mCurrentElementInfoBuilder = null;
            } else if (node.equals("state")) {
                this.mSiteBuilder.leaveState();
            } else if (node.equals("group")) {
                this.mSiteBuilder.leaveGroup();
            } else if (node.equals("globalvar")) {
                String[] defaults = null;
                if (this.mCurrentGlobalVarDefaults.size() > 0) {
                    defaults = new String[this.mCurrentGlobalVarDefaults.size()];
                    defaults = this.mCurrentGlobalVarDefaults.toArray(defaults);
                }
                this.mSiteBuilder.addGlobalVar(this.mCurrentGlobalVar, defaults);
                this.mCurrentGlobalVar = null;
                this.mCurrentGlobalVarDefaults = null;
            } else if (node.equals("globalcookie")) {
                this.mSiteBuilder.addGlobalCookie(this.mCurrentGlobalCookie, this.mCurrentGlobalCookieDefault);
                this.mCurrentGlobalCookie = null;
                this.mCurrentGlobalCookieDefault = null;
            }
        }

        static /* synthetic */ Groovy2Site access$0(GroovyProcessor groovyProcessor) {
            return groovyProcessor.Groovy2Site.this;
        }

        class 1
        extends InputStreamUser {
            private final /* synthetic */ String val$groovyPath;

            1(String string) {
                this.val$groovyPath = string;
            }

            public Class useInputStream(InputStream stream) {
                if (stream == null) {
                    throw new NotFoundProcessingErrorException("site", this.val$groovyPath, null);
                }
                try {
                    GroovyClassLoader mLoader = new GroovyClassLoader(this.getClass().getClassLoader(), new CompilerConfiguration());
                    GroovyCodeSource code_source = new GroovyCodeSource(stream, "sitebuilder.groovy", "/groovy/shell");
                    try {
                        Class clazz = mLoader.parseClass(code_source);
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return clazz;
                    }
                    catch (Throwable e) {
                        throw new ParsingErrorException("site", this.val$groovyPath, e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                    throw throwable;
                }
            }

            public /* synthetic */ Object useInputStream(InputStream inputStream) {
                return this.useInputStream(inputStream);
            }

            static /* synthetic */ GroovyProcessor access$0(1 var0) {
                return var0.GroovyProcessor.this;
            }
        }
    }
}

