/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.ElementInfoProcessor;
import com.uwyn.rife.engine.SubmissionBuilder;
import com.uwyn.rife.engine.exceptions.NotFoundProcessingErrorException;
import com.uwyn.rife.engine.exceptions.ParsingErrorException;
import com.uwyn.rife.engine.exceptions.ProcessingErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.InputStreamUser;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovy.util.BuilderSupport;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

class Groovy2ElementInfo
implements ElementInfoProcessor {
    Groovy2ElementInfo() {
    }

    public void processElementInfo(ElementInfoBuilder builder, String declarationName, ResourceFinder resourceFinder) {
        GroovyProcessor processor = new GroovyProcessor(builder);
        String processed_path = null;
        try {
            try {
                processed_path = declarationName;
                processor.processGroovy(processed_path, resourceFinder);
            }
            catch (NotFoundProcessingErrorException e) {
                processed_path = "elements/" + declarationName;
                processor.processGroovy(processed_path, resourceFinder);
            }
        }
        catch (Exception e) {
            throw new ProcessingErrorException("element", declarationName, e);
        }
        if (RifeConfig.Engine.getSiteAutoReload()) {
            URL resource = resourceFinder.getResource(processed_path);
            if (resource == null) {
                throw new NotFoundProcessingErrorException("element", processed_path, null);
            }
            try {
                builder.addResourceModificationTime(resource, resourceFinder.getModificationTime(resource));
            }
            catch (ResourceFinderErrorException e) {
                throw new ProcessingErrorException("element", declarationName, "Error while retrieving the modification time.", e);
            }
        }
    }

    private class GroovyProcessor
    extends BuilderSupport {
        private ElementInfoBuilder mElementInfoBuilder = null;
        private String mGroovyPath = null;
        private ResourceFinder mResourceFinder = null;
        private String mCurrentInput = null;
        private String mCurrentOutput = null;
        private String mCurrentIncookie = null;
        private String mCurrentOutcookie = null;
        private String mCurrentParameter = null;
        private ArrayList<String> mDefaults = null;
        private SubmissionBuilder mSubmissionBuilder = null;

        GroovyProcessor(ElementInfoBuilder builder) {
            this.mElementInfoBuilder = builder;
        }

        public synchronized void processGroovy(String groovyPath, ResourceFinder resourceFinder) {
            if (groovyPath == null) {
                throw new IllegalArgumentException("groovyPath can't be null.");
            }
            if (groovyPath.length() == 0) {
                throw new IllegalArgumentException("groovyPath can't be empty.");
            }
            if (resourceFinder == null) {
                throw new IllegalArgumentException("resourceFinder can't be null.");
            }
            this.mGroovyPath = groovyPath;
            this.mResourceFinder = resourceFinder;
            Class script_class = null;
            try {
                script_class = (Class)this.mResourceFinder.useStream(groovyPath, (InputStreamUser)new 1(groovyPath));
            }
            catch (ResourceFinderErrorException e) {
                throw new NotFoundProcessingErrorException("element", groovyPath, e);
            }
            Binding binding = new Binding();
            binding.setVariable("processor", (Object)this);
            binding.setVariable("builder", (Object)this.mElementInfoBuilder);
            Script script = InvokerHelper.createScript((Class)script_class, (Binding)binding);
            script.run();
        }

        protected void setParent(Object parent, Object child) {
        }

        protected Object createNode(Object node) {
            return this.createNode(node, null, null);
        }

        protected Object createNode(Object node, Object value) {
            return this.createNode(node, null, value);
        }

        protected Object createNode(Object node, Map attributes) {
            return this.createNode(node, attributes, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object createNode(Object node, Map atts, Object value) {
            if (atts == null) {
                atts = new HashMap();
            }
            if (node.equals("element")) {
                String content_type = Convert.toString(atts.get("contenttype"));
                String extending = Convert.toString(atts.get("extends"));
                String implementation = Convert.toString(atts.get("implementation"));
                this.mElementInfoBuilder.setContentType(content_type);
                if (extending != null) {
                    this.mElementInfoBuilder.extendsFrom(extending);
                }
                if (implementation == null) return node;
                this.mElementInfoBuilder.setImplementation(implementation);
                return node;
            } else if (node.equals("prop")) {
                this.mElementInfoBuilder.addStaticProperty(Convert.toString(atts.get("name")), value);
                return node;
            } else if (node.equals("input")) {
                this.mCurrentInput = Convert.toString(atts.get("name"));
                this.mDefaults = new ArrayList();
                return node;
            } else if (node.equals("inbean")) {
                String classname = Convert.toString(atts.get("classname"));
                String prefix = Convert.toString(atts.get("prefix"));
                String name = Convert.toString(atts.get("name"));
                this.mElementInfoBuilder.addInBean(classname, prefix, name);
                return node;
            } else if (node.equals("output")) {
                this.mCurrentOutput = Convert.toString(atts.get("name"));
                this.mDefaults = new ArrayList();
                return node;
            } else if (node.equals("outbean")) {
                String classname = Convert.toString(atts.get("classname"));
                String prefix = Convert.toString(atts.get("prefix"));
                String name = Convert.toString(atts.get("name"));
                this.mElementInfoBuilder.addOutBean(classname, prefix, name);
                return node;
            } else if (node.equals("incookie")) {
                this.mCurrentIncookie = Convert.toString(atts.get("name"));
                this.mDefaults = new ArrayList();
                return node;
            } else if (node.equals("outcookie")) {
                this.mCurrentOutcookie = Convert.toString(atts.get("name"));
                this.mDefaults = new ArrayList();
                return node;
            } else if (node.equals("childtrigger")) {
                this.mElementInfoBuilder.addChildTrigger(Convert.toString(atts.get("name")));
                return node;
            } else if (node.equals("submission")) {
                this.mSubmissionBuilder = this.mElementInfoBuilder.enterSubmission(Convert.toString(atts.get("name")));
                return node;
            } else if (node.equals("param")) {
                if (Convert.toString(atts.get("name")) != null && Convert.toString(atts.get("regexp")) != null) {
                    throw new ParsingErrorException("element", this.mGroovyPath, "A submission parameter can't have both a name and a regexp attribute.", null);
                }
                if (Convert.toString(atts.get("name")) != null) {
                    this.mCurrentParameter = Convert.toString(atts.get("name"));
                    this.mDefaults = new ArrayList();
                    return node;
                } else {
                    if (Convert.toString(atts.get("regexp")) == null) throw new ParsingErrorException("element", this.mGroovyPath, "A submission parameter needs either a name or a regexp attribute.", null);
                    this.mSubmissionBuilder.addParameterRegexp(Convert.toString(atts.get("regexp")));
                    this.mDefaults = null;
                }
                return node;
            } else if (node.equals("bean")) {
                String classname = Convert.toString(atts.get("classname"));
                String prefix = Convert.toString(atts.get("prefix"));
                String name = Convert.toString(atts.get("name"));
                this.mSubmissionBuilder.addBean(classname, prefix, name);
                return node;
            } else if (node.equals("file")) {
                this.mSubmissionBuilder.addFile(Convert.toString(atts.get("name")));
                return node;
            } else if (node.equals("defaultvalue")) {
                if (this.mDefaults == null) {
                    throw new ParsingErrorException("element", this.mGroovyPath, "A submission parameter that's defined by a regular expression can't have default values.", null);
                }
                this.mDefaults.add((String)value);
                return node;
            } else {
                if (!node.equals("exit")) throw new ParsingErrorException("element", this.mGroovyPath, "Unsupport element name '" + node + "'.", null);
                this.mElementInfoBuilder.addExit(Convert.toString(atts.get("name")));
            }
            return node;
        }

        protected void nodeCompleted(Object parent, Object node) {
            if (node.equals("input")) {
                String[] defaults = null;
                if (this.mDefaults.size() > 0) {
                    defaults = new String[this.mDefaults.size()];
                    defaults = this.mDefaults.toArray(defaults);
                }
                this.mElementInfoBuilder.addInput(this.mCurrentInput, defaults);
                this.mCurrentInput = null;
                this.mDefaults = null;
            } else if (node.equals("output")) {
                String[] defaults = null;
                if (this.mDefaults.size() > 0) {
                    defaults = new String[this.mDefaults.size()];
                    defaults = this.mDefaults.toArray(defaults);
                }
                this.mElementInfoBuilder.addOutput(this.mCurrentOutput, defaults);
                this.mCurrentOutput = null;
                this.mDefaults = null;
            } else if (node.equals("incookie")) {
                String defaultValue = null;
                if (this.mDefaults.size() > 0) {
                    defaultValue = this.mDefaults.get(0);
                }
                this.mElementInfoBuilder.addIncookie(this.mCurrentIncookie, defaultValue);
                this.mCurrentIncookie = null;
                this.mDefaults = null;
            } else if (node.equals("outcookie")) {
                String defaultValue = null;
                if (this.mDefaults.size() > 0) {
                    defaultValue = this.mDefaults.get(0);
                }
                this.mElementInfoBuilder.addOutcookie(this.mCurrentOutcookie, defaultValue);
                this.mCurrentOutcookie = null;
                this.mDefaults = null;
            } else if (node.equals("submission")) {
                this.mSubmissionBuilder.leaveSubmission();
            } else if (node.equals("param")) {
                if (this.mDefaults != null) {
                    String[] defaults = null;
                    if (this.mDefaults.size() > 0) {
                        defaults = new String[this.mDefaults.size()];
                        defaults = this.mDefaults.toArray(defaults);
                    }
                    this.mSubmissionBuilder.addParameter(this.mCurrentParameter, defaults);
                }
                this.mCurrentParameter = null;
                this.mDefaults = null;
            }
        }

        static /* synthetic */ Groovy2ElementInfo access$0(GroovyProcessor groovyProcessor) {
            return groovyProcessor.Groovy2ElementInfo.this;
        }

        class 1
        extends InputStreamUser {
            private final /* synthetic */ String val$groovyPath;

            1(String string) {
                this.val$groovyPath = string;
            }

            public Class useInputStream(InputStream stream) {
                if (stream == null) {
                    throw new NotFoundProcessingErrorException("element", this.val$groovyPath, null);
                }
                GroovyClassLoader mLoader = new GroovyClassLoader(this.getClass().getClassLoader(), new CompilerConfiguration());
                GroovyCodeSource code_source = new GroovyCodeSource(stream, "elementinfobuilder.groovy", "/groovy/shell");
                try {
                    return mLoader.parseClass(code_source);
                }
                catch (Throwable e) {
                    throw new ParsingErrorException("element", this.val$groovyPath, e);
                }
            }

            public /* synthetic */ Object useInputStream(InputStream inputStream) {
                return this.useInputStream(inputStream);
            }

            static /* synthetic */ GroovyProcessor access$0(1 var0) {
                return var0.GroovyProcessor.this;
            }
        }
    }
}

