/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.Version;
import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.EngineClassLoaderRifeWebappPath;
import com.uwyn.rife.engine.InitConfig;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.RequestState;
import com.uwyn.rife.engine.Response;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.exceptions.DeferException;
import com.uwyn.rife.engine.exceptions.ElementCompilationFailedException;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.rep.participants.ParticipantSite;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.template.exceptions.TemplateCompilationFailedException;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Gate {
    private Throwable mInitException = null;
    private InitConfig mInitConfig = null;
    private Site mSiteFromInit = null;
    private boolean mSiteFromRep = false;
    private boolean mTempPathSet = false;

    public void init(InitConfig config) throws ServletException {
        StringBuffer application_classpath;
        this.mInitConfig = config;
        StringBuffer stringBuffer = application_classpath = new StringBuffer();
        synchronized (stringBuffer) {
            Iterator iterator;
            String webapp_root = this.mInitConfig.getServletContext().getRealPath("/");
            if (webapp_root.endsWith(File.separator)) {
                webapp_root = webapp_root.substring(0, webapp_root.length() - File.separator.length());
            }
            application_classpath.append(webapp_root);
            application_classpath.append(File.separator + "WEB-INF" + File.separator + "classes");
            Set lib_resources = this.mInitConfig.getServletContext().getResourcePaths("/WEB-INF/lib");
            if (lib_resources != null) {
                iterator = ((Collection)lib_resources).iterator();
                while (iterator.hasNext()) {
                    String lib_resource = (String)iterator.next();
                    if (!lib_resource.endsWith(".jar")) continue;
                    application_classpath.append(File.pathSeparator);
                    application_classpath.append(webapp_root);
                    application_classpath.append(lib_resource);
                }
            }
            if (EngineClassLoaderRifeWebappPath.RIFE_WEBAPP_PATH != null) {
                iterator = ((Collection)EngineClassLoaderRifeWebappPath.RIFE_WEBAPP_PATH).iterator();
                while (iterator.hasNext()) {
                    String path = (String)iterator.next();
                    application_classpath.append(File.pathSeparator);
                    application_classpath.append(path);
                }
            }
            if (application_classpath.length() > 0) {
                RifeConfig.Global.setApplicationClassPath(application_classpath.toString());
            }
        }
    }

    public void handleInitException(Throwable e) {
        this.handleInitException(e, false);
    }

    private void handleSiteInitException(Throwable e) {
        this.handleInitException(e, true);
    }

    private void handleInitException(Throwable e, boolean isSiteInit) {
        if (isSiteInit || this.mInitException == null) {
            if (RifeConfig.Engine.getPrettyEngineExceptions()) {
                if (!isSiteInit) {
                    Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
                }
                this.mInitException = e;
            } else {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private Site obtainSite() {
        Site result;
        block7: {
            if (this.mSiteFromInit != null) {
                return this.mSiteFromInit;
            }
            result = null;
            try {
                if (this.mInitConfig == null) {
                    throw new ServletException("No servlet configuration is available, it is required to set up the site structure.");
                }
                this.mInitException = null;
                if (Site.hasRepInstance() && (result = Site.getRepInstance()) == null && ((ParticipantSite)Rep.getParticipant("ParticipantSite")).getException() != null) {
                    throw ((ParticipantSite)Rep.getParticipant("ParticipantSite")).getException();
                }
                if (this.mSiteFromRep) break block7;
                String site_xml_path = this.mInitConfig.getInitParameter("site.xml.path");
                if (site_xml_path == null) {
                    if (result == null) {
                        throw new ServletException("The required init parameter 'site.xml.path' is not provided.");
                    }
                    this.mSiteFromRep = true;
                    break block7;
                }
                ResourceFinderClasspath resourcefinder = ResourceFinderClasspath.getInstance();
                SiteBuilder builder = new SiteBuilder(site_xml_path, resourcefinder);
                this.mSiteFromInit = result = builder.getSite();
                this.mSiteFromRep = false;
            }
            catch (Throwable e) {
                this.handleSiteInitException(e);
            }
        }
        return result;
    }

    public boolean handleRequest(String gateUrl, String elementUrl, HttpServletRequest request, HttpServletResponse response) {
        if (!(this.mTempPathSet || Config.hasRepInstance() && Config.getRepInstance().hasParameter("TEMP_PATH"))) {
            RifeConfig.Global.setTempPath(System.getProperty("java.io.tmpdir") + File.separator + "rife_" + request.getServerName() + "_" + request.getServerPort() + "_" + request.getContextPath());
            File file_temp_path = new File(RifeConfig.Global.getTempPath());
            if (!file_temp_path.exists()) {
                if (!file_temp_path.mkdirs()) {
                    throw new EngineException("Couldn't create the temporary directory : '" + RifeConfig.Global.getTempPath() + "'.");
                }
            } else {
                if (!file_temp_path.isDirectory()) {
                    throw new EngineException("The element package directory '" + RifeConfig.Global.getTempPath() + "' exists but is not a directory.");
                }
                if (!file_temp_path.canWrite()) {
                    throw new EngineException("The element package directory '" + RifeConfig.Global.getTempPath() + "' is not writable.");
                }
            }
            this.mTempPathSet = true;
        } else {
            this.mTempPathSet = true;
        }
        Site site = this.obtainSite();
        if (elementUrl == null || 0 == elementUrl.length()) {
            elementUrl = "/";
        }
        if (this.mInitException != null) {
            Gate.printExceptionDetails(response, this.mInitException);
            return true;
        }
        try {
            ElementInfo element_info = null;
            StringBuffer element_url_buffer = new StringBuffer(elementUrl);
            int element_url_location = -1;
            String element_path_info = "";
            while ((element_info = -1 == element_url_location ? site.resolveUrl(element_url_buffer.toString()) : site.resolvePathInfoUrl(element_url_buffer.toString())) == null && -1 != (element_url_location = element_url_buffer.lastIndexOf("/"))) {
                element_url_buffer.setLength(element_url_location);
                if (element_url_location != -1) continue;
            }
            if (element_info == null) {
                element_info = site.searchFallback(elementUrl);
                if (element_info == null) {
                    return false;
                }
            } else if (!element_info.isPathInfoUsed() && elementUrl.length() != element_url_buffer.length()) {
                element_info = site.searchFallback(elementUrl);
                if (element_info == null) {
                    return false;
                }
            } else if (element_info.isPathInfoUsed() && !(element_path_info = elementUrl.substring(element_url_buffer.length())).startsWith("/")) {
                element_path_info = "/" + element_path_info;
            }
            Request rife_request = new Request(request, element_info.getStateStore());
            Response rife_response = new Response(rife_request, response, false);
            RequestState request_state = new RequestState(this.mInitConfig, site, rife_request, gateUrl, element_path_info, element_info, null);
            request_state.service(rife_response);
            rife_response.close();
        }
        catch (DeferException e) {
            return false;
        }
        catch (Throwable e) {
            String message = "Error on host " + request.getServerName() + ":" + request.getServerPort() + "/" + request.getContextPath();
            if (RifeConfig.Engine.getLogEngineExceptions()) {
                Logger.getLogger("com.uwyn.rife.engine").severe(message + "\n" + ExceptionUtils.getExceptionStackTrace(e));
            }
            if (!RifeConfig.Engine.getPrettyEngineExceptions()) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(message, e);
            }
            Gate.printExceptionDetails(response, e);
        }
        return true;
    }

    private static void printExceptionDetails(HttpServletResponse response, Throwable exception) {
        response.setContentType("text/html");
        Template template2 = null;
        template2 = exception instanceof ElementCompilationFailedException || exception instanceof TemplateCompilationFailedException ? TemplateFactory.HTML.get("html.rife.engine_error_compilation") : TemplateFactory.HTML.get("html.rife.engine_error_default");
        template2.setValue("exceptions", ExceptionUtils.formatExceptionStackTrace(exception, template2));
        template2.setValue("RIFE_VERSION", StringUtils.encodeHtml(Version.getVersion()));
        try {
            response.getWriter().print(template2.getContent());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

