/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.asm.ClassReader;
import com.uwyn.rife.asm.ClassWriter;
import com.uwyn.rife.engine.ContinuationDebug;
import com.uwyn.rife.engine.ElementDetectionClassVisitor;
import com.uwyn.rife.engine.MetricsClassVisitor;
import com.uwyn.rife.engine.ResumableClassAdapter;
import com.uwyn.rife.engine.TypesClassVisitor;
import com.uwyn.rife.resources.ModificationTimeClasspath;
import com.uwyn.rife.tools.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;

public class EngineClassLoader
extends URLClassLoader {
    static final String DEFAULT_IMPLEMENTATIONS_PATH = "implementations/";
    private static HashMap<String, Long> sModificationTimes;
    private static final String ENTRY_METHOD = "processElement()V";
    private static ArrayList<String> sRifeWebappPath;
    private static boolean sRifeWebappPathProcessed;
    private static /* synthetic */ boolean $assertionsDisabled;

    public EngineClassLoader(ClassLoader initiating) {
        super(new URL[0], initiating);
    }

    protected Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(classname, resolve, false);
    }

    public Class loadClass(String classname, boolean resolve, boolean loadElement) throws ClassNotFoundException {
        if (!$assertionsDisabled && classname == null) {
            throw new AssertionError();
        }
        String packagename = null;
        int packagename_index = classname.lastIndexOf(46);
        if (packagename_index != -1) {
            packagename = classname.substring(0, packagename_index);
        }
        boolean auto_reload = this.doAutoReload();
        Class<?> c = this.findLoadedClass(classname);
        if (c != null) {
            if (auto_reload && loadElement && this.isModified(classname)) {
                EngineClassLoader new_classloader = new EngineClassLoader(this);
                return new_classloader.loadClass(classname, resolve);
            }
        } else {
            if (c == null && classname.startsWith("java.")) {
                try {
                    c = this.findSystemClass(classname);
                }
                catch (ClassNotFoundException e) {
                    c = null;
                }
            }
            if (c == null) {
                boolean webapp_class = false;
                if (classname.intern() == "com.uwyn.rife.engine.EngineClassLoaderRifeWebappPath".intern()) {
                    webapp_class = true;
                } else {
                    Object object;
                    ClassLoader parent;
                    block67: {
                        if (!sRifeWebappPathProcessed) {
                            try {
                                Class<?> webapp_path_class = this.loadClass("com.uwyn.rife.engine.EngineClassLoaderRifeWebappPath");
                                Field webapp_path_field = webapp_path_class.getField("RIFE_WEBAPP_PATH");
                                sRifeWebappPath = (ArrayList)webapp_path_field.get(null);
                                sRifeWebappPathProcessed = true;
                            }
                            catch (Throwable e) {
                                throw new ClassNotFoundException(classname, e);
                            }
                        }
                        parent = this.getParent();
                        if (classname.startsWith("com.uwyn.rife.") || classname.startsWith("groovy.") || classname.startsWith("org.codehaus.groovy.")) {
                            webapp_class = true;
                        } else {
                            try {
                                File resource_file;
                                int exclamation_index;
                                String class_file = classname.replace('.', '/') + ".class";
                                URL resource = this.getResource(class_file);
                                if (resource == null) break block67;
                                String resource_path = resource.getPath();
                                String resource_protocol = resource.getProtocol();
                                if (resource_path.indexOf("WEB-INF") != -1) {
                                    webapp_class = true;
                                    break block67;
                                }
                                if (resource_protocol != null && resource_protocol.equals("classloader")) {
                                    webapp_class = true;
                                    break block67;
                                }
                                if (sRifeWebappPath == null) break block67;
                                if (resource_path.startsWith("jar:file:")) {
                                    resource_path = resource_path.substring("jar:file:".length());
                                }
                                if (resource_path.startsWith("file:")) {
                                    resource_path = resource_path.substring("file:".length());
                                }
                                if ((exclamation_index = resource_path.indexOf("!")) != -1) {
                                    resource_path = resource_path.substring(0, exclamation_index);
                                }
                                if (!(resource_file = new File(resource_path = URLDecoder.decode(resource_path, "ISO-8859-1"))).exists()) break block67;
                                resource_path = resource_file.getCanonicalPath();
                                object = ((Collection)sRifeWebappPath).iterator();
                                while (object.hasNext()) {
                                    String path = (String)object.next();
                                    if (!resource_path.startsWith(path)) continue;
                                    webapp_class = true;
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                webapp_class = false;
                            }
                        }
                    }
                    if (parent != null) {
                        try {
                            Class<?> clazz;
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("java.lang.ClassLoader");
                            }
                            catch (ClassNotFoundException resource) {
                                throw new NoClassDefFoundError(resource.getMessage());
                            }
                            Class[] classArray = new Class[1];
                            try {
                                clazz = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException resource_path) {
                                throw new NoClassDefFoundError(resource_path.getMessage());
                            }
                            classArray[0] = clazz;
                            Method method = clazz2.getDeclaredMethod("findLoadedClass", classArray);
                            method.setAccessible(true);
                            c = (Class<?>)method.invoke((Object)parent, (Object[])new String[]{classname});
                        }
                        catch (Throwable e) {
                            c = null;
                        }
                    }
                    if (c == null || auto_reload) {
                        byte[] raw_bytes = null;
                        int innerclass_index = classname.indexOf("$");
                        try {
                            raw_bytes = innerclass_index > -1 ? this.getClassBytes(auto_reload, classname.substring(0, innerclass_index), loadElement) : this.getClassBytes(auto_reload, classname, loadElement);
                        }
                        catch (ClassNotFoundException e) {
                            raw_bytes = null;
                        }
                        if (raw_bytes != null) {
                            if (!this.isElement(auto_reload, raw_bytes)) {
                                if (c == null) {
                                    if (!webapp_class) {
                                        try {
                                            c = parent.loadClass(classname);
                                        }
                                        catch (ClassNotFoundException e) {
                                            c = null;
                                        }
                                    } else {
                                        Object pkg;
                                        if (packagename != null && (pkg = this.getPackage(packagename)) == null) {
                                            this.definePackage(packagename, null, null, null, null, null, null, null);
                                        }
                                        classname = classname.intern();
                                        pkg = classname;
                                        synchronized (pkg) {
                                            c = this.findLoadedClass(classname);
                                            if (c == null) {
                                                if (innerclass_index > -1) {
                                                    raw_bytes = this.getClassBytes(auto_reload, classname, loadElement);
                                                }
                                                if ((c = this.defineClass(classname, raw_bytes, 0, raw_bytes.length)) == null) {
                                                    throw new ClassNotFoundException(classname);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                Package pkg;
                                if (innerclass_index > -1) {
                                    raw_bytes = this.getClassBytes(auto_reload, classname, loadElement);
                                }
                                long modification_time = this.getClassModificationTime(classname);
                                sModificationTimes.put(classname, new Long(modification_time));
                                byte[] resumable_bytes = null;
                                boolean skip_debug = false;
                                try {
                                    ContinuationDebug.LOGGER.finest("METRICS:");
                                    ClassReader metrics_reader = new ClassReader(raw_bytes);
                                    MetricsClassVisitor metrics_visitor = new MetricsClassVisitor(classname, ENTRY_METHOD);
                                    metrics_reader.accept(metrics_visitor, skip_debug);
                                    ContinuationDebug.LOGGER.finest("\n");
                                    if (metrics_visitor.getPauseCount() > 0) {
                                        ContinuationDebug.LOGGER.finest("TYPES:");
                                        ClassReader types_reader = new ClassReader(raw_bytes);
                                        TypesClassVisitor types_visitor = new TypesClassVisitor(metrics_visitor, classname, ENTRY_METHOD);
                                        types_reader.accept(types_visitor, skip_debug);
                                        ContinuationDebug.LOGGER.finest("\n");
                                        ContinuationDebug.LOGGER.finest("SOURCE:");
                                        ClassReader resumable_reader = new ClassReader(raw_bytes);
                                        ClassWriter resumable_writer = new ClassWriter(true);
                                        ResumableClassAdapter resumable_visitor = new ResumableClassAdapter(metrics_visitor, types_visitor, classname, ENTRY_METHOD, resumable_writer);
                                        resumable_reader.accept(resumable_visitor, skip_debug);
                                        resumable_bytes = resumable_writer.toByteArray();
                                        ContinuationDebug.LOGGER.finest("\n");
                                        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                                            ContinuationDebug.LOGGER.finest("RESULT:");
                                            ClassReader reporting_reader = new ClassReader(resumable_bytes);
                                            ResumableClassAdapter reporting_visitor = new ResumableClassAdapter(null, null, classname, ENTRY_METHOD, null);
                                            reporting_reader.accept(reporting_visitor, skip_debug);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    throw new ClassNotFoundException(classname, e);
                                }
                                if (packagename != null && (pkg = this.getPackage(packagename)) == null) {
                                    this.definePackage(packagename, null, null, null, null, null, null, null);
                                }
                                classname = classname.intern();
                                object = classname;
                                synchronized (object) {
                                    c = this.findLoadedClass(classname);
                                    if (c == null) {
                                        c = resumable_bytes == null ? this.defineClass(classname, raw_bytes, 0, raw_bytes.length) : this.defineClass(classname, resumable_bytes, 0, resumable_bytes.length);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (c == null) {
            try {
                c = this.getParent().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                c = null;
            }
        }
        if (c == null) {
            c = this.findSystemClass(classname);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError();
        }
        return c;
    }

    private boolean hasRepClass() {
        if (this.getParent() instanceof EngineClassLoader) {
            return ((EngineClassLoader)this.getParent()).hasRepClass();
        }
        try {
            return this.findLoadedClass("com.uwyn.rife.rep.Rep") != null;
        }
        catch (ClassCircularityError e) {
            return true;
        }
    }

    private boolean doAutoReload() {
        String string_value;
        Object value = System.getProperties().get("ELEMENT_AUTO_RELOAD");
        if (value == null) {
            return true;
        }
        return value instanceof String && ((string_value = (String)value).equals("1") || string_value.equalsIgnoreCase("t") || string_value.equalsIgnoreCase("true") || string_value.equalsIgnoreCase("y") || string_value.equalsIgnoreCase("yes") || string_value.equalsIgnoreCase("on"));
    }

    static String constructSourcePath(String classname) {
        String source_location = null;
        int innerclass_index = classname.indexOf("$");
        if (innerclass_index != -1) {
            String containing_classname = classname.substring(0, innerclass_index);
            source_location = containing_classname.replace('.', '/') + ".java";
        } else {
            source_location = classname.replace('.', '/') + ".java";
        }
        return source_location;
    }

    byte[] getClassBytes(boolean doAutoReload, String classname, boolean performCompilation) throws ClassNotFoundException {
        byte[] raw_bytes;
        block10: {
            raw_bytes = null;
            String class_filename = classname.replace('.', '/') + ".class";
            URL class_resource = this.getResource(class_filename);
            try {
                if (class_resource == null || doAutoReload && performCompilation && this.isModified(classname)) {
                    try {
                        if (!performCompilation && !this.hasRepClass()) {
                            throw new ClassNotFoundException(classname);
                        }
                        String source_location = EngineClassLoader.constructSourcePath(classname);
                        File class_file = this.compileClass(classname, source_location);
                        raw_bytes = FileUtils.readBytes(class_file);
                        break block10;
                    }
                    catch (Throwable e) {
                        Class<?> elementcompilation_failed_class = this.loadClass("com.uwyn.rife.engine.exceptions.ElementCompilationFailedException");
                        if (e.getClass() == elementcompilation_failed_class) {
                            throw (RuntimeException)e;
                        }
                        if (e instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)e;
                        }
                        throw new ClassNotFoundException(classname, e);
                    }
                }
                raw_bytes = FileUtils.readBytes(class_resource);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ClassNotFoundException("Error while reading the contents of the element class file '" + classname + "'.", e);
            }
        }
        return raw_bytes;
    }

    File compileClass(String classname, String sourceLocation) throws ClassNotFoundException {
        long source_modification_time;
        long class_modification_time;
        if (!$assertionsDisabled && classname == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sourceLocation == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !sourceLocation.endsWith(".java")) {
            throw new AssertionError();
        }
        URL source_resource = this.getSourceResource(sourceLocation, true);
        if (source_resource == null) {
            throw new ClassNotFoundException("Couldn't find the source file '" + sourceLocation + "'.");
        }
        int classname_index = classname.lastIndexOf(".");
        String element_package = null;
        String element_classname = null;
        if (classname_index != -1) {
            element_package = classname.substring(0, classname_index);
            element_classname = classname.substring(classname_index + 1);
        } else {
            element_classname = classname;
        }
        Object generation_path_object = null;
        try {
            Class<?> tests_class = this.loadClass("com.uwyn.rife.config.RifeConfig$Engine");
            Method method = tests_class.getMethod("getElementGenerationPath", null);
            generation_path_object = method.invoke(null, (Object[])null);
        }
        catch (Throwable e) {
            throw new ClassNotFoundException("Couldn't obtain the element bytecode generation path.", e);
        }
        String generation_path = (String)generation_path_object + File.separatorChar;
        String package_dir = "";
        package_dir = element_package != null ? generation_path + element_package.replace('.', File.separatorChar) + File.separator : generation_path;
        String filename_java = null;
        try {
            filename_java = URLDecoder.decode(source_resource.getPath(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClassNotFoundException("Couldn't decode the resource path '" + source_resource.getPath() + "'.", e);
        }
        String filename_class = package_dir + element_classname + ".class";
        File file_packagedir = new File(package_dir);
        File file_class = new File(filename_class);
        if (!file_packagedir.exists()) {
            if (!file_packagedir.mkdirs()) {
                throw new ClassNotFoundException("Couldn't create the package directory : '" + package_dir + "'.");
            }
        } else {
            if (!file_packagedir.isDirectory()) {
                throw new ClassNotFoundException("The package directory '" + package_dir + "' exists but is not a directory.");
            }
            if (!file_packagedir.canWrite()) {
                throw new ClassNotFoundException("The package directory '" + package_dir + "' is not writable.");
            }
        }
        boolean is_already_compiled = false;
        if (file_class.exists() && (class_modification_time = file_class.lastModified()) >= (source_modification_time = this.getSourceModificationTime(source_resource))) {
            is_already_compiled = true;
        }
        if (!is_already_compiled) {
            try {
                Class<?> clazz;
                Class<?> clazz2;
                Class<?> clazz3;
                Class<?> clazz4;
                Class<?> classloader_classpath_class = this.loadClass("com.uwyn.rife.engine.EngineClassLoaderClasspath");
                Field classloader_classpath_field = classloader_classpath_class.getField("CLASSPATH");
                String classloader_classpath = (String)classloader_classpath_field.get(null);
                Class<?> tests_class = this.loadClass("com.uwyn.rife.tools.CompilationUtils");
                Class[] classArray = new Class[4];
                try {
                    clazz4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[0] = clazz4;
                try {
                    clazz3 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[1] = clazz3;
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[2] = clazz2;
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[3] = clazz;
                Method method = tests_class.getMethod("compile", classArray);
                generation_path_object = method.invoke(null, filename_java, file_class, generation_path, classloader_classpath);
            }
            catch (InvocationTargetException e) {
                Class<?> compilation_failed_class = this.loadClass("com.uwyn.rife.tools.exceptions.CompilationFailedException");
                Throwable target_exception = e.getTargetException();
                if (compilation_failed_class == target_exception.getClass()) {
                    String sourcefilename = null;
                    String errors = null;
                    Throwable cause = null;
                    try {
                        Method sourcefilename_method = compilation_failed_class.getMethod("getSourceFilename", null);
                        sourcefilename = (String)sourcefilename_method.invoke((Object)target_exception, (Object[])null);
                        Method errors_method = compilation_failed_class.getMethod("getErrors", null);
                        errors = (String)errors_method.invoke((Object)target_exception, (Object[])null);
                        Method cause_method = compilation_failed_class.getMethod("getCause", null);
                        cause = (Throwable)cause_method.invoke((Object)target_exception, (Object[])null);
                    }
                    catch (Throwable e2) {
                        throw new ClassNotFoundException("Unexpected error while compiling the element source '" + filename_java + "'+.", e);
                    }
                    Object elementcompilation_failed_instance = null;
                    try {
                        Class<?> clazz;
                        Class<?> clazz5;
                        Class<?> clazz6;
                        Class<?> elementcompilation_failed_class = this.loadClass("com.uwyn.rife.engine.exceptions.ElementCompilationFailedException");
                        Class[] classArray = new Class[3];
                        try {
                            clazz6 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[0] = clazz6;
                        try {
                            clazz5 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[1] = clazz5;
                        try {
                            clazz = Class.forName("java.lang.Throwable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[2] = clazz;
                        Constructor<?> elementcompilation_failed_constructor = elementcompilation_failed_class.getConstructor(classArray);
                        elementcompilation_failed_instance = elementcompilation_failed_constructor.newInstance(sourcefilename, errors, cause);
                    }
                    catch (Throwable e2) {
                        throw new ClassNotFoundException("Unexpected error while compiling the element source '" + filename_java + "'+.", e);
                    }
                    throw (RuntimeException)elementcompilation_failed_instance;
                }
                throw new ClassNotFoundException("Unexpected error while compiling the element source '" + filename_java + "'.", e);
            }
            catch (Throwable e) {
                throw new ClassNotFoundException("Unexpected error while compiling the element source '" + filename_java + "'.", e);
            }
        }
        if (!$assertionsDisabled && file_class == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file_class.exists()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file_class.canRead()) {
            throw new AssertionError();
        }
        return file_class;
    }

    private URL getSourceResource(String sourceLocation, boolean getElement) {
        URL source_resource = this.getResource(sourceLocation);
        if (source_resource == null && getElement) {
            source_resource = this.getResource(DEFAULT_IMPLEMENTATIONS_PATH + sourceLocation);
        }
        return source_resource;
    }

    private boolean isElement(boolean doAutoReload, byte[] bytes) throws ClassNotFoundException {
        ElementDetectionClassVisitor detection_visitor = new ElementDetectionClassVisitor(this);
        return detection_visitor.isElement(doAutoReload, bytes);
    }

    private long getClassModificationTime(String classname) {
        return this.getSourceModificationTime(this.getSourceResource(EngineClassLoader.constructSourcePath(classname), true));
    }

    private long getSourceModificationTime(URL sourceResource) {
        if (sourceResource == null) {
            return -1;
        }
        try {
            return ModificationTimeClasspath.getModificationTime(sourceResource);
        }
        catch (Throwable e) {
            return -1;
        }
    }

    private boolean isModified(String classname) {
        Long last_modification_time = sModificationTimes.get(classname);
        if (last_modification_time == null) {
            return false;
        }
        long current_modification_time = this.getClassModificationTime(classname);
        return current_modification_time > last_modification_time;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.EngineClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        sModificationTimes = new HashMap();
        sRifeWebappPath = null;
        sRifeWebappPathProcessed = false;
    }
}

