/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ContinuationContext;
import com.uwyn.rife.engine.ElementAware;
import com.uwyn.rife.engine.ElementChildTrigger;
import com.uwyn.rife.engine.ElementContext;
import com.uwyn.rife.engine.ElementDeployer;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementInitializer;
import com.uwyn.rife.engine.EmbeddingContext;
import com.uwyn.rife.engine.InitConfig;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.UploadedFile;
import com.uwyn.rife.engine.exceptions.AnswerException;
import com.uwyn.rife.engine.exceptions.ChildTriggerNotImplementedException;
import com.uwyn.rife.engine.exceptions.ElementContextMissingException;
import com.uwyn.rife.engine.exceptions.ElementInfoMissingException;
import com.uwyn.rife.engine.exceptions.RawAccessDeniedException;
import com.uwyn.rife.engine.exceptions.RequestAccessDeniedException;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.ObjectUtils;
import com.uwyn.rife.tools.ServletUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSupport
implements Cloneable {
    private ElementAware mElementAware = null;
    private ElementInfo mElementInfo = null;
    private ElementContext mElementContext = null;
    private boolean mRequestAccessEnabled = true;
    private ElementInitializer mInitializer = null;
    private ElementChildTrigger mChildTrigger = null;
    private Class mDeploymentClass = null;
    private boolean mProhibitRawAccess = true;
    private boolean mCloneContinuations = true;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected ElementSupport() {
    }

    public void setInitializer(ElementInitializer initializer) {
        this.mInitializer = initializer;
    }

    public void initialize() {
        if (this.mInitializer != null) {
            this.mInitializer.initialize();
        }
    }

    public void setChildTrigger(ElementChildTrigger childTrigger) {
        this.mChildTrigger = childTrigger;
    }

    public boolean childTriggered(String name, String[] values) {
        if (this.mChildTrigger == null) {
            throw new ChildTriggerNotImplementedException(this.getClass().getName(), name);
        }
        return this.mChildTrigger.childTriggered(name, values);
    }

    public void setDeploymentClass(Class<? extends ElementDeployer> klass) {
        this.mDeploymentClass = klass;
    }

    public Class getDeploymentClass() {
        return this.mDeploymentClass;
    }

    public void setProhibitRawAccess(boolean access) {
        this.mProhibitRawAccess = access;
    }

    public boolean prohibitRawAccess() {
        return this.mProhibitRawAccess;
    }

    public void setCloneContinuations(boolean clone) {
        this.mCloneContinuations = clone;
    }

    public boolean cloneContinuations() {
        return this.mCloneContinuations;
    }

    public final void pause() {
    }

    public final Object call(String exit) {
        return null;
    }

    public final void answer() {
        this.answer(null);
    }

    public final void answer(Object answer) {
        throw new AnswerException(this.mElementContext, answer);
    }

    public Template getHtmlTemplate(String name) {
        return this.getHtmlTemplate(name, null, null);
    }

    public Template getHtmlTemplate(String name, TemplateTransformer transformer) {
        return this.getHtmlTemplate(name, null, transformer);
    }

    public Template getHtmlTemplate(String name, String encoding) {
        return this.getHtmlTemplate(name, encoding, null);
    }

    public Template getHtmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getHtmlTemplate(name, encoding, transformer);
    }

    public Template getXhtmlTemplate(String name) {
        return this.getXhtmlTemplate(name, null, null);
    }

    public Template getXhtmlTemplate(String name, TemplateTransformer transformer) {
        return this.getXhtmlTemplate(name, null, transformer);
    }

    public Template getXhtmlTemplate(String name, String encoding) {
        return this.getXhtmlTemplate(name, encoding, null);
    }

    public Template getXhtmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getXhtmlTemplate(name, encoding, transformer);
    }

    public Template getXmlTemplate(String name) {
        return this.getXmlTemplate(name, null, null);
    }

    public Template getXmlTemplate(String name, TemplateTransformer transformer) {
        return this.getXmlTemplate(name, null, transformer);
    }

    public Template getXmlTemplate(String name, String encoding) {
        return this.getXmlTemplate(name, encoding, null);
    }

    public Template getXmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getXmlTemplate(name, encoding, transformer);
    }

    public Template getTextTemplate(String name) {
        return this.getTextTemplate(name, null, null);
    }

    public Template getTextTemplate(String name, TemplateTransformer transformer) {
        return this.getTextTemplate(name, null, transformer);
    }

    public Template getTextTemplate(String name, String encoding) {
        return this.getTextTemplate(name, encoding, null);
    }

    public Template getTextTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getTxtTemplate(name, encoding, transformer);
    }

    public String encodeHtml(String source) {
        return StringUtils.encodeHtml(source);
    }

    public String encodeXml(String source) {
        return StringUtils.encodeXml(source);
    }

    public void enableTextBuffer(boolean enabled) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().enableTextBuffer(enabled);
    }

    public boolean isTextBufferEnabled() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getResponse().isTextBufferEnabled();
    }

    public void print(Template template2) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        this.mElementContext.print(template2);
    }

    public List<String> processTemplate(Template template2) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        return this.mElementContext.processTemplate(template2);
    }

    public void print(Object value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().print(value);
    }

    public void printContent(Template template2) {
        this.print(template2);
    }

    public void printContent(Object value) {
        this.print(value);
    }

    public OutputStream getOutputStream() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getResponse().getOutputStream();
    }

    public void flush() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().flush();
    }

    public Site getSite() {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getSite();
    }

    public ElementDeployer getDeployer() {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getDeployer();
    }

    public ElementInfo getElementInfo() {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo;
    }

    public String getSourceName() {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getImplementation();
    }

    public String getDeclarationName() {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getDeclarationName();
    }

    public ElementInfo getTarget() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getTarget();
    }

    public ElementSupport getEmbeddingElement() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        EmbeddingContext embedding_context = this.mElementContext.getRequestState().getEmbeddingContext();
        if (embedding_context == null) {
            return null;
        }
        return embedding_context.getEmbeddingElement();
    }

    public Template getEmbeddingTemplate() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        EmbeddingContext embedding_context = this.mElementContext.getRequestState().getEmbeddingContext();
        if (embedding_context == null) {
            return null;
        }
        return embedding_context.getTemplate();
    }

    public String getEmbedValue() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getEmbedValue();
    }

    public Properties getEmbedProperties() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getEmbedProperties();
    }

    public boolean hasEmbedValue() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getEmbedValue() != null;
    }

    public boolean hasProperty(String name) {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.hasProperty(name);
    }

    public Object getProperty(String name) {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getProperty(name);
    }

    public String getPropertyString(String name) {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getPropertyString(name);
    }

    public String getPropertyString(String name, String defaultValue) {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.getPropertyString(name, defaultValue);
    }

    public boolean isPropertyEmpty(String name) {
        if (this.mElementInfo == null) {
            throw new ElementInfoMissingException();
        }
        return this.mElementInfo.isPropertyEmpty(name);
    }

    public <BeanType> BeanType getNamedInputBean(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getNamedInputBean(name);
    }

    public <BeanType> BeanType getInputBean(Class<BeanType> beanClass) {
        return this.getInputBean(beanClass, null);
    }

    public <BeanType> BeanType getInputBean(Class<BeanType> beanClass, String prefix) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        return this.mElementContext.getInputBean(beanClass, prefix);
    }

    public boolean hasInputValue(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.hasInputValue(name);
    }

    public boolean isInputEmpty(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.isInputEmpty(name);
    }

    public String getInput(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getInput(name);
    }

    public String getInput(String name, String defaultValue) {
        String input = this.getInput(name);
        if (input == null) {
            return defaultValue;
        }
        return input;
    }

    public String[] getInputValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getInputValues(name);
    }

    public boolean getInputBoolean(String name) {
        return this.getInputBoolean(name, false);
    }

    public boolean getInputBoolean(String name, boolean defaultValue) {
        String value = this.getInput(name);
        if (value == null) {
            return defaultValue;
        }
        return StringUtils.convertToBoolean(value);
    }

    public int getInputInt(String name) {
        return this.getInputInt(name, 0);
    }

    public int getInputInt(String name, int defaultValue) {
        String value = this.getInput(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getInputLong(String name) {
        return this.getInputLong(name, 0L);
    }

    public long getInputLong(String name, long defaultValue) {
        String value = this.getInput(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getInputDouble(String name) {
        return this.getInputDouble(name, 0.0);
    }

    public double getInputDouble(String name, double defaultValue) {
        String value = this.getInput(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getInputFloat(String name) {
        return this.getInputFloat(name, 0.0f);
    }

    public float getInputFloat(String name, float defaultValue) {
        String value = this.getInput(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Collection<String> selectInputParameter(Template template2, String name, String[] values) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.selectInputParameter(template2, name, values);
    }

    public void setOutput(String name, String value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        this.mElementContext.setOutput(name, value);
    }

    public void setOutput(String name, String[] values) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (values == null) {
            throw new IllegalArgumentException("values can't be null.");
        }
        if (0 == values.length) {
            throw new IllegalArgumentException("values can't be empty.");
        }
        this.mElementContext.setOutput(name, values);
    }

    public void setOutput(String name, boolean value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, char value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, char[] value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, double value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, float value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, int value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, long value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, String.valueOf(value));
    }

    public void setOutput(String name, Object value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.setOutput(name, value);
    }

    public void addOutputValue(String name, String value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        this.mElementContext.addOutputValue(name, value);
    }

    public void addOutputValues(String name, String[] values) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (values == null) {
            throw new IllegalArgumentException("values can't be null.");
        }
        if (0 == values.length) {
            throw new IllegalArgumentException("values can't be empty.");
        }
        this.mElementContext.addOutputValues(name, values);
    }

    public void addOutputValue(String name, boolean value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, char value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, char[] value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, double value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, float value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, int value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, long value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, String.valueOf(value));
    }

    public void addOutputValue(String name, Object value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.addOutputValue(name, value);
    }

    public void setNamedOutputBean(String name, Object bean) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        this.mElementContext.setNamedOutputBean(name, bean);
    }

    public void setOutputBean(Object bean) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        this.mElementContext.setOutputBean(bean, null);
    }

    public void setOutputBean(Object bean, String prefix) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        this.mElementContext.setOutputBean(bean, prefix);
    }

    public void clearOutput(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.clearOutput(name);
    }

    public void clearNamedOutputBean(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.clearNamedOutputBean(name);
    }

    public void clearOutputBean(Class beanClass) {
        this.clearOutputBean(beanClass, null);
    }

    public void clearOutputBean(Class beanClass, String prefix) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.mElementContext.clearOutputBean(beanClass, prefix);
    }

    public boolean hasCookie(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.hasCookie(name);
    }

    public Cookie getCookie(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getCookie(name);
    }

    public String getCookieValue(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getCookieValue(name);
    }

    public Map<String, String> getCookieValues() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getCookieValues();
    }

    public String getCookieValue(String name, String defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getCookieValueBoolean(String name) {
        return this.getCookieValueBoolean(name, false);
    }

    public boolean getCookieValueBoolean(String name, boolean defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        return StringUtils.convertToBoolean(value);
    }

    public int getCookieValueInt(String name) {
        return this.getCookieValueInt(name, 0);
    }

    public int getCookieValueInt(String name, int defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getCookieValueLong(String name) {
        return this.getCookieValueLong(name, 0L);
    }

    public long getCookieValueLong(String name, long defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getCookieValueDouble(String name) {
        return this.getCookieValueDouble(name, 0.0);
    }

    public double getCookieValueDouble(String name, double defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getCookieValueFloat(String name) {
        return this.getCookieValueFloat(name, 0.0f);
    }

    public float getCookieValueFloat(String name, float defaultValue) {
        String value = this.getCookieValue(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setCookie(Cookie cookie) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (cookie == null) {
            throw new IllegalArgumentException("cookie can't be null.");
        }
        if (cookie.getName() == null) {
            throw new IllegalArgumentException("cookie name can't be empty.");
        }
        this.mElementContext.setCookie(cookie);
    }

    public String getContinuationId() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        return ContinuationContext.getActiveContextId();
    }

    public String getExitQueryUrl(String name) {
        return this.getExitQueryUrl(name, null, null);
    }

    public String getExitQueryUrl(String name, String pathinfo) {
        return this.getExitQueryUrl(name, pathinfo, null);
    }

    public String getExitQueryUrl(String name, String[] outputValues) {
        return this.getExitQueryUrl(name, null, outputValues);
    }

    public String getExitQueryUrl(String name, String pathinfo, String[] outputValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (outputValues != null && outputValues.length % 2 > 0) {
            throw new IllegalArgumentException("outputValues should be a series of key/value pairs.");
        }
        return this.mElementContext.getExitQueryUrl(name, pathinfo, outputValues);
    }

    public String getExitFormUrl(String name) {
        return this.getExitFormUrl(name, null);
    }

    public String getExitFormUrl(String name, String pathinfo) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getExitFormUrl(name, pathinfo);
    }

    public String getExitFormParameters(String name) {
        return this.getExitFormParameters(name, null);
    }

    public String getExitFormParameters(String name, String[] outputValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (outputValues != null && outputValues.length % 2 > 0) {
            throw new IllegalArgumentException("outputValues should be a series of key/value pairs.");
        }
        return this.mElementContext.getExitFormParameters(name, outputValues);
    }

    public void setExitQuery(Template template2, String name) {
        this.setExitQuery(template2, name, null, null);
    }

    public void setExitQuery(Template template2, String name, String pathinfo) {
        this.setExitQuery(template2, name, pathinfo, null);
    }

    public void setExitQuery(Template template2, String name, String[] outputValues) {
        this.setExitQuery(template2, name, null, outputValues);
    }

    public void setExitQuery(Template template2, String name, String pathinfo, String[] outputValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (outputValues != null && outputValues.length % 2 > 0) {
            throw new IllegalArgumentException("outputValues should be a series of key/value pairs.");
        }
        this.mElementContext.setExitQuery(template2, name, pathinfo, outputValues);
    }

    public void setExitForm(Template template2, String name) {
        this.setExitForm(template2, name, null, null);
    }

    public void setExitForm(Template template2, String name, String pathinfo) {
        this.setExitForm(template2, name, pathinfo, null);
    }

    public void setExitForm(Template template2, String name, String[] outputValues) {
        this.setExitForm(template2, name, null, outputValues);
    }

    public void setExitForm(Template template2, String name, String pathinfo, String[] outputValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (outputValues != null && outputValues.length % 2 > 0) {
            throw new IllegalArgumentException("outputValues should be a series of key/value pairs.");
        }
        this.mElementContext.setExitForm(template2, name, pathinfo, outputValues);
    }

    public Collection<String> selectParameter(Template template2, String name, String[] values) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.selectParameter(template2, name, values);
    }

    public void generateForm(Template template2, Object beanInstance) {
        this.generateForm(template2, beanInstance, null);
    }

    public void generateForm(Template template2, Object beanInstance, String prefix) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (beanInstance == null) {
            throw new IllegalArgumentException("beanInstance can't be null.");
        }
        this.mElementContext.generateForm(template2, beanInstance, prefix);
    }

    public void generateEmptyForm(Template template2, Class beanClass) {
        this.generateEmptyForm(template2, beanClass, null);
    }

    public void generateEmptyForm(Template template2, Class beanClass, String prefix) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.mElementContext.generateEmptyForm(template2, beanClass, prefix);
    }

    public void removeForm(Template template2, Class beanClass) {
        this.removeForm(template2, beanClass, null);
    }

    public void removeForm(Template template2, Class beanClass, String prefix) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.mElementContext.removeForm(template2, beanClass, prefix);
    }

    public Collection<String> selectSubmissionParameter(Template template2, String name, String[] values) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.selectSubmissionParameter(template2, name, values);
    }

    public Collection selectSubmissionParameter(Template template2, String name, String value) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.selectSubmissionParameter(template2, name, new String[]{value});
    }

    public void setSubmissionBean(Template template2, Object beanInstance) {
        this.setSubmissionBean(template2, beanInstance, true);
    }

    public void setSubmissionBean(Template template2, Object beanInstance, boolean encode) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (beanInstance == null) {
            throw new IllegalArgumentException("beanInstance can't be null.");
        }
        this.mElementContext.setSubmissionBean(template2, beanInstance, encode);
    }

    public <BeanType> BeanType getNamedSubmissionBean(String beanName) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (beanName == null) {
            throw new IllegalArgumentException("beanName can't be null.");
        }
        if (0 == beanName.length()) {
            throw new IllegalArgumentException("beanName can't be empty.");
        }
        String submission_name = this.mElementContext.getSubmission();
        if (submission_name == null) {
            return null;
        }
        return this.mElementContext.getNamedSubmissionBean(submission_name, beanName);
    }

    public <BeanType> BeanType getNamedSubmissionBean(String submissionName, String beanName) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("beanName can't be null.");
        }
        if (0 == beanName.length()) {
            throw new IllegalArgumentException("beanName can't be empty.");
        }
        return this.mElementContext.getNamedSubmissionBean(submissionName, beanName);
    }

    public <BeanType> BeanType getSubmissionBean(Class<BeanType> beanClass) {
        String submission_name = this.mElementContext.getSubmission();
        if (submission_name == null) {
            return null;
        }
        return this.getSubmissionBean(submission_name, beanClass, null);
    }

    public <BeanType> BeanType getSubmissionBean(Class<BeanType> beanClass, String prefix) {
        String submission_name = this.mElementContext.getSubmission();
        if (submission_name == null) {
            return null;
        }
        return this.getSubmissionBean(submission_name, beanClass, prefix);
    }

    public <BeanType> BeanType getSubmissionBean(String submissionName, Class<BeanType> beanClass) {
        return this.getSubmissionBean(submissionName, beanClass, null);
    }

    public <BeanType> BeanType getSubmissionBean(String submissionName, Class<BeanType> beanClass, String prefix) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        return this.mElementContext.getSubmissionBean(submissionName, beanClass, prefix);
    }

    public void fillSubmissionBean(Object bean) {
        String submission_name = this.mElementContext.getSubmission();
        if (submission_name == null) {
            return;
        }
        this.fillSubmissionBean(submission_name, bean, null);
    }

    public void fillSubmissionBean(String submissionName, Object bean) {
        this.fillSubmissionBean(submissionName, bean, null);
    }

    public void fillSubmissionBean(Object bean, String prefix) {
        String submission_name = this.mElementContext.getSubmission();
        if (submission_name == null) {
            return;
        }
        this.fillSubmissionBean(submission_name, bean, prefix);
    }

    public void fillSubmissionBean(String submissionName, Object bean, String prefix) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        this.mElementContext.fillSubmissionBean(submissionName, bean, prefix);
    }

    public boolean hasSubmission() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.hasSubmission();
    }

    public boolean hasSubmission(String submissionName) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        return this.mElementContext.hasSubmission(submissionName);
    }

    public String getSubmission() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getSubmission();
    }

    public boolean hasParameterValue(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.hasParameterValue(name);
    }

    public boolean isParameterEmpty(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.isParameterEmpty(name);
    }

    public String getParameter(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getParameter(name);
    }

    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public ArrayList<String> getParameterNames() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getParameterNames(null);
    }

    public ArrayList<String> getParameterNames(String regexp) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getParameterNames(regexp);
    }

    public String[] getParameterValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getParameterValues(name);
    }

    public boolean getParameterBoolean(String name) {
        return this.getParameterBoolean(name, false);
    }

    public boolean getParameterBoolean(String name, boolean defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return StringUtils.convertToBoolean(value);
    }

    public int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    public int getParameterInt(String name, int defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getParameterLong(String name) {
        return this.getParameterLong(name, 0L);
    }

    public long getParameterLong(String name, long defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getParameterDouble(String name) {
        return this.getParameterDouble(name, 0.0);
    }

    public double getParameterDouble(String name, double defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getParameterFloat(String name) {
        return this.getParameterFloat(name, 0.0f);
    }

    public float getParameterFloat(String name, float defaultValue) {
        String value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int[] getParameterIntValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return ArrayUtils.createIntArray(this.mElementContext.getParameterValues(name));
    }

    public long[] getParameterLongValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return ArrayUtils.createLongArray(this.mElementContext.getParameterValues(name));
    }

    public float[] getParameterFloatValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return ArrayUtils.createFloatArray(this.mElementContext.getParameterValues(name));
    }

    public double[] getParameterDoubleValues(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return ArrayUtils.createDoubleArray(this.mElementContext.getParameterValues(name));
    }

    public ArrayList<String> getUploadedFileNames() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getUploadedFileNames();
    }

    public boolean hasUploadedFile(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.hasUploadedFile(name);
    }

    public boolean isFileEmpty(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.isFileEmpty(name);
    }

    public UploadedFile getUploadedFile(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getUploadedFile(name);
    }

    public UploadedFile[] getUploadedFiles(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mElementContext.getUploadedFiles(name);
    }

    public String getSubmissionQueryUrl(String name) {
        return this.getSubmissionQueryUrl(name, null, null);
    }

    public String getSubmissionQueryUrl(String name, String pathinfo) {
        return this.getSubmissionQueryUrl(name, pathinfo, null);
    }

    public String getSubmissionQueryUrl(String name, String[] parameterValues) {
        return this.getSubmissionQueryUrl(name, null, parameterValues);
    }

    public String getSubmissionQueryUrl(String name, String pathinfo, String[] parameterValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (parameterValues != null && parameterValues.length % 2 > 0) {
            throw new IllegalArgumentException("parameterValues should be a series of key/value pairs.");
        }
        return this.mElementContext.getSubmissionQueryUrl(name, pathinfo, parameterValues);
    }

    public String getSubmissionFormUrl() {
        return this.getSubmissionFormUrl(null);
    }

    public String getSubmissionFormUrl(String pathinfo) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getSubmissionFormUrl(pathinfo);
    }

    public String getSubmissionFormParameters(String name) {
        return this.getSubmissionFormParameters(name, null);
    }

    public String getSubmissionFormParameters(String name, String[] parameterValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (parameterValues != null && parameterValues.length % 2 > 0) {
            throw new IllegalArgumentException("parameterValues should be a series of key/value pairs.");
        }
        return this.mElementContext.getSubmissionFormParameters(name, parameterValues);
    }

    public void setSubmissionQuery(Template template2, String name) {
        this.setSubmissionQuery(template2, name, null, null);
    }

    public void setSubmissionQuery(Template template2, String name, String pathinfo) {
        this.setSubmissionQuery(template2, name, pathinfo, null);
    }

    public void setSubmissionQuery(Template template2, String name, String[] parameterValues) {
        this.setSubmissionQuery(template2, name, null, parameterValues);
    }

    public void setSubmissionQuery(Template template2, String name, String pathinfo, String[] parameterValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (parameterValues != null && parameterValues.length % 2 > 0) {
            throw new IllegalArgumentException("parameterValues should be a series of key/value pairs.");
        }
        this.mElementContext.setSubmissionQuery(template2, name, pathinfo, parameterValues);
    }

    public void setSubmissionForm(Template template2, String name) {
        this.setSubmissionForm(template2, name, null, null);
    }

    public void setSubmissionForm(Template template2, String name, String pathinfo) {
        this.setSubmissionForm(template2, name, pathinfo, null);
    }

    public void setSubmissionForm(Template template2, String name, String[] parameterValues) {
        this.setSubmissionForm(template2, name, null, parameterValues);
    }

    public void setSubmissionForm(Template template2, String name, String pathinfo, String[] parameterValues) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (parameterValues != null && parameterValues.length % 2 > 0) {
            throw new IllegalArgumentException("parameterValues should be a series of key/value pairs.");
        }
        this.mElementContext.setSubmissionForm(template2, name, pathinfo, parameterValues);
    }

    public void processEmbeddedElement(Template template2, String elementId) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (elementId == null) {
            throw new IllegalArgumentException("elementId can't be null.");
        }
        if (0 == elementId.length()) {
            throw new IllegalArgumentException("elementId can't be empty.");
        }
        this.mElementContext.processEmbeddedElement(template2, this, elementId, null);
    }

    public void processEmbeddedElement(Template template2, String elementId, String differentiator) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (elementId == null) {
            throw new IllegalArgumentException("elementId can't be null.");
        }
        if (0 == elementId.length()) {
            throw new IllegalArgumentException("elementId can't be empty.");
        }
        this.mElementContext.processEmbeddedElement(template2, this, elementId, differentiator);
    }

    public void evaluateExpressionRoleUserTags(Template template2, String id) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (template2 == null) {
            throw new IllegalArgumentException("template can't be null.");
        }
        if (id == null) {
            return;
        }
        this.mElementContext.evaluateExpressionRoleUserTags(template2, id);
    }

    public void exit(String name) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.mElementContext.exit(name);
    }

    public void child() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.child();
    }

    public void defer() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.defer();
    }

    public void forward(String url) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.forward(url);
    }

    public void redirect(String url) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.redirect(url);
    }

    public String getResponseCharacterEncoding() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getResponse().getCharacterEncoding();
    }

    public void setContentLength(int length) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setContentLength(length);
    }

    public void setContentType(String value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setContentType(value);
    }

    public void addHeader(String name, String value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().addHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().addDateHeader(name, date);
    }

    public void addIntHeader(String name, int integer) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().addIntHeader(name, integer);
    }

    public boolean containsHeader(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getResponse().containsHeader(name);
    }

    public void sendError(int statusCode) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().sendError(statusCode);
    }

    public void sendError(int statusCode, String message) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().sendError(statusCode, message);
    }

    public void sendRedirect(String location) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().sendRedirect(location);
    }

    public void preventCaching() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        ServletUtils.preventCaching(this.mElementContext.getResponse().getHttpServletResponse());
    }

    public void setDateHeader(String name, long date) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setIntHeader(name, value);
    }

    public void setStatus(int statusCode) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setStatus(statusCode);
    }

    public void setResponseLocale(Locale locale) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getResponse().setLocale(locale);
    }

    public Locale getResponseLocale(Locale locale) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getResponse().getLocale();
    }

    public String getServerRootUrl() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getServerRootUrl(-1);
    }

    public String getWebappRootUrl() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getWebappRootUrl(-1);
    }

    public String getRequestCharacterEncoding() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getCharacterEncoding();
    }

    public String getContentType() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getContentType();
    }

    public long getDateHeader(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getDateHeader(name);
    }

    public String getHeader(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getHeader(name);
    }

    public Enumeration getHeaderNames() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getHeaders(name);
    }

    public InitConfig getInitConfig() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getInitConfig();
    }

    public int getIntHeader(String name) {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getIntHeader(name);
    }

    public Locale getRequestLocale() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getLocale();
    }

    public Enumeration getRequestLocales() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getLocales();
    }

    public String getPathInfo() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getElementState().getPathInfo();
    }

    public RequestMethod getMethod() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getElementState().getMethod();
    }

    public String getProtocol() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getProtocol();
    }

    public String getRemoteAddr() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRemoteAddr();
    }

    public String getRemoteUser() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRemoteUser();
    }

    public String getRemoteHost() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRemoteHost();
    }

    public int getServerPort() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getServerPort();
    }

    public String getScheme() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getScheme();
    }

    public String getServerName() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getServerName();
    }

    public boolean isSecure() {
        if (!this.mRequestAccessEnabled) {
            throw new RequestAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().isSecure();
    }

    public Object getRequestAttribute(String name) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRequestAttribute(name);
    }

    public boolean hasRequestAttribute(String name) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().hasRequestAttribute(name);
    }

    public Enumeration getRequestAttributeNames() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRequestAttributeNames();
    }

    public void removeRequestAttribute(String name) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getRequestState().removeRequestAttribute(name);
    }

    public void setRequestAttribute(String name, Object object) {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        this.mElementContext.getRequestState().setRequestAttribute(name, object);
    }

    public ElementContext getElementContext() {
        if (this.prohibitRawAccess()) {
            throw new RawAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext;
    }

    public HttpServletRequest getHttpServletRequest() {
        if (this.prohibitRawAccess()) {
            throw new RawAccessDeniedException();
        }
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getRequest().getHttpServletRequest();
    }

    public ServletContext getServletContext() {
        if (this.mElementContext == null) {
            throw new ElementContextMissingException();
        }
        return this.mElementContext.getRequestState().getInitConfig().getServletContext();
    }

    void setElementAware(ElementAware elementAware) {
        this.mElementAware = elementAware;
        elementAware.noticeElement(this);
    }

    ElementAware getElementAware() {
        return this.mElementAware;
    }

    ElementContext _getElementContext() {
        return this.mElementContext;
    }

    void setElementContext(ElementContext elementContext) {
        this.mElementContext = elementContext;
    }

    void setElementInfo(ElementInfo elementInfo) {
        if (!$assertionsDisabled && elementInfo == null) {
            throw new AssertionError();
        }
        this.mElementInfo = elementInfo;
    }

    void enableRequestAccess(boolean enabled) {
        this.mRequestAccessEnabled = enabled;
    }

    protected Object clone() throws CloneNotSupportedException {
        ElementSupport new_elementsupport = (ElementSupport)super.clone();
        new_elementsupport.mElementContext = null;
        if (this == this.mElementAware) {
            new_elementsupport.mElementAware = (ElementAware)((Object)new_elementsupport);
        } else {
            new_elementsupport.mElementAware = ObjectUtils.genericClone(this.mElementAware);
            if (new_elementsupport.mElementAware == null) {
                throw new CloneNotSupportedException();
            }
        }
        new_elementsupport.mElementAware.noticeElement(new_elementsupport);
        return new_elementsupport;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementSupport");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

