/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.engine.ElementInfoProcessor;
import com.uwyn.rife.engine.Groovy2ElementInfo;
import com.uwyn.rife.engine.Janino2ElementInfo;
import com.uwyn.rife.engine.Xml2ElementInfo;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInfoProcessorFactory
extends EnumClass<String> {
    public static final String MANUAL_IDENTIFIER = "manual";
    public static final String XML_IDENTIFIER = "xml";
    public static final String GROOVY_IDENTIFIER = "groovy";
    public static final String JANINO_IDENTIFIER = "janino";
    public static final ElementInfoProcessorFactory MANUAL = new ElementInfoProcessorFactory("manual", null, null);
    public static final ElementInfoProcessorFactory XML = new ElementInfoProcessorFactory("xml", "xml", new Xml2ElementInfo());
    public static final ElementInfoProcessorFactory GROOVY = new ElementInfoProcessorFactory("groovy", "groovy", new Groovy2ElementInfo());
    public static final ElementInfoProcessorFactory JANINO = new ElementInfoProcessorFactory("janino", "janino", new Janino2ElementInfo());
    private String mExtension = null;
    private ElementInfoProcessor mProcessor = null;

    public ElementInfoProcessorFactory(String identifier, String extension, ElementInfoProcessor processor) {
        super(identifier);
        this.mExtension = extension;
        this.mProcessor = processor;
    }

    public String getExtension() {
        return this.mExtension;
    }

    public ElementInfoProcessor getProcessor() {
        return this.mProcessor;
    }

    public static ElementInfoProcessorFactory getElementInfoProcessorFactory(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementInfoProcessorFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (ElementInfoProcessorFactory)EnumClass.getMember(clazz, identifier);
    }

    public static Collection<ElementInfoProcessorFactory> getElementInfoProcessorFactories() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementInfoProcessorFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return EnumClass.getMembers(clazz);
    }
}

