/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.DataLink;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.engine.ElementDeployer;
import com.uwyn.rife.engine.ElementFactory;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.engine.ElementType;
import com.uwyn.rife.engine.FlowLink;
import com.uwyn.rife.engine.GlobalExit;
import com.uwyn.rife.engine.GlobalVar;
import com.uwyn.rife.engine.RequestState;
import com.uwyn.rife.engine.ReservedParameters;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.Submission;
import com.uwyn.rife.engine.exceptions.ChildTriggerExistsException;
import com.uwyn.rife.engine.exceptions.ChildTriggerVariableUnknownException;
import com.uwyn.rife.engine.exceptions.DeployerInstantiationException;
import com.uwyn.rife.engine.exceptions.ElementAlreadyHasIdException;
import com.uwyn.rife.engine.exceptions.ElementAlreadyMappedException;
import com.uwyn.rife.engine.exceptions.ElementImplementationUnsupportedException;
import com.uwyn.rife.engine.exceptions.ExitExistsException;
import com.uwyn.rife.engine.exceptions.ExitUnknownException;
import com.uwyn.rife.engine.exceptions.FlowLinkMissingException;
import com.uwyn.rife.engine.exceptions.GlobalCookieFileConflictException;
import com.uwyn.rife.engine.exceptions.GlobalCookieIncookieConflictException;
import com.uwyn.rife.engine.exceptions.GlobalCookieOutcookieConflictException;
import com.uwyn.rife.engine.exceptions.GlobalCookieParameterConflictException;
import com.uwyn.rife.engine.exceptions.GlobalCookiePropertyConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarFileConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarInputConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarOutputConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarParameterConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarPropertyConflictException;
import com.uwyn.rife.engine.exceptions.GlobalVarUnknownException;
import com.uwyn.rife.engine.exceptions.IncookieExistsException;
import com.uwyn.rife.engine.exceptions.IncookieFileConflictException;
import com.uwyn.rife.engine.exceptions.IncookieGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.IncookieParameterConflictException;
import com.uwyn.rife.engine.exceptions.IncookiePropertyConflictException;
import com.uwyn.rife.engine.exceptions.IncookieUnknownException;
import com.uwyn.rife.engine.exceptions.InputExistsException;
import com.uwyn.rife.engine.exceptions.InputFileConflictException;
import com.uwyn.rife.engine.exceptions.InputGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.InputParameterConflictException;
import com.uwyn.rife.engine.exceptions.InputPropertyConflictException;
import com.uwyn.rife.engine.exceptions.InputUnknownException;
import com.uwyn.rife.engine.exceptions.NamedInbeanExistsException;
import com.uwyn.rife.engine.exceptions.NamedInbeanGlobalBeanConflictException;
import com.uwyn.rife.engine.exceptions.NamedInbeanUnknownException;
import com.uwyn.rife.engine.exceptions.NamedOutbeanExistsException;
import com.uwyn.rife.engine.exceptions.NamedOutbeanGlobalBeanConflictException;
import com.uwyn.rife.engine.exceptions.NamedOutbeanUnknownException;
import com.uwyn.rife.engine.exceptions.OutcookieExistsException;
import com.uwyn.rife.engine.exceptions.OutcookieGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.OutcookieUnknownException;
import com.uwyn.rife.engine.exceptions.OutputExistsException;
import com.uwyn.rife.engine.exceptions.OutputGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.OutputUnknownException;
import com.uwyn.rife.engine.exceptions.PropertyFileConflictException;
import com.uwyn.rife.engine.exceptions.PropertyGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.PropertyGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.PropertyIncookieConflictException;
import com.uwyn.rife.engine.exceptions.PropertyInputConflictException;
import com.uwyn.rife.engine.exceptions.PropertyParameterConflictException;
import com.uwyn.rife.engine.exceptions.PropertyUnknownException;
import com.uwyn.rife.engine.exceptions.ReservedInputNameException;
import com.uwyn.rife.engine.exceptions.ReservedOutputNameException;
import com.uwyn.rife.engine.exceptions.SnapbackFlowLinkMissingException;
import com.uwyn.rife.engine.exceptions.SubmissionExistsException;
import com.uwyn.rife.engine.exceptions.SubmissionUnknownException;
import com.uwyn.rife.tools.ExceptionUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInfo
implements Cloneable {
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final int DEFAULT_INTEGER = 0;
    public static final long DEFAULT_LONG = 0L;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final float DEFAULT_FLOAT = 0.0f;
    private Site mSite = null;
    private String mUrl = null;
    private String mId = null;
    private int mGroupId = -1;
    private StateStore mStateStore = null;
    private boolean mPathInfoUsed = false;
    private String mDeclarationName = null;
    private String mImplementation = null;
    private ElementType mType = null;
    private String mContentType = null;
    private HashMap<String, Object> mStaticProperties = new HashMap();
    private HashMap<String, Object> mProperties = null;
    private HashMap<String, Submission> mSubmissions = new HashMap();
    private HashMap<String, String[]> mInputs = new HashMap();
    private HashMap<String, String[]> mOutputs = new HashMap();
    private HashMap<String, String> mIncookies = new HashMap();
    private HashMap<String, String> mOutcookies = new HashMap();
    private HashMap<String, BeanDeclaration> mNamedInbeans = new HashMap();
    private HashMap<String, BeanDeclaration> mNamedOutbeans = new HashMap();
    private boolean mHasSubmissionDefaults = false;
    private boolean mHasGlobalVarDefaults = false;
    private boolean mHasGlobalCookieDefaults = false;
    private boolean mHasInputDefaults = false;
    private boolean mHasOutputDefaults = false;
    private boolean mHasIncookieDefaults = false;
    private boolean mHasOutcookieDefaults = false;
    private boolean mHasSnapbackFlowLinks = false;
    private boolean mHasSnapbackDataLinks = false;
    private ArrayList<String> mChildTriggers = new ArrayList();
    private HashMap<String, FlowLink> mExits = new HashMap();
    private HashMap<ElementInfo, ArrayList<DataLink>> mDatalinks = new HashMap();
    private ArrayList<DataLink> mSnapbackDatalinks = new ArrayList();
    private Stack<ElementInfo> mInheritanceStack = null;
    private Stack<ElementInfo> mPrecedenceStack = null;
    private HashMap<String, GlobalExit> mGlobalExits = null;
    private HashMap<String, GlobalVar> mGlobalVars = null;
    private HashMap<String, String> mGlobalCookies = null;
    private HashMap<String, BeanDeclaration> mNamedGlobalBeans = null;
    private ArrayList<String> mDepartureVars = null;
    private boolean mHasDepartureVars = false;
    private ElementDeployer mDeployer = null;
    private Collection<String> mPropertyNames = null;
    private static NumberFormat MEMORY_FORMAT;
    private static /* synthetic */ boolean $assertionsDisabled;

    ElementInfo() {
    }

    ElementInfo(String declarationName, String contentType, String implementation, ElementType type) {
        this();
        this.setDeclarationName(declarationName);
        this.setContentType(contentType);
        this.setImplementation(implementation);
        this.setType(type);
    }

    void extendFrom(ElementInfo extendedElement) {
        this.mImplementation = extendedElement.mImplementation;
        this.mType = extendedElement.mType;
        this.mContentType = extendedElement.mContentType;
        this.mStaticProperties = new HashMap<String, Object>(extendedElement.mStaticProperties);
        this.mSubmissions = new HashMap<String, Submission>(extendedElement.mSubmissions);
        this.mInputs = new HashMap<String, String[]>(extendedElement.mInputs);
        this.mOutputs = new HashMap<String, String[]>(extendedElement.mOutputs);
        this.mIncookies = new HashMap<String, String>(extendedElement.mIncookies);
        this.mOutcookies = new HashMap<String, String>(extendedElement.mOutcookies);
        this.mNamedInbeans = new HashMap<String, BeanDeclaration>(extendedElement.mNamedInbeans);
        this.mNamedOutbeans = new HashMap<String, BeanDeclaration>(extendedElement.mNamedOutbeans);
        this.mHasSubmissionDefaults = extendedElement.mHasSubmissionDefaults;
        this.mHasGlobalVarDefaults = extendedElement.mHasGlobalVarDefaults;
        this.mHasGlobalCookieDefaults = extendedElement.mHasGlobalCookieDefaults;
        this.mHasInputDefaults = extendedElement.mHasInputDefaults;
        this.mHasOutputDefaults = extendedElement.mHasOutputDefaults;
        this.mHasIncookieDefaults = extendedElement.mHasIncookieDefaults;
        this.mHasOutcookieDefaults = extendedElement.mHasOutcookieDefaults;
        this.mHasSnapbackFlowLinks = false;
        this.mHasSnapbackDataLinks = false;
        this.mChildTriggers = new ArrayList<String>(extendedElement.mChildTriggers);
        this.mExits = new HashMap<String, FlowLink>(extendedElement.mExits);
        this.mDatalinks = new HashMap();
        this.mSnapbackDatalinks = new ArrayList();
        for (String exit : (Collection)this.mExits.keySet()) {
            this.mExits.put(exit, null);
        }
        this.mPropertyNames = null;
    }

    void populateFrom(ElementInfo referenceElement) {
        this.mSite = referenceElement.mSite;
        this.mDeclarationName = referenceElement.mDeclarationName;
        this.mImplementation = referenceElement.mImplementation;
        this.mType = referenceElement.mType;
        this.mUrl = referenceElement.mUrl;
        this.mId = referenceElement.mId;
        this.mGroupId = referenceElement.mGroupId;
        this.mStateStore = referenceElement.mStateStore;
        this.mPathInfoUsed = referenceElement.mPathInfoUsed;
        this.mContentType = referenceElement.mContentType;
        this.mStaticProperties = referenceElement.mStaticProperties;
        this.mSubmissions = referenceElement.mSubmissions;
        this.mInputs = referenceElement.mInputs;
        this.mOutputs = referenceElement.mOutputs;
        this.mIncookies = referenceElement.mIncookies;
        this.mOutcookies = referenceElement.mOutcookies;
        this.mNamedInbeans = referenceElement.mNamedInbeans;
        this.mNamedOutbeans = referenceElement.mNamedOutbeans;
        this.mHasSubmissionDefaults = referenceElement.mHasSubmissionDefaults;
        this.mHasGlobalVarDefaults = referenceElement.mHasGlobalVarDefaults;
        this.mHasGlobalCookieDefaults = referenceElement.mHasGlobalCookieDefaults;
        this.mHasInputDefaults = referenceElement.mHasInputDefaults;
        this.mHasOutputDefaults = referenceElement.mHasOutputDefaults;
        this.mHasIncookieDefaults = referenceElement.mHasIncookieDefaults;
        this.mHasOutcookieDefaults = referenceElement.mHasOutcookieDefaults;
        this.mHasSnapbackFlowLinks = referenceElement.mHasSnapbackFlowLinks;
        this.mHasSnapbackDataLinks = referenceElement.mHasSnapbackDataLinks;
        this.mChildTriggers = referenceElement.mChildTriggers;
        this.mExits = referenceElement.mExits;
        this.mDatalinks = referenceElement.mDatalinks;
        this.mSnapbackDatalinks = referenceElement.mSnapbackDatalinks;
        this.mInheritanceStack = referenceElement.mInheritanceStack;
        this.mGlobalExits = referenceElement.mGlobalExits;
        this.mGlobalVars = referenceElement.mGlobalVars;
        this.mGlobalCookies = referenceElement.mGlobalCookies;
        this.mNamedGlobalBeans = referenceElement.mNamedGlobalBeans;
        this.mDepartureVars = referenceElement.mDepartureVars;
        this.mHasDepartureVars = referenceElement.mHasDepartureVars;
        this.mDeployer = referenceElement.mDeployer;
        this.mPropertyNames = null;
    }

    void deploy() {
        ElementSupport element = null;
        Class deployment_class = null;
        ElementDeployer deployer = null;
        element = ElementFactory.INSTANCE.getInstance(this);
        if (element != null && (deployment_class = element.getDeploymentClass()) != null) {
            try {
                deployer = (ElementDeployer)deployment_class.newInstance();
                deployer.setElementInfo(this);
                deployer.deploy();
                this.setDeployer(deployer);
            }
            catch (InstantiationException e) {
                throw new DeployerInstantiationException(this.getDeclarationName(), e);
            }
            catch (IllegalAccessException e) {
                throw new DeployerInstantiationException(this.getDeclarationName(), e);
            }
            catch (ClassCastException e) {
                throw new DeployerInstantiationException(this.getDeclarationName(), e);
            }
        }
    }

    void setSite(Site site) {
        if (!$assertionsDisabled && site == null) {
            throw new AssertionError();
        }
        this.mSite = site;
    }

    public Site getSite() {
        return this.mSite;
    }

    void setGroupId(int groupId) {
        this.mGroupId = groupId;
    }

    public int getGroupId() {
        return this.mGroupId;
    }

    void setProperties(HashMap<String, Object> properties) {
        if (properties != null) {
            for (String name : (Collection)properties.keySet()) {
                if (this.containsInput(name)) {
                    throw new PropertyInputConflictException(this.getDeclarationName(), name);
                }
                if (this.containsIncookie(name)) {
                    throw new PropertyIncookieConflictException(this.getDeclarationName(), name);
                }
                for (Submission submission : this.mSubmissions.values()) {
                    if (submission.containsParameter(name)) {
                        throw new PropertyParameterConflictException(this.getDeclarationName(), name, submission.getName());
                    }
                    if (!submission.containsFile(name)) continue;
                    throw new PropertyFileConflictException(this.getDeclarationName(), name, submission.getName());
                }
                if (this.containsGlobalVar(name)) {
                    throw new PropertyGlobalVarConflictException(this.getDeclarationName(), name);
                }
                if (!this.containsGlobalCookie(name)) continue;
                throw new PropertyGlobalCookieConflictException(this.getDeclarationName(), name);
            }
        }
        this.mProperties = properties;
        this.mPropertyNames = null;
    }

    void setInheritanceStack(Stack<ElementInfo> inheritanceStack) {
        if (!$assertionsDisabled && inheritanceStack == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mInheritanceStack != null) {
            throw new AssertionError();
        }
        this.mInheritanceStack = inheritanceStack;
    }

    public Stack<ElementInfo> getInheritanceStack() {
        return this.mInheritanceStack;
    }

    void setPrecedenceStack(Stack<ElementInfo> precedenceStack) {
        if (!$assertionsDisabled && precedenceStack == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mPrecedenceStack != null) {
            throw new AssertionError();
        }
        this.mPrecedenceStack = precedenceStack;
    }

    public Stack<ElementInfo> getPrecedenceStack() {
        return this.mPrecedenceStack;
    }

    void setGlobalExits(HashMap<String, GlobalExit> globalExits) {
        if (!$assertionsDisabled && globalExits == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mGlobalExits != null) {
            throw new AssertionError();
        }
        this.mGlobalExits = globalExits;
    }

    void setGlobalVars(HashMap<String, GlobalVar> globalVars) {
        if (!$assertionsDisabled && globalVars == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mGlobalVars != null) {
            throw new AssertionError();
        }
        String globalvar_name = null;
        for (Map.Entry globalvar_entry : (Collection)globalVars.entrySet()) {
            globalvar_name = (String)globalvar_entry.getKey();
            if (this.containsInput(globalvar_name)) {
                throw new GlobalVarInputConflictException(this.getDeclarationName(), globalvar_name);
            }
            if (this.containsOutput(globalvar_name)) {
                throw new GlobalVarOutputConflictException(this.getDeclarationName(), globalvar_name);
            }
            for (Submission submission : this.mSubmissions.values()) {
                if (submission.containsParameter(globalvar_name)) {
                    throw new GlobalVarParameterConflictException(this.getDeclarationName(), globalvar_name, submission.getName());
                }
                if (!submission.containsFile(globalvar_name)) continue;
                throw new GlobalVarFileConflictException(this.getDeclarationName(), globalvar_name, submission.getName());
            }
            if (this.containsProperty(globalvar_name)) {
                throw new GlobalVarPropertyConflictException(this.getDeclarationName(), globalvar_name);
            }
            if (globalvar_name == null) continue;
            this.mHasGlobalVarDefaults = true;
        }
        this.mGlobalVars = globalVars;
    }

    void setGlobalCookies(HashMap<String, String> globalCookies) {
        if (!$assertionsDisabled && globalCookies == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mGlobalCookies != null) {
            throw new AssertionError();
        }
        String globalcookie_name = null;
        for (Map.Entry globalcookie_entry : (Collection)globalCookies.entrySet()) {
            globalcookie_name = (String)globalcookie_entry.getKey();
            if (this.containsIncookie(globalcookie_name)) {
                throw new GlobalCookieIncookieConflictException(this.getDeclarationName(), globalcookie_name);
            }
            if (this.containsOutcookie(globalcookie_name)) {
                throw new GlobalCookieOutcookieConflictException(this.getDeclarationName(), globalcookie_name);
            }
            for (Submission submission : this.mSubmissions.values()) {
                if (submission.containsParameter(globalcookie_name)) {
                    throw new GlobalCookieParameterConflictException(this.getDeclarationName(), globalcookie_name, submission.getName());
                }
                if (!submission.containsFile(globalcookie_name)) continue;
                throw new GlobalCookieFileConflictException(this.getDeclarationName(), globalcookie_name, submission.getName());
            }
            if (this.containsProperty(globalcookie_name)) {
                throw new GlobalCookiePropertyConflictException(this.getDeclarationName(), globalcookie_name);
            }
            if (globalcookie_name == null) continue;
            this.mHasGlobalCookieDefaults = true;
        }
        this.mGlobalCookies = globalCookies;
    }

    void setNamedGlobalBeans(HashMap<String, BeanDeclaration> globalBeans) {
        if (!$assertionsDisabled && globalBeans == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mNamedGlobalBeans != null) {
            throw new AssertionError();
        }
        String globalbean_name = null;
        for (Map.Entry globalbean_entry : (Collection)globalBeans.entrySet()) {
            globalbean_name = (String)globalbean_entry.getKey();
            if (this.containsNamedInbean(globalbean_name)) {
                throw new NamedInbeanGlobalBeanConflictException(this.getDeclarationName(), globalbean_name);
            }
            if (!this.containsNamedOutbean(globalbean_name)) continue;
            throw new NamedOutbeanGlobalBeanConflictException(this.getDeclarationName(), globalbean_name);
        }
        this.mNamedGlobalBeans = globalBeans;
    }

    public Collection<String> getGlobalExitNames() {
        if (this.mGlobalExits == null) {
            return null;
        }
        return this.mGlobalExits.keySet();
    }

    public Collection<String> getGlobalVarNames() {
        if (this.mGlobalVars == null) {
            return null;
        }
        return this.mGlobalVars.keySet();
    }

    public Collection<String> getGlobalCookieNames() {
        if (this.mGlobalCookies == null) {
            return null;
        }
        return this.mGlobalCookies.keySet();
    }

    public Collection<String> getNamedGlobalBeanNames() {
        if (this.mNamedGlobalBeans == null) {
            return null;
        }
        return this.mNamedGlobalBeans.keySet();
    }

    public boolean hasGlobalExits() {
        return this.mGlobalExits != null && !this.mGlobalExits.isEmpty();
    }

    public boolean hasGlobalVars() {
        return this.mGlobalVars != null && !this.mGlobalVars.isEmpty();
    }

    public boolean hasGlobalCookies() {
        return this.mGlobalCookies != null && !this.mGlobalCookies.isEmpty();
    }

    public boolean hasNamedGlobalBeans() {
        return this.mNamedGlobalBeans != null && !this.mNamedGlobalBeans.isEmpty();
    }

    public boolean containsGlobalExit(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalExits == null) {
            return false;
        }
        return this.mGlobalExits.containsKey(name);
    }

    public boolean containsGlobalVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalVars == null) {
            return false;
        }
        return this.mGlobalVars.containsKey(name);
    }

    public boolean containsGlobalCookie(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalCookies == null) {
            return false;
        }
        return this.mGlobalCookies.containsKey(name);
    }

    public boolean containsNamedGlobalBean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mNamedGlobalBeans == null) {
            return false;
        }
        return this.mNamedGlobalBeans.containsKey(name);
    }

    public GlobalExit getGlobalExitInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalExits == null) {
            return null;
        }
        return this.mGlobalExits.get(name);
    }

    public GlobalVar getGlobalVarInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalVars == null) {
            return null;
        }
        return this.mGlobalVars.get(name);
    }

    public String getGlobalCookieInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mGlobalCookies == null) {
            return null;
        }
        return this.mGlobalCookies.get(name);
    }

    public BeanDeclaration getNamedGlobalBeanInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mNamedGlobalBeans == null) {
            return null;
        }
        return this.mNamedGlobalBeans.get(name);
    }

    void setDepartureVars(ArrayList<String> departureVars) {
        if (!$assertionsDisabled && departureVars == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mDepartureVars != null) {
            throw new AssertionError();
        }
        for (String departure_var : (Collection)departureVars) {
            if (this.containsGlobalVar(departure_var)) continue;
            throw new GlobalVarUnknownException(departure_var);
        }
        this.mDepartureVars = departureVars;
        this.mHasDepartureVars = true;
    }

    ArrayList<String> getDepartureVars() {
        return this.mDepartureVars;
    }

    boolean hasDepartureVars() {
        return this.mHasDepartureVars;
    }

    boolean containsDepartureVar(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.mHasDepartureVars || this.mDepartureVars == null) {
            return false;
        }
        return this.mDepartureVars.contains(name);
    }

    void setUrl(String url) {
        if (url != null) {
            if (this.mUrl != null) {
                throw new ElementAlreadyMappedException(this.getDeclarationName(), this.mUrl);
            }
            if (0 == url.length()) {
                this.mUrl = "/";
                return;
            }
        }
        this.mUrl = url;
    }

    void setId(String id) {
        if (this.mId != null && id != null) {
            throw new ElementAlreadyHasIdException(this.getDeclarationName(), this.mId);
        }
        this.mId = id;
    }

    void setStateStore(StateStore stateStore) {
        if (!$assertionsDisabled && stateStore == null) {
            throw new AssertionError();
        }
        this.mStateStore = stateStore;
    }

    StateStore getStateStore() {
        return this.mStateStore;
    }

    void setDeclarationName(String declarationName) {
        this.mDeclarationName = declarationName;
    }

    public String getDeclarationName() {
        return this.mDeclarationName;
    }

    void setImplementation(String implementation) {
        this.mImplementation = implementation;
        this.setType(ElementFactory.getElementType(implementation));
        if (this.mType == null) {
            throw new ElementImplementationUnsupportedException(this.mDeclarationName, this.mImplementation, null);
        }
    }

    void setType(ElementType type) {
        this.mType = type;
    }

    public String getImplementation() {
        return this.mImplementation;
    }

    public String getAbsoluteUrl(Element currentElement) {
        StringBuffer absolute_url;
        if (currentElement == null) {
            throw new IllegalArgumentException("currentElement can't be null.");
        }
        if (this.mUrl == null) {
            return null;
        }
        String gateservlet_path = currentElement.getElementContext().getRequestState().getGateUrl();
        StringBuffer stringBuffer = absolute_url = new StringBuffer(gateservlet_path);
        synchronized (stringBuffer) {
            if (!gateservlet_path.endsWith("/") && !this.mUrl.startsWith("/")) {
                absolute_url.append("/");
            }
            absolute_url.append(this.mUrl);
            return absolute_url.toString();
        }
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getId() {
        return this.mId;
    }

    void setPathInfoUsed(boolean state) {
        this.mPathInfoUsed = state;
    }

    public boolean isPathInfoUsed() {
        return this.mPathInfoUsed;
    }

    void setContentType(String contentType) {
        if (contentType == null) {
            contentType = RifeConfig.Engine.getDefaultContentType();
        }
        this.mContentType = contentType;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public ElementType getType() {
        return this.mType;
    }

    public ElementSupport getElement() {
        return ElementFactory.INSTANCE.getInstance(this);
    }

    long startTrace() {
        if (Logger.getLogger("com.uwyn.rife.engine").isLoggable(Level.INFO) && RifeConfig.Engine.getElementDebugTrace()) {
            return System.currentTimeMillis();
        }
        return 0;
    }

    void outputTrace(long start, RequestState state) {
        if (start != (long)0) {
            StringBuffer output;
            StringBuffer stringBuffer = output = new StringBuffer();
            synchronized (stringBuffer) {
                if (RifeConfig.Engine.getElementDebugMemory()) {
                    Runtime runtime = Runtime.getRuntime();
                    long total_memory = runtime.totalMemory();
                    long free_memory = runtime.freeMemory();
                    output.append("total (");
                    output.append(MEMORY_FORMAT.format(total_memory / (long)1024));
                    output.append("kb) free (");
                    output.append(MEMORY_FORMAT.format(free_memory / (long)1024));
                    output.append("kb) used (");
                    output.append(MEMORY_FORMAT.format((total_memory - free_memory) / (long)1024));
                    output.append("kb)");
                    output.append(" ");
                }
                output.append(System.currentTimeMillis() - start);
                output.append("ms : ");
                output.append(state.getServerName());
                output.append(":");
                output.append(state.getServerPort());
                output.append(" ");
                output.append(this.getId());
                output.append(" ");
                if (state.getRequest() != null && state.getRequest().getHttpServletRequest() != null) {
                    output.append(state.getRequest().getHttpServletRequest().getRequestURI());
                    String query_string = state.getRequest().getHttpServletRequest().getQueryString();
                    if (query_string != null && query_string.length() > 0) {
                        output.append("?");
                        output.append(query_string);
                    }
                }
                Logger.getLogger("com.uwyn.rife.engine").info(output.toString());
            }
        }
    }

    public Collection<String> getPropertyNames() {
        if (this.mPropertyNames == null) {
            this.mPropertyNames = new HashSet<String>();
            this.mPropertyNames.addAll(this.mStaticProperties.keySet());
            if (this.mProperties != null) {
                this.mPropertyNames.addAll(this.mProperties.keySet());
            }
        }
        return this.mPropertyNames;
    }

    public Collection<String> getInputNames() {
        return this.mInputs.keySet();
    }

    public Collection<String> getOutputNames() {
        return this.mOutputs.keySet();
    }

    public Set<Map.Entry<String, GlobalExit>> getGlobalExitEntries() {
        return this.mGlobalExits.entrySet();
    }

    public Set<Map.Entry<String, GlobalVar>> getGlobalVarEntries() {
        return this.mGlobalVars.entrySet();
    }

    public Set<Map.Entry<String, String[]>> getOutputEntries() {
        return this.mOutputs.entrySet();
    }

    public Collection<String> getIncookieNames() {
        return this.mIncookies.keySet();
    }

    public Collection<String> getOutcookieNames() {
        return this.mOutcookies.keySet();
    }

    public Set<Map.Entry<String, String>> getGlobalCookieEntries() {
        return this.mGlobalCookies.entrySet();
    }

    public Set<Map.Entry<String, String>> getOutcookieEntries() {
        return this.mOutcookies.entrySet();
    }

    public Collection<String> getNamedInbeanNames() {
        return this.mNamedInbeans.keySet();
    }

    public Collection<String> getNamedOutbeanNames() {
        return this.mNamedOutbeans.keySet();
    }

    public BeanDeclaration getNamedInbeanInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mNamedInbeans == null) {
            return null;
        }
        return this.mNamedInbeans.get(name);
    }

    public BeanDeclaration getNamedOutbeanInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (this.mNamedOutbeans == null) {
            return null;
        }
        return this.mNamedOutbeans.get(name);
    }

    public Collection<String> getChildTriggerNames() {
        return this.mChildTriggers;
    }

    public Collection<String> getExitNames() {
        return this.mExits.keySet();
    }

    public boolean hasProperty(String key) {
        if (key == null || 0 == key.length()) {
            return false;
        }
        boolean result = false;
        if (this.mProperties != null) {
            result = this.mProperties.containsKey(key);
        }
        if (!result && this.mStaticProperties != null) {
            result = this.mStaticProperties.containsKey(key);
        }
        return result;
    }

    public Object getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null.");
        }
        if (0 == key.length()) {
            throw new IllegalArgumentException("key can't be empty.");
        }
        Object value = null;
        if (this.mProperties != null) {
            value = this.mProperties.get(key);
        }
        if (value == null && this.mStaticProperties != null) {
            value = this.mStaticProperties.get(key);
        }
        return value;
    }

    public String getPropertyString(String key) {
        return this.getPropertyString(key, null);
    }

    public String getPropertyString(String key, String defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        String result = null;
        if (value != null) {
            result = value.toString();
        }
        if (result == null || 0 == result.length()) {
            return defaultValue;
        }
        return result;
    }

    public boolean isPropertyEmpty(String name) {
        if (!this.hasProperty(name)) {
            return true;
        }
        return 0 == this.getPropertyString(name, "").length();
    }

    public Submission getSubmission(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mSubmissions.get(name);
    }

    public String[] getGlobalVarDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        GlobalVar data = this.mGlobalVars.get(name);
        if (data == null) {
            return null;
        }
        return data.getDefaultValues();
    }

    public String[] getInputDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mInputs.get(name);
    }

    public String[] getOutputDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutputs.get(name);
    }

    public String getIncookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mIncookies.get(name);
    }

    public String getGlobalCookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mGlobalCookies.get(name);
    }

    public String getOutcookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutcookies.get(name);
    }

    public HashMap<String, String> getDefaultIncookies() {
        HashMap<String, String> default_incookies = new HashMap<String, String>();
        for (Map.Entry incookie_entry : (Collection)this.mIncookies.entrySet()) {
            if ((String)incookie_entry.getValue() == null) continue;
            default_incookies.put((String)incookie_entry.getKey(), (String)incookie_entry.getValue());
        }
        return default_incookies;
    }

    public HashMap<String, String> getDefaultOutcookies() {
        HashMap<String, String> default_outcookies = new HashMap<String, String>();
        for (Map.Entry outcookie_entry : (Collection)this.mOutcookies.entrySet()) {
            if ((String)outcookie_entry.getValue() == null) continue;
            default_outcookies.put((String)outcookie_entry.getKey(), (String)outcookie_entry.getValue());
        }
        return default_outcookies;
    }

    public HashMap<String, String> getDefaultGlobalCookies() {
        HashMap<String, String> default_globalcookies = new HashMap<String, String>();
        for (Map.Entry globalcookie_entry : (Collection)this.mGlobalCookies.entrySet()) {
            if ((String)globalcookie_entry.getValue() == null) continue;
            default_globalcookies.put((String)globalcookie_entry.getKey(), (String)globalcookie_entry.getValue());
        }
        return default_globalcookies;
    }

    public String[] getParameterDefaultValues(String submissionName, String parameterName) {
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName can't be null.");
        }
        if (0 == parameterName.length()) {
            throw new IllegalArgumentException("parameterName can't be empty.");
        }
        return this.mSubmissions.get(submissionName).getParameterDefaultValues(parameterName);
    }

    public Set<Map.Entry<String, FlowLink>> getExitEntries() {
        return this.mExits.entrySet();
    }

    public Collection<String> getSubmissionNames() {
        return this.mSubmissions.keySet();
    }

    public Collection<Submission> getSubmissions() {
        return this.mSubmissions.values();
    }

    public FlowLink getFlowLink(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mExits.containsKey(name)) {
            return null;
        }
        return this.mExits.get(name);
    }

    public boolean containsProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mStaticProperties.containsKey(name) || this.mProperties != null && this.mProperties.containsKey(name);
    }

    public boolean containsInput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mInputs.containsKey(name);
    }

    public boolean containsInputPossibility(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mInputs.containsKey(name) || this.mGlobalVars != null && this.mGlobalVars.containsKey(name);
    }

    public boolean containsOutput(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutputs.containsKey(name);
    }

    public boolean containsOutputPossibility(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutputs.containsKey(name) || this.mGlobalVars != null && this.mGlobalVars.containsKey(name);
    }

    public boolean containsIncookie(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mIncookies.containsKey(name);
    }

    public boolean containsIncookiePossibility(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mIncookies.containsKey(name) || this.mGlobalCookies != null && this.mGlobalCookies.containsKey(name);
    }

    public boolean containsOutcookie(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutcookies.containsKey(name);
    }

    public boolean containsOutcookiePossibility(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mOutcookies.containsKey(name) || this.mGlobalCookies != null && this.mGlobalCookies.containsKey(name);
    }

    public boolean containsNamedInbean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mNamedInbeans.containsKey(name);
    }

    public boolean containsNamedOutbean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mNamedOutbeans.containsKey(name);
    }

    public boolean containsChildTrigger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mChildTriggers.contains(name);
    }

    public boolean containsExit(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mExits.containsKey(name);
    }

    public boolean containsSubmission(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mSubmissions.containsKey(name);
    }

    public boolean hasSubmission(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mSubmissions.containsKey(name);
    }

    public boolean hasGlobalVarDefaults() {
        return this.mHasGlobalVarDefaults;
    }

    public boolean hasGlobalCookieDefaults() {
        return this.mHasGlobalCookieDefaults;
    }

    public boolean hasInputDefaults() {
        return this.mHasInputDefaults;
    }

    public boolean hasOutputDefaults() {
        return this.mHasOutputDefaults;
    }

    public boolean hasIncookieDefaults() {
        return this.mHasIncookieDefaults;
    }

    public boolean hasOutcookieDefaults() {
        return this.mHasOutcookieDefaults;
    }

    public boolean hasParameterDefaults(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mHasSubmissionDefaults && this.mSubmissions.get(name).hasParameterDefaults();
    }

    public boolean hasGlobalVarDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasGlobalVarDefaults) {
            return false;
        }
        GlobalVar data = this.mGlobalVars.get(name);
        if (data == null) {
            return false;
        }
        return data.getDefaultValues() != null;
    }

    public boolean hasGlobalCookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasGlobalCookieDefaults) {
            return false;
        }
        String data = this.mGlobalCookies.get(name);
        return data != null && data.length() != 0;
    }

    public boolean hasInputDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasInputDefaults) {
            return false;
        }
        return this.mInputs.get(name) != null;
    }

    public boolean hasOutputDefaultValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasOutputDefaults) {
            return false;
        }
        return this.mOutputs.get(name) != null;
    }

    public boolean hasIncookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasIncookieDefaults) {
            return false;
        }
        return this.mIncookies.get(name) != null;
    }

    public boolean hasOutcookieDefaultValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (!this.mHasOutcookieDefaults) {
            return false;
        }
        return this.mOutcookies.get(name) != null;
    }

    public boolean hasParameterDefaultValues(String submissionName, String parameterName) {
        if (submissionName == null) {
            throw new IllegalArgumentException("submissionName can't be null.");
        }
        if (0 == submissionName.length()) {
            throw new IllegalArgumentException("submissionName can't be empty.");
        }
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName can't be null.");
        }
        if (0 == parameterName.length()) {
            throw new IllegalArgumentException("parameterName can't be empty.");
        }
        if (!this.mHasSubmissionDefaults) {
            return false;
        }
        return this.mSubmissions.get(submissionName).hasParameterDefaultValues(parameterName);
    }

    public boolean hasDataLink(ElementInfo target) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        return this.mDatalinks.containsKey(target);
    }

    public boolean hasSnapbackDataLinks() {
        return this.mHasSnapbackDataLinks;
    }

    public boolean hasFlowLink(ElementInfo target) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (0 == this.mExits.size()) {
            return false;
        }
        for (FlowLink flowlink : this.mExits.values()) {
            if (flowlink == null || flowlink.getTarget() == null || !flowlink.getTarget().equals(target)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSnapbackFlowLinks() {
        return this.mHasSnapbackFlowLinks;
    }

    void validatePropertyName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsProperty(name)) {
            throw new PropertyUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateInputName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsInput(name) && !this.containsGlobalVar(name)) {
            throw new InputUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateOutputName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsOutput(name) && !this.containsGlobalVar(name)) {
            throw new OutputUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateIncookieName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsIncookie(name) && !this.containsGlobalCookie(name)) {
            throw new IncookieUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateOutcookieName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsOutcookie(name) && !this.containsGlobalCookie(name)) {
            throw new OutcookieUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateInbeanName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsNamedInbean(name) && !this.containsNamedGlobalBean(name)) {
            throw new NamedInbeanUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateOutbeanName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsNamedOutbean(name) && !this.containsNamedGlobalBean(name)) {
            throw new NamedOutbeanUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateExitName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsExit(name)) {
            throw new ExitUnknownException(this.getDeclarationName(), name);
        }
    }

    void validateSubmissionName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsSubmission(name)) {
            throw new SubmissionUnknownException(this.getDeclarationName(), name);
        }
    }

    void addDataLink(DataLink dataLink) {
        if (!$assertionsDisabled && dataLink == null) {
            throw new AssertionError();
        }
        this.validateOutputName(dataLink.getOutput());
        if (dataLink.isSnapback()) {
            if (!this.hasSnapbackFlowLinks()) {
                throw new SnapbackFlowLinkMissingException(this.getDeclarationName());
            }
            if (!this.mSnapbackDatalinks.contains(dataLink)) {
                this.mSnapbackDatalinks.add(dataLink);
            }
            this.mHasSnapbackDataLinks = true;
        } else {
            ElementInfo target = dataLink.getTarget();
            target.validateInputName(dataLink.getInput());
            if (!this.hasFlowLink(target)) {
                throw new FlowLinkMissingException(this.getDeclarationName(), target.getDeclarationName());
            }
            ArrayList<DataLink> datalinks = this.mDatalinks.get(target);
            if (datalinks == null) {
                datalinks = new ArrayList();
                this.mDatalinks.put(target, datalinks);
            }
            if (!datalinks.contains(dataLink)) {
                datalinks.add(dataLink);
            }
        }
    }

    Collection<String> getDataLinkInputs(String outputName, ElementInfo target, boolean snapback) {
        if (!$assertionsDisabled && outputName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputName.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        ArrayList<DataLink> datalinks = this.mDatalinks.get(target);
        if (!snapback && datalinks == null) {
            return null;
        }
        HashSet<String> inputnames_list = new HashSet<String>();
        if (datalinks != null) {
            for (DataLink datalink : (Collection)datalinks) {
                if (!datalink.getOutput().equals(outputName)) continue;
                inputnames_list.add(datalink.getInput());
            }
        }
        if (snapback) {
            for (DataLink datalink : (Collection)this.mSnapbackDatalinks) {
                if (!datalink.getOutput().equals(outputName)) continue;
                inputnames_list.add(datalink.getInput());
            }
        }
        if (0 == inputnames_list.size()) {
            return null;
        }
        return inputnames_list;
    }

    void setFlowLink(FlowLink flowLink) {
        if (!$assertionsDisabled && flowLink == null) {
            throw new AssertionError();
        }
        this.validateExitName(flowLink.getExitName());
        this.mExits.put(flowLink.getExitName(), flowLink);
        if (flowLink.isSnapback()) {
            this.mHasSnapbackFlowLinks = true;
        }
    }

    void addStaticProperty(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.containsInput(name)) {
            throw new PropertyInputConflictException(this.getDeclarationName(), name);
        }
        if (this.containsIncookie(name)) {
            throw new PropertyIncookieConflictException(this.getDeclarationName(), name);
        }
        for (Submission submission : this.mSubmissions.values()) {
            if (submission.containsParameter(name)) {
                throw new PropertyParameterConflictException(this.getDeclarationName(), name, submission.getName());
            }
            if (!submission.containsFile(name)) continue;
            throw new PropertyFileConflictException(this.getDeclarationName(), name, submission.getName());
        }
        if (this.containsGlobalVar(name)) {
            throw new PropertyGlobalVarConflictException(this.getDeclarationName(), name);
        }
        if (this.containsGlobalCookie(name)) {
            throw new PropertyGlobalCookieConflictException(this.getDeclarationName(), name);
        }
        this.mStaticProperties.put(name, value);
        this.mPropertyNames = null;
    }

    void addInput(String name, String[] defaultValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (ReservedParameters.RESERVED_NAMES_LIST.contains(name)) {
            throw new ReservedInputNameException(this.getDeclarationName(), name);
        }
        if (this.mInputs.containsKey(name)) {
            throw new InputExistsException(this.getDeclarationName(), name);
        }
        for (Submission submission : this.mSubmissions.values()) {
            if (submission.containsParameter(name)) {
                throw new InputParameterConflictException(this.getDeclarationName(), name, submission.getName());
            }
            if (!submission.containsFile(name)) continue;
            throw new InputFileConflictException(this.getDeclarationName(), name, submission.getName());
        }
        if (this.containsProperty(name)) {
            throw new InputPropertyConflictException(this.getDeclarationName(), name);
        }
        if (this.containsGlobalVar(name)) {
            throw new InputGlobalVarConflictException(this.getDeclarationName(), name);
        }
        if (defaultValues != null) {
            this.mHasInputDefaults = true;
        }
        this.mInputs.put(name, defaultValues);
    }

    void addOutput(String name, String[] defaultValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (ReservedParameters.RESERVED_NAMES_LIST.contains(name)) {
            throw new ReservedOutputNameException(this.getDeclarationName(), name);
        }
        if (this.mOutputs.containsKey(name)) {
            throw new OutputExistsException(this.getDeclarationName(), name);
        }
        if (this.containsGlobalVar(name)) {
            throw new OutputGlobalVarConflictException(this.getDeclarationName(), name);
        }
        if (defaultValues != null) {
            this.mHasOutputDefaults = true;
        }
        this.mOutputs.put(name, defaultValues);
    }

    void addIncookie(String name, String defaultValue) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mIncookies.containsKey(name)) {
            throw new IncookieExistsException(this.getDeclarationName(), name);
        }
        for (Submission submission : this.mSubmissions.values()) {
            if (submission.containsParameter(name)) {
                throw new IncookieParameterConflictException(this.getDeclarationName(), name, submission.getName());
            }
            if (!submission.containsFile(name)) continue;
            throw new IncookieFileConflictException(this.getDeclarationName(), name, submission.getName());
        }
        if (this.containsProperty(name)) {
            throw new IncookiePropertyConflictException(this.getDeclarationName(), name);
        }
        if (this.containsGlobalCookie(name)) {
            throw new IncookieGlobalCookieConflictException(this.getDeclarationName(), name);
        }
        if (defaultValue != null) {
            this.mHasIncookieDefaults = true;
        }
        this.mIncookies.put(name, defaultValue);
    }

    void addOutcookie(String name, String defaultValue) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mOutcookies.containsKey(name)) {
            throw new OutcookieExistsException(this.getDeclarationName(), name);
        }
        if (this.containsGlobalCookie(name)) {
            throw new OutcookieGlobalCookieConflictException(this.getDeclarationName(), name);
        }
        if (defaultValue != null) {
            this.mHasOutcookieDefaults = true;
        }
        this.mOutcookies.put(name, defaultValue);
    }

    void addNamedInbean(String name, BeanDeclaration bean) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bean == null) {
            throw new AssertionError();
        }
        if (this.containsNamedGlobalBean(name)) {
            throw new NamedInbeanGlobalBeanConflictException(this.getDeclarationName(), name);
        }
        if (this.mNamedInbeans.containsKey(name)) {
            throw new NamedInbeanExistsException(this.getDeclarationName(), name);
        }
        this.mNamedInbeans.put(name, bean);
    }

    void addNamedOutbean(String name, BeanDeclaration bean) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bean == null) {
            throw new AssertionError();
        }
        if (this.containsNamedGlobalBean(name)) {
            throw new NamedOutbeanGlobalBeanConflictException(this.getDeclarationName(), name);
        }
        if (this.mNamedOutbeans.containsKey(name)) {
            throw new NamedOutbeanExistsException(this.getDeclarationName(), name);
        }
        this.mNamedOutbeans.put(name, bean);
    }

    void addChildTrigger(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!(this.containsInput(name) || this.containsIncookie(name) || this.containsOutput(name) || this.containsOutcookie(name) || this.containsGlobalVar(name) || this.containsGlobalCookie(name))) {
            throw new ChildTriggerVariableUnknownException(this.getDeclarationName(), name);
        }
        if (this.mChildTriggers.contains(name)) {
            throw new ChildTriggerExistsException(this.getDeclarationName(), name);
        }
        this.mChildTriggers.add(name);
    }

    void addExit(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mExits.containsKey(name)) {
            throw new ExitExistsException(this.getDeclarationName(), name);
        }
        this.mExits.put(name, null);
    }

    void addSubmission(String name, Submission submission) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && submission == null) {
            throw new AssertionError();
        }
        if (this.mSubmissions.containsKey(name)) {
            throw new SubmissionExistsException(this.getDeclarationName(), name);
        }
        this.mSubmissions.put(name, submission);
        submission.setName(name);
        submission.setElementInfo(this);
        if (submission.hasParameterDefaults()) {
            this.setHasSubmissionDefaults(true);
        }
    }

    void setHasSubmissionDefaults(boolean hasSubmissionDefaults) {
        this.mHasSubmissionDefaults = hasSubmissionDefaults;
    }

    void setDeployer(ElementDeployer deployer) {
        this.mDeployer = deployer;
    }

    public ElementDeployer getDeployer() {
        return this.mDeployer;
    }

    public synchronized ElementInfo clone() {
        ElementInfo new_elementinfo = null;
        try {
            new_elementinfo = (ElementInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        if (this.mStaticProperties != null) {
            new_elementinfo.mStaticProperties = new HashMap<String, Object>(this.mStaticProperties);
        }
        if (this.mSubmissions != null) {
            new_elementinfo.mSubmissions = new HashMap();
            Submission submission = null;
            for (String id : (Collection)this.mSubmissions.keySet()) {
                submission = this.mSubmissions.get(id);
                if (submission != null) {
                    submission = submission.clone();
                }
                submission.setElementInfo(this);
                new_elementinfo.mSubmissions.put(id, submission);
            }
        }
        if (this.mInputs != null) {
            new_elementinfo.mInputs = new HashMap<String, String[]>(this.mInputs);
        }
        if (this.mOutputs != null) {
            new_elementinfo.mOutputs = new HashMap<String, String[]>(this.mOutputs);
        }
        if (this.mIncookies != null) {
            new_elementinfo.mIncookies = new HashMap<String, String>(this.mIncookies);
        }
        if (this.mOutcookies != null) {
            new_elementinfo.mOutcookies = new HashMap<String, String>(this.mOutcookies);
        }
        if (this.mNamedInbeans != null) {
            new_elementinfo.mNamedInbeans = new HashMap<String, BeanDeclaration>(this.mNamedInbeans);
        }
        if (this.mNamedOutbeans != null) {
            new_elementinfo.mNamedOutbeans = new HashMap<String, BeanDeclaration>(this.mNamedOutbeans);
        }
        if (this.mChildTriggers != null) {
            new_elementinfo.mChildTriggers = new ArrayList<String>(this.mChildTriggers);
        }
        if (this.mExits != null) {
            new_elementinfo.mExits = new HashMap<String, FlowLink>(this.mExits);
        }
        if (this.mDatalinks != null) {
            new_elementinfo.mDatalinks = new HashMap();
            ArrayList<DataLink> data_links = null;
            for (ElementInfo element_info : (Collection)this.mDatalinks.keySet()) {
                data_links = this.mDatalinks.get(element_info);
                if (data_links != null) {
                    data_links = new ArrayList<DataLink>(data_links);
                }
                new_elementinfo.mDatalinks.put(element_info, data_links);
            }
        }
        if (this.mInheritanceStack != null) {
            new_elementinfo.mInheritanceStack = new Stack();
            new_elementinfo.mInheritanceStack.addAll(this.mInheritanceStack);
        }
        if (this.mPrecedenceStack != null) {
            new_elementinfo.mPrecedenceStack = new Stack();
            new_elementinfo.mPrecedenceStack.addAll(this.mPrecedenceStack);
        }
        if (this.mGlobalExits != null) {
            new_elementinfo.mGlobalExits = new HashMap<String, GlobalExit>(this.mGlobalExits);
        }
        if (this.mGlobalVars != null) {
            new_elementinfo.mGlobalVars = new HashMap<String, GlobalVar>(this.mGlobalVars);
        }
        if (this.mGlobalCookies != null) {
            new_elementinfo.mGlobalCookies = new HashMap<String, String>(this.mGlobalCookies);
        }
        if (this.mNamedGlobalBeans != null) {
            new_elementinfo.mNamedGlobalBeans = new HashMap<String, BeanDeclaration>(this.mNamedGlobalBeans);
        }
        if (this.mDepartureVars != null) {
            new_elementinfo.mDepartureVars = new ArrayList<String>(this.mDepartureVars);
        }
        return new_elementinfo;
    }

    public synchronized /* synthetic */ Object clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        MEMORY_FORMAT = null;
        MEMORY_FORMAT = NumberFormat.getIntegerInstance();
        MEMORY_FORMAT.setMinimumIntegerDigits(8);
        MEMORY_FORMAT.setMaximumIntegerDigits(8);
        MEMORY_FORMAT.setGroupingUsed(false);
    }
}

