/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.GroupDeclaration;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.exceptions.ElementIdInvalidException;
import com.uwyn.rife.resources.ResourceFinder;
import java.util.HashMap;
import java.util.Stack;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementDeclaration
implements Cloneable {
    private SiteBuilder mSiteBuilder = null;
    private ElementInfoBuilder mElementInfoBuilder = null;
    private GroupDeclaration mGroup = null;
    private StateStore mStateStore = null;
    private String mDeclarationName = null;
    private String mId = null;
    private String mUrl = null;
    private String mInherits = null;
    private String mPre = null;
    private ElementInfo mElementInfo = null;
    private HashMap<String, Object> mProperties = null;
    private Stack<ElementDeclaration> mParentStack = null;
    private Stack<ElementDeclaration> mPreStack = null;

    ElementDeclaration(SiteBuilder siteBuilder, ResourceFinder resourceFinder, GroupDeclaration group, StateStore stateStore, String declarationName) {
        this.mSiteBuilder = siteBuilder;
        this.mElementInfoBuilder = new ElementInfoBuilder(siteBuilder, resourceFinder, this);
        this.setGroup(group);
        this.mStateStore = stateStore;
        this.mDeclarationName = declarationName;
        this.mProperties = null;
        this.mParentStack = new Stack();
        this.mPreStack = new Stack();
    }

    void setId(String id) {
        if (id == null) {
            id = SiteBuilder.generateId(this.mDeclarationName);
        } else if (this.mDeclarationName == null) {
            this.mDeclarationName = new StringBuffer().append(new StringBuffer().append("manual").append(":").toString()).append(id).toString();
        }
        if (id == null) {
            this.mId = null;
            return;
        }
        if (id.startsWith(".") || id.endsWith(".") || id.indexOf("..") != -1 || id.indexOf("^") != -1 || id.indexOf(":") != -1) {
            throw new ElementIdInvalidException(id);
        }
        this.mId = id;
    }

    void setUrl(String url) {
        this.mUrl = url;
    }

    void setInherits(String inherits) {
        this.mInherits = inherits;
    }

    void setPre(String pre) {
        this.mPre = pre;
    }

    SiteBuilder getSiteBuilder() {
        return this.mSiteBuilder;
    }

    ElementInfoBuilder getElementInfoBuilder() {
        return this.mElementInfoBuilder;
    }

    void setGroup(GroupDeclaration group) {
        if (this.mGroup != null) {
            this.mGroup.removeElementDeclaration(this);
        }
        if (group != null) {
            group.addElementDeclaration(this);
        }
        this.mGroup = group;
    }

    GroupDeclaration getGroup() {
        return this.mGroup;
    }

    String getId() {
        if (this.mId == null) {
            this.setId(null);
        }
        return this.mId;
    }

    void setStateStore(StateStore stateStore) {
        this.mStateStore = stateStore;
    }

    StateStore getStateStore() {
        return this.mStateStore;
    }

    String getUrl() {
        return this.mUrl;
    }

    String getDeclarationName() {
        return this.mDeclarationName;
    }

    String getInherits() {
        return this.mInherits;
    }

    String getPre() {
        return this.mPre;
    }

    void setElementInfo(ElementInfo elementInfo) {
        this.mElementInfo = elementInfo;
    }

    ElementInfo getElementInfo() {
        return this.mElementInfo;
    }

    void addProperty(String name, Object value) {
        if (this.mProperties == null) {
            this.mProperties = new HashMap();
        }
        this.mProperties.put(name, value);
    }

    HashMap<String, Object> getProperties() {
        return this.mProperties;
    }

    Stack<ElementDeclaration> getParentStack() {
        return this.mParentStack;
    }

    Stack<ElementDeclaration> getPreStack() {
        return this.mPreStack;
    }

    public synchronized ElementDeclaration clone() {
        ElementDeclaration new_elementdeclaration;
        block5: {
            new_elementdeclaration = null;
            try {
                new_elementdeclaration = (ElementDeclaration)super.clone();
                if (this.mElementInfo == null) break block5;
                new_elementdeclaration.mElementInfo = this.mElementInfo.clone();
                if (this.mParentStack != null) {
                    new_elementdeclaration.mParentStack = new Stack();
                    new_elementdeclaration.mParentStack.addAll(this.mParentStack);
                }
                if (this.mPreStack != null) {
                    new_elementdeclaration.mPreStack = new Stack();
                    new_elementdeclaration.mPreStack.addAll(this.mPreStack);
                }
                if (this.mProperties != null) {
                    new_elementdeclaration.mProperties = new HashMap();
                    new_elementdeclaration.mProperties.putAll(this.mProperties);
                }
            }
            catch (CloneNotSupportedException e) {
                new_elementdeclaration = null;
            }
        }
        return new_elementdeclaration;
    }

    public synchronized /* synthetic */ Object clone() {
        return this.clone();
    }
}

