/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserIdentity;
import com.uwyn.rife.cmf.CmfProperty;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.CallState;
import com.uwyn.rife.engine.ChildRequestEncoder;
import com.uwyn.rife.engine.ContinuationContext;
import com.uwyn.rife.engine.ElementAware;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementState;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.engine.EmbeddingContext;
import com.uwyn.rife.engine.FlowLink;
import com.uwyn.rife.engine.GlobalVar;
import com.uwyn.rife.engine.OutcookieListener;
import com.uwyn.rife.engine.OutputListener;
import com.uwyn.rife.engine.ParameterMapEncoder;
import com.uwyn.rife.engine.Request;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.RequestState;
import com.uwyn.rife.engine.Response;
import com.uwyn.rife.engine.Scope;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.Submission;
import com.uwyn.rife.engine.TriggerContext;
import com.uwyn.rife.engine.TriggerListEncoder;
import com.uwyn.rife.engine.UploadedFile;
import com.uwyn.rife.engine.exceptions.AnswerException;
import com.uwyn.rife.engine.exceptions.BeanClassNamesErrorException;
import com.uwyn.rife.engine.exceptions.BeanInstanceValuesErrorException;
import com.uwyn.rife.engine.exceptions.CallException;
import com.uwyn.rife.engine.exceptions.ChildTriggeredException;
import com.uwyn.rife.engine.exceptions.DeferException;
import com.uwyn.rife.engine.exceptions.ElementIdNotFoundException;
import com.uwyn.rife.engine.exceptions.EmbeddedElementNotFoundException;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.ExitNotAttachedException;
import com.uwyn.rife.engine.exceptions.ExitTargetUrlMissingException;
import com.uwyn.rife.engine.exceptions.ExitTriggeredException;
import com.uwyn.rife.engine.exceptions.FileUnknownException;
import com.uwyn.rife.engine.exceptions.ForwardException;
import com.uwyn.rife.engine.exceptions.NamedInbeanClassnameErrorException;
import com.uwyn.rife.engine.exceptions.NamedOutbeanClassnameErrorException;
import com.uwyn.rife.engine.exceptions.NamedSubmissionBeanClassnameErrorException;
import com.uwyn.rife.engine.exceptions.ParameterUnknownException;
import com.uwyn.rife.engine.exceptions.PauseException;
import com.uwyn.rife.engine.exceptions.RedirectException;
import com.uwyn.rife.engine.exceptions.SubmissionBeanFormGenerationErrorException;
import com.uwyn.rife.engine.exceptions.SubmissionInheritanceUrlMissingException;
import com.uwyn.rife.engine.exceptions.SubmissionUrlMissingException;
import com.uwyn.rife.engine.exceptions.UnserializableOutputValueException;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.FormBuilder;
import com.uwyn.rife.site.Validated;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.template.BeanHandler;
import com.uwyn.rife.template.FilteredTagProcessorGroovy;
import com.uwyn.rife.template.FilteredTagProcessorJanino;
import com.uwyn.rife.template.FilteredTagProcessorOgnl;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateEncoder;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.Base64;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.ClassUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.HttpUtils;
import com.uwyn.rife.tools.SerializationUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import com.uwyn.rife.tools.exceptions.SerializationUtilsErrorException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementContext {
    public static final String PREFIX_EXIT_QUERY = "EXIT:QUERY:";
    public static final String PREFIX_EXIT_FORM = "EXIT:FORM:";
    public static final String PREFIX_EXIT_PARAMS = "EXIT:PARAMS:";
    public static final String PREFIX_SUBMISSION_QUERY = "SUBMISSION:QUERY:";
    public static final String PREFIX_SUBMISSION_FORM = "SUBMISSION:FORM:";
    public static final String PREFIX_SUBMISSION_PARAMS = "SUBMISSION:PARAMS:";
    public static final String PREFIX_PARAM = "PARAM:";
    public static final String PREFIX_INPUT = "INPUT:";
    public static final String PREFIX_OUTPUT = "OUTPUT:";
    public static final String PREFIX_INCOOKIE = "INCOOKIE:";
    public static final String PREFIX_OUTCOOKIE = "OUTCOOKIE:";
    public static final String PREFIX_ELEMENT = "ELEMENT:";
    public static final String PREFIX_OGNL_ROLEUSER = "OGNL:ROLEUSER:";
    public static final String PREFIX_GROOVY_ROLEUSER = "GROOVY:ROLEUSER:";
    public static final String PREFIX_JANINO_ROLEUSER = "JANINO:ROLEUSER:";
    public static final String ID_WEBAPP_ROOTURL = "WEBAPP:ROOTURL";
    public static final String TAG_ELEMENT = "^ELEMENT:(.*?)(:[^:]*)?$";
    public static final String TAG_OGNL_ROLEUSER = "(?s)^(OGNL:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_JANINO_ROLEUSER = "(?s)^(JANINO:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    public static final String TAG_GROOVY_ROLEUSER = "(?s)^(GROOVY:ROLEUSER:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$";
    private static ThreadLocal<ElementSupport> sActiveElements;
    private ElementSupport mElement = null;
    private ElementInfo mElementInfo = null;
    private RequestState mRequestState = null;
    private ElementState mElementState = null;
    private Response mResponse = null;
    private HashMap<String, String[]> mOutputs = null;
    private HashMap<String, String> mOutcookies = null;
    private ArrayList<OutputListener> mOutputListeners = null;
    private ArrayList<OutcookieListener> mOutcookieListeners = null;
    private CallState mActiveCallState = null;
    private String mContextId = null;
    private String mSubmission = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    static ElementSupport getActiveElement() {
        return sActiveElements.get();
    }

    ElementContext(ElementSupport element, RequestState state, Response response) {
        OutputListener listener;
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        element.setElementContext(this);
        this.mElement = element;
        this.mElementInfo = this.mElement.getElementInfo();
        this.mRequestState = state;
        this.mElementState = this.mRequestState.getElementState();
        this.mResponse = response;
        this.mOutputs = new HashMap();
        this.mOutcookies = new HashMap();
        if (state.isEmbedded()) {
            listener = state.getEmbeddingListener();
            this.addOutputListener(listener);
            this.addOutcookieListener((OutcookieListener)((Object)listener));
        }
        if (state.isPreceeding()) {
            listener = state.getPrecedenceListener();
            this.addOutputListener(listener);
            this.addOutcookieListener((OutcookieListener)((Object)listener));
        }
        if (this.mElementState.isInheritanceTarget() && this.mElementState.hasParameterValue("childrequest")) {
            ChildRequestEncoder.decode(element.getElementInfo(), this.mRequestState);
        }
        String[] output_values = null;
        for (String globalvar_name : this.mElementInfo.getGlobalVarNames()) {
            if (!this.mElementState.hasInputValue(globalvar_name)) continue;
            output_values = this.mElementState.getInputValues(globalvar_name);
            this.setOutputValues(globalvar_name, output_values);
        }
    }

    private void handleChildTriggerVariablesPre() {
        if (this.mElementInfo.getChildTriggerNames().size() > 0) {
            for (String child_trigger_name : this.mElementInfo.getChildTriggerNames()) {
                if (this.mElementState.hasInputValue(child_trigger_name)) {
                    if (!this.mElementInfo.containsGlobalVar(child_trigger_name) && !this.mElementInfo.containsInput(child_trigger_name)) continue;
                    this.triggerChild(child_trigger_name, this.getInputValues(child_trigger_name));
                    continue;
                }
                if (this.mRequestState.getCookie(child_trigger_name) != null) {
                    if (!this.mElementInfo.containsGlobalCookie(child_trigger_name) && !this.mElementInfo.containsIncookie(child_trigger_name)) continue;
                    this.triggerChild(child_trigger_name, new String[]{this.getCookie(child_trigger_name).getValue()});
                    continue;
                }
                if (this.mElementInfo.hasInputDefaultValues(child_trigger_name)) {
                    this.triggerChild(child_trigger_name, this.mElementInfo.getInputDefaultValues(child_trigger_name));
                    continue;
                }
                if (this.mElementInfo.hasIncookieDefaultValue(child_trigger_name)) {
                    this.triggerChild(child_trigger_name, new String[]{this.mElementInfo.getIncookieDefaultValue(child_trigger_name)});
                    continue;
                }
                if (this.mElementInfo.containsGlobalVar(child_trigger_name) && this.mElementInfo.hasGlobalVarDefaultValues(child_trigger_name)) {
                    this.triggerChild(child_trigger_name, this.mElementInfo.getGlobalVarDefaultValues(child_trigger_name));
                    continue;
                }
                if (!this.mElementInfo.containsGlobalCookie(child_trigger_name) || !this.mElementInfo.hasGlobalCookieDefaultValue(child_trigger_name)) continue;
                this.triggerChild(child_trigger_name, new String[]{this.mElementInfo.getGlobalCookieDefaultValue(child_trigger_name)});
            }
        }
    }

    private void handleChildTriggerVariablesPost() {
        if (this.mElementInfo.getChildTriggerNames().size() > 0) {
            for (String child_trigger_name : this.mElementInfo.getChildTriggerNames()) {
                if (!this.mElementInfo.hasOutputDefaultValues(child_trigger_name)) continue;
                String[] output_defaultvalues = this.mElementInfo.getOutputDefaultValues(child_trigger_name);
                this.triggerChild(child_trigger_name, output_defaultvalues);
            }
        }
    }

    ElementContext processContext() {
        long start = this.mElementInfo.startTrace();
        ElementContext result = null;
        try {
            try {
                Cookie default_cookie;
                ElementSupport previous_active_element;
                block56: {
                    String cont_id;
                    if (this.mElementState.inInheritanceStructure()) {
                        if (this.mElementState.isNextTrigger(this.mElementInfo)) {
                            if (1 == this.mElementState.getNextTriggerType() && this.mElementInfo.containsChildTrigger(this.mElementState.getNextTriggerName())) {
                                this.triggerChild(this.mElementState.getNextTriggerName(), this.mElementState.getNextTriggerValues());
                            } else if (2 == this.mElementState.getNextTriggerType() && this.mElementInfo.containsExit(this.mElementState.getNextTriggerName())) {
                                this.exit(this.mElementState.getNextTriggerName());
                            }
                        }
                        this.handleChildTriggerVariablesPre();
                    }
                    this.mRequestState.handlePrecedence(this.mResponse, this.getElementInfo());
                    if (this.mElementInfo.getContentType() != null && this.mElementInfo.getContentType().length() > 0) {
                        this.mResponse.setContentType(this.mElementInfo.getContentType());
                    }
                    ContinuationContext continuation_context = this.mRequestState.getContinuationContext(this.mElementInfo);
                    ContinuationContext.setContext(continuation_context);
                    if (continuation_context == null && this.mActiveCallState == null && (cont_id = this.mRequestState.getContinuationId()) != null) {
                        this.mActiveCallState = this.mRequestState.getSite().getContinuationManager().getCreatedCallState(cont_id);
                    }
                    previous_active_element = sActiveElements.get();
                    sActiveElements.set(this.mElement);
                    try {
                        ElementAware element_aware = this.mElement.getElementAware();
                        if (this.mElementState.hasParameterValue("submission")) {
                            String[] submission_names = this.mElementState.getParameterValues("submission");
                            String[] submission_contexts = this.mElementState.getParameterValues("submissioncontext");
                            String submission_context = null;
                            String submission_context_id = null;
                            String submission_target = null;
                            HashSet<String> non_parameter_inputs = null;
                            int counter = 0;
                            String[] stringArray = submission_names;
                            int n = 0;
                            while (n < stringArray.length) {
                                String submission_name = stringArray[n];
                                if (submission_contexts == null || counter >= submission_contexts.length) {
                                    submission_context = this.getContextId();
                                } else {
                                    try {
                                        byte[] decoded = Base64.decode(submission_contexts[counter].getBytes("UTF-8"));
                                        submission_context = decoded != null && decoded.length > 0 ? new String(decoded) : this.getContextId();
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        // empty catch block
                                    }
                                }
                                int seperator_index = submission_context.indexOf("^");
                                if (-1 == seperator_index) {
                                    submission_context_id = submission_context;
                                    submission_target = submission_context;
                                } else {
                                    submission_context_id = submission_context.substring(0, seperator_index);
                                    submission_target = submission_context.substring(seperator_index + 1);
                                }
                                if (this.mSubmission == null && this.getContextId().equals(submission_context_id) && this.mElementInfo.hasSubmission(submission_name)) {
                                    this.mSubmission = submission_name;
                                } else {
                                    Collection<String> names;
                                    Submission submission;
                                    ElementInfo submission_target_element;
                                    if (0 == submission_target.length()) {
                                        submission_target = this.getElementInfo().getId();
                                    }
                                    if ((submission_target_element = this.mElementInfo.getSite().resolveId(submission_target)) != null && (submission = submission_target_element.getSubmission(submission_name)) != null && (names = submission.getParameterNames()) != null && names.size() > 0) {
                                        if (non_parameter_inputs == null) {
                                            non_parameter_inputs = new HashSet<String>();
                                        }
                                        non_parameter_inputs.addAll(names);
                                    }
                                }
                                ++counter;
                                ++n;
                            }
                            this.mElementState.setNonParameterInputs(non_parameter_inputs);
                        }
                        this.mElement.initialize();
                        Object submission_handler = null;
                        String submission_name = this.getSubmission();
                        if (submission_name != null) {
                            String submission_handler_name = new StringBuffer().append("do").append(StringUtils.capitalize(submission_name)).toString();
                            try {
                                submission_handler = element_aware.getClass().getMethod(submission_handler_name, null);
                            }
                            catch (NoSuchMethodException e) {
                                submission_handler = null;
                            }
                            catch (SecurityException e) {
                                throw new EngineException(e);
                            }
                        }
                        if (submission_handler == null) {
                            element_aware.processElement();
                            break block56;
                        }
                        try {
                            ((Method)submission_handler).invoke((Object)element_aware, (Object[])null);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof EngineException) {
                                throw (EngineException)e.getCause();
                            }
                            throw new EngineException(e.getCause());
                        }
                        catch (IllegalArgumentException e) {
                            throw new EngineException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new EngineException(e);
                        }
                    }
                    catch (AnswerException e) {
                        if (this.mActiveCallState == null) break block56;
                        throw e;
                    }
                }
                sActiveElements.set(previous_active_element);
                this.handleChildTriggerVariablesPost();
                if (this.mElementInfo.hasOutcookieDefaults()) {
                    default_cookie = null;
                    for (Map.Entry default_outcookie_entry : (Collection)this.mElementInfo.getDefaultOutcookies().entrySet()) {
                        if (this.mOutcookies.containsKey((String)default_outcookie_entry.getKey())) continue;
                        default_cookie = new Cookie((String)default_outcookie_entry.getKey(), (String)default_outcookie_entry.getValue());
                        default_cookie.setPath("");
                        this.setCookie(default_cookie);
                    }
                }
                if (this.mElementInfo.hasGlobalCookieDefaults()) {
                    default_cookie = null;
                    for (Map.Entry default_globalcookie_entry : (Collection)this.mElementInfo.getDefaultGlobalCookies().entrySet()) {
                        if (this.mOutcookies.containsKey((String)default_globalcookie_entry.getKey())) continue;
                        default_cookie = new Cookie((String)default_globalcookie_entry.getKey(), (String)default_globalcookie_entry.getValue());
                        default_cookie.setPath("");
                        this.setCookie(default_cookie);
                    }
                }
            }
            catch (PauseException e) {
                ContinuationContext context = e.getContext();
                this.mElementInfo.getSite().getContinuationManager().addContext(context);
                this.mRequestState.setRequest(null);
                try {
                    this.mResponse.flush();
                }
                catch (EngineException e2) {
                    // empty catch block
                }
                this.mResponse = null;
                e.getContext().setActiveCallState(this.mActiveCallState);
                this.setActiveCallState(null);
            }
            catch (ChildTriggeredException e) {
                result = this.setupChildtriggerContext(e.getChildTriggerName(), e.getChildTriggerValues());
                if (result != null && this.mActiveCallState != null) {
                    result.setActiveCallState(this.mActiveCallState);
                }
            }
            catch (ExitTriggeredException e) {
                result = this.handleExitTrigger(e.getExitName());
                if (result != null && this.mActiveCallState != null) {
                    result.setActiveCallState(this.mActiveCallState);
                }
            }
            catch (CallException e) {
                String exit = e.getExitName();
                this.mElementInfo.validateExitName(exit);
                if (this.mElementInfo.getFlowLink(exit) == null) {
                    throw new ExitNotAttachedException(this.mElementInfo.getDeclarationName(), exit);
                }
                ContinuationContext context = e.getContext();
                this.mElementInfo.getSite().getContinuationManager().addContext(context);
                context.setActiveCallState(this.getActiveCallState());
                this.setActiveCallState(null);
                CallState call_state = new CallState(context.getId(), this.mElementInfo.getId(), this.mElementState.clone());
                e.getContext().setCreatedCallState(call_state);
                result = this.setupExitContext(e.getExitName());
                result.setActiveCallState(call_state);
            }
            catch (ForwardException e) {
                this.handleForward(e.getUrl());
            }
            catch (RedirectException e) {
                this.getResponse().sendRedirect(e.getUrl());
            }
        }
        finally {
            try {
                if (this.mResponse != null) {
                    this.mResponse.flush();
                }
            }
            catch (EngineException e) {}
            this.mElementInfo.outputTrace(start, this.mRequestState);
        }
        return result;
    }

    public void setActiveCallState(CallState callState) {
        this.mActiveCallState = callState;
    }

    public CallState getActiveCallState() {
        return this.mActiveCallState;
    }

    private ElementContext setupChildtriggerContext(String childtrigger, String[] values) {
        ElementContext element_context = null;
        Map<String, String[]> child_inputs = null;
        if (this.mElementState.inInheritanceStructure()) {
            ElementInfo child_element_info = this.mElementState.getInheritanceStack().pop();
            if (this.mElementState.isNextChildTrigger(this.mElementInfo, childtrigger)) {
                child_inputs = this.mElementState.nextTrigger().getParameters();
            } else {
                child_inputs = this.getChildInputValues(child_element_info);
                if (childtrigger != null) {
                    this.mElementState.addTrigger(TriggerContext.generateChildTrigger(this.mElementInfo, childtrigger, values, child_inputs));
                }
            }
            this.mElementState.setInputs(child_inputs);
            element_context = this.mRequestState.getElementContext(child_element_info, this.mResponse);
        }
        return element_context;
    }

    private ElementContext handleExitTrigger(String exit) {
        FlowLink flowlink = this.mElementInfo.getFlowLink(exit);
        if (flowlink == null) {
            throw new ExitNotAttachedException(this.mElementInfo.getDeclarationName(), exit);
        }
        if (flowlink.isRedirect()) {
            this.getResponse().sendRedirect(this._getExitQueryUrl(flowlink, null, null));
            return null;
        }
        return this.setupExitContext(exit);
    }

    private ElementContext setupExitContext(String exit) {
        FlowLink flowlink = this.mElementInfo.getFlowLink(exit);
        if (flowlink == null) {
            throw new ExitNotAttachedException(this.mElementInfo.getDeclarationName(), exit);
        }
        ElementInfo target = flowlink.getExitTarget(this.mRequestState);
        Map<Object, Object> exit_request_params = null;
        Map<String, String[]> exit_inputs = null;
        Stack<ElementInfo> inheritance_stack = null;
        if (this.mElementState.inInheritanceStructure() && !flowlink.cancelInheritance()) {
            if (this.mElementState.isNextExitTrigger(this.mElementInfo, exit)) {
                exit_request_params = this.mElementState.getRequestParameters();
                exit_inputs = this.mElementState.nextTrigger().getParameters();
            } else {
                exit_request_params = new HashMap();
                exit_request_params.put("childrequest", new String[]{this.getEncodedChildRequest()});
                exit_request_params.put("triggerlist", this.mElementState.getParameterValues("triggerlist"));
                exit_inputs = this.getExitInputValues(this.mOutputs, target, flowlink.isSnapback());
                this.mElementState.addTrigger(TriggerContext.generateExitTrigger(this.mElementInfo, exit, exit_inputs));
            }
            inheritance_stack = this.mElementState.getInheritanceStack();
            Stack<ElementInfo> dest_inheritance_stack = target.getInheritanceStack();
            if (dest_inheritance_stack != null) {
                inheritance_stack.addAll(dest_inheritance_stack);
                target = inheritance_stack.pop();
            }
        } else {
            exit_request_params = new HashMap();
            exit_inputs = this.getExitInputValues(this.mOutputs, target, flowlink.isSnapback());
            this.mRequestState.setTarget(target);
            Stack<ElementInfo> dest_inheritance_stack = target.getInheritanceStack();
            if (dest_inheritance_stack != null) {
                inheritance_stack = new Stack();
                inheritance_stack.addAll(dest_inheritance_stack);
                target = inheritance_stack.pop();
            }
        }
        this.mElementState.setMethod(RequestMethod.EXIT);
        this.mElementState.setRequestParameters(exit_request_params);
        this.mElementState.setInheritanceStack(inheritance_stack);
        this.mElementState.setInputs(exit_inputs);
        return this.mRequestState.getElementContext(target, this.mResponse);
    }

    private void handleForward(String url) {
        boolean is_absolute_url = true;
        if (-1 == url.indexOf(":/")) {
            StringBuffer absolute_url;
            is_absolute_url = false;
            StringBuffer stringBuffer = absolute_url = new StringBuffer();
            synchronized (stringBuffer) {
                absolute_url.append(this.getWebappRootUrl(RifeConfig.Engine.getLocalForwardPort()));
                if (url.startsWith("/")) {
                    absolute_url.append(url.substring(1));
                } else {
                    absolute_url.append(url);
                }
            }
            url = absolute_url.toString();
        }
        try {
            HttpUtils.Page page;
            HashMap<String, String> request_header_map = new HashMap<String, String>();
            HttpServletRequest request = this.mRequestState.getRequest().getHttpServletRequest();
            Enumeration request_header_names = request.getHeaderNames();
            if (request_header_names.hasMoreElements()) {
                String header_name = null;
                String header_name_lowercase = null;
                String header_value = null;
                do {
                    if ((header_name = (String)request_header_names.nextElement()) == null) continue;
                    header_name_lowercase = header_name.toLowerCase();
                    header_value = request.getHeader(header_name);
                    if (is_absolute_url && ("host".equals(header_name_lowercase) || "connection".equals(header_name_lowercase) || "keep-alive".equals(header_name_lowercase) || "content-type".equals(header_name_lowercase) || "content-length".equals(header_name_lowercase))) continue;
                    request_header_map.put(header_name, header_value);
                } while (request_header_names.hasMoreElements());
            }
            if ((page = new HttpUtils.Request(url).headers(request_header_map).retrieve()).getResponseCode() / 100 != 2) {
                this.mResponse.sendError(page.getResponseCode(), page.getResponseMessage());
            } else {
                this.mResponse.setStatus(page.getResponseCode());
            }
            if (page.getContent() != null) {
                this.mResponse.print(page.getContent());
            }
            for (Map.Entry header : (Collection)page.getHeaders().entrySet()) {
                String key;
                if ((String)header.getKey() == null || (key = ((String)header.getKey()).toLowerCase()).equals("accept-encoding") || key.equals("content-encoding") || key.equals("content-length") || key.equals("date") || key.equals("host") || key.equals("server") || key.equals("transfer-encoding")) continue;
                if (key.equals("content-type")) {
                    String content_type = page.getContentType();
                    int charset_index = content_type.indexOf("; charset=");
                    if (charset_index != -1) {
                        content_type = content_type.substring(0, charset_index);
                    }
                    this.mResponse.setContentType(content_type);
                    continue;
                }
                for (String header_value : (Collection)((List)header.getValue())) {
                    this.mResponse.addHeader((String)header.getKey(), header_value);
                }
            }
        }
        catch (IOException e) {
            this.mResponse.sendError(404);
        }
        HttpServletRequest request = this.mRequestState.getRequest().getHttpServletRequest();
        RequestDispatcher dispatcher = request.getRequestDispatcher(url);
        if (dispatcher == null) {
            this.mResponse.sendError(404);
        }
    }

    RequestState getRequestState() {
        return this.mRequestState;
    }

    ElementInfo getElementInfo() {
        return this.mElementInfo;
    }

    Response getResponse() {
        return this.mResponse;
    }

    void setResponse(Response response) {
        this.mResponse = response;
    }

    HashMap<String, String[]> getOutputs() {
        return this.mOutputs;
    }

    Template getHtmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Template template2 = TemplateFactory.ENGINEHTML.get(name, encoding, transformer);
        return template2;
    }

    Template getXhtmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Template template2 = TemplateFactory.ENGINEXHTML.get(name, encoding, transformer);
        return template2;
    }

    Template getXmlTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Template template2 = TemplateFactory.ENGINEXML.get(name, encoding, transformer);
        return template2;
    }

    Template getTxtTemplate(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        Template template2 = TemplateFactory.ENGINETXT.get(name, encoding, transformer);
        return template2;
    }

    void processEmbeddedElements(Template template2, ElementSupport embeddingElement) {
        if (template2.hasFilteredValues(TAG_ELEMENT)) {
            List<String[]> element_tags = template2.getFilteredValues(TAG_ELEMENT);
            for (String[] captured_groups : (Collection)element_tags) {
                if (template2.isValueSet(captured_groups[0])) continue;
                this.processEmbeddedElement(template2, embeddingElement, captured_groups[1], captured_groups[2]);
            }
        }
    }

    void print(Template template2) {
        List<String> set_values = this.processTemplate(template2);
        this.mResponse.print(template2.getDeferredContent());
        for (Object value : (Collection)set_values) {
            template2.removeValue(value.toString());
        }
    }

    List<String> processTemplate(Template template2) {
        ArrayList<String> set_values = new ArrayList<String>();
        TemplateEncoder encoder = template2.getEncoder();
        this.evaluateExpressionRoleUserTags(template2, null);
        Set<Map.Entry<String, FlowLink>> exit_entries = this.mElementInfo.getExitEntries();
        if (exit_entries.size() > 0) {
            String exit_name = null;
            String exit_query_value_id = null;
            String exit_form_value_id = null;
            String exit_params_value_id = null;
            for (Map.Entry exit_entry : (Collection)exit_entries) {
                if ((FlowLink)exit_entry.getValue() == null) continue;
                exit_name = (String)exit_entry.getKey();
                exit_query_value_id = new StringBuffer().append(PREFIX_EXIT_QUERY).append(exit_name).toString();
                exit_form_value_id = new StringBuffer().append(PREFIX_EXIT_FORM).append(exit_name).toString();
                exit_params_value_id = new StringBuffer().append(PREFIX_EXIT_PARAMS).append(exit_name).toString();
                if (template2.hasValueId(exit_query_value_id) && !template2.isValueSet(exit_query_value_id)) {
                    template2.setValue(exit_query_value_id, encoder.encode(this._getExitQueryUrl((FlowLink)exit_entry.getValue(), null, null)));
                    set_values.add(exit_query_value_id);
                }
                if (template2.hasValueId(exit_form_value_id)) {
                    if (!template2.isValueSet(exit_form_value_id)) {
                        template2.setValue(exit_form_value_id, encoder.encode(this._getExitFormUrl((FlowLink)exit_entry.getValue(), null)));
                        set_values.add(exit_form_value_id);
                    }
                    if (template2.hasValueId(exit_params_value_id)) {
                        if (template2.isValueSet(exit_params_value_id)) continue;
                        template2.setValue(exit_params_value_id, this._getExitFormParameters((FlowLink)exit_entry.getValue(), null));
                        set_values.add(exit_params_value_id);
                        continue;
                    }
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The required template value '").append(exit_params_value_id).toString()).append("' is not present. Replacement of the template value '").toString()).append(exit_form_value_id).toString()).append("' alone is not sufficient.").toString());
                }
                if (!template2.hasValueId(exit_params_value_id)) continue;
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The template value '").append(exit_params_value_id).toString()).append("' was specified, while the template value '").toString()).append(exit_form_value_id).toString()).append("' could not be found. This is not sufficient, both are needed.").toString());
            }
        }
        String submission_query_value_id = null;
        String submission_form_value_id = null;
        String submission_params_value_id = null;
        for (String submission_name : this.mElementInfo.getSubmissionNames()) {
            submission_query_value_id = new StringBuffer().append(PREFIX_SUBMISSION_QUERY).append(submission_name).toString();
            submission_form_value_id = new StringBuffer().append(PREFIX_SUBMISSION_FORM).append(submission_name).toString();
            submission_params_value_id = new StringBuffer().append(PREFIX_SUBMISSION_PARAMS).append(submission_name).toString();
            if (template2.hasValueId(submission_query_value_id) && !template2.isValueSet(submission_query_value_id)) {
                template2.setValue(submission_query_value_id, encoder.encode(this._getSubmissionQueryUrl(submission_name, null, null)));
                set_values.add(submission_query_value_id);
            }
            if (template2.hasValueId(submission_form_value_id)) {
                if (!template2.isValueSet(submission_form_value_id)) {
                    template2.setValue(submission_form_value_id, encoder.encode(this.getSubmissionFormUrl(null)));
                    set_values.add(submission_form_value_id);
                }
                if (template2.hasValueId(submission_params_value_id)) {
                    if (template2.isValueSet(submission_params_value_id)) continue;
                    template2.setValue(submission_params_value_id, this._getSubmissionFormParameters(submission_name, null));
                    set_values.add(submission_params_value_id);
                    continue;
                }
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The parameters template value '").append(submission_params_value_id).toString()).append("' is not present. Replacement of the template value '").toString()).append(submission_form_value_id).toString()).append("' alone is not sufficient.").toString());
            }
            if (!template2.hasValueId(submission_params_value_id)) continue;
            throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The template value '").append(submission_params_value_id).toString()).append("' was specified, while the template value '").toString()).append(submission_form_value_id).toString()).append("' could not be found. This is not sufficient, both are needed.").toString());
        }
        String[] submission_param_values = null;
        String submission_param_value_id = null;
        for (Submission submission : this.mElementInfo.getSubmissions()) {
            FormBuilder form_builder;
            for (String submission_param_name : submission.getParameterNames()) {
                if (!this.mElementState.hasParameterValue(submission_param_name)) continue;
                submission_param_values = this.mElementState.getParameterValues(submission_param_name);
                submission_param_value_id = new StringBuffer().append(PREFIX_PARAM).append(submission_param_name).toString();
                if (template2.hasValueId(submission_param_value_id) && !template2.isValueSet(submission_param_value_id)) {
                    template2.setValue(submission_param_value_id, encoder.encode(submission_param_values[0]));
                    set_values.add(submission_param_value_id);
                }
                set_values.addAll(this.selectSubmissionParameter(template2, submission_param_name, submission_param_values));
            }
            BeanHandler bean_handler = template2.getBeanHandler();
            if (bean_handler == null || (form_builder = bean_handler.getFormBuilder()) == null) continue;
            for (BeanDeclaration bean : submission.getBeans()) {
                try {
                    form_builder.generateForm(template2, bean.getBeanClass(), this.mElementState.getRequestParameters(), bean.getPrefix());
                }
                catch (Throwable e) {
                    throw new SubmissionBeanFormGenerationErrorException(this.mElementInfo.getDeclarationName(), submission.getName(), bean.getClassname(), e);
                }
            }
        }
        String input_value_id = null;
        String[] input_values = null;
        for (Map.Entry input_entry : (Collection)this.mElementState.getInputEntries()) {
            if (!this.mElementInfo.containsInput((String)input_entry.getKey()) || !this.mElementState.hasInputValue((String)input_entry.getKey())) continue;
            input_value_id = new StringBuffer().append(PREFIX_INPUT).append((String)input_entry.getKey()).toString();
            input_values = (String[])input_entry.getValue();
            if (template2.hasValueId(input_value_id) && !template2.isValueSet(input_value_id)) {
                template2.setValue(input_value_id, encoder.encode(input_values[0]));
                set_values.add(input_value_id);
            }
            set_values.addAll(this.selectInputParameter(template2, (String)input_entry.getKey(), input_values));
        }
        String output_value_id = null;
        for (Map.Entry output_entry : (Collection)this.getOutputEntries(this.mOutputs)) {
            output_value_id = new StringBuffer().append(PREFIX_OUTPUT).append((String)output_entry.getKey()).toString();
            if (!template2.hasValueId(output_value_id) || template2.isValueSet(output_value_id)) continue;
            template2.setValue(output_value_id, encoder.encode(((String[])output_entry.getValue())[0]));
            set_values.add(output_value_id);
        }
        for (String globalvar_name : this.mElementInfo.getGlobalVarNames()) {
            if (this.mElementState.hasInputValue(globalvar_name)) {
                input_value_id = new StringBuffer().append(PREFIX_INPUT).append(globalvar_name).toString();
                if (template2.hasValueId(input_value_id) && !template2.isValueSet(input_value_id)) {
                    template2.setValue(input_value_id, encoder.encode(this.mElementState.getInput(globalvar_name)));
                    set_values.add(input_value_id);
                }
                set_values.addAll(this.selectInputParameter(template2, globalvar_name, this.mElementState.getInputValues(globalvar_name)));
            }
            if (!this.hasOutputValue(globalvar_name) || !template2.hasValueId(output_value_id = new StringBuffer().append(PREFIX_OUTPUT).append(globalvar_name).toString()) || template2.isValueSet(output_value_id)) continue;
            template2.setValue(output_value_id, encoder.encode(this.getOutputValue(globalvar_name)[0]));
            set_values.add(output_value_id);
        }
        String incookie_value_id = null;
        for (Map.Entry incookie_entry : (Collection)this.getIncookieEntries()) {
            if (!this.mElementInfo.containsIncookie((String)incookie_entry.getKey()) && !this.mElementInfo.containsGlobalCookie((String)incookie_entry.getKey()) || !template2.hasValueId(incookie_value_id = new StringBuffer().append(PREFIX_INCOOKIE).append((String)incookie_entry.getKey()).toString()) || template2.isValueSet(incookie_value_id)) continue;
            template2.setValue(incookie_value_id, encoder.encode((String)incookie_entry.getValue()));
            set_values.add(incookie_value_id);
        }
        String outcookie_value_id = null;
        for (Map.Entry outcookie_entry : (Collection)this.getOutcookieEntries(this.mOutcookies)) {
            if (!this.mElementInfo.containsOutcookiePossibility((String)outcookie_entry.getKey()) || !template2.hasValueId(outcookie_value_id = new StringBuffer().append(PREFIX_OUTCOOKIE).append((String)outcookie_entry.getKey()).toString()) || template2.isValueSet(outcookie_value_id)) continue;
            template2.setValue(outcookie_value_id, encoder.encode((String)outcookie_entry.getValue()));
            set_values.add(outcookie_value_id);
        }
        if (template2.hasValueId(ID_WEBAPP_ROOTURL) && !template2.isValueSet(ID_WEBAPP_ROOTURL)) {
            template2.setValue(ID_WEBAPP_ROOTURL, this.getWebappRootUrl(-1));
            set_values.add(ID_WEBAPP_ROOTURL);
        }
        return set_values;
    }

    private void triggerChild(String childTriggerName, String[] childTriggerValues) {
        this.mElement.enableRequestAccess(false);
        try {
            if (this.mElement.childTriggered(childTriggerName, childTriggerValues)) {
                throw new ChildTriggeredException(childTriggerName, childTriggerValues);
            }
        }
        finally {
            this.mElement.enableRequestAccess(true);
        }
    }

    String getServerRootUrl(int port) {
        StringBuffer server_root;
        StringBuffer stringBuffer = server_root = new StringBuffer();
        synchronized (stringBuffer) {
            HttpServletRequest request = this.mRequestState.getRequest().getHttpServletRequest();
            server_root.append(request.getScheme());
            server_root.append("://");
            server_root.append(request.getServerName());
            if (port <= -1) {
                port = request.getServerPort();
            }
            if (port != 80) {
                server_root.append(":");
                server_root.append(port);
            }
        }
        return server_root.toString();
    }

    String getWebappRootUrl(int port) {
        StringBuffer webapp_root;
        if (RifeConfig.Engine.getProxyRootUrl() != null) {
            return RifeConfig.Engine.getProxyRootUrl();
        }
        StringBuffer stringBuffer = webapp_root = new StringBuffer();
        synchronized (stringBuffer) {
            webapp_root.append(this.getServerRootUrl(port));
            String gate_url = this.mRequestState.getGateUrl();
            if (!gate_url.startsWith("/")) {
                webapp_root.append("/");
            }
            webapp_root.append(gate_url);
            if (gate_url.length() > 0 && !gate_url.endsWith("/")) {
                webapp_root.append("/");
            }
        }
        return webapp_root.toString();
    }

    boolean hasSubmission() {
        return this.getSubmission() != null;
    }

    boolean hasSubmission(String name) {
        String submission = this.getSubmission();
        return submission != null && submission.equals(name);
    }

    String getSubmission() {
        if (this.mSubmission == null) {
            return null;
        }
        return this.mSubmission;
    }

    private void validateParameter(String parameterName) {
        if (!$assertionsDisabled && parameterName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameterName.length() <= 0) {
            throw new AssertionError();
        }
        boolean found = false;
        for (Submission submission : this.mElementInfo.getSubmissions()) {
            if (!submission.containsParameter(parameterName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new ParameterUnknownException(this.mElementInfo.getDeclarationName(), parameterName);
        }
    }

    private void validateParameter(String submissionName, String parameterName) {
        if (!$assertionsDisabled && parameterName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameterName.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(submissionName);
        Submission submission = this.mElementInfo.getSubmission(submissionName);
        if (!submission.containsParameter(parameterName)) {
            throw new ParameterUnknownException(this.mElementInfo.getDeclarationName(), submissionName, parameterName);
        }
    }

    private void validateFile(String fileName) {
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && fileName.length() <= 0) {
            throw new AssertionError();
        }
        boolean found = false;
        for (Submission submission : this.mElementInfo.getSubmissions()) {
            if (!submission.containsFile(fileName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new FileUnknownException(this.mElementInfo.getDeclarationName(), fileName);
        }
    }

    private void validateFile(String submissionName, String fileName) {
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && fileName.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(submissionName);
        Submission submission = this.mElementInfo.getSubmission(submissionName);
        if (!submission.containsFile(fileName)) {
            throw new FileUnknownException(this.mElementInfo.getDeclarationName(), submissionName, fileName);
        }
    }

    boolean isInputEmpty(String name) {
        String input = this.getInput(name);
        return input == null || input.trim().equals("");
    }

    String getInput(String name) {
        String[] default_values;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateInputName(name);
        String input = this.mElementState.getInput(name);
        if (input == null && this.mElementInfo.hasInputDefaults() && (default_values = this.mElementInfo.getInputDefaultValues(name)) != null) {
            input = default_values[0];
        }
        if (input == null && this.mElementInfo.hasGlobalVarDefaults() && (default_values = this.mElementInfo.getGlobalVarDefaultValues(name)) != null) {
            input = default_values[0];
        }
        return input;
    }

    String[] getInputValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateInputName(name);
        String[] input_values = this.mElementState.getInputValues(name);
        if (input_values == null && this.mElementInfo.hasInputDefaults()) {
            input_values = this.mElementInfo.getInputDefaultValues(name);
        }
        if (input_values == null && this.mElementInfo.hasGlobalVarDefaults()) {
            input_values = this.mElementInfo.getGlobalVarDefaultValues(name);
        }
        return input_values;
    }

    boolean hasInputValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateInputName(name);
        return this.mElementState.hasInputValue(name) || this.mElementInfo.hasInputDefaultValues(name) || this.mElementInfo.hasGlobalVarDefaultValues(name);
    }

    Collection<String> selectInputParameter(Template template2, String name, String[] values) {
        return this.selectParameter(template2, new StringBuffer().append(PREFIX_INPUT).append(name).toString(), values);
    }

    void setOutput(String name, String value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        String[] value_array = new String[]{value};
        this.setOutputValues(name, value_array);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, value_array);
        }
    }

    void setOutput(String name, String[] values) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values.length <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        this.setOutputValues(name, values);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, values);
        }
    }

    void setOutput(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        String[] value_array = null;
        String value_text = null;
        Class<?> value_type = value.getClass();
        if (value_type.isArray()) {
            value_array = ArrayUtils.createStringArray(value);
        }
        if (value_array == null) {
            if (ClassUtils.isBasic(value_type)) {
                value_text = String.valueOf(value);
            } else if (value instanceof Serializable) {
                try {
                    value_text = SerializationUtils.serializeToString((Serializable)value);
                }
                catch (SerializationUtilsErrorException e) {
                    throw new UnserializableOutputValueException(this.mElementInfo.getDeclarationName(), name, value, e);
                }
            } else {
                value_text = String.valueOf(value);
            }
            value_array = new String[]{value_text};
        }
        this.setOutputValues(name, value_array);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, value_array);
        }
    }

    void addOutputValue(String name, String value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        String[] value_array = null;
        value_array = this.hasOutputValue(name) ? ArrayUtils.join(this.getOutputValue(name), value) : new String[]{value};
        this.setOutputValues(name, value_array);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, value_array);
        }
    }

    void addOutputValues(String name, String[] values) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values.length <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        if (this.hasOutputValue(name)) {
            this.setOutputValues(name, ArrayUtils.join(this.getOutputValue(name), values));
        } else {
            this.setOutputValues(name, values);
        }
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, this.getOutputValue(name));
        }
    }

    void addOutputValue(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        String value_text = null;
        Class<?> value_type = value.getClass();
        if (ClassUtils.isBasic(value_type)) {
            value_text = String.valueOf(value);
        } else if (value instanceof Serializable) {
            try {
                value_text = SerializationUtils.serializeToString((Serializable)value);
            }
            catch (SerializationUtilsErrorException e) {
                throw new UnserializableOutputValueException(this.mElementInfo.getDeclarationName(), name, value, e);
            }
        } else {
            value_text = String.valueOf(value);
        }
        String[] value_array = null;
        value_array = this.hasOutputValue(name) ? ArrayUtils.join(this.getOutputValue(name), value_text) : new String[]{value_text};
        this.setOutputValues(name, value_array);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(name)) {
            this.triggerChild(name, value_array);
        }
    }

    void clearOutput(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutputName(name);
        this.removeOutputValue(name);
    }

    void clearNamedOutputBean(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutbeanName(name);
        BeanDeclaration output_bean = this.mElementInfo.getNamedOutbeanInfo(name);
        if (output_bean == null) {
            output_bean = this.mElementInfo.getNamedGlobalBeanInfo(name);
        }
        Class<?> output_bean_class = null;
        try {
            output_bean_class = Class.forName(output_bean.getClassname());
        }
        catch (ClassNotFoundException e) {
            throw new NamedOutbeanClassnameErrorException(this.mElementInfo.getDeclarationName(), name, output_bean.getClassname());
        }
        this.clearOutputBean(output_bean_class, output_bean.getPrefix());
    }

    void clearOutputBean(Class beanClass, String prefix) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        try {
            Collection<String> output_names = this.mElementInfo.getOutputNames();
            String[] output_names_array = new String[output_names.size()];
            output_names.toArray(output_names_array);
            Collection<String> globalvar_names = this.mElementInfo.getGlobalVarNames();
            String[] globalvar_names_array = new String[globalvar_names.size()];
            globalvar_names.toArray(globalvar_names_array);
            String[] merged_names_array = ArrayUtils.join(output_names_array, globalvar_names_array);
            SortedSet<String> property_names = BeanUtils.getPropertyNames(beanClass, merged_names_array, null, prefix);
            for (String property_name : (Collection)property_names) {
                this.clearOutput(property_name);
            }
        }
        catch (BeanUtilsException e) {
            throw new BeanClassNamesErrorException(beanClass, (Throwable)e);
        }
    }

    private Set<Map.Entry<String, String>> getIncookieEntries() {
        return this.getCookieValues().entrySet();
    }

    private Set<Map.Entry<String, String>> getOutcookieEntries(Map<String, String> cookies) {
        if (this.mElementInfo.hasOutcookieDefaults()) {
            HashSet<Map.Entry<String, String>> entryset = new HashSet<Map.Entry<String, String>>();
            for (Map.Entry outcookie_defaults_entry : (Collection)this.mElementInfo.getOutcookieEntries()) {
                if (cookies.containsKey((String)outcookie_defaults_entry.getKey()) || (String)outcookie_defaults_entry.getValue() == null) continue;
                entryset.add(outcookie_defaults_entry);
            }
            entryset.addAll(cookies.entrySet());
            return entryset;
        }
        return cookies.entrySet();
    }

    boolean hasCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateIncookieName(name);
        return this.mRequestState.hasCookie(name) || this.mElementInfo.hasIncookieDefaultValue(name) || this.mElementInfo.hasGlobalCookieDefaultValue(name);
    }

    Cookie getCookie(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateIncookieName(name);
        Cookie cookie = this.mRequestState.getCookie(name);
        if (cookie == null) {
            if (this.mElementInfo.hasIncookieDefaultValue(name)) {
                cookie = new Cookie(name, this.mElementInfo.getIncookieDefaultValue(name));
            }
            if (this.mElementInfo.hasGlobalCookieDefaultValue(name)) {
                cookie = new Cookie(name, this.mElementInfo.getGlobalCookieDefaultValue(name));
            }
        }
        return cookie;
    }

    String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        String value = null;
        if (cookie != null) {
            value = cookie.getValue();
        }
        return value;
    }

    void setCookie(Cookie cookie) {
        if (!$assertionsDisabled && cookie == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cookie.getName() == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutcookieName(cookie.getName());
        this.mResponse.setCookie(cookie);
        this.mOutcookies.put(cookie.getName(), cookie.getValue());
        this.fireOutcookieSet(cookie);
        if (this.mElementState.inInheritanceStructure() && this.mElementInfo.containsChildTrigger(cookie.getName())) {
            this.mRequestState.setStateCookie(cookie);
            this.triggerChild(cookie.getName(), new String[]{cookie.getValue()});
        }
        if (this.mRequestState.isEmbedded()) {
            this.mRequestState.setStateCookie(cookie);
        }
    }

    HashMap<String, String> getCookieValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : (Collection)this.mElementInfo.getDefaultIncookies().entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : (Collection)this.mElementInfo.getDefaultGlobalCookies().entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : (Collection)this.mRequestState.getCookies().entrySet()) {
            result.put((String)entry.getKey(), ((Cookie)entry.getValue()).getValue());
        }
        return result;
    }

    boolean hasParameterValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateParameter(name);
            return false;
        }
        this.validateParameter(submission, name);
        return this.mElementState.hasParameterValue(name) || this.mElementInfo.hasParameterDefaultValues(submission, name);
    }

    boolean isParameterEmpty(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String parameter = this.getParameter(name);
        return parameter == null || parameter.trim().equals("");
    }

    String getParameter(String name) {
        String[] default_values;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateParameter(name);
            return null;
        }
        this.validateParameter(submission, name);
        String parameter = this.mElementState.getParameter(name);
        if (parameter == null && this.mElementInfo.hasParameterDefaults(submission) && (default_values = this.mElementInfo.getParameterDefaultValues(submission, name)) != null) {
            return default_values[0];
        }
        return parameter;
    }

    ArrayList<String> getParameterNames(String regexp) {
        Pattern pattern = null;
        if (regexp != null) {
            pattern = Pattern.compile(new StringBuffer().append(new StringBuffer().append("^").append(regexp).toString()).append("$").toString());
        }
        ArrayList<String> result = new ArrayList<String>();
        String submission_name = this.getSubmission();
        if (submission_name == null) {
            return result;
        }
        Submission submission = this.mElementInfo.getSubmission(submission_name);
        if (submission == null) {
            return result;
        }
        Collection<String> parameter_names = null;
        parameter_names = submission.getParameterDefaultNames();
        for (String parameter_name : parameter_names) {
            if (pattern != null && !pattern.matcher(parameter_name).matches()) continue;
            result.add(parameter_name);
        }
        parameter_names = submission.getParameterNames();
        for (String parameter_name : parameter_names) {
            if (!this.mElementState.hasParameterValue(parameter_name) || result.contains(parameter_name) || pattern != null && !pattern.matcher(parameter_name).matches()) continue;
            result.add(parameter_name);
        }
        Matcher matcher = null;
        for (Pattern parameter_regexp : submission.getParameterRegexps()) {
            for (String parameter_name : this.mElementState.getParameterNames()) {
                matcher = parameter_regexp.matcher(parameter_name);
                if (!matcher.matches() || !this.mElementState.hasParameterValue(parameter_name) || result.contains(parameter_name) || pattern != null && !pattern.matcher(parameter_name).matches()) continue;
                result.add(parameter_name);
            }
        }
        return result;
    }

    String[] getParameterValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateParameter(name);
            return null;
        }
        this.validateParameter(submission, name);
        String[] parameter_values = this.mElementState.getParameterValues(name);
        if (parameter_values == null && this.mElementInfo.hasParameterDefaults(submission)) {
            return this.mElementInfo.getParameterDefaultValues(submission, name);
        }
        return parameter_values;
    }

    ArrayList<String> getUploadedFileNames() {
        ArrayList<String> result = new ArrayList<String>();
        String submission_name = this.getSubmission();
        if (submission_name == null) {
            return result;
        }
        Submission submission = this.mElementInfo.getSubmission(submission_name);
        if (submission == null) {
            return result;
        }
        Collection<String> file_names = submission.getFileNames();
        for (String file_name : file_names) {
            if (!this.mRequestState.hasUploadedFile(file_name)) continue;
            result.add(file_name);
        }
        return result;
    }

    boolean hasUploadedFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateFile(name);
            return false;
        }
        this.validateFile(submission, name);
        return this.mRequestState.hasUploadedFile(name);
    }

    boolean isFileEmpty(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        UploadedFile file = this.getUploadedFile(name);
        return file == null || file.getFile() == null || (long)0 == file.getFile().length();
    }

    UploadedFile getUploadedFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateFile(name);
            return null;
        }
        this.validateFile(submission, name);
        return this.mRequestState.getUploadedFile(name);
    }

    UploadedFile[] getUploadedFiles(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String submission = this.getSubmission();
        if (submission == null) {
            this.validateFile(name);
            return null;
        }
        this.validateFile(submission, name);
        return this.mRequestState.getUploadedFiles(name);
    }

    private Set<Map.Entry<String, String[]>> getOutputEntries(Map<String, String[]> outputs) {
        if (this.mElementInfo.hasOutputDefaults()) {
            HashSet<Map.Entry<String, String[]>> entryset = new HashSet<Map.Entry<String, String[]>>();
            for (Map.Entry output_defaults_entry : (Collection)this.mElementInfo.getOutputEntries()) {
                if (outputs.containsKey((String)output_defaults_entry.getKey()) || (String[])output_defaults_entry.getValue() == null) continue;
                entryset.add(output_defaults_entry);
            }
            entryset.addAll(outputs.entrySet());
            return entryset;
        }
        return outputs.entrySet();
    }

    private boolean hasOutputValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        boolean result = this.mOutputs.containsKey(name);
        if (!result && this.mElementInfo.hasOutputDefaults() && this.mElementInfo.hasOutputDefaultValues(name)) {
            result = true;
        }
        return result;
    }

    private String[] getOutputValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        String[] outputs = this.mOutputs.get(name);
        if (outputs == null && this.mElementInfo.hasOutputDefaults()) {
            outputs = this.mElementInfo.getOutputDefaultValues(name);
        }
        return outputs;
    }

    void setOutputValues(String name, String[] values) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values == null) {
            throw new AssertionError();
        }
        this.mOutputs.put(name, values);
        this.fireOutputValueSet(name, values);
    }

    void removeOutputValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mOutputs.remove(name);
        this.fireOutputValueRemoved(name);
    }

    void addOutputListener(OutputListener listener) {
        if (this.mOutputListeners == null) {
            this.mOutputListeners = new ArrayList();
        }
        this.mOutputListeners.add(listener);
    }

    void removeOutputListener(OutputListener listener) {
        this.mOutputListeners.remove(listener);
    }

    private void fireOutputValueSet(String name, String[] values) {
        if (this.mOutputListeners == null) {
            return;
        }
        for (OutputListener listener : (Collection)this.mOutputListeners) {
            listener.outputValueSet(name, values);
        }
    }

    private void fireOutputValueRemoved(String name) {
        if (this.mOutputListeners == null) {
            return;
        }
        for (OutputListener listener : (Collection)this.mOutputListeners) {
            listener.outputValueRemoved(name);
        }
    }

    void addOutcookieListener(OutcookieListener listener) {
        if (this.mOutcookieListeners == null) {
            this.mOutcookieListeners = new ArrayList();
        }
        this.mOutcookieListeners.add(listener);
    }

    void removeOutcookieListener(OutcookieListener listener) {
        this.mOutcookieListeners.remove(listener);
    }

    private void fireOutcookieSet(Cookie cookie) {
        if (this.mOutcookieListeners == null) {
            return;
        }
        for (OutcookieListener listener : (Collection)this.mOutcookieListeners) {
            listener.outcookieSet(cookie);
        }
    }

    void child() {
        throw new ChildTriggeredException(null, null);
    }

    void defer() {
        throw new DeferException();
    }

    void forward(String url) {
        throw new ForwardException(url);
    }

    void redirect(String url) {
        throw new RedirectException(url);
    }

    void exit(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateExitName(name);
        throw new ExitTriggeredException(name);
    }

    private Map<String, String[]> getChildInputValues(ElementInfo targetElement) {
        Map<String, String[]> inputs = null;
        inputs = this.mElementState.getInputs();
        if (inputs == null) {
            inputs = this.mElementState.getRequestParameters();
        }
        if (this.mElementInfo.hasGlobalVars() && targetElement.hasGlobalVars()) {
            String[] input_values_array = null;
            for (Map.Entry output_entry : (Collection)this.getOutputEntries(this.mOutputs)) {
                if (!this.mElementInfo.containsGlobalVar((String)output_entry.getKey()) || !targetElement.containsGlobalVar((String)output_entry.getKey())) continue;
                input_values_array = (String[])output_entry.getValue();
                inputs.put((String)output_entry.getKey(), input_values_array);
            }
        }
        return inputs;
    }

    private HashMap<String, String[]> getExitInputValues(Map<String, String[]> outputs, ElementInfo target, boolean snapback) {
        HashMap<String, String[]> inputs = new HashMap<String, String[]>();
        if (this.mElementInfo.hasSnapbackDataLinks() || this.mElementInfo.hasDataLink(target) || this.mElementInfo.hasGlobalVars() && target.hasGlobalVars()) {
            HashMap<String, String[]> dest_input_candidates = new HashMap<String, String[]>();
            if (target == this.mElementInfo) {
                Collection<String> input_names = this.mElementInfo.getInputNames();
                Collection<String> output_names = this.mElementInfo.getOutputNames();
                Iterator<String> input_names_it = input_names.iterator();
                String input_name = null;
                String[] input_values = null;
                while (input_names_it.hasNext()) {
                    input_name = input_names_it.next();
                    if (!output_names.contains(input_name) || (input_values = this.getInputValues(input_name)) == null) continue;
                    dest_input_candidates.put(input_name, input_values);
                }
            }
            GlobalVar globalvar_data = null;
            for (Map.Entry globalvar_entry : (Collection)this.mElementInfo.getGlobalVarEntries()) {
                globalvar_data = (GlobalVar)globalvar_entry.getValue();
                if (globalvar_data == null || globalvar_data.getDefaultValues() == null) continue;
                dest_input_candidates.put((String)globalvar_entry.getKey(), globalvar_data.getDefaultValues());
            }
            String[] output_values_array = null;
            for (Map.Entry output_entry : (Collection)this.getOutputEntries(outputs)) {
                output_values_array = (String[])output_entry.getValue();
                dest_input_candidates.put((String)output_entry.getKey(), output_values_array);
            }
            Collection<String> dest_input_names = null;
            GlobalVar globalvar_source = null;
            GlobalVar globalvar_target = null;
            for (String candidate : (Collection)dest_input_candidates.keySet()) {
                if (this.mElementInfo.containsDepartureVar(candidate)) continue;
                if (this.mElementInfo.containsGlobalVar(candidate) && target.containsGlobalVar(candidate)) {
                    globalvar_source = this.mElementInfo.getGlobalVarInfo(candidate);
                    globalvar_target = target.getGlobalVarInfo(candidate);
                    if (globalvar_source.getGroupId() == globalvar_target.getGroupId()) {
                        inputs.put(candidate, (String[])dest_input_candidates.get(candidate));
                    }
                }
                if ((dest_input_names = this.mElementInfo.getDataLinkInputs(candidate, target, snapback)) == null) continue;
                for (String dest_input_name : dest_input_names) {
                    inputs.put(dest_input_name, (String[])dest_input_candidates.get(candidate));
                }
            }
        }
        return inputs;
    }

    private HashMap<String, String[]> overrideOutputValues(String[] outputValues) {
        if (outputValues == null || 0 == outputValues.length) {
            return this.mOutputs;
        }
        HashMap<String, String[]> outputs = new HashMap<String, String[]>(this.mOutputs);
        int i = 0;
        while (i < outputValues.length) {
            outputs.put(outputValues[i], new String[]{outputValues[i + 1]});
            i += 2;
        }
        return outputs;
    }

    private HashMap<String, String[]> getExitInputValues(ElementInfo target, boolean snapback, String[] outputValues) {
        HashMap<String, String[]> overridden_outputs = this.overrideOutputValues(outputValues);
        HashMap<String, String[]> inputs = this.getExitInputValues(overridden_outputs, target, snapback);
        return inputs;
    }

    private HashMap<String, String[]> _getExitParameters(FlowLink flowlink, ElementInfo contextTarget, String[] outputValues) {
        HashMap<String, String[]> parameters = null;
        HashMap<String, String[]> inputs = this.getExitInputValues(flowlink.getTarget(), flowlink.isSnapback(), outputValues);
        if (this.mElementState.inInheritanceStructure() && !flowlink.cancelInheritance()) {
            parameters = new LinkedHashMap<String, String[]>();
            parameters.put("childrequest", new String[]{this.getEncodedChildRequest()});
            ArrayList<TriggerContext> new_trigger_context = this.mElementState.cloneTriggerList();
            new_trigger_context.add(TriggerContext.generateExitTrigger(this.mElementInfo, flowlink.getExitName(), inputs));
            parameters.put("triggerlist", new String[]{TriggerListEncoder.encode(new_trigger_context)});
        } else {
            parameters = inputs;
        }
        if (this.mElementInfo == flowlink.getTarget()) {
            String continuation_id = ContinuationContext.getActiveContextId();
            if (continuation_id != null) {
                parameters.put("contid", new String[]{continuation_id});
            }
        } else if (this.mActiveCallState != null) {
            parameters.put("contid", new String[]{this.mActiveCallState.getContinuationId()});
        }
        return parameters;
    }

    String getExitFormUrl(String name, String pathinfo) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateExitName(name);
        FlowLink flowlink = null;
        flowlink = this.mElementInfo.getFlowLink(name);
        if (flowlink == null) {
            throw new ExitNotAttachedException(this.mElement.getElementInfo().getDeclarationName(), name);
        }
        return this._getExitFormUrl(flowlink, pathinfo);
    }

    private String _getExitFormUrl(FlowLink flowlink, String pathinfo) {
        StringBuffer url;
        if (!$assertionsDisabled && flowlink == null) {
            throw new AssertionError();
        }
        ElementInfo flowlink_target = flowlink.getExitTarget(this.mRequestState);
        ElementInfo context_target = null;
        context_target = this.mElementState.inInheritanceStructure() && !flowlink.cancelInheritance() ? this.mRequestState.getTarget() : flowlink_target;
        StringBuffer stringBuffer = url = new StringBuffer(this.mRequestState.getGateUrl());
        synchronized (stringBuffer) {
            String target_url = context_target.getUrl();
            if (target_url == null) {
                throw new ExitTargetUrlMissingException(this.mElementInfo.getDeclarationName(), flowlink.getExitName(), context_target.getDeclarationName());
            }
            this.appendTargetAndPathinfo(url, target_url, pathinfo);
            StateStore state_store = flowlink_target.getStateStore();
            Request request = this.getRequestState().getRequest();
            return state_store.exportFormUrl(url.toString(), request, this.mResponse);
        }
    }

    private void appendTargetAndPathinfo(StringBuffer url, String targetUrl, String pathinfo) {
        url.append(targetUrl);
        if (pathinfo != null && pathinfo.length() > 0) {
            if (url.charAt(url.length() - 1) != '/') {
                url.append("/");
            }
            url.append(StringUtils.stripFromFront(pathinfo, "/"));
        }
    }

    String getExitFormParameters(String name, String[] outputValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputValues != null && outputValues.length % 2 != 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateExitName(name);
        FlowLink flowlink = null;
        flowlink = this.mElementInfo.getFlowLink(name);
        if (flowlink == null) {
            throw new ExitNotAttachedException(this.mElement.getElementInfo().getDeclarationName(), name);
        }
        return this._getExitFormParameters(flowlink, outputValues);
    }

    private String _getExitFormParameters(FlowLink flowlink, String[] outputValues) {
        if (!$assertionsDisabled && flowlink == null) {
            throw new AssertionError();
        }
        ElementInfo flowlink_target = flowlink.getExitTarget(this.mRequestState);
        HashMap<String, String[]> parameters = this._getExitParameters(flowlink, flowlink_target, outputValues);
        return flowlink_target.getStateStore().exportFormParameters(parameters, this.getRequestState().getRequest(), this.getResponse());
    }

    String getExitQueryUrl(String name, String pathinfo, String[] outputValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputValues != null && outputValues.length % 2 != 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateExitName(name);
        FlowLink flowlink = null;
        flowlink = this.mElementInfo.getFlowLink(name);
        if (flowlink == null) {
            throw new ExitNotAttachedException(this.mElement.getElementInfo().getDeclarationName(), name);
        }
        return this._getExitQueryUrl(flowlink, pathinfo, outputValues);
    }

    private String _getExitQueryUrl(FlowLink flowlink, String pathinfo, String[] outputValues) {
        StringBuffer url;
        if (!$assertionsDisabled && flowlink == null) {
            throw new AssertionError();
        }
        ElementInfo flowlink_target = flowlink.getExitTarget(this.mRequestState);
        ElementInfo context_target = null;
        context_target = this.mElementState.inInheritanceStructure() && !flowlink.cancelInheritance() ? this.mRequestState.getTarget() : flowlink_target;
        StringBuffer stringBuffer = url = new StringBuffer(this.mRequestState.getGateUrl());
        synchronized (stringBuffer) {
            String target_url = context_target.getUrl();
            if (target_url == null) {
                throw new ExitTargetUrlMissingException(this.mElementInfo.getDeclarationName(), flowlink.getExitName(), context_target.getDeclarationName());
            }
            this.appendTargetAndPathinfo(url, target_url, pathinfo);
            StateStore state_store = flowlink_target.getStateStore();
            Request request = this.getRequestState().getRequest();
            HashMap<String, String[]> parameters = this._getExitParameters(flowlink, flowlink_target, outputValues);
            return state_store.exportQueryUrl(url.toString(), parameters, request, this.mResponse, this.mElementInfo, "exit", flowlink.getExitName());
        }
    }

    void setExitQuery(Template template2, String name, String pathinfo, String[] outputValues) {
        template2.setValue(new StringBuffer().append(PREFIX_EXIT_QUERY).append(name).toString(), StringUtils.encodeHtml(this.getExitQueryUrl(name, pathinfo, outputValues)));
    }

    void setExitForm(Template template2, String name, String pathinfo, String[] outputValues) {
        template2.setValue(new StringBuffer().append(PREFIX_EXIT_FORM).append(name).toString(), StringUtils.encodeHtml(this.getExitFormUrl(name, pathinfo)));
        template2.setValue(new StringBuffer().append(PREFIX_EXIT_PARAMS).append(name).toString(), this.getExitFormParameters(name, outputValues));
    }

    Collection<String> selectParameter(Template template2, String name, String[] values) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        BeanHandler bean_handler = template2.getBeanHandler();
        if (bean_handler == null) {
            return new ArrayList<String>();
        }
        FormBuilder form_builder = bean_handler.getFormBuilder();
        if (form_builder == null) {
            return new ArrayList<String>();
        }
        return form_builder.selectParameter(template2, name, values);
    }

    void generateForm(Template template2, Object beanInstance, String prefix) {
        BeanHandler bean_handler = template2.getBeanHandler();
        if (bean_handler == null) {
            return;
        }
        FormBuilder form_builder = bean_handler.getFormBuilder();
        if (form_builder == null) {
            return;
        }
        try {
            form_builder.removeForm(template2, beanInstance.getClass(), prefix);
            form_builder.generateForm(template2, beanInstance, null, prefix);
        }
        catch (BeanUtilsException e) {
            throw new EngineException(e);
        }
    }

    void generateEmptyForm(Template template2, Class beanClass, String prefix) {
        BeanHandler bean_handler = template2.getBeanHandler();
        if (bean_handler == null) {
            return;
        }
        FormBuilder form_builder = bean_handler.getFormBuilder();
        if (form_builder == null) {
            return;
        }
        try {
            form_builder.removeForm(template2, beanClass, prefix);
            form_builder.generateForm(template2, beanClass, null, prefix);
        }
        catch (BeanUtilsException e) {
            throw new EngineException(e);
        }
    }

    void removeForm(Template template2, Class beanClass, String prefix) {
        BeanHandler bean_handler = template2.getBeanHandler();
        if (bean_handler == null) {
            return;
        }
        FormBuilder form_builder = bean_handler.getFormBuilder();
        if (form_builder == null) {
            return;
        }
        try {
            form_builder.removeForm(template2, beanClass, prefix);
        }
        catch (BeanUtilsException e) {
            throw new EngineException(e);
        }
    }

    private String getContextId() {
        if (this.mContextId != null) {
            return this.mContextId;
        }
        this.mContextId = this.buildContextId(new StringBuffer()).toString();
        return this.mContextId;
    }

    private StringBuffer buildContextId(StringBuffer buffer) {
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            String differentiator;
            boolean is_embedded_submission;
            boolean bl = is_embedded_submission = this.mRequestState.isEmbedded() && this.mRequestState.getTarget().getUrl() == null;
            if (is_embedded_submission) {
                buffer = this.mRequestState.getEmbeddingContext().getElementContext().buildContextId(buffer);
                buffer.append("::");
                buffer.append(this.mRequestState.getEmbeddingContext().getTemplate().getName());
                buffer.append(":");
            }
            if (this.mRequestState.isPreceeding()) {
                buffer.append(this.mRequestState.getPrecedenceTarget().getId());
            } else {
                buffer.append(this.mRequestState.getTarget().getId());
            }
            if (is_embedded_submission && (differentiator = this.mRequestState.getEmbeddingContext().getDifferentiator()) != null) {
                buffer.append(differentiator);
            }
        }
        return buffer;
    }

    private HashMap<String, String[]> getSubmissionParameters(String name, String[] parameterValues) {
        String continuation_id;
        Submission submission;
        LinkedHashMap<String, String[]> parameters = new LinkedHashMap<String, String[]>();
        parameters.put("submission", new String[]{name});
        if (parameterValues != null) {
            String parameter_name = null;
            String parameter_value = null;
            int i = 0;
            while (i < parameterValues.length) {
                parameter_name = parameterValues[i];
                parameter_value = parameterValues[i + 1];
                this.validateParameter(name, parameter_name);
                parameters.put(parameter_name, new String[]{parameter_value});
                i += 2;
            }
        }
        if ((submission = this.mElementInfo.getSubmission(name)) == null || Scope.LOCAL == submission.getScope()) {
            String target;
            String submission_context = this.getContextId();
            if (!submission_context.equals(target = this.getElementInfo().getId())) {
                StringBuffer submission_context_buffer = new StringBuffer(submission_context);
                Iterator<String> iterator = submission_context_buffer;
                synchronized (iterator) {
                    submission_context_buffer.append("^");
                    submission_context_buffer.append(target);
                    submission_context = submission_context_buffer.toString();
                }
            }
            try {
                parameters.put("submissioncontext", new String[]{Base64.encodeToString(submission_context.getBytes("UTF-8"), false)});
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if ((continuation_id = ContinuationContext.getActiveContextId()) != null) {
            parameters.put("contid", new String[]{continuation_id});
        } else if (this.mActiveCallState != null) {
            parameters.put("contid", new String[]{this.mActiveCallState.getContinuationId()});
        }
        if (this.mElementState.inInheritanceStructure()) {
            parameters.put("childrequest", new String[]{this.getEncodedChildRequest()});
            parameters.put("triggerlist", new String[]{this.mElementState.encodeTriggerList()});
        }
        LinkedHashMap<String, String[]> inputs = new LinkedHashMap<String, String[]>();
        ElementContext context = this;
        while (context != null && context.mRequestState.isEmbedded()) {
            context = context.mRequestState.getEmbeddingContext().getElementContext();
            for (String string : context.mElementInfo.getInputNames()) {
                if (!context.mElementState.hasInputValue(string)) continue;
                inputs.put(string, context.mElementState.getInputValues(string));
            }
            for (String globalvar_name : context.mElementInfo.getGlobalVarNames()) {
                if (!context.mElementState.hasInputValue(globalvar_name)) continue;
                inputs.put(globalvar_name, context.mElementState.getInputValues(globalvar_name));
            }
        }
        for (String string : this.mElementInfo.getGlobalVarNames()) {
            if (!this.mElementState.hasInputValue(string)) continue;
            inputs.put(string, this.mElementState.getInputValues(string));
        }
        for (String input_name : this.mElementInfo.getInputNames()) {
            if (!this.mElementState.hasInputValue(input_name)) continue;
            inputs.put(input_name, this.mElementState.getInputValues(input_name));
        }
        if (inputs.size() > 0) {
            parameters.put("inputs", new String[]{ParameterMapEncoder.encodeToBase64String(inputs)});
        }
        return parameters;
    }

    private String getSubmissionUrl() {
        String url = null;
        url = this.mElementState.inInheritanceStructure() ? this.mRequestState.getTarget().getUrl() : this.mElementInfo.getUrl();
        if (url == null) {
            if (!this.mRequestState.isEmbedded()) {
                if (this.mElementState.inInheritanceStructure()) {
                    throw new SubmissionInheritanceUrlMissingException(this.mRequestState.getTarget().getDeclarationName(), this.mElementInfo.getDeclarationName());
                }
                throw new SubmissionUrlMissingException(this.mElementInfo.getDeclarationName());
            }
            ElementContext context = this;
            while (url == null && context != null && context.mRequestState.isEmbedded()) {
                context = context.mRequestState.getEmbeddingContext().getElementContext();
                url = context.mElementState.inInheritanceStructure() ? context.mRequestState.getTarget().getUrl() : context.mElementInfo.getUrl();
            }
        }
        return url;
    }

    private String _getSubmissionQueryUrl(String name, String pathinfo, String[] parameterValues) {
        StringBuffer query_url;
        StringBuffer stringBuffer = query_url = new StringBuffer(this.mRequestState.getGateUrl());
        synchronized (stringBuffer) {
            this.appendTargetAndPathinfo(query_url, this.getSubmissionUrl(), pathinfo);
            StateStore state_store = this.mElementInfo.getStateStore();
            Request request = this.getRequestState().getRequest();
            HashMap<String, String[]> parameters = this.getSubmissionParameters(name, parameterValues);
            return state_store.exportQueryUrl(query_url.toString(), parameters, request, this.mResponse, this.mElementInfo, "submission", name);
        }
    }

    String getSubmissionQueryUrl(String name, String pathinfo, String[] parameterValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameterValues != null && parameterValues.length % 2 != 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(name);
        return this._getSubmissionQueryUrl(name, pathinfo, parameterValues);
    }

    String getSubmissionFormUrl(String pathinfo) {
        StringBuffer form_url;
        StringBuffer stringBuffer = form_url = new StringBuffer(this.mRequestState.getGateUrl());
        synchronized (stringBuffer) {
            this.appendTargetAndPathinfo(form_url, this.getSubmissionUrl(), pathinfo);
            StateStore state_store = this.mElementInfo.getStateStore();
            Request request = this.getRequestState().getRequest();
            return state_store.exportFormUrl(form_url.toString(), request, this.mResponse);
        }
    }

    String getSubmissionFormParameters(String name, String[] parameterValues) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameterValues != null && parameterValues.length % 2 != 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(name);
        return this._getSubmissionFormParameters(name, parameterValues);
    }

    private String _getSubmissionFormParameters(String name, String[] parameterValues) {
        HashMap<String, String[]> parameters = this.getSubmissionParameters(name, parameterValues);
        return this.mElementInfo.getStateStore().exportFormParameters(parameters, this.getRequestState().getRequest(), this.getResponse());
    }

    void setSubmissionQuery(Template template2, String name, String pathinfo, String[] parameterValues) {
        template2.setValue(new StringBuffer().append(PREFIX_SUBMISSION_QUERY).append(name).toString(), StringUtils.encodeHtml(this.getSubmissionQueryUrl(name, pathinfo, parameterValues)));
    }

    void setSubmissionForm(Template template2, String name, String pathinfo, String[] parameterValues) {
        template2.setValue(new StringBuffer().append(PREFIX_SUBMISSION_FORM).append(name).toString(), StringUtils.encodeHtml(this.getSubmissionFormUrl(pathinfo)));
        template2.setValue(new StringBuffer().append(PREFIX_SUBMISSION_PARAMS).append(name).toString(), this.getSubmissionFormParameters(name, parameterValues));
    }

    Collection<String> selectSubmissionParameter(Template template2, String name, String[] values) {
        return this.selectParameter(template2, new StringBuffer().append(PREFIX_PARAM).append(name).toString(), values);
    }

    void setSubmissionBean(Template template2, Object beanInstance) {
        this.setSubmissionBean(template2, beanInstance, true);
    }

    void setSubmissionBean(Template template2, Object beanInstance, boolean encode) {
        template2.setBean(beanInstance, PREFIX_PARAM, encode);
    }

    void removeSubmissionBean(Template template2, Object beanInstance) {
        template2.removeBean(beanInstance, PREFIX_PARAM);
    }

    private <BeanType> BeanType _getSubmissionBean(Submission submission, Class<BeanType> beanClass, String prefix) {
        if (!$assertionsDisabled && submission == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beanClass == null) {
            throw new AssertionError();
        }
        HashMap<String, PropertyDescriptor> bean_properties = this.getBeanUppercasedProperties(beanClass);
        BeanType bean_instance = this.getBeanInstance(beanClass);
        String[] parameter_values = null;
        for (String parameter_name : submission.getParameterNames()) {
            if (!this.mElementState.hasParameterValue(parameter_name) || (parameter_values = this.mElementState.getParameterValues(parameter_name)) == null || parameter_values.length <= 0) continue;
            this.setUppercasedBeanProperty(parameter_name, parameter_values, prefix, beanClass, bean_properties, bean_instance, null);
        }
        for (String uploadedfile_name : (Collection)this.getUploadedFileNames()) {
            UploadedFile file = this.getUploadedFile(uploadedfile_name);
            this.setUppercasedBeanProperty(uploadedfile_name, file, prefix, beanClass, bean_properties, bean_instance);
        }
        return bean_instance;
    }

    <BeanType> BeanType getNamedSubmissionBean(String submissionName, String beanName) {
        if (!$assertionsDisabled && submissionName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && submissionName.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beanName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beanName.length() <= 0) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(submissionName);
        if (!this.hasSubmission(submissionName)) {
            return null;
        }
        BeanDeclaration bean = this.mElementInfo.getSubmission(submissionName).getNamedBean(beanName);
        Class<?> bean_class = null;
        try {
            bean_class = Class.forName(bean.getClassname());
        }
        catch (ClassNotFoundException e) {
            throw new NamedSubmissionBeanClassnameErrorException(this.mElementInfo.getDeclarationName(), submissionName, beanName, bean.getClassname(), e);
        }
        return (BeanType)this._getSubmissionBean(this.mElementInfo.getSubmission(submissionName), bean_class, bean.getPrefix());
    }

    <BeanType> BeanType getSubmissionBean(String submissionName, Class<BeanType> beanClass, String prefix) {
        if (!$assertionsDisabled && submissionName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && submissionName.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beanClass == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateSubmissionName(submissionName);
        if (!this.hasSubmission(submissionName)) {
            return null;
        }
        return this._getSubmissionBean(this.mElementInfo.getSubmission(submissionName), beanClass, prefix);
    }

    private void _fillSubmissionBean(Submission submission, Object bean, String prefix) {
        if (!$assertionsDisabled && submission == null) {
            throw new AssertionError();
        }
        if (bean == null) {
            return;
        }
        HashMap<String, PropertyDescriptor> bean_properties = this.getBeanUppercasedProperties(bean.getClass());
        String[] parameter_values = null;
        Object empty_bean = null;
        for (String parameter_name : submission.getParameterNames()) {
            if (!this.mElementState.hasParameterValue(parameter_name) || (parameter_values = this.mElementState.getParameterValues(parameter_name)) == null || parameter_values.length <= 0) continue;
            if (0 == parameter_values[0].length() && empty_bean == null) {
                try {
                    empty_bean = bean.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append("Unexpected error while invoking the default constructor of the bean with class '").append(bean.getClass().getName()).toString()).append("'.").toString(), e);
                }
                catch (IllegalAccessException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append("No permission to invoke the default constructor of the bean with class '").append(bean.getClass().getName()).toString()).append("'.").toString(), e);
                }
            }
            this.setUppercasedBeanProperty(parameter_name, parameter_values, prefix, bean.getClass(), bean_properties, bean, empty_bean);
        }
        for (String uploadedfile_name : (Collection)this.getUploadedFileNames()) {
            UploadedFile file = this.getUploadedFile(uploadedfile_name);
            this.setUppercasedBeanProperty(uploadedfile_name, file, prefix, bean.getClass(), bean_properties, bean);
        }
    }

    void fillSubmissionBean(String submissionName, Object bean, String prefix) {
        if (!$assertionsDisabled && submissionName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && submissionName.length() <= 0) {
            throw new AssertionError();
        }
        if (bean == null) {
            return;
        }
        this.mElementInfo.validateSubmissionName(submissionName);
        if (!this.hasSubmission(submissionName)) {
            return;
        }
        this._fillSubmissionBean(this.mElementInfo.getSubmission(submissionName), bean, prefix);
    }

    <BeanType> BeanType getNamedInputBean(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateInbeanName(name);
        BeanDeclaration input_bean = this.mElementInfo.getNamedInbeanInfo(name);
        if (input_bean == null) {
            input_bean = this.mElementInfo.getNamedGlobalBeanInfo(name);
        }
        Class<?> input_bean_class = null;
        try {
            input_bean_class = Class.forName(input_bean.getClassname());
        }
        catch (ClassNotFoundException e) {
            throw new NamedInbeanClassnameErrorException(this.mElementInfo.getDeclarationName(), name, input_bean.getClassname());
        }
        return (BeanType)this.getInputBean(input_bean_class, input_bean.getPrefix());
    }

    <BeanType> BeanType getInputBean(Class<BeanType> beanClass, String prefix) {
        if (!$assertionsDisabled && beanClass == null) {
            throw new AssertionError();
        }
        HashMap<String, PropertyDescriptor> bean_properties = this.getBeanUppercasedProperties(beanClass);
        BeanType bean_instance = this.getBeanInstance(beanClass);
        Collection<String> input_names = this.mElementInfo.getInputNames();
        Collection<String> globalvar_names = this.mElementInfo.getGlobalVarNames();
        ArrayList<String> merged_names = new ArrayList<String>();
        merged_names.addAll(input_names);
        merged_names.addAll(globalvar_names);
        String[] values = null;
        for (String name : (Collection)merged_names) {
            if (!this.mElementState.hasInputValue(name) || (values = this.mElementState.getInputValues(name)) == null || values.length <= 0) continue;
            this.setUppercasedBeanProperty(name, values, prefix, beanClass, bean_properties, bean_instance, null);
        }
        return bean_instance;
    }

    void setNamedOutputBean(String name, Object bean) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.mElementInfo.validateOutbeanName(name);
        BeanDeclaration output_bean = this.mElementInfo.getNamedOutbeanInfo(name);
        if (output_bean == null) {
            output_bean = this.mElementInfo.getNamedGlobalBeanInfo(name);
        }
        this.setOutputBean(bean, output_bean.getPrefix());
    }

    void setOutputBean(Object bean, String prefix) {
        if (bean == null) {
            throw new IllegalArgumentException("bean can't be null.");
        }
        try {
            Collection<String> output_names = this.mElementInfo.getOutputNames();
            String[] output_names_array = new String[output_names.size()];
            output_names.toArray(output_names_array);
            Collection<String> globalvar_names = this.mElementInfo.getGlobalVarNames();
            String[] globalvar_names_array = new String[globalvar_names.size()];
            globalvar_names.toArray(globalvar_names_array);
            String[] merged_names_array = ArrayUtils.join(output_names_array, globalvar_names_array);
            SortedMap<String, Object> property_values = BeanUtils.getPropertyValues(bean, merged_names_array, null, prefix);
            Object property_value = null;
            for (String property_name : (Collection)property_values.keySet()) {
                property_value = property_values.get(property_name);
                if (property_value == null) continue;
                this.setOutput(property_name, (Object)property_value);
            }
        }
        catch (BeanUtilsException e) {
            throw new BeanInstanceValuesErrorException(bean, (Throwable)e);
        }
    }

    private HashMap<String, PropertyDescriptor> getBeanUppercasedProperties(Class beanClass) {
        HashMap<String, PropertyDescriptor> bean_properties = new HashMap<String, PropertyDescriptor>();
        BeanInfo bean_info = null;
        PropertyDescriptor[] bean_properties_array = null;
        try {
            bean_info = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new EngineException(new StringBuffer().append(new StringBuffer().append("Couldn't introspect the bean with class '").append(beanClass.getName()).toString()).append("'.").toString(), e);
        }
        bean_properties_array = bean_info.getPropertyDescriptors();
        String bean_property_name = null;
        PropertyDescriptor[] propertyDescriptorArray = bean_properties_array;
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            PropertyDescriptor bean_property = propertyDescriptorArray[n];
            bean_property_name = bean_property.getName().toUpperCase();
            if (bean_properties.containsKey(bean_property_name)) {
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Duplicate case insensitive bean property '").append(bean_property_name).toString()).append("' in bean '").toString()).append(beanClass.getName()).toString()).append("'.").toString());
            }
            bean_properties.put(bean_property_name, bean_property);
            ++n;
        }
        return bean_properties;
    }

    private <BeanType> BeanType getBeanInstance(Class<BeanType> beanClass) {
        BeanType bean_instance;
        try {
            bean_instance = beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineException(new StringBuffer().append(new StringBuffer().append("Can't instantiate a bean with class '").append(beanClass.getName()).toString()).append("'.").toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new EngineException(new StringBuffer().append(new StringBuffer().append("No permission to instantiate a bean with class '").append(beanClass.getName()).toString()).append("'.").toString(), e);
        }
        return bean_instance;
    }

    /*
     * Unable to fully structure code
     */
    private void setUppercasedBeanProperty(String name, String[] values, String prefix, Class beanClass, HashMap<String, PropertyDescriptor> beanProperties, Object beanInstance, Object emptyBean) {
        block126: {
            name_upper = null;
            property = null;
            write_method = null;
            property_type = null;
            if (prefix != null) {
                if (!name.startsWith(prefix)) {
                    return;
                }
                name = name.substring(prefix.length());
            }
            if (!beanProperties.containsKey(name_upper = name.toUpperCase())) break block126;
            if (values == null || 0 == values.length) {
                return;
            }
            property = beanProperties.get(name_upper);
            write_method = property.getWriteMethod();
            if (write_method == null) {
                return;
            }
            property_type = property.getPropertyType();
            if (property_type == null) {
                return;
            }
            validated = null;
            if (beanInstance instanceof Validated) {
                validated = (Validated)beanInstance;
            }
            try {
                block128: {
                    block142: {
                        block141: {
                            block140: {
                                block139: {
                                    block138: {
                                        block137: {
                                            block136: {
                                                block135: {
                                                    block134: {
                                                        block133: {
                                                            block132: {
                                                                block131: {
                                                                    block130: {
                                                                        block129: {
                                                                            block127: {
                                                                                if (property_type.isArray()) {
                                                                                    component_type = property_type.getComponentType();
                                                                                    try {
                                                                                        v0 = Class.forName("java.lang.String");
                                                                                    }
                                                                                    catch (ClassNotFoundException var14_20) {
                                                                                        throw new NoClassDefFoundError(var14_20.getMessage());
                                                                                    }
                                                                                    if (component_type == v0) {
                                                                                        write_method.invoke(beanInstance, new Object[]{values});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Integer.TYPE) {
                                                                                        parameter_values_typed = new int[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Integer.parseInt(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v1 = Class.forName("java.lang.Integer");
                                                                                    }
                                                                                    catch (ClassNotFoundException var16_24) {
                                                                                        throw new NoClassDefFoundError(var16_24.getMessage());
                                                                                    }
                                                                                    if (component_type == v1) {
                                                                                        parameter_values_typed = new Integer[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Integer(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Character.TYPE) {
                                                                                        parameter_values_typed = new char[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = values[i].charAt(0);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v2 = Class.forName("java.lang.Character");
                                                                                    }
                                                                                    catch (ClassNotFoundException var18_30) {
                                                                                        throw new NoClassDefFoundError(var18_30.getMessage());
                                                                                    }
                                                                                    if (component_type == v2) {
                                                                                        parameter_values_typed = new Character[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Character(values[i].charAt(0));
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Boolean.TYPE) {
                                                                                        parameter_values_typed = new boolean[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = StringUtils.convertToBoolean(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v3 = Class.forName("java.lang.Boolean");
                                                                                    }
                                                                                    catch (ClassNotFoundException var20_36) {
                                                                                        throw new NoClassDefFoundError(var20_36.getMessage());
                                                                                    }
                                                                                    if (component_type == v3) {
                                                                                        parameter_values_typed = new Boolean[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Boolean(StringUtils.convertToBoolean(values[i]));
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Byte.TYPE) {
                                                                                        parameter_values_typed = new byte[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Byte.parseByte(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v4 = Class.forName("java.lang.Byte");
                                                                                    }
                                                                                    catch (ClassNotFoundException var22_42) {
                                                                                        throw new NoClassDefFoundError(var22_42.getMessage());
                                                                                    }
                                                                                    if (component_type == v4) {
                                                                                        parameter_values_typed = new Byte[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Byte(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Double.TYPE) {
                                                                                        parameter_values_typed = new double[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Double.parseDouble(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v5 = Class.forName("java.lang.Double");
                                                                                    }
                                                                                    catch (ClassNotFoundException var24_48) {
                                                                                        throw new NoClassDefFoundError(var24_48.getMessage());
                                                                                    }
                                                                                    if (component_type == v5) {
                                                                                        parameter_values_typed = new Double[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Double(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Float.TYPE) {
                                                                                        parameter_values_typed = new float[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Float.parseFloat(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v6 = Class.forName("java.lang.Float");
                                                                                    }
                                                                                    catch (ClassNotFoundException var26_54) {
                                                                                        throw new NoClassDefFoundError(var26_54.getMessage());
                                                                                    }
                                                                                    if (component_type == v6) {
                                                                                        parameter_values_typed = new Float[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Float(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Long.TYPE) {
                                                                                        parameter_values_typed = new long[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Long.parseLong(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v7 = Class.forName("java.lang.Long");
                                                                                    }
                                                                                    catch (ClassNotFoundException var28_60) {
                                                                                        throw new NoClassDefFoundError(var28_60.getMessage());
                                                                                    }
                                                                                    if (component_type == v7) {
                                                                                        parameter_values_typed = new Long[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Long(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    if (component_type == Short.TYPE) {
                                                                                        parameter_values_typed = new short[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = Short.parseShort(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v8 = Class.forName("java.lang.Short");
                                                                                    }
                                                                                    catch (ClassNotFoundException var30_66) {
                                                                                        throw new NoClassDefFoundError(var30_66.getMessage());
                                                                                    }
                                                                                    if (component_type == v8) {
                                                                                        parameter_values_typed = new Short[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new Short(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                        break block126;
                                                                                    }
                                                                                    try {
                                                                                        v9 = Class.forName("java.lang.StringBuffer");
                                                                                    }
                                                                                    catch (ClassNotFoundException var31_70) {
                                                                                        throw new NoClassDefFoundError(var31_70.getMessage());
                                                                                    }
                                                                                    if (component_type == v9) {
                                                                                        parameter_values_typed = new StringBuffer[values.length];
                                                                                        i = 0;
                                                                                        while (i < values.length) {
                                                                                            if (values[i] != null && values[i].length() > 0) {
                                                                                                parameter_values_typed[i] = new StringBuffer(values[i]);
                                                                                            }
                                                                                            ++i;
                                                                                        }
                                                                                        write_method.invoke(beanInstance, new Object[]{parameter_values_typed});
                                                                                    }
                                                                                    break block126;
                                                                                }
                                                                                if (emptyBean != null && values[0] != null && 0 == values[0].length()) {
                                                                                    read_method = property.getReadMethod();
                                                                                    empty_value = read_method.invoke(emptyBean, (Object[])null);
                                                                                    write_method.invoke(beanInstance, new Object[]{empty_value});
                                                                                    break block126;
                                                                                }
                                                                                parameter_value_typed = null;
                                                                                try {
                                                                                    v10 = Class.forName("java.lang.String");
                                                                                }
                                                                                catch (ClassNotFoundException var14_22) {
                                                                                    throw new NoClassDefFoundError(var14_22.getMessage());
                                                                                }
                                                                                if (property_type != v10) break block127;
                                                                                if (values[0] != null && values[0].length() > 0) {
                                                                                    parameter_value_typed = values[0];
                                                                                }
                                                                                break block128;
                                                                            }
                                                                            if (property_type == Integer.TYPE) break block129;
                                                                            try {
                                                                                v11 = Class.forName("java.lang.Integer");
                                                                            }
                                                                            catch (ClassNotFoundException var16_25) {
                                                                                throw new NoClassDefFoundError(var16_25.getMessage());
                                                                            }
                                                                            if (property_type != v11) break block130;
                                                                        }
                                                                        if (values[0] != null && values[0].length() > 0) {
                                                                            parameter_value_typed = new Integer(values[0]);
                                                                        }
                                                                        break block128;
                                                                    }
                                                                    if (property_type == Character.TYPE) break block131;
                                                                    try {
                                                                        v12 = Class.forName("java.lang.Character");
                                                                    }
                                                                    catch (ClassNotFoundException var18_31) {
                                                                        throw new NoClassDefFoundError(var18_31.getMessage());
                                                                    }
                                                                    if (property_type != v12) break block132;
                                                                }
                                                                if (values[0] != null && values[0].length() > 0) {
                                                                    parameter_value_typed = new Character(values[0].charAt(0));
                                                                }
                                                                break block128;
                                                            }
                                                            if (property_type == Boolean.TYPE) break block133;
                                                            try {
                                                                v13 = Class.forName("java.lang.Boolean");
                                                            }
                                                            catch (ClassNotFoundException var20_37) {
                                                                throw new NoClassDefFoundError(var20_37.getMessage());
                                                            }
                                                            if (property_type != v13) break block134;
                                                        }
                                                        if (values[0] != null && values[0].length() > 0) {
                                                            parameter_value_typed = new Boolean(StringUtils.convertToBoolean(values[0]));
                                                        }
                                                        break block128;
                                                    }
                                                    if (property_type == Byte.TYPE) break block135;
                                                    try {
                                                        v14 = Class.forName("java.lang.Byte");
                                                    }
                                                    catch (ClassNotFoundException var22_43) {
                                                        throw new NoClassDefFoundError(var22_43.getMessage());
                                                    }
                                                    if (property_type != v14) break block136;
                                                }
                                                if (values[0] != null && values[0].length() > 0) {
                                                    parameter_value_typed = new Byte(values[0]);
                                                }
                                                break block128;
                                            }
                                            if (property_type == Double.TYPE) break block137;
                                            try {
                                                v15 = Class.forName("java.lang.Double");
                                            }
                                            catch (ClassNotFoundException var24_49) {
                                                throw new NoClassDefFoundError(var24_49.getMessage());
                                            }
                                            if (property_type != v15) break block138;
                                        }
                                        if (values[0] != null && values[0].length() > 0) {
                                            parameter_value_typed = new Double(values[0]);
                                        }
                                        break block128;
                                    }
                                    if (property_type == Float.TYPE) break block139;
                                    try {
                                        v16 = Class.forName("java.lang.Float");
                                    }
                                    catch (ClassNotFoundException var26_55) {
                                        throw new NoClassDefFoundError(var26_55.getMessage());
                                    }
                                    if (property_type != v16) break block140;
                                }
                                if (values[0] != null && values[0].length() > 0) {
                                    parameter_value_typed = new Float(values[0]);
                                }
                                break block128;
                            }
                            if (property_type == Long.TYPE) break block141;
                            try {
                                v17 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException var28_61) {
                                throw new NoClassDefFoundError(var28_61.getMessage());
                            }
                            if (property_type != v17) break block142;
                        }
                        if (values[0] != null && values[0].length() > 0) {
                            parameter_value_typed = new Long(values[0]);
                        }
                        break block128;
                    }
                    if (property_type == Short.TYPE) ** GOTO lbl-1000
                    try {
                        v18 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException var30_67) {
                        throw new NoClassDefFoundError(var30_67.getMessage());
                    }
                    if (property_type == v18) lbl-1000:
                    // 2 sources

                    {
                        if (values[0] != null && values[0].length() > 0) {
                            parameter_value_typed = new Short(values[0]);
                        }
                    } else {
                        try {
                            v19 = Class.forName("java.lang.StringBuffer");
                        }
                        catch (ClassNotFoundException var31_71) {
                            throw new NoClassDefFoundError(var31_71.getMessage());
                        }
                        if (property_type == v19) {
                            if (values[0] != null && values[0].length() > 0) {
                                parameter_value_typed = new StringBuffer(values[0]);
                            }
                        } else {
                            try {
                                v20 = Class.forName("java.io.Serializable");
                            }
                            catch (ClassNotFoundException var32_74) {
                                throw new NoClassDefFoundError(var32_74.getMessage());
                            }
                            if (v20.isAssignableFrom(property_type) && values[0] != null && values[0].length() > 0) {
                                try {
                                    parameter_value_typed = SerializationUtils.deserializeFromString(values[0]);
                                }
                                catch (SerializationUtilsErrorException e) {
                                    parameter_value_typed = null;
                                }
                            }
                        }
                    }
                }
                if (parameter_value_typed != null) {
                    write_method.invoke(beanInstance, new Object[]{parameter_value_typed});
                }
            }
            catch (NumberFormatException e) {
                if (validated != null) {
                    validated.addValidationError(new ValidationError.NOTNUMERIC(name));
                }
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(name).toString()).append("' property of the bean with class '").toString()).append(beanClass.getName()).toString()).append("' couldn't be populated due to numeric conversion problems.").toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(beanClass.getName()).toString()).append("'.").toString(), e);
            }
            catch (IllegalArgumentException e) {
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(beanClass.getName()).toString()).append("'.").toString(), e);
            }
            catch (InvocationTargetException e) {
                throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(write_method.getName()).toString()).append("' method of the bean with class '").toString()).append(beanClass.getName()).toString()).append("' has thrown an exception.").toString(), e);
            }
        }
    }

    private void setUppercasedBeanProperty(String name, UploadedFile file, String prefix, Class beanClass, HashMap<String, PropertyDescriptor> beanProperties, Object beanInstance) {
        block29: {
            String name_upper = null;
            PropertyDescriptor property = null;
            Method write_method = null;
            Class<?> property_type = null;
            if (prefix != null) {
                if (!name.startsWith(prefix)) {
                    return;
                }
                name = name.substring(prefix.length());
            }
            if (beanProperties.containsKey(name_upper = name.toUpperCase())) {
                if (file == null) {
                    return;
                }
                property = beanProperties.get(name_upper);
                write_method = property.getWriteMethod();
                if (write_method == null) {
                    return;
                }
                property_type = property.getPropertyType();
                if (property_type == null) {
                    return;
                }
                Validated validated = null;
                if (beanInstance instanceof Validated) {
                    validated = (Validated)beanInstance;
                }
                Constrained constrained = null;
                if (beanInstance instanceof Constrained) {
                    constrained = (Constrained)beanInstance;
                }
                try {
                    Class<?> clazz;
                    if (file.wasSizeExceeded()) {
                        if (validated != null) {
                            validated.addValidationError(new ValidationError.WRONGLENGTH(name));
                        }
                        break block29;
                    }
                    Object parameter_value_typed = null;
                    try {
                        clazz = Class.forName("java.io.InputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    if (property_type == clazz) {
                        parameter_value_typed = new FileInputStream(file.getFile());
                    } else {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (property_type == clazz2) {
                            parameter_value_typed = FileUtils.readString(file.getFile());
                        } else {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("[B");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            if (property_type == clazz3) {
                                parameter_value_typed = FileUtils.readBytes(file.getFile());
                            }
                        }
                    }
                    if (parameter_value_typed != null) {
                        ConstrainedProperty constrained_property;
                        if (constrained != null && (constrained_property = (ConstrainedProperty)constrained.getConstrainedProperty(name)) != null && constrained_property instanceof CmfProperty) {
                            ((CmfProperty)constrained_property).name(file.getName());
                        }
                        write_method.invoke(beanInstance, parameter_value_typed);
                    }
                }
                catch (FileUtilsErrorException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(name).toString()).append("' property of the bean with class '").toString()).append(beanClass.getName()).toString()).append("' couldn't be populated due to an unexpected problem during file reading.").toString(), e);
                }
                catch (FileNotFoundException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(name).toString()).append("' property of the bean with class '").toString()).append(beanClass.getName()).toString()).append("' couldn't be populated due to an unexpected problem during file reading.").toString(), e);
                }
                catch (IllegalAccessException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(beanClass.getName()).toString()).append("'.").toString(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(beanClass.getName()).toString()).append("'.").toString(), e);
                }
                catch (InvocationTargetException e) {
                    throw new EngineException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(write_method.getName()).toString()).append("' method of the bean with class '").toString()).append(beanClass.getName()).toString()).append("' has thrown an exception.").toString(), e);
                }
            }
        }
    }

    void processEmbeddedElement(Template template2, ElementSupport embeddingElement, String elementId, String differentiator) {
        StringBuffer value_id_buffer;
        String value_id = null;
        StringBuffer stringBuffer = value_id_buffer = new StringBuffer(PREFIX_ELEMENT);
        synchronized (stringBuffer) {
            value_id_buffer.append(elementId);
            if (differentiator != null) {
                value_id_buffer.append(differentiator);
            }
            value_id = value_id_buffer.toString();
        }
        if (!template2.hasValueId(value_id)) {
            throw new EmbeddedElementNotFoundException(elementId);
        }
        ElementInfo embedded_element = null;
        RequestState embedded_state = null;
        Response embedded_response = null;
        embedded_element = this.mElementInfo.getSite().resolveId(elementId, this.mElementInfo);
        if (embedded_element == null) {
            throw new ElementIdNotFoundException(elementId);
        }
        embedded_state = new RequestState(this.mRequestState.getInitConfig(), this.mRequestState.getSite(), this.mRequestState.getRequest(), this.mRequestState.getGateUrl(), "", embedded_element, new EmbeddingContext(this, embeddingElement, template2, template2.getValue(value_id), differentiator));
        embedded_state.getElementState().setMethod(this.mElementState.getMethod());
        embedded_state.getElementState().setRequestParameters(this.mElementState.getRequestParameters());
        embedded_state.getElementState().setInputs(this.mElementState.getInputs());
        embedded_state.setStateCookies(this.mRequestState.getStateCookies());
        embedded_response = new Response(this.mRequestState.getRequest(), this.mResponse.getHttpServletResponse(), true);
        embedded_state.service(embedded_response);
        embedded_response.close();
        template2.setValue(value_id, embedded_response.getEmbeddedContent());
    }

    void evaluateExpressionRoleUserTags(Template template2, String id) {
        RoleUserIdentity identity;
        if ((template2.hasFilteredBlocks(TAG_OGNL_ROLEUSER) || template2.hasFilteredBlocks(TAG_GROOVY_ROLEUSER) || template2.hasFilteredBlocks(TAG_JANINO_ROLEUSER)) && (identity = (RoleUserIdentity)this.mRequestState.getRequestAttribute("identity")) != null) {
            String language_id;
            RoleUserAttributes attributes = identity.getAttributes();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("login", identity.getLogin());
            map.put("password", attributes.getPassword());
            map.put("userId", new Long(attributes.getUserId()));
            map.put("roles", attributes.getRoles());
            if (template2.hasFilteredBlocks(TAG_OGNL_ROLEUSER)) {
                Class<?> clazz;
                language_id = id;
                if (language_id != null) {
                    language_id = new StringBuffer().append(PREFIX_OGNL_ROLEUSER).append(language_id).toString();
                }
                try {
                    clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                FilteredTagProcessorOgnl.getInstance().processTags(template2, template2.getFilteredBlocks(TAG_OGNL_ROLEUSER), language_id, clazz, "user", attributes, map);
            }
            if (template2.hasFilteredBlocks(TAG_GROOVY_ROLEUSER)) {
                Class<?> clazz;
                language_id = id;
                if (language_id != null) {
                    language_id = new StringBuffer().append(PREFIX_GROOVY_ROLEUSER).append(language_id).toString();
                }
                try {
                    clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                FilteredTagProcessorGroovy.getInstance().processTags(template2, template2.getFilteredBlocks(TAG_GROOVY_ROLEUSER), language_id, clazz, "user", attributes, map);
            }
            if (template2.hasFilteredBlocks(TAG_JANINO_ROLEUSER)) {
                Class<?> clazz;
                language_id = id;
                if (language_id != null) {
                    language_id = new StringBuffer().append(PREFIX_JANINO_ROLEUSER).append(language_id).toString();
                }
                try {
                    clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                FilteredTagProcessorJanino.getInstance().processTags(template2, template2.getFilteredBlocks(TAG_JANINO_ROLEUSER), language_id, clazz, "user", attributes, map);
            }
        }
    }

    private String getEncodedChildRequest() {
        String child_request = null;
        child_request = this.mElementState.hasParameterValue("childrequest") ? this.mElementState.getParameter("childrequest") : ChildRequestEncoder.encode((ElementInfo)this.mElementState.getInheritanceStack().get(0), this.mRequestState);
        return child_request;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.ElementContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        sActiveElements = new ThreadLocal();
    }
}

