/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.CallState;
import com.uwyn.rife.engine.ContinuationStack;
import com.uwyn.rife.engine.ElementContext;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.engine.Site;
import com.uwyn.rife.engine.exceptions.ElementLocalVariableUncloneableException;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.UniqueIDGenerator;
import java.util.logging.Logger;

public class ContinuationContext
implements Cloneable {
    private static ThreadLocal<ContinuationContext> sContext = new ThreadLocal();
    private ElementSupport mElement = null;
    private CallState mCreatedCallState = null;
    private CallState mActiveCallState = null;
    private Object mCallAnswer = null;
    private String mAbsoluteElementId = null;
    private String mId = null;
    private long mStart = -1;
    private int mLabel = -1;
    private ContinuationStack mLocalVars = null;
    private ContinuationStack mLocalStack = null;

    public static ContinuationContext getContext() {
        ContinuationContext context = sContext.get();
        if (context == null) {
            context = new ContinuationContext(ElementContext.getActiveElement());
            sContext.set(context);
        } else {
            context.resetStart();
        }
        return context;
    }

    static String getActiveContextId() {
        ContinuationContext context = sContext.get();
        if (context == null) {
            return null;
        }
        return context.getId();
    }

    static ContinuationContext currentContext() {
        return sContext.get();
    }

    static void setContext(ContinuationContext context) {
        sContext.set(context);
    }

    ContinuationContext(ElementSupport element) {
        this.mElement = element;
        ElementInfo element_info = this.mElement.getElementInfo();
        this.mElement.getSite();
        this.mAbsoluteElementId = Site.getAbsoluteId(element_info.getId(), element_info);
        this.resetId();
        this.resetStart();
        this.mLabel = -1;
        this.mLocalVars = new ContinuationStack().initialize();
        this.mLocalStack = new ContinuationStack().initialize();
    }

    public void remove() {
        this.mElement.getElementInfo().getSite().getContinuationManager().removeContext(this);
    }

    public Object getCallAnswer() {
        return this.mCallAnswer;
    }

    public void setLabel(int label) {
        this.mLabel = label;
    }

    public int getLabel() {
        return this.mLabel;
    }

    public ContinuationStack getLocalVars() {
        return this.mLocalVars;
    }

    public ContinuationStack getLocalStack() {
        return this.mLocalStack;
    }

    boolean isCorrespondingElement(ElementInfo elementInfo) {
        return this.mAbsoluteElementId.equals(elementInfo.getId());
    }

    private void resetStart() {
        this.mStart = System.currentTimeMillis();
    }

    void resetId() {
        this.mId = UniqueIDGenerator.generate().toString();
    }

    String getId() {
        return this.mId;
    }

    ElementSupport getElement() {
        return this.mElement;
    }

    void setCreatedCallState(CallState createdCallState) {
        this.mCreatedCallState = createdCallState;
    }

    CallState getCreatedCallState() {
        return this.mCreatedCallState;
    }

    void setActiveCallState(CallState callState) {
        this.mActiveCallState = callState;
    }

    CallState getActiveCallState() {
        return this.mActiveCallState;
    }

    String getAbsoluteElementId() {
        return this.mAbsoluteElementId;
    }

    long getStart() {
        return this.mStart;
    }

    void setCallAnswer(Object answer) {
        this.mCallAnswer = answer;
    }

    public ContinuationContext clone() throws CloneNotSupportedException {
        ContinuationContext new_continuationcontext = null;
        try {
            new_continuationcontext = (ContinuationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        new_continuationcontext.mElement = (ElementSupport)this.mElement.clone();
        new_continuationcontext.mElement.setElementContext(null);
        new_continuationcontext.mCallAnswer = null;
        new_continuationcontext.mId = UniqueIDGenerator.generate().toString();
        try {
            new_continuationcontext.mLocalVars = this.mLocalVars.clone(new_continuationcontext.mElement);
            new_continuationcontext.mLocalStack = this.mLocalStack.clone(new_continuationcontext.mElement);
        }
        catch (CloneNotSupportedException e) {
            throw new ElementLocalVariableUncloneableException(this.mElement.getClass().getName(), e.getMessage(), e);
        }
        return new_continuationcontext;
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

