/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ParameterMapEncoder;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.RequestState;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.Base64;
import java.util.Map;

class ChildRequestEncoder {
    private static final String SEP_DECLARATION_NAME = "x\u0000";
    private static final int SEP_DECLARATION_NAME_LENGTH = SEP_DECLARATION_NAME.length();
    private static final byte[] SEP_DECLARATION_NAME_BYTES = SEP_DECLARATION_NAME.getBytes();
    private static final String SEP_METHOD = "m\u0000";
    private static final int SEP_METHOD_LENGTH = SEP_METHOD.length();
    private static final byte[] SEP_METHOD_BYTES = SEP_METHOD.getBytes();
    private static final String SEP_PATHINFO = "i\u0000";
    private static final int SEP_PATHINFO_LENGTH = SEP_PATHINFO.length();
    private static final byte[] SEP_PATHINFO_BYTES = SEP_PATHINFO.getBytes();

    static String encode(ElementInfo elementInfo, RequestState state) {
        byte[] childrequest_bytes = new byte[]{};
        if (state != null) {
            String path_info;
            String declaration_name = elementInfo.getDeclarationName();
            childrequest_bytes = declaration_name.getBytes();
            childrequest_bytes = ArrayUtils.join(childrequest_bytes, SEP_DECLARATION_NAME_BYTES);
            RequestMethod method = state.getElementState().getMethod();
            if (method != null) {
                childrequest_bytes = ArrayUtils.join(childrequest_bytes, method.toString().getBytes());
                childrequest_bytes = ArrayUtils.join(childrequest_bytes, SEP_METHOD_BYTES);
            }
            if ((path_info = state.getElementState().getPathInfo()) != null && path_info.length() > 0) {
                childrequest_bytes = ArrayUtils.join(childrequest_bytes, path_info.getBytes());
                childrequest_bytes = ArrayUtils.join(childrequest_bytes, SEP_PATHINFO_BYTES);
            }
            childrequest_bytes = ArrayUtils.join(childrequest_bytes, ParameterMapEncoder.encodeToBytes(state.getElementState().getRequestParameters()));
        }
        return Base64.encodeToString(childrequest_bytes, false);
    }

    static void decode(ElementInfo elementInfo, RequestState state) {
        if (state != null) {
            String encoded_childrequest = state.getElementState().getParameter("childrequest");
            String declaration_name = null;
            String method = "";
            String path_info = "";
            Map<String, String[]> parameters = null;
            if (encoded_childrequest != null & encoded_childrequest.length() > 0) {
                int path_info_index;
                String decoded_childrequest = new String(Base64.decode(encoded_childrequest));
                int declaration_name_index = decoded_childrequest.indexOf(SEP_DECLARATION_NAME);
                if (declaration_name_index != -1) {
                    declaration_name = decoded_childrequest.substring(0, declaration_name_index);
                }
                if (declaration_name == null || !declaration_name.equals(elementInfo.getDeclarationName())) {
                    return;
                }
                int method_index = (decoded_childrequest = decoded_childrequest.substring(declaration_name_index + SEP_DECLARATION_NAME_LENGTH)).indexOf(SEP_METHOD);
                if (method_index != -1) {
                    method = decoded_childrequest.substring(0, method_index);
                    decoded_childrequest = decoded_childrequest.substring(method_index + SEP_METHOD_LENGTH);
                }
                if ((path_info_index = decoded_childrequest.indexOf(SEP_PATHINFO)) != -1) {
                    path_info = decoded_childrequest.substring(0, path_info_index);
                    decoded_childrequest = decoded_childrequest.substring(path_info_index + SEP_PATHINFO_LENGTH);
                }
                parameters = ParameterMapEncoder.decodeFromString(decoded_childrequest);
            }
            state.getElementState().setMethod(RequestMethod.getMethod(method));
            state.getElementState().setPathInfo(path_info);
            state.getElementState().setRequestParameters(parameters);
        }
    }
}

