/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.datastructures;

import com.uwyn.rife.datastructures.KeyValue;
import com.uwyn.rife.tools.Sort;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueList
implements Collection,
Cloneable {
    ArrayList<KeyValue> mElements = new ArrayList();

    public synchronized void swap(int position1, int position2) {
        KeyValue element1 = this.get(position1);
        KeyValue element2 = this.get(position2);
        this.add(position1 + 1, element2);
        this.remove(position1);
        this.add(position2 + 1, element1);
        this.remove(position2);
    }

    public synchronized void sortKeys() {
        new SortKeys().sort(this, this.size() - 1, true);
    }

    public synchronized void sortValues() {
        new SortValues().sort(this, this.size() - 1, true);
    }

    public String getValue(String key) {
        KeyValue element = this.get(key);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public synchronized KeyValue getPrevious(int elementIndex) {
        if (-1 != elementIndex && elementIndex > 0) {
            return this.get(elementIndex - 1);
        }
        return null;
    }

    public KeyValue getPrevious(String key) {
        return this.getPrevious(this.indexOf(key));
    }

    public KeyValue getPrevious(KeyValue element) {
        return this.getPrevious(this.indexOf(element));
    }

    public KeyValue getNext(int elementIndex) {
        if (-1 != elementIndex && elementIndex < this.size() - 1) {
            return this.get(elementIndex + 1);
        }
        return null;
    }

    public KeyValue getNext(String key) {
        return this.getNext(this.indexOf(key));
    }

    public KeyValue getNext(KeyValue element) {
        return this.getNext(this.indexOf(element));
    }

    public synchronized Collection<KeyValue> getAll(String key) {
        ArrayList<KeyValue> matched_elements = new ArrayList<KeyValue>();
        Object[] element_array = new KeyValue[this.size()];
        this.toArray(element_array);
        int index = 0;
        do {
            if (-1 == (index = this.indexOf(index, key))) continue;
            matched_elements.add((KeyValue)element_array[index]);
        } while (-1 != index);
        if (matched_elements.isEmpty()) {
            return null;
        }
        return matched_elements;
    }

    public boolean contains(String key) {
        if (!this.mElements.isEmpty()) {
            for (KeyValue element : (Collection)this.mElements) {
                if (!element.getKey().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Object keyvalue) {
        if (keyvalue != null && keyvalue instanceof KeyValue) {
            return this.mElements.contains(keyvalue);
        }
        return false;
    }

    public boolean contains(String key, String value) {
        return this.mElements.contains(new KeyValue(key, value));
    }

    public boolean contains(KeyValue element) {
        return this.mElements.contains(element);
    }

    public boolean containsAll(Collection collection) {
        return this.mElements.containsAll(collection);
    }

    public int indexOf(String key, String value) {
        return this.mElements.indexOf(new KeyValue(key, value));
    }

    public int indexOf(KeyValue element) {
        return this.mElements.indexOf(element);
    }

    public synchronized int indexOf(int startIndex, KeyValue element) {
        if (!this.mElements.isEmpty()) {
            int i = startIndex;
            while (i < this.mElements.size()) {
                if (this.mElements.get(i).equals(element)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized int indexOf(String key) {
        return this.indexOf(0, key);
    }

    public synchronized int indexOf(int startIndex, String key) {
        if (!this.mElements.isEmpty()) {
            int i = startIndex;
            while (i < this.mElements.size()) {
                if (this.mElements.get(i).getKey().equals(key)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized boolean add(Object element) {
        if (element instanceof KeyValue) {
            return this.add((KeyValue)element);
        }
        return false;
    }

    public synchronized boolean add(String key, String value) {
        return this.mElements.add(new KeyValue(key, value));
    }

    public synchronized boolean add(KeyValue element) {
        return this.mElements.add(element);
    }

    public synchronized boolean add(KeyValueList source) {
        boolean result = true;
        for (Object element : (Collection)source) {
            if (this.add(((KeyValue)element).clone())) continue;
            result = false;
        }
        return result;
    }

    public synchronized void add(int index, String key, String value) {
        this.mElements.add(index, new KeyValue(key, value));
    }

    public synchronized void add(int index, KeyValue element) {
        this.mElements.add(index, element);
    }

    public boolean addAll(Collection collection) {
        boolean result = true;
        for (Object element : collection) {
            if (this.add(element)) continue;
            result = false;
        }
        return result;
    }

    public synchronized void addAfter(KeyValue existingElement, String key, String value) {
        this.mElements.add(this.indexOf(existingElement) + 1, new KeyValue(key, value));
    }

    public synchronized void addAfter(KeyValue existingElement, KeyValue newElement) {
        this.mElements.add(this.indexOf(existingElement) + 1, newElement);
    }

    public synchronized void addBefore(KeyValue existingElement, String key, String value) {
        this.mElements.add(this.indexOf(existingElement), new KeyValue(key, value));
    }

    public synchronized void addBefore(KeyValue existingElement, KeyValue newElement) {
        this.mElements.add(this.indexOf(existingElement), newElement);
    }

    @Override
    public synchronized boolean remove(Object element) {
        if (element instanceof KeyValue) {
            return this.remove((KeyValue)element);
        }
        return false;
    }

    public synchronized boolean remove(String key, String value) {
        return this.mElements.remove(new KeyValue(key, value));
    }

    public synchronized boolean remove(KeyValue element) {
        return this.mElements.remove(element);
    }

    public synchronized void remove(int index) {
        this.mElements.remove(index);
    }

    public boolean removeAll(Collection collection) {
        return this.mElements.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.mElements.retainAll(collection);
    }

    public synchronized boolean remove(String key) {
        if (!this.mElements.isEmpty()) {
            for (KeyValue element : (Collection)this.mElements) {
                if (!element.getKey().equals(key)) continue;
                return this.mElements.remove(element);
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.mElements.clear();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.mElements.toArray();
    }

    public synchronized Object[] toArray(Object[] anArray) {
        this.mElements.toArray(anArray);
        return anArray;
    }

    public synchronized String[] getKeysArray() {
        String[] keys = new String[this.size()];
        int i = 0;
        for (Object object : this.keys()) {
            keys[i] = (String)object;
            ++i;
        }
        return keys;
    }

    public synchronized void trimToSize() {
        this.mElements.trimToSize();
    }

    public synchronized void ensureCapacity(int minCapacity) {
        this.mElements.ensureCapacity(minCapacity);
    }

    @Override
    public int size() {
        return this.mElements.size();
    }

    public synchronized void setSize(int newSize) {
        if (this.size() > newSize) {
            ArrayList<KeyValue> new_elements = new ArrayList<KeyValue>(newSize);
            int i = 0;
            while (i < newSize) {
                new_elements.set(i, this.mElements.get(i));
                ++i;
            }
            this.mElements = new_elements;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mElements.isEmpty();
    }

    @Override
    public synchronized Iterator<KeyValue> iterator() {
        return this.mElements.iterator();
    }

    public synchronized /* synthetic */ SimpleIterator iterator() {
        return this.iterator();
    }

    public synchronized Collection<String> keys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (KeyValue element : (Collection)this.mElements) {
            keys.add(element.getKey());
        }
        return keys;
    }

    public synchronized Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (KeyValue element : (Collection)this.mElements) {
            values.add(element.getValue());
        }
        return values;
    }

    public synchronized KeyValue get(int index) {
        return this.mElements.get(index);
    }

    public synchronized KeyValue get(String key) {
        int index = this.indexOf(key);
        if (-1 == index) {
            return null;
        }
        return this.get(index);
    }

    public synchronized KeyValue first() {
        return this.mElements.get(0);
    }

    public synchronized KeyValue last() {
        return this.mElements.get(this.size() - 1);
    }

    public synchronized void set(int index, String key, String value) {
        this.mElements.set(index, new KeyValue(key, value));
    }

    public synchronized void set(int index, KeyValue element) {
        this.mElements.set(index, element);
    }

    public synchronized KeyValueList clone() {
        KeyValueList new_object;
        block3: {
            new_object = null;
            try {
                new_object = (KeyValueList)super.clone();
                if (new_object.mElements == null) break block3;
                new_object.mElements = (ArrayList)this.mElements.clone();
                int i = 0;
                while (i < this.mElements.size()) {
                    new_object.mElements.set(i, this.mElements.get(i).clone());
                    ++i;
                }
            }
            catch (CloneNotSupportedException e) {
                new_object = null;
            }
        }
        return new_object;
    }

    public synchronized /* synthetic */ Object clone() {
        return this.clone();
    }

    public String toHtml() {
        StringBuffer html;
        StringBuffer stringBuffer = html = new StringBuffer();
        synchronized (stringBuffer) {
            if (!this.mElements.isEmpty()) {
                for (KeyValue element : (Collection)this.mElements) {
                    html.append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("<B>").append(StringUtils.encodeHtml(element.getKey())).toString()).append("</B> = &quot;").toString()).append(StringUtils.encodeHtml(element.getValue())).toString()).append("&quot;<BR>\n").toString());
                }
            }
            return html.toString();
        }
    }

    public String toString() {
        StringBuffer output;
        StringBuffer stringBuffer = output = new StringBuffer();
        synchronized (stringBuffer) {
            if (!this.mElements.isEmpty()) {
                for (KeyValue element : (Collection)this.mElements) {
                    output.append(new StringBuffer().append(element.getValue()).append(" ").toString());
                }
            }
            return output.toString();
        }
    }

    public String toStringVerbose() {
        StringBuffer html;
        StringBuffer stringBuffer = html = new StringBuffer();
        synchronized (stringBuffer) {
            if (!this.mElements.isEmpty()) {
                for (KeyValue element : (Collection)this.mElements) {
                    html.append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(element.getKey()).append(" = \"").toString()).append(element.getValue()).toString()).append("\"\n").toString());
                }
            }
            return html.toString();
        }
    }

    private class SortKeys
    extends Sort {
        public void swap(Object dataToSort, int position1, int position2) {
            ((KeyValueList)dataToSort).swap(position1, position2);
        }

        public Object elementAt(Object dataToSort, int position) {
            return ((KeyValueList)dataToSort).get(position).getKey();
        }

        public int compare(Object element1, Object element2) {
            return ((String)element1).compareTo((String)element2);
        }

        static /* synthetic */ KeyValueList access$0(SortKeys sortKeys) {
            return sortKeys.KeyValueList.this;
        }
    }

    private class SortValues
    extends Sort {
        public void swap(Object dataToSort, int position1, int position2) {
            ((KeyValueList)dataToSort).swap(position1, position2);
        }

        public Object elementAt(Object dataToSort, int position) {
            return ((KeyValueList)dataToSort).get(position).getValue();
        }

        public int compare(Object element1, Object element2) {
            return ((String)element1).compareTo((String)element2);
        }

        static /* synthetic */ KeyValueList access$0(SortValues sortValues) {
            return sortValues.KeyValueList.this;
        }
    }
}

