/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database.queries;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.AbstractQuery;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.QueryParameterType;
import com.uwyn.rife.database.queries.QueryParameters;
import com.uwyn.rife.database.queries.Select;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParametrizedQuery
extends AbstractQuery
implements Query,
Cloneable {
    private QueryParameters mParameters = null;

    protected AbstractParametrizedQuery(Datasource datasource) {
        super(datasource);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.mParameters != null) {
            this.mParameters.clear();
        }
    }

    private void addTypedParameters(QueryParameterType type, QueryParameters parameters) {
        if (parameters == null) {
            return;
        }
        this.addTypedParameters(type, parameters.getOrderedNames());
    }

    private void addTypedParameters(QueryParameterType type, List<String> parameters) {
        if (this.mParameters == null) {
            this.mParameters = new QueryParameters(this);
        }
        this.mParameters.addTypedParameters(type, parameters);
    }

    private void addTypedParameter(QueryParameterType type, String parameter) {
        if (this.mParameters == null) {
            this.mParameters = new QueryParameters(this);
        }
        this.mParameters.addTypedParameter(type, parameter);
    }

    private <T> T getTypedParameters(QueryParameterType type) {
        if (this.mParameters == null) {
            return null;
        }
        return this.mParameters.getTypedParameters(type);
    }

    private void clearTypedParameters(QueryParameterType type) {
        if (this.mParameters == null) {
            return;
        }
        this.mParameters.clearTypedParameters(type);
        if (0 == this.mParameters.getNumberOfTypes()) {
            this.mParameters = null;
        }
    }

    protected void _fieldSubselect(Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        this.addTypedParameters(QueryParameterType.FIELD, query.getParameters());
    }

    protected void _tableSubselect(Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        this.addTypedParameters(QueryParameterType.TABLE, query.getParameters());
    }

    protected void _whereSubselect(Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        this.addTypedParameters(QueryParameterType.WHERE, query.getParameters());
    }

    protected void _unionSubselect(Select query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        this.addTypedParameters(QueryParameterType.UNION, query.getParameters());
    }

    @Override
    public QueryParameters getParameters() {
        return this.mParameters;
    }

    protected void addFieldParameter(String field) {
        this.addTypedParameter(QueryParameterType.FIELD, field);
    }

    protected void clearWhereParameters() {
        this.clearTypedParameters(QueryParameterType.WHERE);
    }

    protected void addWhereParameter(String field) {
        this.addTypedParameter(QueryParameterType.WHERE, field);
    }

    protected List<String> getWhereParameters() {
        return (List)this.getTypedParameters(QueryParameterType.WHERE);
    }

    public void addWhereParameters(List<String> parameters) {
        this.addTypedParameters(QueryParameterType.WHERE, parameters);
    }

    protected void setLimitParameter(String limitParameter) {
        this.addTypedParameter(QueryParameterType.LIMIT, limitParameter);
    }

    public String getLimitParameter() {
        return (String)this.getTypedParameters(QueryParameterType.LIMIT);
    }

    protected void setOffsetParameter(String offsetParameter) {
        this.addTypedParameter(QueryParameterType.OFFSET, offsetParameter);
    }

    public String getOffsetParameter() {
        return (String)this.getTypedParameters(QueryParameterType.OFFSET);
    }

    protected boolean isLimitBeforeOffset() {
        return true;
    }

    @Override
    public AbstractParametrizedQuery clone() {
        AbstractParametrizedQuery new_instance = (AbstractParametrizedQuery)super.clone();
        if (new_instance != null && this.mParameters != null) {
            new_instance.mParameters = this.mParameters.clone();
        }
        return new_instance;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ AbstractQuery clone() {
        return this.clone();
    }
}

