/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.exceptions.RowProcessorErrorException;
import com.uwyn.rife.tools.ExceptionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public abstract class DbRowProcessor
implements Cloneable {
    private boolean mSuccessful = false;

    public abstract boolean processRow(ResultSet var1) throws SQLException;

    public final boolean wasSuccessful() {
        return this.mSuccessful;
    }

    final void processRowWrapper(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet can't be null.");
        }
        this.mSuccessful = false;
        try {
            this.mSuccessful = this.processRow(resultSet);
        }
        catch (SQLException e) {
            this.mSuccessful = false;
            throw new RowProcessorErrorException(e);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }
}

