/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbStatement;
import com.uwyn.rife.database.exceptions.ConnectionCloseErrorException;
import com.uwyn.rife.database.exceptions.ConnectionMetaDataErrorException;
import com.uwyn.rife.database.exceptions.ConnectionStatusErrorException;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.exceptions.PreparedStatementCreationErrorException;
import com.uwyn.rife.database.exceptions.StatementCreationErrorException;
import com.uwyn.rife.database.exceptions.TransactionBeginErrorException;
import com.uwyn.rife.database.exceptions.TransactionCommitErrorException;
import com.uwyn.rife.database.exceptions.TransactionRollbackErrorException;
import com.uwyn.rife.database.exceptions.TransactionSupportCheckErrorException;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.tools.ExceptionUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DbConnection {
    private static final int TRANSACTIONS_SUPPORT_UNKNOWN = -1;
    private static final int TRANSACTIONS_UNSUPPORTED = 0;
    private static final int TRANSACTIONS_SUPPORTED = 1;
    private Datasource mDatasource = null;
    private Connection mConnection = null;
    private ArrayList<DbStatement> mStatements = null;
    private int mSupportsTransactions = -1;
    private Thread mTransactionThread = null;
    private long mTransactionStart = -1;
    private static /* synthetic */ boolean $assertionsDisabled;

    DbConnection(Connection connection, Datasource datasource) {
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && datasource == null) {
            throw new AssertionError();
        }
        this.mDatasource = datasource;
        this.mConnection = connection;
        this.mStatements = new ArrayList();
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mDatasource == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mStatements == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 0 != this.mStatements.size()) {
            throw new AssertionError();
        }
    }

    public Datasource getDatasource() {
        return this.mDatasource;
    }

    public void close() {
        if (this.isClosed()) {
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                this.notifyAll();
            }
            return;
        }
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            block22: {
                if (this.hasTransactionThread() && !this.isTransactionValidForThread()) {
                    return;
                }
                try {
                    if (this.mDatasource.isPooled() || this.hasTransactionThread() && this.isTransactionValidForThread()) break block22;
                    try {
                        try {
                            while (this.mStatements.size() > 0) {
                                this.mStatements.get(0).close();
                            }
                            this.mStatements = new ArrayList();
                        }
                        finally {
                            try {
                                this.mConnection.close();
                            }
                            catch (SQLException e) {
                                throw new ConnectionCloseErrorException(this.mDatasource, (Throwable)e);
                            }
                        }
                    }
                    finally {
                        this.mConnection = null;
                        this.mSupportsTransactions = -1;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }
    }

    boolean isCleanedUp() {
        return this.mConnection == null;
    }

    void detectCleanup() throws SQLException {
        if (this.isCleanedUp()) {
            throw new SQLException("The connection is closed.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void cleanup() {
        Thread transaction_thread = null;
        if (this.mTransactionThread != null) {
            transaction_thread = this.mTransactionThread;
            this.mTransactionThread = null;
            this.mTransactionStart = -1;
        }
        DbStatement statement = null;
        DbConnection dbConnection = this;
        // MONITORENTER : dbConnection
        while (this.mStatements.size() > 0) {
            statement = this.mStatements.get(0);
            statement.close();
            try {
                statement.cancel();
            }
            catch (DatabaseException e) {
                // empty catch block
            }
        }
        this.mStatements = new ArrayList();
        // MONITOREXIT : dbConnection
        if (this.mConnection != null) {
            try {
                this.mConnection.rollback();
                this.mConnection.setAutoCommit(true);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.mConnection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.mConnection = null;
        this.mSupportsTransactions = -1;
        if (transaction_thread == null) return;
        this.mDatasource.getPool().unregisterThreadConnection(transaction_thread);
    }

    private void handleException() {
        if (!this.mDatasource.isPooled()) {
            Datasource datasource = this.mDatasource;
            synchronized (datasource) {
                DbConnection dbConnection = this;
                synchronized (dbConnection) {
                    this.cleanup();
                    this.notifyAll();
                }
            }
        }
        this.mDatasource.getPool().recreateConnection(this);
    }

    public DbStatement createStatement() {
        try {
            this.detectCleanup();
            Statement statement = this.mConnection.createStatement();
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbStatement db_statement = new DbStatement(this, statement);
                this.mStatements.add(db_statement);
                return db_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new StatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbStatement createStatement(int resultSetType, int resultSetConcurrency) {
        try {
            this.detectCleanup();
            Statement statement = this.mConnection.createStatement(resultSetType, resultSetConcurrency);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbStatement db_statement = new DbStatement(this, statement);
                this.mStatements.add(db_statement);
                return db_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new StatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            this.detectCleanup();
            Statement statement = this.mConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbStatement db_statement = new DbStatement(this, statement);
                this.mStatements.add(db_statement);
                return db_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new StatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbPreparedStatement getPreparedStatement(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql can't be null.");
        }
        if (0 == sql.length()) {
            throw new IllegalArgumentException("sql can't be empty.");
        }
        try {
            this.detectCleanup();
            PreparedStatement prepared_statement = this.mConnection.prepareStatement(sql);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbPreparedStatement db_prepared_statement = new DbPreparedStatement(this, sql, prepared_statement);
                this.mStatements.add(db_prepared_statement);
                return db_prepared_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new PreparedStatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbPreparedStatement getPreparedStatement(String sql, int autoGeneratedKeys) {
        if (sql == null) {
            throw new IllegalArgumentException("sql can't be null.");
        }
        if (0 == sql.length()) {
            throw new IllegalArgumentException("sql can't be empty.");
        }
        try {
            this.detectCleanup();
            PreparedStatement prepared_statement = this.mConnection.prepareStatement(sql, autoGeneratedKeys);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbPreparedStatement db_prepared_statement = new DbPreparedStatement(this, sql, prepared_statement);
                this.mStatements.add(db_prepared_statement);
                return db_prepared_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new PreparedStatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbPreparedStatement getPreparedStatement(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        if (query.getSql() == null) {
            throw new IllegalArgumentException("query can't be empty.");
        }
        try {
            this.detectCleanup();
            String sql = query.getSql();
            PreparedStatement prepared_statement = this.mConnection.prepareStatement(sql);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbPreparedStatement db_prepared_statement = new DbPreparedStatement(this, query, prepared_statement);
                this.mStatements.add(db_prepared_statement);
                return db_prepared_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new PreparedStatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DbPreparedStatement getPreparedStatement(Query query, int autoGeneratedKeys) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null.");
        }
        if (query.getSql() == null) {
            throw new IllegalArgumentException("query can't be empty.");
        }
        try {
            this.detectCleanup();
            String sql = query.getSql();
            PreparedStatement prepared_statement = this.mConnection.prepareStatement(sql, autoGeneratedKeys);
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                DbPreparedStatement db_prepared_statement = new DbPreparedStatement(this, query, prepared_statement);
                this.mStatements.add(db_prepared_statement);
                return db_prepared_statement;
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new PreparedStatementCreationErrorException(this.mDatasource, (Throwable)e);
        }
    }

    void releaseStatement(DbStatement statement) {
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            this.mStatements.remove(statement);
        }
    }

    public boolean supportsTransactions() {
        try {
            DbConnection dbConnection = this;
            synchronized (dbConnection) {
                this.detectCleanup();
                if (-1 == this.mSupportsTransactions) {
                    this.mSupportsTransactions = this.mConnection.getMetaData().supportsTransactions() ? 1 : 0;
                }
                return 1 == this.mSupportsTransactions;
                {
                }
            }
        }
        catch (SQLException e) {
            this.handleException();
            throw new TransactionSupportCheckErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public boolean beginTransaction() {
        if (!this.supportsTransactions()) {
            return false;
        }
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            if (this.hasTransactionThread()) {
                return false;
            }
            this.mTransactionThread = Thread.currentThread();
            this.mTransactionStart = System.currentTimeMillis();
        }
        try {
            this.detectCleanup();
            this.mConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            if (this.mTransactionThread != null) {
                this.mTransactionThread = null;
                this.mTransactionStart = -1;
            }
            this.handleException();
            throw new TransactionBeginErrorException(this.mDatasource, (Throwable)e);
        }
        this.mDatasource.getPool().registerThreadConnection(this.mTransactionThread, this);
        return true;
    }

    public boolean commit() {
        if (!this.supportsTransactions()) {
            return false;
        }
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            if (!this.isTransactionValidForThread()) {
                return false;
            }
        }
        try {
            try {
                this.detectCleanup();
                this.mConnection.commit();
                this.mConnection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.handleException();
                throw new TransactionCommitErrorException(this.mDatasource, (Throwable)e);
            }
        }
        finally {
            DbConnection dbConnection2 = this;
            synchronized (dbConnection2) {
                if (this.mTransactionThread != null) {
                    this.mTransactionStart = -1;
                    this.mTransactionThread = null;
                }
                this.notifyAll();
            }
            this.mDatasource.getPool().unregisterThreadConnection(Thread.currentThread());
        }
        return true;
    }

    public boolean rollback() {
        if (!this.supportsTransactions()) {
            return false;
        }
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            if (!this.isTransactionValidForThread()) {
                return false;
            }
        }
        try {
            try {
                this.detectCleanup();
                this.mConnection.rollback();
                this.mConnection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.handleException();
                throw new TransactionRollbackErrorException(this.mDatasource, (Throwable)e);
            }
        }
        finally {
            DbConnection dbConnection2 = this;
            synchronized (dbConnection2) {
                if (this.mTransactionThread != null) {
                    this.mTransactionStart = -1;
                    this.mTransactionThread = null;
                }
                this.notifyAll();
            }
            this.mDatasource.getPool().unregisterThreadConnection(Thread.currentThread());
        }
        return true;
    }

    public boolean isFree() {
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            if (this.isCleanedUp()) {
                return false;
            }
            if (!this.hasTransactionThread()) {
                return true;
            }
            return this.isTransactionValidForThread();
            {
            }
        }
    }

    private boolean hasTransactionThread() {
        return this.mTransactionThread != null;
    }

    public boolean isTransactionValidForThread() {
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            if (!this.hasTransactionThread()) {
                return false;
            }
            return this.mTransactionThread == Thread.currentThread();
            {
            }
        }
    }

    public boolean isClosed() {
        try {
            if (this.mConnection == null) {
                return true;
            }
            return this.mConnection.isClosed();
        }
        catch (SQLException e) {
            this.cleanup();
            throw new ConnectionStatusErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public DatabaseMetaData getMetaData() {
        try {
            this.detectCleanup();
            return this.mConnection.getMetaData();
        }
        catch (SQLException e) {
            this.handleException();
            throw new ConnectionMetaDataErrorException(this.mDatasource, (Throwable)e);
        }
    }

    public void setTransactionIsolation(int level) {
        try {
            this.detectCleanup();
            this.mConnection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.handleException();
            throw new ConnectionMetaDataErrorException(this.mDatasource, (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        DbConnection dbConnection = this;
        synchronized (dbConnection) {
            this.cleanup();
            this.notifyAll();
        }
        super.finalize();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.database").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbConnection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

