/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.exceptions.BeanException;
import com.uwyn.rife.database.exceptions.DatabaseException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbBeanFetcher<BeanType>
extends DbRowProcessor {
    private Datasource mDatasource = null;
    private Class<BeanType> mBeanClass = null;
    private BeanInfo mBeanInfo = null;
    private BeanType mLastBeanInstance = null;
    private HashMap<String, PropertyDescriptor> mBeanProperties = new HashMap();
    private ArrayList<BeanType> mCollectedInstances = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public DbBeanFetcher(Datasource datasource, Class<BeanType> beanClass) {
        this(datasource, beanClass, false);
    }

    public DbBeanFetcher(Datasource datasource, Class<BeanType> beanClass, boolean collectInstances) {
        PropertyDescriptor[] bean_properties;
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass can't be null.");
        }
        this.mDatasource = datasource;
        this.mBeanClass = beanClass;
        try {
            this.mBeanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new BeanException(new StringBuffer().append(new StringBuffer().append("Couldn't introspect the bean with class '").append(this.mBeanClass.getName()).toString()).append("'.").toString(), beanClass, e);
        }
        PropertyDescriptor[] propertyDescriptorArray = bean_properties = this.mBeanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            PropertyDescriptor bean_property = propertyDescriptorArray[n];
            this.mBeanProperties.put(bean_property.getName().toLowerCase(), bean_property);
            ++n;
        }
        if (collectInstances) {
            this.mCollectedInstances = new ArrayList();
        }
        if (!$assertionsDisabled && this.mDatasource == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mBeanClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mBeanInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mLastBeanInstance != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mBeanProperties == null) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean processRow(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet can't be null.");
        }
        Object instance = null;
        try {
            instance = this.mBeanClass.newInstance();
        }
        catch (InstantiationException e) {
            instance = null;
            SQLException e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Can't instantiate a bean with class '").append(this.mBeanClass.getName()).toString()).append("' : ").toString()).append(e.getMessage()).toString());
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            instance = null;
            SQLException e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("No permission to instantiate a bean with class '").append(this.mBeanClass.getName()).toString()).append("' : ").toString()).append(e.getMessage()).toString());
            e2.initCause(e);
            throw e2;
        }
        ResultSetMetaData meta = resultSet.getMetaData();
        String column_name = null;
        PropertyDescriptor property = null;
        Method write_method = null;
        int column_type = 1111;
        Object typed_object = null;
        int i = 1;
        while (i <= meta.getColumnCount()) {
            column_name = meta.getColumnName(i).toLowerCase();
            if (this.mBeanProperties.containsKey(column_name) && (write_method = (property = this.mBeanProperties.get(column_name)).getWriteMethod()) != null) {
                SQLException e2;
                try {
                    column_type = meta.getColumnType(i);
                    try {
                        typed_object = this.mDatasource.getSqlConversion().getTypedObject(resultSet, i, column_type, property.getPropertyType());
                    }
                    catch (DatabaseException e) {
                        e2 = new SQLException("Data conversion error while obtaining the typed object.");
                        e2.initCause(e);
                        throw e2;
                    }
                    if (typed_object == null) {
                        Object column_value = resultSet.getObject(i);
                        if (column_value != null && property.getPropertyType().isAssignableFrom(column_value.getClass())) {
                            typed_object = column_value;
                        } else {
                            String column_stringvalue = resultSet.getString(i);
                            if (column_stringvalue != null) {
                                try {
                                    Class<?> clazz;
                                    Class[] classArray = new Class[1];
                                    try {
                                        clazz = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    classArray[0] = clazz;
                                    Constructor<?> constructor = property.getPropertyType().getConstructor(classArray);
                                    if (constructor != null) {
                                        typed_object = constructor.newInstance(column_stringvalue);
                                    }
                                }
                                catch (SecurityException e) {
                                    instance = null;
                                    SQLException e22 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("No permission to obtain the String constructor of the property with name '").append(property.getName()).toString()).append("' and class '").toString()).append(property.getPropertyType().getName()).toString()).append("' of the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'.").toString());
                                    e22.initCause(e);
                                    throw e22;
                                }
                                catch (NoSuchMethodException e) {
                                    instance = null;
                                    SQLException e23 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Couldn't find a String constructor for the property with name '").append(property.getName()).toString()).append("' and class '").toString()).append(property.getPropertyType().getName()).toString()).append("' of the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'.").toString());
                                    e23.initCause(e);
                                    throw e23;
                                }
                                catch (InstantiationException e) {
                                    instance = null;
                                    SQLException e24 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Can't instantiate a new instance of the property with name '").append(property.getName()).toString()).append("' and class '").toString()).append(property.getPropertyType().getName()).toString()).append("' of the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'.").toString());
                                    e24.initCause(e);
                                    throw e24;
                                }
                            }
                        }
                    }
                    if (typed_object != null) {
                        write_method.invoke(instance, typed_object);
                    }
                }
                catch (IllegalAccessException e) {
                    instance = null;
                    e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("No permission to invoke the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'.").toString());
                    e2.initCause(e);
                    throw e2;
                }
                catch (IllegalArgumentException e) {
                    instance = null;
                    e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Invalid arguments while invoking the '").append(write_method.getName()).toString()).append("' method on the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'.").toString());
                    e2.initCause(e);
                    throw e2;
                }
                catch (InvocationTargetException e) {
                    instance = null;
                    e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("The '").append(write_method.getName()).toString()).append("' method of the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("' has thrown an exception").toString());
                    e2.initCause(e);
                    throw e2;
                }
                catch (SQLException e) {
                    instance = null;
                    e2 = new SQLException(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("SQLException while invoking the '").append(write_method.getName()).toString()).append("' method of the bean with class '").toString()).append(this.mBeanClass.getName()).toString()).append("'").toString());
                    e2.initCause(e);
                    throw e2;
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && instance == null) {
            throw new AssertionError();
        }
        this.mLastBeanInstance = instance;
        this.gotBeanInstance(instance);
        if (this.mCollectedInstances != null) {
            this.mCollectedInstances.add(instance);
        }
        return true;
    }

    public void gotBeanInstance(BeanType instance) {
    }

    public BeanType getBeanInstance() {
        return this.mLastBeanInstance;
    }

    public List<BeanType> getCollectedInstances() {
        return this.mCollectedInstances;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.DbBeanFetcher");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

