/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Xml2Datasources;
import com.uwyn.rife.database.exceptions.CantFindXmlPathException;
import com.uwyn.rife.database.exceptions.CantWriteToDestinationException;
import com.uwyn.rife.database.exceptions.DatasourceNotFoundException;
import com.uwyn.rife.database.exceptions.InitializationErrorException;
import com.uwyn.rife.database.exceptions.MissingXmlPathException;
import com.uwyn.rife.database.exceptions.ModificationTimeErrorException;
import com.uwyn.rife.database.exceptions.StoreXmlErrorException;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.selector.XmlSelectorResolver;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.SortListComparables;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Datasources {
    private HashMap<String, Datasource> mDatasources = null;
    private long mModificationTime = 0;
    private String mXmlPath = null;
    private ResourceFinder mResourceFinder = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Datasources() {
        this.mDatasources = new HashMap();
    }

    public Datasources(String xmlPath, ResourceFinder resourceFinder) {
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null.");
        }
        if (0 == xmlPath.length()) {
            throw new IllegalArgumentException("xmlPath can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mResourceFinder = resourceFinder;
        String datasource_resolved = XmlSelectorResolver.resolve(xmlPath, this.mResourceFinder, "rep/datasources-");
        if (datasource_resolved == null) {
            throw new DatasourceNotFoundException(xmlPath);
        }
        URL datasource_resource = this.mResourceFinder.getResource(datasource_resolved);
        if (datasource_resource == null) {
            throw new DatasourceNotFoundException(xmlPath, datasource_resolved);
        }
        try {
            this.mModificationTime = resourceFinder.getModificationTime(datasource_resolved);
        }
        catch (ResourceFinderErrorException e) {
            throw new ModificationTimeErrorException(xmlPath, e);
        }
        this.mXmlPath = datasource_resolved;
        this.initialize();
        if (!$assertionsDisabled && this.mResourceFinder == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mXmlPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mXmlPath.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mModificationTime <= (long)0) {
            throw new AssertionError();
        }
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantDatasources");
    }

    public static Datasources getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantDatasources");
        if (participant == null) {
            return null;
        }
        return (Datasources)participant.getObject();
    }

    public Datasource getDatasource(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mDatasources.get(name);
    }

    public void setDatasource(String name, Datasource datasource) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null.");
        }
        this.mDatasources.put(name, datasource);
    }

    public Collection<String> getDatasourceNames() {
        return this.mDatasources.keySet();
    }

    public String getXmlPath() {
        return this.mXmlPath;
    }

    public String toXml() {
        StringBuffer xml_output;
        StringBuffer stringBuffer = xml_output = new StringBuffer();
        synchronized (stringBuffer) {
            xml_output.append("<datasources>\n");
            ArrayList<String> datasource_keys_arraylist = new ArrayList<String>();
            for (String datasource_key : (Collection)this.mDatasources.keySet()) {
                datasource_keys_arraylist.add(datasource_key);
            }
            new SortListComparables().sort(datasource_keys_arraylist);
            Datasource datasource = null;
            for (String datasource_key : (Collection)datasource_keys_arraylist) {
                datasource = this.mDatasources.get(datasource_key);
                xml_output.append(new StringBuffer().append(new StringBuffer().append("\t<datasource name=\"").append(StringUtils.encodeXml(datasource_key)).toString()).append("\">\n").toString());
                xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<driver>").append(StringUtils.encodeXml(datasource.getDriver())).toString()).append("</driver>\n").toString());
                xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<url>").append(StringUtils.encodeXml(datasource.getUrl())).toString()).append("</url>\n").toString());
                if (datasource.getUser() != null) {
                    xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<user>").append(StringUtils.encodeXml(datasource.getUser())).toString()).append("</user>\n").toString());
                }
                if (datasource.getPassword() != null) {
                    xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<password>").append(StringUtils.encodeXml(datasource.getPassword())).toString()).append("</password>\n").toString());
                }
                if (datasource.getPoolsize() > 0) {
                    xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<poolsize>").append(datasource.getPoolsize()).toString()).append("</poolsize>\n").toString());
                }
                xml_output.append("\t</datasource>\n");
            }
            xml_output.append("</datasources>\n");
            if (!$assertionsDisabled && xml_output.length() <= 0) {
                throw new AssertionError();
            }
            return xml_output.toString();
        }
    }

    private void initialize() {
        try {
            Xml2Datasources xml_datasources = new Xml2Datasources();
            xml_datasources.processXml(this.mXmlPath, this.mResourceFinder);
            Datasources datasources = this;
            synchronized (datasources) {
                this.mDatasources = xml_datasources.getDatasources();
            }
        }
        catch (XmlErrorException e) {
            throw new InitializationErrorException(this.mXmlPath, e);
        }
        if (!$assertionsDisabled && this.mDatasources == null) {
            throw new AssertionError();
        }
    }

    public void storeToXml() {
        String xmlpath = null;
        URL xmlpath_resource = null;
        xmlpath = this.getXmlPath();
        if (xmlpath == null) {
            throw new MissingXmlPathException();
        }
        xmlpath_resource = this.mResourceFinder.getResource(xmlpath);
        if (xmlpath_resource == null) {
            throw new CantFindXmlPathException(xmlpath);
        }
        this.storeToXml(new File(URLDecoder.decode(xmlpath_resource.getPath())));
    }

    public synchronized void storeToXml(File destination) {
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null");
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new CantWriteToDestinationException(destination);
        }
        StringBuffer content = new StringBuffer(new StringBuffer().append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n").append("<!DOCTYPE datasources SYSTEM \"/dtd/datasources.dtd\">\n").toString());
        content.append(this.toXml());
        try {
            FileUtils.writeString(content.toString(), destination);
        }
        catch (FileUtilsErrorException e) {
            throw new StoreXmlErrorException(destination, (Throwable)e);
        }
    }

    public void cleanup() {
        Datasources datasources = this;
        synchronized (datasources) {
            if (this.mDatasources == null) {
                return;
            }
            HashMap<String, Datasource> datasoures = this.mDatasources;
            this.mModificationTime = 0;
            this.mDatasources = null;
            for (Datasource datasource : datasoures.values()) {
                datasource.cleanup();
            }
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.Datasources");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

