/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.database;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ConnectionPool {
    private int mPoolsize = 0;
    private ArrayList<DbConnection> mConnectionPool = new ArrayList();
    private HashMap<Thread, DbConnection> mThreadConnections = new HashMap();
    private static /* synthetic */ boolean $assertionsDisabled;

    ConnectionPool() {
    }

    void setPoolsize(int poolsize) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.mConnectionPool.size() > 0) {
                this.cleanup();
            }
            this.mPoolsize = poolsize;
        }
    }

    int getPoolsize() {
        return this.mPoolsize;
    }

    boolean isInitialized() {
        return this.mConnectionPool.size() > 0;
    }

    void preparePool(Datasource datasource) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.cleanup();
            this.mConnectionPool.ensureCapacity(this.mPoolsize);
            int i = 0;
            while (i < this.mPoolsize) {
                this.mConnectionPool.add(datasource.createConnection());
                ++i;
            }
            if (!$assertionsDisabled && this.mPoolsize != this.mConnectionPool.size()) {
                throw new AssertionError();
            }
            this.notifyAll();
        }
    }

    public void cleanup() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (0 == this.mConnectionPool.size()) {
                return;
            }
            ArrayList<DbConnection> previous_pool = null;
            previous_pool = this.mConnectionPool;
            this.mConnectionPool = new ArrayList();
            if (previous_pool != null) {
                Iterator iterator = ((Collection)previous_pool).iterator();
                while (iterator.hasNext()) {
                    DbConnection connection = (DbConnection)iterator.next();
                    connection.cleanup();
                }
                previous_pool.clear();
            }
            this.mThreadConnections.clear();
        }
    }

    void registerThreadConnection(Thread thread, DbConnection connection) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.mThreadConnections.put(thread, connection);
        }
    }

    void unregisterThreadConnection(Thread thread) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.mThreadConnections.remove(thread);
            this.notifyAll();
        }
    }

    boolean hasThreadConnection(Thread thread) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.mThreadConnections.containsKey(thread);
        }
    }

    void recreateConnection(DbConnection connection) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.mConnectionPool.remove(connection)) {
                this.mConnectionPool.add(connection.getDatasource().createConnection());
            }
            connection.cleanup();
        }
    }

    DbConnection getConnection(Datasource datasource) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            DbConnection connection;
            if (this.mThreadConnections.containsKey(Thread.currentThread()) && (connection = this.mThreadConnections.get(Thread.currentThread())) != null) {
                return connection;
            }
            if (0 == this.mPoolsize) {
                return datasource.createConnection();
            }
            connection = null;
            DbConnection possible_connection = null;
            while (connection == null) {
                if (this.mConnectionPool.size() < this.mPoolsize) {
                    this.preparePool(datasource);
                }
                int i = 0;
                while (i < this.mConnectionPool.size() && connection == null) {
                    possible_connection = this.mConnectionPool.get(i);
                    if (possible_connection == null || possible_connection.isCleanedUp()) {
                        connection = datasource.createConnection();
                        this.mConnectionPool.set(i, connection);
                        break;
                    }
                    if (possible_connection != null && possible_connection.isFree()) {
                        connection = possible_connection;
                        break;
                    }
                    ++i;
                }
                if (connection != null) continue;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.yield();
                }
            }
            this.mConnectionPool.remove(connection);
            this.mConnectionPool.add(connection);
            return connection;
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.database.ConnectionPool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

