/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.image;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.uwyn.rife.cmf.loader.ImageContentLoaderBackend;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.ImageWaiter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JimiLoader
extends ImageContentLoaderBackend {
    @Override
    public Image loadFromBytes(byte[] data, Set<String> errors) {
        return new LoaderDelegate().load(data, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("com.sun.jimi.core.Jimi") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate {
        public Image load(byte[] data, Set<String> errors) {
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            Image image = null;
            try {
                JimiRasterImage raster_image = Jimi.getRasterImage((InputStream)is, (int)2);
                ImageProducer producer = raster_image.getImageProducer();
                image = Toolkit.getDefaultToolkit().createImage(producer);
                ImageWaiter.wait(image);
            }
            catch (Throwable e) {
                if (errors != null) {
                    errors.add(ExceptionUtils.getExceptionStackTrace(e));
                }
                image = null;
            }
            return image;
        }
    }
}

