/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.image;

import com.sun.media.jai.codec.SeekableStream;
import com.uwyn.rife.cmf.loader.ImageContentLoaderBackend;
import com.uwyn.rife.tools.ExceptionUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Set;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaiLoader
extends ImageContentLoaderBackend {
    @Override
    public Image loadFromBytes(byte[] data, Set<String> errors) {
        return new LoaderDelegate().load(data, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("javax.media.jai.JAI") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate {
        public Image load(byte[] data, Set<String> errors) {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            BufferedImage image = null;
            SeekableStream in_stream = SeekableStream.wrapInputStream((InputStream)in, (boolean)false);
            RenderedOp jai = JAI.create((String)"stream", (Object)in_stream);
            PrintStream default_err = System.err;
            try {
                try {
                    System.setErr(new PrintStream(new ByteArrayOutputStream()));
                    image = jai.getAsBufferedImage();
                }
                catch (Throwable e) {
                    if (errors != null) {
                        errors.add(ExceptionUtils.getExceptionStackTrace(e));
                    }
                    image = null;
                }
            }
            finally {
                System.setErr(default_err);
            }
            return image;
        }
    }
}

