/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.image;

import com.uwyn.rife.cmf.loader.ImageContentLoaderBackend;
import com.uwyn.rife.tools.ExceptionUtils;
import ij.ImagePlus;
import ij.io.Opener;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageJLoader
extends ImageContentLoaderBackend {
    @Override
    public Image loadFromBytes(byte[] data, Set<String> errors) {
        return new LoaderDelegate().load(data, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("ij.io.Opener") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate {
        public Image load(byte[] data, Set<String> errors) {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Image image = null;
            try {
                ImagePlus imagej = new Opener().openTiff((InputStream)in, "cmfdata");
                if (imagej != null) {
                    image = imagej.getImage();
                }
            }
            catch (Throwable e) {
                if (errors != null) {
                    errors.add(ExceptionUtils.getExceptionStackTrace(e));
                }
                image = null;
            }
            return image;
        }
    }
}

