/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.format;

import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.exceptions.FormatException;
import com.uwyn.rife.cmf.format.exceptions.InvalidContentDataTypeException;
import com.uwyn.rife.cmf.format.exceptions.UnreadableDataFormatException;
import com.uwyn.rife.cmf.loader.XhtmlContentLoader;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.tools.StringUtils;
import java.util.HashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlFormatter
implements Formatter<String, String> {
    @Override
    public String format(Content content, ContentTransformer<String> transformer) throws FormatException {
        if (!(content.getData() instanceof String)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new InvalidContentDataTypeException(this, content.getMimeType(), clazz, content.getData().getClass());
        }
        String data = null;
        if (content.hasCachedLoadedData()) {
            data = (String)content.getCachedLoadedData();
        }
        if (data == null) {
            HashSet<String> errors = new HashSet<String>();
            data = (String)new XhtmlContentLoader().load(content.getData(), content.isFragment(), errors);
            if (data == null) {
                throw new UnreadableDataFormatException(content.getMimeType(), errors);
            }
        }
        data = StringUtils.encodeHtmlDefensive(data);
        if (transformer != null) {
            data = transformer.transform(data, content.getAttributes());
        }
        return data;
    }

    @Override
    public /* synthetic */ Object format(Content content, ContentTransformer contentTransformer) throws FormatException {
        return this.format(content, contentTransformer);
    }
}

