/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.elements;

import com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContent;
import com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentFactory;
import com.uwyn.rife.cmf.dam.exceptions.ContentManagerException;
import com.uwyn.rife.cmf.elements.MissingDatasourceException;
import com.uwyn.rife.config.Config;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.logging.Logger;

public class ServeContent
extends Element {
    public void processElement() {
        String datasource_name = this.getPropertyString("datasource", Config.getRepInstance().getString("DATASOURCE", "datasource"));
        Datasource datasource = Datasources.getRepInstance().getDatasource(datasource_name);
        if (datasource == null) {
            throw new MissingDatasourceException(this.getElementInfo().getId());
        }
        String repository_name = this.getPropertyString("repository");
        DatabaseContent manager = DatabaseContentFactory.getInstance(datasource);
        String content_path = this.getEmbedValue();
        try {
            if (content_path != null) {
                this.print(manager.getContentForHtml(content_path, this.getElementInfo()));
                return;
            }
            content_path = this.getPathInfo();
            if (repository_name != null) {
                StringBuffer buffer;
                StringBuffer stringBuffer = buffer = new StringBuffer(repository_name);
                synchronized (stringBuffer) {
                    buffer.append(":");
                    buffer.append(content_path);
                    content_path = buffer.toString();
                }
            }
            if ((content_path = this.filterPath(content_path)) != null && !content_path.equals("/")) {
                manager.serveContentData(this, content_path);
                return;
            }
        }
        catch (ContentManagerException e) {
            Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        this.setStatus(404);
    }

    public String filterPath(String path) {
        return path;
    }
}

