/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dao;

import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.Validation;
import com.uwyn.rife.tools.Localization;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentInfo
extends Validation {
    private String mPath = null;
    private int mVersion = -1;
    private Timestamp mCreated = null;
    private String mMimeType = null;
    private boolean mFragment = false;
    private String mName = null;
    private Map<String, String> mAttributes = null;
    private int mSize = -1;
    private Map<String, String> mProperties = null;

    @Override
    public void activateValidation() {
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("path").notNull(true)).notEmpty(true)).maxLength(255));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("mimeType").notNull(true)).notEmpty(true)).maxLength(80));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("version").notNull(true)).rangeBegin(0)).saved(false));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("name").maxLength(100));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("created").notNull(true)).saved(false));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("attributes").persistent(false));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("size").persistent(false));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("properties").persistent(false));
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getOptimalPath() {
        StringBuffer result;
        if (this.mPath == null) {
            return null;
        }
        if (this.mName == null) {
            return this.mPath;
        }
        StringBuffer stringBuffer = result = new StringBuffer(this.mPath);
        synchronized (stringBuffer) {
            result.append("/");
            result.append(this.mName);
            return result.toString();
        }
    }

    public void setVersion(int version) {
        this.mVersion = version;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public void setMimeType(String mimeType) {
        this.mMimeType = mimeType;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public void setFragment(boolean fragment) {
        this.mFragment = fragment;
    }

    public boolean isFragment() {
        return this.mFragment;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public void setCreated(Timestamp created) {
        this.mCreated = created;
    }

    public Timestamp getCreated() {
        return this.mCreated;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.mAttributes = attributes;
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public boolean hasAttributes() {
        return this.mAttributes != null && this.mAttributes.size() > 0;
    }

    public boolean hasAttribute(String name) {
        if (this.mAttributes == null) {
            return false;
        }
        return this.mAttributes.containsKey(name);
    }

    public String getAttribute(String name) {
        if (this.mAttributes == null) {
            return null;
        }
        return this.mAttributes.get(name);
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getFormattedSize() {
        NumberFormat format = NumberFormat.getNumberInstance(Localization.getLocale());
        double size = this.getSize();
        double size_kb = size / (double)1024;
        if (size_kb >= (double)1024) {
            double size_mb = size_kb / (double)1024;
            if (size_mb >= (double)1024) {
                double size_gb = size_mb / (double)1024;
                format.setMaximumFractionDigits(2);
                return new StringBuffer().append(format.format(size_gb)).append("GB").toString();
            }
            format.setMaximumFractionDigits(2);
            return new StringBuffer().append(format.format(size_mb)).append("MB").toString();
        }
        if (size_kb >= (double)100) {
            format.setMaximumFractionDigits(0);
        } else {
            format.setMaximumFractionDigits(2);
        }
        return new StringBuffer().append(format.format(size_kb)).append("KB").toString();
    }

    public void setProperties(Map<String, String> properties) {
        this.mProperties = properties;
    }

    public boolean hasProperties() {
        return this.mProperties != null && this.mProperties.size() > 0;
    }

    public boolean hasProperty(String name) {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.containsKey(name);
    }

    public String getProperty(String name) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }
}

