/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dao;

import com.uwyn.rife.cmf.MimeType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content {
    private MimeType mMimeType = null;
    private Object mData = null;
    private boolean mFragment = false;
    private String mName = null;
    private Map<String, String> mAttributes = null;
    private Map<String, String> mProperties = null;
    private Object mCachedLoadedData = null;

    public Content(MimeType mimeType, Object data) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType can't be null");
        }
        this.mMimeType = mimeType;
        this.mData = data;
    }

    public MimeType getMimeType() {
        return this.mMimeType;
    }

    public Object getData() {
        return this.mData;
    }

    public Content fragment(boolean fragment) {
        this.setFragment(fragment);
        return this;
    }

    public void setFragment(boolean fragment) {
        this.mFragment = fragment;
    }

    public boolean isFragment() {
        return this.mFragment;
    }

    public Content name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public Content attributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Content attribute(String name, boolean value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, char value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, byte value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, short value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, int value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, long value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, float value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, double value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Content attribute(String name, String value) {
        if (this.mAttributes == null) {
            this.mAttributes = new HashMap<String, String>();
        }
        this.mAttributes.put(name, value);
        return this;
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes == null) {
            this.mAttributes = null;
            return;
        }
        this.mAttributes = new HashMap<String, String>(attributes);
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public boolean hasAttributes() {
        return this.mAttributes != null && this.mAttributes.size() > 0;
    }

    public boolean hasAttribute(String name) {
        if (this.mAttributes == null) {
            return false;
        }
        return this.mAttributes.containsKey(name);
    }

    public String getAttribute(String name) {
        if (this.mAttributes == null) {
            return null;
        }
        return this.mAttributes.get(name);
    }

    public Content properties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public Content property(String name, boolean value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, char value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, byte value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, short value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, int value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, long value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, float value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, double value) {
        return this.property(name, String.valueOf(value));
    }

    public Content property(String name, String value) {
        if (this.mProperties == null) {
            this.mProperties = new HashMap<String, String>();
        }
        this.mProperties.put(name, value);
        return this;
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            this.mProperties = null;
            return;
        }
        this.mProperties = new HashMap<String, String>(properties);
    }

    public boolean hasProperties() {
        return this.mProperties != null && this.mProperties.size() > 0;
    }

    public boolean hasProperty(String name) {
        if (this.mProperties == null) {
            return false;
        }
        return this.mProperties.containsKey(name);
    }

    public String getProperty(String name) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public Content cachedLoadedData(Object data) {
        this.setCachedLoadedData(data);
        return this;
    }

    public void setCachedLoadedData(Object data) {
        this.mCachedLoadedData = data;
    }

    public boolean hasCachedLoadedData() {
        return this.mCachedLoadedData != null;
    }

    public Object getCachedLoadedData() {
        return this.mCachedLoadedData;
    }
}

