/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentstores;

import com.uwyn.rife.cmf.dam.contentstores.DatabaseRawStore;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.Select;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class RawContentStream
extends InputStream {
    protected DbPreparedStatement mStatement = null;
    protected DbResultSet mResultSet = null;
    protected byte[] mBuffer = null;
    protected int mIndex = 0;
    protected boolean mHasRow = false;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected RawContentStream(DbPreparedStatement statement) {
        this.mStatement = statement;
        this.mResultSet = this.mStatement.getResultSet();
        this.mHasRow = true;
        if (!$assertionsDisabled && this.mStatement == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mResultSet == null) {
            throw new AssertionError();
        }
    }

    public int read() throws IOException {
        if (this.mResultSet == null) {
            throw new IOException("Trying to read from a closed raw content stream.");
        }
        int result = -1;
        try {
            if (this.mBuffer == null) {
                if (!this.mHasRow) {
                    return -1;
                }
                this.mBuffer = this.mResultSet.getBytes("chunk");
                this.mIndex = 0;
            }
            result = this.mBuffer[this.mIndex++];
            if (this.mIndex >= this.mBuffer.length) {
                this.mBuffer = null;
                this.mHasRow = this.mResultSet.next();
            }
        }
        catch (SQLException e) {
            IOException e2 = new IOException("Unexpected error while reading the next bytes.");
            e2.initCause(e);
            throw e2;
        }
        return result;
    }

    public void close() throws IOException {
        if (this.mStatement == null) {
            return;
        }
        try {
            try {
                this.mStatement.close();
            }
            catch (DatabaseException e) {
                IOException e2 = new IOException("Unable to close prepared statement.");
                e2.initCause(e);
                throw e2;
            }
        }
        finally {
            this.mStatement = null;
            this.mResultSet = null;
            this.mBuffer = null;
        }
    }

    protected static DbPreparedStatement prepareStatement(DatabaseRawStore store, Select retrieveContentChunks, int id) {
        DbPreparedStatement statement = store.getConnection().getPreparedStatement(retrieveContentChunks);
        statement.setInt("contentId", id);
        statement.executeQuery();
        DbResultSet resultset = statement.getResultSet();
        try {
            if (!resultset.next()) {
                statement.close();
                return null;
            }
        }
        catch (SQLException e) {
            statement.close();
            return null;
        }
        return statement;
    }

    public static RawContentStream getInstance(DatabaseRawStore store, Select retrieveContentChunks, int id) {
        DbPreparedStatement statement = RawContentStream.prepareStatement(store, retrieveContentChunks, id);
        if (statement == null) {
            return null;
        }
        return new RawContentStream(statement);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentstores.RawContentStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

