/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentmanagers;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dam.ContentDataUser;
import com.uwyn.rife.cmf.dam.ContentManager;
import com.uwyn.rife.cmf.dam.ContentStore;
import com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.InstallContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.RemoveContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnknownContentRepositoryException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnsupportedMimeTypeException;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseImageStoreFactory;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseRawStoreFactory;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseTextStoreFactory;
import com.uwyn.rife.cmf.dam.exceptions.ContentManagerException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.dao.ContentInfo;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateSequence;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropSequence;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.SequenceValue;
import com.uwyn.rife.datastructures.Pair;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.tools.InnerClassException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseContent
extends DbQueryManager
implements ContentManager {
    protected ArrayList<ContentStore> mStores = new ArrayList();
    protected HashMap<MimeType, ContentStore> mMimeMapping = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public DatabaseContent(Datasource datasource) {
        super(datasource);
        this.mStores.add(DatabaseTextStoreFactory.getInstance(this.getDatasource()));
        this.mStores.add(DatabaseImageStoreFactory.getInstance(this.getDatasource()));
        this.mStores.add(DatabaseRawStoreFactory.getInstance(this.getDatasource()));
        this.mMimeMapping = new HashMap();
        for (ContentStore store : (Collection)this.mStores) {
            for (MimeType mime_type : store.getSupportedMimeTypes()) {
                this.mMimeMapping.put(mime_type, store);
            }
        }
    }

    @Override
    public abstract DatabaseContentInfo getContentInfo(String var1);

    @Override
    public /* synthetic */ ContentInfo getContentInfo(String string) {
        return this.getContentInfo(string);
    }

    protected boolean _install(CreateSequence createSequenceContentRepository, CreateSequence createSequenceContentInfo, CreateTable createTableContentRepository, CreateTable createTableContentInfo, CreateTable createTableContentAttribute, CreateTable createTableContentProperty) {
        if (!$assertionsDisabled && createSequenceContentRepository == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createSequenceContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableContentRepository == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableContentAttribute == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableContentProperty == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createSequenceContentRepository);
            this.executeUpdate(createSequenceContentInfo);
            this.executeUpdate(createTableContentRepository);
            this.executeUpdate(createTableContentInfo);
            this.executeUpdate(createTableContentAttribute);
            this.executeUpdate(createTableContentProperty);
            this.createRepository("default");
            for (ContentStore store : (Collection)this.mStores) {
                store.install();
            }
        }
        catch (DatabaseException e) {
            throw new InstallContentErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropSequence dropSequenceContentRepository, DropSequence dropSequenceContentInfo, DropTable dropTableContentRepository, DropTable dropTableContentInfo, DropTable dropTableContentAttribute, DropTable dropTableContentProperty) {
        if (!$assertionsDisabled && dropSequenceContentRepository == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropSequenceContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableContentRepository == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableContentAttribute == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableContentProperty == null) {
            throw new AssertionError();
        }
        try {
            for (ContentStore store : (Collection)this.mStores) {
                store.remove();
            }
            this.executeUpdate(dropTableContentProperty);
            this.executeUpdate(dropTableContentAttribute);
            this.executeUpdate(dropTableContentInfo);
            this.executeUpdate(dropTableContentRepository);
            this.executeUpdate(dropSequenceContentInfo);
            this.executeUpdate(dropSequenceContentRepository);
        }
        catch (DatabaseException e) {
            throw new RemoveContentErrorException(e);
        }
        return true;
    }

    protected String getValueColumnName() {
        return "value";
    }

    protected boolean _createRepository(SequenceValue getContentRepositoryId, Insert storeContentRepository, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty");
        }
        if (!$assertionsDisabled && getContentRepositoryId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && storeContentRepository == null) {
            throw new AssertionError();
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 2(getContentRepositoryId, storeContentRepository, name));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    protected Pair<String, String> splitLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("location can't be null");
        }
        if (0 == location.length()) {
            throw new IllegalArgumentException("location can't be empty");
        }
        int colon_index = location.indexOf(":");
        String repository = null;
        String path = null;
        if (colon_index != -1) {
            repository = location.substring(0, colon_index);
            path = location.substring(colon_index + 1);
        } else {
            path = location;
        }
        if (repository == null || 0 == repository.length()) {
            repository = "default";
        }
        if (0 == path.length()) {
            throw new IllegalArgumentException("path can't be empty");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path needs to be absolute");
        }
        return new Pair<String, String>(repository, path);
    }

    protected boolean _storeContent(SequenceValue getContentId, Select getContentRepositoryId, Insert storeContentInfo, Insert storeContentAttribute, Insert storeContentProperty, String location, Content content, ContentTransformer transformer) {
        if (content == null) {
            throw new IllegalArgumentException("content can't be null");
        }
        Pair<String, String> split_location = this.splitLocation(location);
        if (!$assertionsDisabled && getContentId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getContentRepositoryId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && storeContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && storeContentAttribute == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && storeContentProperty == null) {
            throw new AssertionError();
        }
        ContentStore store = this.mMimeMapping.get(content.getMimeType());
        if (store == null) {
            throw new UnsupportedMimeTypeException(content.getMimeType());
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 7(getContentId, getContentRepositoryId, split_location, storeContentInfo, content, storeContentAttribute, store, transformer, storeContentProperty));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    protected boolean _deleteContent(Select getContentInfo, Delete deleteContentInfo, Delete deleteContentAttributes, Delete deleteContentProperties, String location) {
        Pair<String, String> split_location = this.splitLocation(location);
        if (!$assertionsDisabled && getContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && deleteContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && deleteContentAttributes == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && deleteContentProperties == null) {
            throw new AssertionError();
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 13(getContentInfo, deleteContentAttributes, deleteContentProperties, deleteContentInfo, split_location));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    private Pair<String, String> splitPath(String path) {
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        int slash_index = path.lastIndexOf(47);
        String path_part = path.substring(0, slash_index);
        String name_part = path.substring(slash_index + 1);
        return new Pair<String, String>(path_part, name_part);
    }

    protected <ResultType> ResultType _useContentData(Select retrieveContent, String location, ContentDataUser user) {
        Class<?> clazz;
        if (user == null) {
            throw new IllegalArgumentException("user can't be null");
        }
        Pair<String, String> split_location = this.splitLocation(location);
        if (!$assertionsDisabled && retrieveContent == null) {
            throw new AssertionError();
        }
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        DatabaseContentInfo content_info = (DatabaseContentInfo)this.executeFetchFirstBean(retrieveContent, clazz, new 14(split_location));
        if (content_info == null) {
            return null;
        }
        MimeType mime_type = MimeType.getMimeType(content_info.getMimeType());
        ContentStore store = this.mMimeMapping.get(mime_type);
        if (store == null) {
            throw new UnsupportedMimeTypeException(mime_type);
        }
        return store.useContentData(content_info.getContentId(), user);
    }

    protected boolean _hasContentData(Select retrieveContent, String location) {
        Class<?> clazz;
        Pair<String, String> split_location = this.splitLocation(location);
        if (!$assertionsDisabled && retrieveContent == null) {
            throw new AssertionError();
        }
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        DatabaseContentInfo content_info = (DatabaseContentInfo)this.executeFetchFirstBean(retrieveContent, clazz, new 15(split_location));
        if (content_info == null) {
            return false;
        }
        MimeType mime_type = MimeType.getMimeType(content_info.getMimeType());
        ContentStore store = this.mMimeMapping.get(mime_type);
        if (store == null) {
            throw new UnsupportedMimeTypeException(mime_type);
        }
        return store.hasContentData(content_info.getContentId());
    }

    protected DatabaseContentInfo _getContentInfo(Select getContentInfo, Select getContentAttributes, Select getContentProperties, String location) {
        Class<?> clazz;
        Pair<String, String> split_location = this.splitLocation(location);
        if (!$assertionsDisabled && getContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getContentAttributes == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getContentProperties == null) {
            throw new AssertionError();
        }
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        DatabaseContentInfo content_info = (DatabaseContentInfo)this.executeFetchFirstBean(getContentInfo, clazz, new 16(split_location));
        if (content_info != null) {
            ContentAttributesProcessor processor_attributes = new ContentAttributesProcessor();
            this.executeFetchAll(getContentAttributes, processor_attributes, new 17(content_info));
            content_info.setAttributes(processor_attributes.getAttributes());
            ContentPropertiesProcessor processor_properties = new ContentPropertiesProcessor();
            this.executeFetchAll(getContentProperties, processor_properties, new 18(content_info));
            content_info.setProperties(processor_properties.getProperties());
            MimeType mime_type = MimeType.getMimeType(content_info.getMimeType());
            ContentStore store = this.mMimeMapping.get(mime_type);
            if (store == null) {
                throw new UnsupportedMimeTypeException(mime_type);
            }
            content_info.setSize(store.getSize(content_info.getContentId()));
        }
        return content_info;
    }

    protected void _serveContentData(ElementSupport element, String location) {
        if (element == null) {
            throw new IllegalArgumentException("element can't be null.");
        }
        Pair<String, String> split_location = null;
        try {
            split_location = this.splitLocation(location);
        }
        catch (IllegalArgumentException e) {
            element.setStatus(404);
            return;
        }
        DatabaseContentInfo content_info = null;
        try {
            content_info = this.getContentInfo(location);
        }
        catch (IllegalArgumentException e) {
            element.setStatus(404);
            return;
        }
        if (content_info == null) {
            element.setStatus(404);
            return;
        }
        MimeType mime_type = MimeType.getMimeType(content_info.getMimeType());
        ContentStore store = this.mMimeMapping.get(mime_type);
        if (store == null) {
            throw new UnsupportedMimeTypeException(mime_type);
        }
        long if_modified_since = element.getDateHeader("If-Modified-Since");
        Timestamp last_modified = content_info.getCreated();
        long last_modified_timestamp = last_modified.getTime() / (long)1000 * (long)1000;
        if (if_modified_since > (long)0 && if_modified_since >= last_modified_timestamp) {
            element.setStatus(304);
            return;
        }
        element.setContentType(store.getContentType(content_info));
        if (content_info.hasName()) {
            element.addHeader("Content-Disposition", new StringBuffer().append("inline; filename=").append(content_info.getName()).toString());
        }
        element.addHeader("Cache-Control", "must-revalidate");
        element.addDateHeader("Expires", System.currentTimeMillis() + (long)3600000);
        element.addDateHeader("Last-Modified", last_modified_timestamp);
        store.serveContentData(element, content_info.getContentId());
    }

    protected String _getContentForHtml(String location, ElementInfo serveContent) {
        DatabaseContentInfo content_info = null;
        try {
            content_info = this.getContentInfo(location);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        if (content_info == null) {
            return "";
        }
        MimeType mime_type = MimeType.getMimeType(content_info.getMimeType());
        ContentStore store = this.mMimeMapping.get(mime_type);
        if (store == null) {
            throw new UnsupportedMimeTypeException(mime_type);
        }
        return store.getContentForHtml(content_info.getContentId(), content_info, serveContent);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 2
    extends DbTransactionUser {
        private final /* synthetic */ SequenceValue val$getContentRepositoryId;
        private final /* synthetic */ Insert val$storeContentRepository;
        private final /* synthetic */ String val$name;

        2(SequenceValue sequenceValue, Insert insert2, String string) {
            this.val$getContentRepositoryId = sequenceValue;
            this.val$storeContentRepository = insert2;
            this.val$name = string;
        }

        public Boolean useTransaction() {
            int id = DatabaseContent.this.executeGetFirstInt(this.val$getContentRepositoryId);
            return new Boolean(DatabaseContent.this.executeUpdate(this.val$storeContentRepository, new 1(id, this.val$name)) > 0);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ DatabaseContent access$0(2 var0) {
            return var0.DatabaseContent.this;
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;
            private final /* synthetic */ String val$name;

            1(int n, String string) {
                this.val$id = n;
                this.val$name = string;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("repositoryId", this.val$id).setString("name", this.val$name);
            }

            static /* synthetic */ 2 access$0(1 var0) {
                return var0.2.this;
            }
        }
    }

    class 7
    extends DbTransactionUser {
        private final /* synthetic */ SequenceValue val$getContentId;
        private final /* synthetic */ Select val$getContentRepositoryId;
        private final /* synthetic */ Pair val$split_location;
        private final /* synthetic */ Insert val$storeContentInfo;
        private final /* synthetic */ Content val$content;
        private final /* synthetic */ Insert val$storeContentAttribute;
        private final /* synthetic */ ContentStore val$store;
        private final /* synthetic */ ContentTransformer val$transformer;
        private final /* synthetic */ Insert val$storeContentProperty;

        7(SequenceValue sequenceValue, Select select2, Pair pair, Insert insert2, Content content, Insert insert3, ContentStore contentStore, ContentTransformer contentTransformer, Insert insert4) {
            this.val$getContentId = sequenceValue;
            this.val$getContentRepositoryId = select2;
            this.val$split_location = pair;
            this.val$storeContentInfo = insert2;
            this.val$content = content;
            this.val$storeContentAttribute = insert3;
            this.val$store = contentStore;
            this.val$transformer = contentTransformer;
            this.val$storeContentProperty = insert4;
        }

        public Boolean useTransaction() {
            int id = DatabaseContent.this.executeGetFirstInt(this.val$getContentId);
            int repository_id = DatabaseContent.this.executeGetFirstInt(this.val$getContentRepositoryId, new 3(this.val$split_location));
            if (-1 == repository_id) {
                this.throwException(new UnknownContentRepositoryException((String)this.val$split_location.getFirst()));
            }
            if (DatabaseContent.this.executeUpdate(this.val$storeContentInfo, new 4(id, repository_id, this.val$split_location, this.val$content)) > 0) {
                String value;
                String name;
                Iterator iterator;
                if (this.val$content.hasAttributes()) {
                    iterator = ((Collection)this.val$content.getAttributes().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry attribute = (Map.Entry)iterator.next();
                        name = (String)attribute.getKey();
                        value = (String)attribute.getValue();
                        DatabaseContent.this.executeUpdate(this.val$storeContentAttribute, new 5(id, name, value));
                    }
                }
                try {
                    if (!this.val$store.storeContentData(id, this.val$content, this.val$transformer)) {
                        this.rollback();
                    }
                }
                catch (ContentManagerException e) {
                    this.throwException(e);
                }
                if (this.val$content.hasProperties()) {
                    iterator = ((Collection)this.val$content.getProperties().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry property = (Map.Entry)iterator.next();
                        name = (String)property.getKey();
                        value = (String)property.getValue();
                        DatabaseContent.this.executeUpdate(this.val$storeContentProperty, new 6(id, name, value));
                    }
                }
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 3
        extends DbPreparedStatementHandler {
            private final /* synthetic */ Pair val$split_location;

            3(Pair pair) {
                this.val$split_location = pair;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("repository", (String)this.val$split_location.getFirst());
            }

            static /* synthetic */ 7 access$0(3 var0) {
                return var0.7.this;
            }
        }

        class 4
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;
            private final /* synthetic */ int val$repository_id;
            private final /* synthetic */ Pair val$split_location;
            private final /* synthetic */ Content val$content;

            4(int n, int n2, Pair pair, Content content) {
                this.val$id = n;
                this.val$repository_id = n2;
                this.val$split_location = pair;
                this.val$content = content;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id).setInt("repositoryId", this.val$repository_id).setString("path", (String)this.val$split_location.getSecond()).setString("mimeType", this.val$content.getMimeType().toString()).setBoolean("fragment", this.val$content.isFragment());
                if (this.val$content.hasName()) {
                    statement.setString("name", this.val$content.getName());
                } else {
                    statement.setNull("name", 12);
                }
            }

            static /* synthetic */ 7 access$0(4 var0) {
                return var0.7.this;
            }
        }

        class 5
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ String val$value;

            5(int n, String string, String string2) {
                this.val$id = n;
                this.val$name = string;
                this.val$value = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id).setString("name", this.val$name).setString(DatabaseContent.this.getValueColumnName(), this.val$value);
            }

            static /* synthetic */ 7 access$0(5 var0) {
                return var0.7.this;
            }
        }

        class 6
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ String val$value;

            6(int n, String string, String string2) {
                this.val$id = n;
                this.val$name = string;
                this.val$value = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id).setString("name", this.val$name).setString(DatabaseContent.this.getValueColumnName(), this.val$value);
            }

            static /* synthetic */ 7 access$0(6 var0) {
                return var0.7.this;
            }
        }
    }

    class 13
    extends DbTransactionUser {
        private final /* synthetic */ Select val$getContentInfo;
        private final /* synthetic */ Delete val$deleteContentAttributes;
        private final /* synthetic */ Delete val$deleteContentProperties;
        private final /* synthetic */ Delete val$deleteContentInfo;
        private final /* synthetic */ Pair val$split_location;

        13(Select select2, Delete delete2, Delete delete3, Delete delete4, Pair pair) {
            this.val$getContentInfo = select2;
            this.val$deleteContentAttributes = delete2;
            this.val$deleteContentProperties = delete3;
            this.val$deleteContentInfo = delete4;
            this.val$split_location = pair;
        }

        public Boolean useTransaction() {
            return new Boolean(DatabaseContent.this.executeFetchAll(this.val$getContentInfo, new 11(this.val$deleteContentAttributes, this.val$deleteContentProperties, this.val$deleteContentInfo), new 12(this.val$split_location)));
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 11
        extends DbRowProcessor {
            private final /* synthetic */ Delete val$deleteContentAttributes;
            private final /* synthetic */ Delete val$deleteContentProperties;
            private final /* synthetic */ Delete val$deleteContentInfo;

            11(Delete delete2, Delete delete3, Delete delete4) {
                this.val$deleteContentAttributes = delete2;
                this.val$deleteContentProperties = delete3;
                this.val$deleteContentInfo = delete4;
            }

            public boolean processRow(ResultSet resultSet) throws SQLException {
                int contentid = resultSet.getInt("contentId");
                MimeType mimetype = MimeType.getMimeType(resultSet.getString("mimeType"));
                ContentStore store = ((13)13.this).DatabaseContent.this.mMimeMapping.get(mimetype);
                if (store == null) {
                    throw new UnsupportedMimeTypeException(mimetype);
                }
                if (!store.deleteContentData(contentid)) {
                    13.this.rollback();
                }
                DatabaseContent.this.executeUpdate(this.val$deleteContentAttributes, new 8(contentid));
                DatabaseContent.this.executeUpdate(this.val$deleteContentProperties, new 9(contentid));
                if (0 == DatabaseContent.this.executeUpdate(this.val$deleteContentInfo, new 10(contentid))) {
                    13.this.rollback();
                }
                return true;
            }

            static /* synthetic */ 13 access$0(11 var0) {
                return var0.13.this;
            }

            class 8
            extends DbPreparedStatementHandler {
                private final /* synthetic */ int val$contentid;

                8(int n) {
                    this.val$contentid = n;
                }

                public void setParameters(DbPreparedStatement statement) {
                    statement.setInt("contentId", this.val$contentid);
                }

                static /* synthetic */ 11 access$0(8 var0) {
                    return var0.11.this;
                }
            }

            class 9
            extends DbPreparedStatementHandler {
                private final /* synthetic */ int val$contentid;

                9(int n) {
                    this.val$contentid = n;
                }

                public void setParameters(DbPreparedStatement statement) {
                    statement.setInt("contentId", this.val$contentid);
                }

                static /* synthetic */ 11 access$0(9 var0) {
                    return var0.11.this;
                }
            }

            class 10
            extends DbPreparedStatementHandler {
                private final /* synthetic */ int val$contentid;

                10(int n) {
                    this.val$contentid = n;
                }

                public void setParameters(DbPreparedStatement statement) {
                    statement.setInt("contentId", this.val$contentid);
                }

                static /* synthetic */ 11 access$0(10 var0) {
                    return var0.11.this;
                }
            }
        }

        class 12
        extends DbPreparedStatementHandler {
            private final /* synthetic */ Pair val$split_location;

            12(Pair pair) {
                this.val$split_location = pair;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("repository", (String)this.val$split_location.getFirst()).setString("path", (String)this.val$split_location.getSecond());
            }

            static /* synthetic */ 13 access$0(12 var0) {
                return var0.13.this;
            }
        }
    }

    class 14
    extends DbPreparedStatementHandler {
        private final /* synthetic */ Pair val$split_location;

        14(Pair pair) {
            this.val$split_location = pair;
        }

        public void setParameters(DbPreparedStatement statement) {
            Pair path_parts = DatabaseContent.this.splitPath((String)this.val$split_location.getSecond());
            statement.setString("repository", (String)this.val$split_location.getFirst()).setString("path", (String)this.val$split_location.getSecond()).setString("pathpart", (String)path_parts.getFirst()).setString("namepart", (String)path_parts.getSecond());
        }

        static /* synthetic */ DatabaseContent access$0(14 var0) {
            return var0.DatabaseContent.this;
        }
    }

    class 15
    extends DbPreparedStatementHandler {
        private final /* synthetic */ Pair val$split_location;

        15(Pair pair) {
            this.val$split_location = pair;
        }

        public void setParameters(DbPreparedStatement statement) {
            Pair path_parts = DatabaseContent.this.splitPath((String)this.val$split_location.getSecond());
            statement.setString("repository", (String)this.val$split_location.getFirst()).setString("path", (String)this.val$split_location.getSecond()).setString("pathpart", (String)path_parts.getFirst()).setString("namepart", (String)path_parts.getSecond());
        }

        static /* synthetic */ DatabaseContent access$0(15 var0) {
            return var0.DatabaseContent.this;
        }
    }

    class 16
    extends DbPreparedStatementHandler {
        private final /* synthetic */ Pair val$split_location;

        16(Pair pair) {
            this.val$split_location = pair;
        }

        public void setParameters(DbPreparedStatement statement) {
            Pair path_parts = DatabaseContent.this.splitPath((String)this.val$split_location.getSecond());
            statement.setString("repository", (String)this.val$split_location.getFirst()).setString("path", (String)this.val$split_location.getSecond()).setString("pathpart", (String)path_parts.getFirst()).setString("namepart", (String)path_parts.getSecond());
        }

        static /* synthetic */ DatabaseContent access$0(16 var0) {
            return var0.DatabaseContent.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentAttributesProcessor
    extends DbRowProcessor {
        private Map<String, String> mAttributes = null;

        @Override
        public boolean processRow(ResultSet result) throws SQLException {
            if (this.mAttributes == null) {
                this.mAttributes = new HashMap<String, String>();
            }
            this.mAttributes.put(result.getString("name"), result.getString(DatabaseContent.this.getValueColumnName()));
            return true;
        }

        public Map<String, String> getAttributes() {
            return this.mAttributes;
        }

        static /* synthetic */ DatabaseContent access$0(ContentAttributesProcessor contentAttributesProcessor) {
            return contentAttributesProcessor.DatabaseContent.this;
        }
    }

    class 17
    extends DbPreparedStatementHandler {
        private final /* synthetic */ DatabaseContentInfo val$content_info;

        17(DatabaseContentInfo databaseContentInfo) {
            this.val$content_info = databaseContentInfo;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$content_info.getContentId());
        }

        static /* synthetic */ DatabaseContent access$0(17 var0) {
            return var0.DatabaseContent.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentPropertiesProcessor
    extends DbRowProcessor {
        private Map<String, String> mProperties = null;

        @Override
        public boolean processRow(ResultSet result) throws SQLException {
            if (this.mProperties == null) {
                this.mProperties = new HashMap<String, String>();
            }
            this.mProperties.put(result.getString("name"), result.getString(DatabaseContent.this.getValueColumnName()));
            return true;
        }

        public Map<String, String> getProperties() {
            return this.mProperties;
        }

        static /* synthetic */ DatabaseContent access$0(ContentPropertiesProcessor contentPropertiesProcessor) {
            return contentPropertiesProcessor.DatabaseContent.this;
        }
    }

    class 18
    extends DbPreparedStatementHandler {
        private final /* synthetic */ DatabaseContentInfo val$content_info;

        18(DatabaseContentInfo databaseContentInfo) {
            this.val$content_info = databaseContentInfo;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$content_info.getContentId());
        }

        static /* synthetic */ DatabaseContent access$0(18 var0) {
            return var0.DatabaseContent.this;
        }
    }
}

