/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.DbTransactionUserWithoutResult;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.tools.ExceptionUtils;
import java.sql.SQLException;
import java.util.logging.Logger;

public class OrdinalManager
implements Cloneable {
    public static final Direction UP = new Direction("up");
    public static final Direction DOWN = new Direction("down");
    private Datasource mDatasource = null;
    private DbQueryManager mDbQueryManager = null;
    private String mTable = null;
    private String mOrdinalColumn = null;
    private String mRestrictColumn = null;
    private Update mFreeMoveOrdinal = null;
    private Select mGetFinalOrdinal = null;
    private Select mGetOrdinals = null;
    private Select mGetFinalOrdinalRestricted = null;
    private Update mFreeMoveOrdinalRestricted = null;
    private Select mGetOrdinalsRestricted = null;

    static /* synthetic */ void access$S1000001(OrdinalManager ordinalManager, DbQueryManager dbQueryManager) {
        ordinalManager.mDbQueryManager = dbQueryManager;
    }

    static /* synthetic */ void access$S1000003(OrdinalManager ordinalManager, String string) {
        ordinalManager.mOrdinalColumn = string;
    }

    static /* synthetic */ void access$S1000004(OrdinalManager ordinalManager, String string) {
        ordinalManager.mRestrictColumn = string;
    }

    static /* synthetic */ void access$S1000005(OrdinalManager ordinalManager, Update update2) {
        ordinalManager.mFreeMoveOrdinal = update2;
    }

    static /* synthetic */ void access$S1000006(OrdinalManager ordinalManager, Select select2) {
        ordinalManager.mGetFinalOrdinal = select2;
    }

    static /* synthetic */ void access$S1000007(OrdinalManager ordinalManager, Select select2) {
        ordinalManager.mGetOrdinals = select2;
    }

    static /* synthetic */ void access$S1000008(OrdinalManager ordinalManager, Select select2) {
        ordinalManager.mGetFinalOrdinalRestricted = select2;
    }

    static /* synthetic */ void access$S1000009(OrdinalManager ordinalManager, Update update2) {
        ordinalManager.mFreeMoveOrdinalRestricted = update2;
    }

    public OrdinalManager(Datasource datasource, String table, String ordinalColumn) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource can't be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("table can't be null");
        }
        if (ordinalColumn == null) {
            throw new IllegalArgumentException("ordinalColumn can't be null");
        }
        this.mDatasource = datasource;
        this.mDbQueryManager = new DbQueryManager(datasource);
        this.mTable = table;
        this.mOrdinalColumn = ordinalColumn;
        this.mGetFinalOrdinal = new Select(datasource);
        this.mGetFinalOrdinal.field(this.mOrdinalColumn).from(this.mTable).orderBy(this.mOrdinalColumn, Select.DESC);
        this.mFreeMoveOrdinal = new Update(datasource);
        ((Update)this.mFreeMoveOrdinal.table(this.mTable).whereParameter(this.mOrdinalColumn, "current", "=")).fieldParameter(this.mOrdinalColumn, "new");
        this.mGetOrdinals = new Select(datasource);
        this.mGetOrdinals.field(this.mOrdinalColumn).from(this.mTable).orderBy(this.mOrdinalColumn, Select.ASC);
    }

    public OrdinalManager(Datasource datasource, String table, String ordinalColumn, String restrictColumn) {
        this(datasource, table, ordinalColumn);
        if (restrictColumn == null) {
            throw new IllegalArgumentException("restrictColumn can't be null");
        }
        this.mRestrictColumn = restrictColumn;
        this.mGetFinalOrdinalRestricted = new Select(this.mDatasource);
        ((Select)this.mGetFinalOrdinalRestricted.field(this.mOrdinalColumn).from(this.mTable).whereParameter(this.mRestrictColumn, "=")).orderBy(this.mOrdinalColumn, Select.DESC);
        this.mFreeMoveOrdinalRestricted = new Update(this.mDatasource);
        ((Update)((Update)this.mFreeMoveOrdinalRestricted.table(this.mTable).whereParameter(this.mRestrictColumn, "=")).whereParameterAnd(this.mOrdinalColumn, "current", "=")).fieldParameter(this.mOrdinalColumn, "new");
        this.mGetOrdinalsRestricted = new Select(this.mDatasource);
        ((Select)this.mGetOrdinalsRestricted.field(this.mOrdinalColumn).from(this.mTable).whereParameter(this.mRestrictColumn, "=")).orderBy(this.mOrdinalColumn, Select.ASC);
    }

    public String getTable() {
        return this.mTable;
    }

    public String getOrdinalColumn() {
        return this.mOrdinalColumn;
    }

    public String getRestrictColumn() {
        return this.mRestrictColumn;
    }

    public boolean move(Direction direction, int ordinal) {
        if (direction == UP) {
            return this.up(ordinal);
        }
        if (direction == DOWN) {
            return this.down(ordinal);
        }
        return false;
    }

    public boolean move(Direction direction, long restrictId, int ordinal) {
        if (direction == UP) {
            return this.up(restrictId, ordinal);
        }
        if (direction == DOWN) {
            return this.down(restrictId, ordinal);
        }
        return false;
    }

    public boolean up(int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 1(ordinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean up(long restrictId, int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 2(restrictId, ordinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean down(int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 3(ordinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean down(long restrictId, int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 4(restrictId, ordinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean move(int fromOrdinal, int toOrdinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 5(toOrdinal, fromOrdinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean move(long restrictId, int fromOrdinal, int toOrdinal) {
        if (fromOrdinal == toOrdinal) {
            return true;
        }
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 6(restrictId, toOrdinal, fromOrdinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean free(int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 8(ordinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean free(long restrictId, int ordinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 11(ordinal, restrictId));
        return result == null ? new Boolean(false) : result;
    }

    public boolean update(int currentOrdinal, int newOrdinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 13(currentOrdinal, newOrdinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean update(long restrictId, int currentOrdinal, int newOrdinal) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 15(restrictId, currentOrdinal, newOrdinal));
        return result == null ? new Boolean(false) : result;
    }

    public boolean tighten() {
        this.mDbQueryManager.inTransaction(new 16());
        return true;
    }

    public boolean tighten(long restrictId) {
        17 handler = new 17(this, restrictId, restrictId);
        this.mDbQueryManager.executeQuery((ReadQuery)this.mGetOrdinalsRestricted, (DbPreparedStatementHandler)handler);
        return handler.isTightened();
    }

    public int obtainInsertOrdinal() {
        return this.mDbQueryManager.executeGetFirstInt(this.mGetFinalOrdinal) + 1;
    }

    public int obtainInsertOrdinal(long restrictId) {
        int ordinal = this.mDbQueryManager.executeGetFirstInt(this.mGetFinalOrdinalRestricted, new 18(restrictId));
        return ordinal + 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Direction
    extends EnumClass<String> {
        Direction(String identifier) {
            super(identifier);
        }

        public static Direction getDirection(String name) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.cmf.dam.OrdinalManager$Direction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return (Direction)EnumClass.getMember(clazz, name);
        }
    }

    class 1
    extends DbTransactionUser {
        private final /* synthetic */ int val$ordinal;

        1(int n) {
            this.val$ordinal = n;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$ordinal - 1)) {
                this.rollback();
            }
            if (!OrdinalManager.this.update(this.val$ordinal + 1, this.val$ordinal - 1)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten()) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(1 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 2
    extends DbTransactionUser {
        private final /* synthetic */ long val$restrictId;
        private final /* synthetic */ int val$ordinal;

        2(long l, int n) {
            this.val$restrictId = l;
            this.val$ordinal = n;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$restrictId, this.val$ordinal - 1)) {
                this.rollback();
            }
            if (!OrdinalManager.this.update(this.val$restrictId, this.val$ordinal + 1, this.val$ordinal - 1)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten(this.val$restrictId)) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(2 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 3
    extends DbTransactionUser {
        private final /* synthetic */ int val$ordinal;

        3(int n) {
            this.val$ordinal = n;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$ordinal + 2)) {
                this.rollback();
            }
            if (!OrdinalManager.this.update(this.val$ordinal, this.val$ordinal + 2)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten()) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(3 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 4
    extends DbTransactionUser {
        private final /* synthetic */ long val$restrictId;
        private final /* synthetic */ int val$ordinal;

        4(long l, int n) {
            this.val$restrictId = l;
            this.val$ordinal = n;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$restrictId, this.val$ordinal + 2)) {
                this.rollback();
            }
            if (!OrdinalManager.this.update(this.val$restrictId, this.val$ordinal, this.val$ordinal + 2)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten(this.val$restrictId)) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(4 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 5
    extends DbTransactionUser {
        private final /* synthetic */ int val$toOrdinal;
        private final /* synthetic */ int val$fromOrdinal;

        5(int n, int n2) {
            this.val$toOrdinal = n;
            this.val$fromOrdinal = n2;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$toOrdinal)) {
                this.rollback();
            }
            int real_from = this.val$fromOrdinal;
            if (this.val$toOrdinal < this.val$fromOrdinal) {
                ++real_from;
            }
            if (!OrdinalManager.this.update(real_from, this.val$toOrdinal)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten()) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(5 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 6
    extends DbTransactionUser {
        private final /* synthetic */ long val$restrictId;
        private final /* synthetic */ int val$toOrdinal;
        private final /* synthetic */ int val$fromOrdinal;

        6(long l, int n, int n2) {
            this.val$restrictId = l;
            this.val$toOrdinal = n;
            this.val$fromOrdinal = n2;
        }

        public Boolean useTransaction() {
            if (!OrdinalManager.this.free(this.val$restrictId, this.val$toOrdinal)) {
                this.rollback();
            }
            int real_from = this.val$fromOrdinal;
            if (this.val$toOrdinal < this.val$fromOrdinal) {
                ++real_from;
            }
            if (!OrdinalManager.this.update(this.val$restrictId, real_from, this.val$toOrdinal)) {
                this.rollback();
            }
            if (!OrdinalManager.this.tighten(this.val$restrictId)) {
                this.rollback();
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(6 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 8
    extends DbTransactionUser {
        private final /* synthetic */ int val$ordinal;

        8(int n) {
            this.val$ordinal = n;
        }

        public Boolean useTransaction() {
            int last_ordinal;
            if (this.val$ordinal < 0) {
                return new Boolean(false);
            }
            int i = last_ordinal = OrdinalManager.this.mDbQueryManager.executeGetFirstInt(OrdinalManager.this.mGetFinalOrdinal);
            while (i >= this.val$ordinal) {
                int current_ordinal = i--;
                OrdinalManager.this.mDbQueryManager.executeUpdate(OrdinalManager.this.mFreeMoveOrdinal, new 7(current_ordinal));
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(8 var0) {
            return var0.OrdinalManager.this;
        }

        class 7
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$current_ordinal;

            7(int n) {
                this.val$current_ordinal = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("current", this.val$current_ordinal).setInt("new", this.val$current_ordinal + 1);
            }

            static /* synthetic */ 8 access$0(7 var0) {
                return var0.8.this;
            }
        }
    }

    class 11
    extends DbTransactionUser {
        private final /* synthetic */ int val$ordinal;
        private final /* synthetic */ long val$restrictId;

        11(int n, long l) {
            this.val$ordinal = n;
            this.val$restrictId = l;
        }

        public Boolean useTransaction() {
            int last_ordinal;
            if (this.val$ordinal < 0) {
                return new Boolean(false);
            }
            int i = last_ordinal = OrdinalManager.this.mDbQueryManager.executeGetFirstInt(OrdinalManager.this.mGetFinalOrdinalRestricted, new 9(this.val$restrictId));
            while (i >= this.val$ordinal) {
                int current_ordinal = i--;
                OrdinalManager.this.mDbQueryManager.executeUpdate(OrdinalManager.this.mFreeMoveOrdinalRestricted, new 10(this.val$restrictId, current_ordinal));
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 9
        extends DbPreparedStatementHandler {
            private final /* synthetic */ long val$restrictId;

            9(long l) {
                this.val$restrictId = l;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setLong(OrdinalManager.this.mRestrictColumn, this.val$restrictId);
            }

            static /* synthetic */ 11 access$0(9 var0) {
                return var0.11.this;
            }
        }

        class 10
        extends DbPreparedStatementHandler {
            private final /* synthetic */ long val$restrictId;
            private final /* synthetic */ int val$current_ordinal;

            10(long l, int n) {
                this.val$restrictId = l;
                this.val$current_ordinal = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setLong(OrdinalManager.this.mRestrictColumn, this.val$restrictId).setInt("current", this.val$current_ordinal).setInt("new", this.val$current_ordinal + 1);
            }

            static /* synthetic */ 11 access$0(10 var0) {
                return var0.11.this;
            }
        }
    }

    class 13
    extends DbTransactionUser {
        private final /* synthetic */ int val$currentOrdinal;
        private final /* synthetic */ int val$newOrdinal;

        13(int n, int n2) {
            this.val$currentOrdinal = n;
            this.val$newOrdinal = n2;
        }

        public Boolean useTransaction() {
            if (0 == OrdinalManager.this.mDbQueryManager.executeUpdate(OrdinalManager.this.mFreeMoveOrdinal, new 12(this.val$currentOrdinal, this.val$newOrdinal))) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ OrdinalManager access$0(13 var0) {
            return var0.OrdinalManager.this;
        }

        class 12
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$currentOrdinal;
            private final /* synthetic */ int val$newOrdinal;

            12(int n, int n2) {
                this.val$currentOrdinal = n;
                this.val$newOrdinal = n2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("current", this.val$currentOrdinal).setInt("new", this.val$newOrdinal);
            }

            static /* synthetic */ 13 access$0(12 var0) {
                return var0.13.this;
            }
        }
    }

    class 15
    extends DbTransactionUser {
        private final /* synthetic */ long val$restrictId;
        private final /* synthetic */ int val$currentOrdinal;
        private final /* synthetic */ int val$newOrdinal;

        15(long l, int n, int n2) {
            this.val$restrictId = l;
            this.val$currentOrdinal = n;
            this.val$newOrdinal = n2;
        }

        public Boolean useTransaction() {
            if (0 == OrdinalManager.this.mDbQueryManager.executeUpdate(OrdinalManager.this.mFreeMoveOrdinalRestricted, new 14(this.val$restrictId, this.val$currentOrdinal, this.val$newOrdinal))) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 14
        extends DbPreparedStatementHandler {
            private final /* synthetic */ long val$restrictId;
            private final /* synthetic */ int val$currentOrdinal;
            private final /* synthetic */ int val$newOrdinal;

            14(long l, int n, int n2) {
                this.val$restrictId = l;
                this.val$currentOrdinal = n;
                this.val$newOrdinal = n2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setLong(OrdinalManager.this.mRestrictColumn, this.val$restrictId).setInt("current", this.val$currentOrdinal).setInt("new", this.val$newOrdinal);
            }

            static /* synthetic */ 15 access$0(14 var0) {
                return var0.15.this;
            }
        }
    }

    class 16
    extends DbTransactionUserWithoutResult {
        16() {
        }

        public void useTransactionWithoutResult() {
            OrdinalManager.this.mDbQueryManager.executeQuery((ReadQuery)OrdinalManager.this.mGetOrdinals, (DbPreparedStatementHandler)new TightenResultSetHandler());
        }

        static /* synthetic */ OrdinalManager access$0(16 var0) {
            return var0.OrdinalManager.this;
        }
    }

    class 17
    extends TightenResultSetHandlerRestricted {
        private final /* synthetic */ long val$restrictId;

        17(OrdinalManager ordinalManager2, long l, long l2) {
            this.val$restrictId = l2;
            super(l);
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong(OrdinalManager.this.mRestrictColumn, this.val$restrictId);
        }

        static /* synthetic */ OrdinalManager access$0(17 var0) {
            return var0.OrdinalManager.this;
        }
    }

    private class TightenResultSetHandlerRestricted
    extends DbPreparedStatementHandler {
        private int mCount = 0;
        private long mRestrictId = -1;
        private boolean mTightened = false;

        public TightenResultSetHandlerRestricted(long restrictId) {
            this.mRestrictId = restrictId;
        }

        public Object concludeResults(DbResultSet resultset) throws SQLException {
            while (resultset.next()) {
                this.mTightened = true;
                int ordinal = resultset.getInt(OrdinalManager.this.mOrdinalColumn);
                OrdinalManager.this.update(this.mRestrictId, ordinal, this.mCount);
                ++this.mCount;
            }
            return null;
        }

        public boolean isTightened() {
            return this.mTightened;
        }

        static /* synthetic */ OrdinalManager access$0(TightenResultSetHandlerRestricted tightenResultSetHandlerRestricted) {
            return tightenResultSetHandlerRestricted.OrdinalManager.this;
        }
    }

    class 18
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$restrictId;

        18(long l) {
            this.val$restrictId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong(OrdinalManager.this.mRestrictColumn, this.val$restrictId);
        }

        static /* synthetic */ OrdinalManager access$0(18 var0) {
            return var0.OrdinalManager.this;
        }
    }

    private class TightenResultSetHandler
    extends DbPreparedStatementHandler {
        private int mCount = 0;

        public Object concludeResults(DbResultSet resultset) throws SQLException {
            while (resultset.next()) {
                int ordinal = resultset.getInt(OrdinalManager.this.mOrdinalColumn);
                OrdinalManager.this.update(ordinal, this.mCount);
                ++this.mCount;
            }
            return null;
        }

        static /* synthetic */ OrdinalManager access$0(TightenResultSetHandler tightenResultSetHandler) {
            return tightenResultSetHandler.OrdinalManager.this;
        }
    }
}

