/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam;

import com.uwyn.rife.cmf.CmfProperty;
import com.uwyn.rife.cmf.dam.ContentDataUser;
import com.uwyn.rife.cmf.dam.ContentManager;
import com.uwyn.rife.cmf.dam.OrdinalManager;
import com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentFactory;
import com.uwyn.rife.cmf.dam.exceptions.ContentManagerException;
import com.uwyn.rife.cmf.dam.exceptions.ExpectedMimeTypeConstraintException;
import com.uwyn.rife.cmf.dam.exceptions.ExpectedOrdinalConstraintException;
import com.uwyn.rife.cmf.dam.exceptions.InvalidOrdinalRestrictionTypeException;
import com.uwyn.rife.cmf.dam.exceptions.InvalidOrdinalTypeException;
import com.uwyn.rife.cmf.dam.exceptions.MissingIdentifierValueException;
import com.uwyn.rife.cmf.dam.exceptions.UnknownConstrainedPropertyException;
import com.uwyn.rife.cmf.dam.exceptions.UnknownOrdinalException;
import com.uwyn.rife.cmf.dam.exceptions.UnknownOrdinalRestrictionException;
import com.uwyn.rife.cmf.dam.exceptions.WrongConstrainedPropertyVariantException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManagerDelegate;
import com.uwyn.rife.database.querymanagers.generic.RestoreQuery;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.ClassUtils;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentQueryManager<T>
extends GenericQueryManagerDelegate<T>
implements Cloneable {
    private Class mClass = null;
    private Class mBackendClass = null;
    private DbQueryManager mDbQueryManager = null;
    private ContentManager mContentManager = null;

    static /* synthetic */ void access$S1000003(ContentQueryManager contentQueryManager, ContentManager contentManager) {
        contentQueryManager.mContentManager = contentManager;
    }

    public ContentQueryManager(Datasource datasource, Class<T> klass, Class backendClass) {
        super(datasource, klass, ClassUtils.shortenClassName(backendClass));
        this.mClass = klass;
        this.mBackendClass = backendClass;
        this.mDbQueryManager = new DbQueryManager(datasource);
        this.mContentManager = DatabaseContentFactory.getInstance(datasource);
    }

    public ContentQueryManager(Datasource datasource, Class<T> klass) {
        super(datasource, klass);
        this.mClass = klass;
        this.mBackendClass = klass;
        this.mDbQueryManager = new DbQueryManager(datasource);
        this.mContentManager = DatabaseContentFactory.getInstance(datasource);
    }

    public ContentQueryManager(Datasource datasource, Class<T> klass, ContentManager contentManager) {
        super(datasource, klass);
        this.mClass = klass;
        this.mContentManager = contentManager;
    }

    public ContentManager getContentManager() {
        return this.mContentManager;
    }

    public boolean move(Constrained bean, String propertyName, OrdinalManager.Direction direction) {
        if (bean == null) {
            throw new IllegalArgumentException("constrained can't be nul");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName can't be null");
        }
        if (0 == propertyName.length()) {
            throw new IllegalArgumentException("propertyName can't be empty");
        }
        ConstrainedProperty property = (ConstrainedProperty)bean.getConstrainedProperty(propertyName);
        if (property == null) {
            throw new UnknownConstrainedPropertyException(bean.getClass(), propertyName);
        }
        if (!(property instanceof CmfProperty)) {
            throw new WrongConstrainedPropertyVariantException(bean.getClass(), propertyName);
        }
        CmfProperty cmf_property = (CmfProperty)property;
        if (!cmf_property.isOrdinal()) {
            throw new ExpectedOrdinalConstraintException(bean.getClass(), propertyName);
        }
        int ordinal = -1;
        try {
            Object ordinal_object = BeanUtils.getPropertyValue(bean, propertyName);
            if (!(ordinal_object instanceof Integer)) {
                throw new InvalidOrdinalTypeException(bean.getClass(), propertyName);
            }
            ordinal = (Integer)ordinal_object;
        }
        catch (BeanUtilsException e) {
            throw new UnknownOrdinalException(bean.getClass(), propertyName);
        }
        OrdinalManager ordinals = null;
        if (cmf_property.hasOrdinalRestriction()) {
            String restriction_name = cmf_property.getOrdinalRestriction();
            ordinals = new OrdinalManager(this.getDatasource(), this.getTable(), propertyName, restriction_name);
            int restriction = -1;
            try {
                Object restriction_object = BeanUtils.getPropertyValue(bean, restriction_name);
                if (!(restriction_object instanceof Integer)) {
                    throw new InvalidOrdinalRestrictionTypeException(bean.getClass(), propertyName, restriction_name);
                }
                restriction = (Integer)restriction_object;
            }
            catch (BeanUtilsException e) {
                throw new UnknownOrdinalRestrictionException(bean.getClass(), propertyName, restriction_name);
            }
            return ordinals.move(direction, (long)restriction, ordinal);
        }
        ordinals = new OrdinalManager(this.getDatasource(), this.getTable(), propertyName);
        return ordinals.move(direction, ordinal);
    }

    public boolean up(Constrained bean, String propertyName) {
        return this.move(bean, propertyName, OrdinalManager.UP);
    }

    public boolean down(Constrained bean, String propertyName) {
        return this.move(bean, propertyName, OrdinalManager.DOWN);
    }

    public boolean storeEmptyContent(T bean, String propertyName) {
        if (bean == null) {
            throw new IllegalArgumentException("constrained can't be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName can't be null");
        }
        if (0 == propertyName.length()) {
            throw new IllegalArgumentException("propertyName can't be empty");
        }
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        if (constrained == null) {
            return false;
        }
        int id = this.getIdentifierValue(bean);
        if (-1 == id) {
            throw new MissingIdentifierValueException(bean.getClass(), this.getIdentifierName());
        }
        ConstrainedProperty property = (ConstrainedProperty)constrained.getConstrainedProperty(propertyName);
        if (property == null) {
            throw new UnknownConstrainedPropertyException(bean.getClass(), propertyName);
        }
        if (!(property instanceof CmfProperty)) {
            throw new WrongConstrainedPropertyVariantException(bean.getClass(), propertyName);
        }
        CmfProperty cmf_property = (CmfProperty)property;
        if (!cmf_property.hasMimeType()) {
            throw new ExpectedMimeTypeConstraintException(bean.getClass(), propertyName);
        }
        try {
            Content content = new Content(cmf_property.getMimeType(), null).fragment(cmf_property.isFragment()).name(cmf_property.getName()).attributes(cmf_property.getContentAttributes()).cachedLoadedData(cmf_property.getCachedLoadedData());
            return this.mContentManager.storeContent(this.buildCmfPath(constrained, id, cmf_property.getPropertyName()), content, cmf_property.getTransformer());
        }
        catch (ContentManagerException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int save(T bean) {
        Integer id = (Integer)this.mDbQueryManager.inTransaction(new 1(bean));
        return id;
    }

    @Override
    public T restore(int objectId) {
        Object bean = super.restore(objectId);
        if (bean != null) {
            this.restoreContent(objectId, bean);
        }
        return bean;
    }

    @Override
    public T restoreFirst(RestoreQuery query) {
        Object bean = super.restoreFirst(query);
        if (bean != null) {
            this.restoreContent(this.getIdentifierValue(bean), bean);
        }
        return bean;
    }

    @Override
    public List<T> restore() {
        List beans = super.restore();
        for (Object bean : (Collection)beans) {
            if (bean == null) continue;
            this.restoreContent(this.getIdentifierValue(bean), bean);
        }
        return beans;
    }

    @Override
    public List<T> restore(RestoreQuery query) {
        List beans = super.restore(query);
        for (Object bean : (Collection)beans) {
            if (bean == null) continue;
            this.restoreContent(this.getIdentifierValue(bean), bean);
        }
        return beans;
    }

    private void restoreContent(int objectId, T bean) {
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        if (constrained != null) {
            Collection properties = constrained.getConstrainedProperties();
            CmfProperty cmf_property = null;
            for (ConstrainedProperty property : properties) {
                if (!(property instanceof CmfProperty) || !(cmf_property = (CmfProperty)property).hasMimeType() || !cmf_property.isAutoRetrieved()) continue;
                this.mContentManager.useContentData(this.buildCmfPath(constrained, objectId, cmf_property.getPropertyName()), new 2(property, bean));
            }
        }
    }

    @Override
    public boolean delete(int objectId) {
        Boolean result = (Boolean)this.mDbQueryManager.inTransaction(new 3(objectId));
        return result == null ? false : result;
    }

    public boolean hasContent(T bean, String propertyName) {
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        return this.hasContent(constrained, this.getIdentifierValue(bean), propertyName);
    }

    public boolean hasContent(int objectId, String propertyName) {
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(this.mClass);
        return this.hasContent(constrained, objectId, propertyName);
    }

    private boolean hasContent(Constrained constrained, int objectId, String propertyName) {
        try {
            return this.mContentManager.hasContentData(this.buildCmfPath(constrained, objectId, propertyName));
        }
        catch (ContentManagerException e) {
            throw new DatabaseException(e);
        }
    }

    public String buildCmfPath(T bean, String propertyName) {
        Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
        return this.buildCmfPath(constrained, this.getIdentifierValue(bean), propertyName);
    }

    public String buildCmfPath(int objectId, String propertyName) {
        Constrained constrained = ConstrainedUtils.getConstrainedInstance(this.mClass);
        return this.buildCmfPath(constrained, objectId, propertyName);
    }

    private String buildCmfPath(Constrained constrained, int objectId, String propertyName) {
        StringBuffer path;
        ConstrainedProperty property;
        String repository = null;
        if (constrained != null && (property = (ConstrainedProperty)constrained.getConstrainedProperty(propertyName)) instanceof CmfProperty) {
            repository = ((CmfProperty)property).getRepository();
        }
        StringBuffer stringBuffer = path = new StringBuffer("");
        synchronized (stringBuffer) {
            if (repository != null) {
                path.append(repository);
                path.append(":");
            }
            path.append("/");
            String classname = this.mBackendClass.getName();
            classname = classname.substring(classname.lastIndexOf(".") + 1);
            path.append(StringUtils.encodeUrl(classname));
            path.append("/");
            path.append(objectId);
            path.append("/");
            path.append(StringUtils.encodeUrl(propertyName));
            return path.toString().toLowerCase();
        }
    }

    public String getContentForHtml(T bean, String propertyName, ElementInfo serveContentInfo) {
        return this.getContentManager().getContentForHtml(this.buildCmfPath(bean, propertyName), serveContentInfo);
    }

    public String getContentForHtml(int objectId, String propertyName, ElementInfo serveContentInfo) {
        return this.getContentManager().getContentForHtml(this.buildCmfPath(objectId, propertyName), serveContentInfo);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    class 1
    extends DbTransactionUser {
        private final /* synthetic */ Object val$bean;

        1(Object object) {
            this.val$bean = object;
        }

        public Integer useTransaction() {
            ConstrainedProperty property;
            Iterator iterator;
            int id = -1;
            boolean update2 = false;
            id = ContentQueryManager.this.getIdentifierValue(this.val$bean);
            if (id >= 0) {
                update2 = true;
            }
            Constrained constrained = ConstrainedUtils.makeConstrainedInstance(this.val$bean);
            Collection properties = null;
            CmfProperty cmf_property = null;
            Object value = null;
            if (constrained != null) {
                properties = constrained.getConstrainedProperties();
                iterator = properties.iterator();
                while (iterator.hasNext()) {
                    property = (ConstrainedProperty)iterator.next();
                    if (!(property instanceof CmfProperty)) continue;
                    cmf_property = (CmfProperty)property;
                    if (update2 || !cmf_property.isOrdinal()) continue;
                    try {
                        OrdinalManager ordinals = null;
                        int new_ordinal = -1;
                        if (cmf_property.hasOrdinalRestriction()) {
                            String restriction_name = cmf_property.getOrdinalRestriction();
                            ordinals = new OrdinalManager(ContentQueryManager.this.getDatasource(), ContentQueryManager.this.getTable(), cmf_property.getPropertyName(), restriction_name);
                            long restriction = -1;
                            try {
                                Object restriction_object = BeanUtils.getPropertyValue(this.val$bean, restriction_name);
                                if (!(restriction_object instanceof Number)) {
                                    throw new InvalidOrdinalRestrictionTypeException(this.val$bean.getClass(), cmf_property.getPropertyName(), restriction_name);
                                }
                                restriction = ((Number)restriction_object).longValue();
                            }
                            catch (BeanUtilsException e) {
                                throw new UnknownOrdinalRestrictionException(this.val$bean.getClass(), cmf_property.getPropertyName(), restriction_name);
                            }
                            new_ordinal = ordinals.obtainInsertOrdinal(restriction);
                        } else {
                            ordinals = new OrdinalManager(ContentQueryManager.this.getDatasource(), ContentQueryManager.this.getTable(), cmf_property.getPropertyName());
                            new_ordinal = ordinals.obtainInsertOrdinal();
                        }
                        BeanUtils.setPropertyValue(this.val$bean, cmf_property.getPropertyName(), new Integer(new_ordinal));
                    }
                    catch (BeanUtilsException e) {
                        throw new DatabaseException(e);
                    }
                }
            }
            id = ContentQueryManager.super.save(this.val$bean);
            if (properties != null) {
                iterator = properties.iterator();
                while (iterator.hasNext()) {
                    property = (ConstrainedProperty)iterator.next();
                    if (!(property instanceof CmfProperty) || !(cmf_property = (CmfProperty)property).hasMimeType()) continue;
                    try {
                        value = BeanUtils.getPropertyValue(this.val$bean, property.getPropertyName());
                        if (value == null && !cmf_property.isAutoRetrieved()) continue;
                        Content content = new Content(cmf_property.getMimeType(), value).fragment(cmf_property.isFragment()).name(cmf_property.getName()).attributes(cmf_property.getContentAttributes()).cachedLoadedData(cmf_property.getCachedLoadedData());
                        ContentQueryManager.this.mContentManager.storeContent(ContentQueryManager.this.buildCmfPath(constrained, id, cmf_property.getPropertyName()), content, cmf_property.getTransformer());
                    }
                    catch (BeanUtilsException e) {
                        throw new DatabaseException(e);
                    }
                    catch (ContentManagerException e) {
                        throw new DatabaseException(e);
                    }
                }
            }
            return new Integer(id);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ ContentQueryManager access$0(1 var0) {
            return var0.ContentQueryManager.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 2
    extends ContentDataUser<Object, ConstrainedProperty> {
        private final /* synthetic */ Object val$bean;

        2(Object object, Object object2) {
            this.val$bean = object2;
            super(object);
        }

        @Override
        public Object useContentData(Object contentData) {
            try {
                BeanUtils.setPropertyValue(this.val$bean, ((ConstrainedProperty)this.getData()).getPropertyName(), contentData);
            }
            catch (BeanUtilsException e) {
                throw new DatabaseException(e);
            }
            catch (ContentManagerException e) {
                throw new DatabaseException(e);
            }
            return null;
        }

        static /* synthetic */ ContentQueryManager access$0(2 var0) {
            return var0.ContentQueryManager.this;
        }
    }

    class 3
    extends DbTransactionUser {
        private final /* synthetic */ int val$objectId;

        3(int n) {
            this.val$objectId = n;
        }

        public Boolean useTransaction() {
            Object bean = ContentQueryManager.this.restore(this.val$objectId);
            if (bean == null) {
                return new Boolean(false);
            }
            if (ContentQueryManager.super.delete(this.val$objectId)) {
                Constrained constrained = ConstrainedUtils.makeConstrainedInstance(bean);
                if (constrained != null) {
                    Collection properties = constrained.getConstrainedProperties();
                    CmfProperty cmf_property = null;
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext()) {
                        ConstrainedProperty property = (ConstrainedProperty)iterator.next();
                        if (!(property instanceof CmfProperty)) continue;
                        cmf_property = (CmfProperty)property;
                        if (cmf_property.hasMimeType()) {
                            ContentQueryManager.this.mContentManager.deleteContent(ContentQueryManager.this.buildCmfPath(constrained, this.val$objectId, cmf_property.getPropertyName()));
                            continue;
                        }
                        if (!cmf_property.isOrdinal()) continue;
                        OrdinalManager ordinals = null;
                        if (cmf_property.hasOrdinalRestriction()) {
                            String restriction_name = cmf_property.getOrdinalRestriction();
                            ordinals = new OrdinalManager(ContentQueryManager.this.getDatasource(), ContentQueryManager.this.getTable(), cmf_property.getPropertyName(), restriction_name);
                            int restriction = -1;
                            try {
                                Object restriction_object = BeanUtils.getPropertyValue(bean, restriction_name);
                                if (!(restriction_object instanceof Integer)) {
                                    throw new InvalidOrdinalRestrictionTypeException(bean.getClass(), cmf_property.getPropertyName(), restriction_name);
                                }
                                restriction = (Integer)restriction_object;
                            }
                            catch (BeanUtilsException e) {
                                throw new UnknownOrdinalRestrictionException(bean.getClass(), cmf_property.getPropertyName(), restriction_name);
                            }
                            ordinals.tighten(restriction);
                            continue;
                        }
                        ordinals = new OrdinalManager(ContentQueryManager.this.getDatasource(), ContentQueryManager.this.getTable(), cmf_property.getPropertyName());
                        ordinals.tighten();
                    }
                }
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ ContentQueryManager access$0(3 var0) {
            return var0.ContentQueryManager.this;
        }
    }
}

