/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.tools.Convert;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmfProperty
extends ConstrainedProperty<CmfProperty> {
    public static final String LISTED = "LISTED";
    public static final String POSITION = "POSITION";
    public static final String MIMETYPE = "MIMETYPE";
    public static final String AUTO_RETRIEVED = "AUTO_RETRIEVED";
    public static final String FRAGMENT = "FRAGMENT";
    public static final String NAME = "NAME";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String ORDINAL = "ORDINAL";
    public static final String ORDINAL_RESTRICTION = "ORDINAL_RESTRICTION";
    public static final String CONTENT_ATTRIBUTES = "CONTENT_ATTRIBUTES";
    public static final String TRANSFORMER = "TRANSFORMER";
    public static final String CACHED_LOADED_DATA = "CACHED_LOADED_DATA";

    public CmfProperty(String propertyName) {
        super(propertyName);
    }

    public CmfProperty listed(boolean listed) {
        this.setListed(listed);
        return this;
    }

    public void setListed(boolean listed) {
        this.mConstraints.put(LISTED, new Boolean(listed));
    }

    public boolean isListed() {
        return Convert.toBoolean(this.mConstraints.get(LISTED), false);
    }

    public CmfProperty position(int position) {
        this.setPosition(position);
        return this;
    }

    public void setPosition(int position) {
        if (position < 0) {
            this.mConstraints.remove(POSITION);
        } else {
            this.mConstraints.put(POSITION, new Integer(position));
        }
    }

    public boolean hasPosition() {
        return this.mConstraints.containsKey(POSITION);
    }

    public int getPosition() {
        return Convert.toInt(this.mConstraints.get(POSITION), -1);
    }

    public CmfProperty mimeType(MimeType mimeType) {
        this.setMimeType(mimeType);
        return this;
    }

    public void setMimeType(MimeType mimeType) {
        if (mimeType == null) {
            this.mConstraints.remove(MIMETYPE);
        } else {
            this.mConstraints.put(MIMETYPE, mimeType);
            this.persistent(false);
            this.displayedRaw(true);
        }
    }

    public boolean hasMimeType() {
        return this.mConstraints.containsKey(MIMETYPE);
    }

    public MimeType getMimeType() {
        return (MimeType)this.mConstraints.get(MIMETYPE);
    }

    @Override
    public void setPersistent(boolean persistent) {
        if (this.hasMimeType() && persistent) {
            throw new IllegalArgumentException("Can't make a property persistent that has a content mime type assigned to it.");
        }
        super.setPersistent(persistent);
    }

    @Override
    public void setDisplayedRaw(boolean displayedRaw) {
        if (this.hasMimeType() && !displayedRaw) {
            throw new IllegalArgumentException("Can't make a property not being displayed raw that has a content mime type assigned to it.");
        }
        super.setDisplayedRaw(displayedRaw);
    }

    public CmfProperty autoRetrieved(boolean autoRetrieved) {
        this.setAutoRetrieved(autoRetrieved);
        return this;
    }

    public void setAutoRetrieved(boolean autoRetrieved) {
        this.mConstraints.put(AUTO_RETRIEVED, new Boolean(autoRetrieved));
    }

    public boolean isAutoRetrieved() {
        return Convert.toBoolean(this.mConstraints.get(AUTO_RETRIEVED), false);
    }

    public CmfProperty fragment(boolean fragment) {
        this.setFragment(fragment);
        return this;
    }

    public void setFragment(boolean fragment) {
        this.mConstraints.put(FRAGMENT, new Boolean(fragment));
    }

    public boolean isFragment() {
        return Convert.toBoolean(this.mConstraints.get(FRAGMENT), false);
    }

    public CmfProperty name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        if (name == null) {
            this.mConstraints.remove(NAME);
        } else {
            this.mConstraints.put(NAME, name);
        }
    }

    public String getName() {
        return (String)this.mConstraints.get(NAME);
    }

    public boolean hasName() {
        return this.mConstraints.containsKey(NAME);
    }

    public CmfProperty repository(String repository) {
        this.setRepository(repository);
        return this;
    }

    public void setRepository(String repository) {
        if (repository == null) {
            this.mConstraints.remove(REPOSITORY);
        } else {
            this.mConstraints.put(REPOSITORY, repository);
        }
    }

    public String getRepository() {
        return (String)this.mConstraints.get(REPOSITORY);
    }

    public boolean hasRepository() {
        return this.mConstraints.containsKey(REPOSITORY);
    }

    public CmfProperty ordinal(boolean ordinal) {
        this.setOrdinal(ordinal);
        return this;
    }

    public CmfProperty ordinal(boolean ordinal, String restriction) {
        this.setOrdinal(ordinal, restriction);
        return this;
    }

    public void setOrdinal(boolean ordinal) {
        this.mConstraints.put(ORDINAL, new Boolean(ordinal));
        this.mConstraints.remove(ORDINAL_RESTRICTION);
    }

    public void setOrdinal(boolean ordinal, String restriction) {
        this.mConstraints.put(ORDINAL, new Boolean(ordinal));
        if (ordinal) {
            if (restriction == null) {
                this.mConstraints.remove(ORDINAL_RESTRICTION);
            } else {
                this.mConstraints.put(ORDINAL_RESTRICTION, restriction);
            }
        } else {
            this.mConstraints.remove(ORDINAL_RESTRICTION);
        }
    }

    public boolean isOrdinal() {
        return Convert.toBoolean(this.mConstraints.get(ORDINAL), false);
    }

    public boolean hasOrdinalRestriction() {
        return this.mConstraints.containsKey(ORDINAL_RESTRICTION);
    }

    public String getOrdinalRestriction() {
        return (String)this.mConstraints.get(ORDINAL_RESTRICTION);
    }

    public CmfProperty contentAttribute(String name, boolean value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, char value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, byte value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, short value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, int value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, long value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, float value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, double value) {
        return this.contentAttribute(name, String.valueOf(value));
    }

    public CmfProperty contentAttribute(String name, String value) {
        HashMap<String, String> content_attributes = (HashMap<String, String>)this.mConstraints.get(CONTENT_ATTRIBUTES);
        if (content_attributes == null) {
            content_attributes = new HashMap<String, String>();
            this.mConstraints.put(CONTENT_ATTRIBUTES, content_attributes);
        }
        content_attributes.put(name, value);
        return this;
    }

    public Map<String, String> getContentAttributes() {
        return (HashMap)this.mConstraints.get(CONTENT_ATTRIBUTES);
    }

    public CmfProperty transformer(ContentTransformer transformer) {
        this.setTransformer(transformer);
        return this;
    }

    public void setTransformer(ContentTransformer transformer) {
        if (transformer == null) {
            this.mConstraints.remove(TRANSFORMER);
        } else {
            this.mConstraints.put(TRANSFORMER, transformer);
        }
    }

    public boolean hasTransformer() {
        return this.mConstraints.containsKey(TRANSFORMER);
    }

    public ContentTransformer getTransformer() {
        return (ContentTransformer)this.mConstraints.get(TRANSFORMER);
    }

    public void setCachedLoadedData(Object data) {
        if (data == null) {
            this.mConstraints.remove(CACHED_LOADED_DATA);
        } else {
            this.mConstraints.put(CACHED_LOADED_DATA, data);
        }
    }

    public Object getCachedLoadedData() {
        return this.mConstraints.get(CACHED_LOADED_DATA);
    }

    static /* synthetic */ HashMap access$Lcom$uwyn$rife$site$ConstrainedProperty$27(CmfProperty cmfProperty) {
        return cmfProperty.mConstraints;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$site$ConstrainedProperty$27(CmfProperty cmfProperty, HashMap hashMap) {
        cmfProperty.mConstraints = hashMap;
    }
}

