/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.sessionvalidators;

import com.uwyn.rife.authentication.CredentialsManager;
import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.SessionAttributes;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.SessionValidator;
import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.authentication.exceptions.SessionValidatorException;
import com.uwyn.rife.authentication.sessionvalidators.exceptions.RoleCheckErrorException;
import com.uwyn.rife.authentication.sessionvalidators.exceptions.SessionValidityCheckErrorException;

public class MixedSessionValidator
implements SessionValidator {
    public static final int SESSION_INVALID = 0;
    public static final int SESSION_VALID = 1;
    protected CredentialsManager mCredentialsManager = null;
    protected SessionManager mSessionManager = null;
    protected RememberManager mRememberManager = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        if (!$assertionsDisabled && credentialsManager == null) {
            throw new AssertionError();
        }
        this.mCredentialsManager = credentialsManager;
    }

    public CredentialsManager getCredentialsManager() {
        return this.mCredentialsManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (!$assertionsDisabled && sessionManager == null) {
            throw new AssertionError();
        }
        this.mSessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public void setRememberManager(RememberManager rememberManager) {
        if (!$assertionsDisabled && rememberManager == null) {
            throw new AssertionError();
        }
        this.mRememberManager = rememberManager;
    }

    public RememberManager getRememberManager() {
        return this.mRememberManager;
    }

    public boolean isAccessAuthorized(int id) {
        return 1 == id;
    }

    public int validateSession(String authId, String hostIp, SessionAttributes attributes) throws SessionValidatorException {
        if (authId == null || 0 == authId.length() || hostIp == null || 0 == hostIp.length() || attributes == null) {
            return 0;
        }
        SessionManager sessions = this.getSessionManager();
        try {
            if (!sessions.isSessionValid(authId, hostIp)) {
                return 0;
            }
        }
        catch (SessionManagerException e) {
            throw new SessionValidityCheckErrorException(authId, hostIp, e);
        }
        if (attributes.hasAttribute("role")) {
            long user_id = -1;
            String role = attributes.getAttribute("role");
            try {
                user_id = sessions.getSessionUserId(authId);
            }
            catch (SessionManagerException e) {
                user_id = -1;
            }
            if ((long)-1 == user_id) {
                return 0;
            }
            try {
                if (!((DatabaseUsers)this.mCredentialsManager).isUserInRole(user_id, attributes.getAttribute("role"))) {
                    return 0;
                }
            }
            catch (CredentialsManagerException e) {
                throw new RoleCheckErrorException(authId, hostIp, role, e);
            }
            return 1;
        }
        return 1;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.sessionvalidators.MixedSessionValidator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

