/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.sessionvalidators;

import com.uwyn.rife.authentication.CredentialsManager;
import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.SessionAttributes;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.SessionValidator;
import com.uwyn.rife.authentication.exceptions.SessionValidatorException;
import com.uwyn.rife.authentication.sessionvalidators.ProcessSessionValidity;
import com.uwyn.rife.authentication.sessionvalidators.exceptions.SessionValidityCheckErrorException;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.Select;

public abstract class DatabaseSessionValidator
extends DbQueryManager
implements SessionValidator {
    public static final int SESSION_INVALID = 0;
    public static final int SESSION_VALID = 1;
    protected CredentialsManager mCredentialsManager = null;
    protected SessionManager mSessionManager = null;
    protected RememberManager mRememberManager = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseSessionValidator(Datasource datasource) {
        super(datasource);
    }

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        if (!$assertionsDisabled && credentialsManager == null) {
            throw new AssertionError();
        }
        this.mCredentialsManager = credentialsManager;
    }

    public CredentialsManager getCredentialsManager() {
        return this.mCredentialsManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (!$assertionsDisabled && sessionManager == null) {
            throw new AssertionError();
        }
        this.mSessionManager = sessionManager;
    }

    public void setRememberManager(RememberManager rememberManager) {
        if (!$assertionsDisabled && rememberManager == null) {
            throw new AssertionError();
        }
        this.mRememberManager = rememberManager;
    }

    public RememberManager getRememberManager() {
        return this.mRememberManager;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public boolean isAccessAuthorized(int id) {
        return 1 == id;
    }

    protected int _validateSession(Select sessionValidityNoRole, Select sessionValidityRole, ProcessSessionValidity processSessionValidity, String authId, String hostIp, SessionAttributes attributes) throws SessionValidatorException {
        if (!$assertionsDisabled && sessionValidityRole == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length() || hostIp == null || 0 == hostIp.length() || attributes == null) {
            return 0;
        }
        int result = 0;
        Select query = null;
        query = attributes.hasAttribute("role") ? sessionValidityRole : sessionValidityNoRole;
        try {
            this.executeFetchFirst(query, processSessionValidity, new 1(authId, hostIp, attributes));
            result = processSessionValidity.getValidity();
        }
        catch (DatabaseException e) {
            throw new SessionValidityCheckErrorException(authId, hostIp, e);
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.sessionvalidators.DatabaseSessionValidator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;
        private final /* synthetic */ String val$hostIp;
        private final /* synthetic */ SessionAttributes val$attributes;

        1(String string, String string2, SessionAttributes sessionAttributes) {
            this.val$authId = string;
            this.val$hostIp = string2;
            this.val$attributes = sessionAttributes;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$authId).setString("hostIp", this.val$hostIp).setLong("sessStart", System.currentTimeMillis() - DatabaseSessionValidator.this.mSessionManager.getSessionDuration());
            if (this.val$attributes.hasAttribute("role")) {
                statement.setString("role", this.val$attributes.getAttribute("role"));
            }
        }

        static /* synthetic */ DatabaseSessionValidator access$0(1 var0) {
            return var0.DatabaseSessionValidator.this;
        }
    }
}

