/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.sessionmanagers;

import com.uwyn.rife.authentication.ListSessions;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.config.RifeConfig;
import java.util.Random;

public class PurgingSessionManager
implements SessionManager {
    private int mSessionPurgeFrequency = RifeConfig.Authentication.getSessionPurgeFrequency();
    private int mSessionPurgeScale = RifeConfig.Authentication.getSessionPurgeScale();
    private Random mRandom = new Random();
    private SessionManager mSessionManager = null;

    public PurgingSessionManager(SessionManager sessionManager) {
        if (sessionManager == null) {
            throw new IllegalArgumentException("sessionManager can't be null");
        }
        this.mSessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public int getSessionPurgeFrequency() {
        return this.mSessionPurgeFrequency;
    }

    public void setSessionPurgeFrequency(int frequency) {
        this.mSessionPurgeFrequency = frequency;
    }

    public int getSessionPurgeScale() {
        return this.mSessionPurgeScale;
    }

    public void setSessionPurgeScale(int scale) {
        this.mSessionPurgeScale = scale;
    }

    public String startSession(long userId, String hostIp, boolean remembered) throws SessionManagerException {
        int purge_decision = -1;
        Random random = this.mRandom;
        synchronized (random) {
            purge_decision = this.mRandom.nextInt(this.mSessionPurgeScale);
        }
        if (purge_decision <= this.mSessionPurgeFrequency) {
            this.purgeSessions();
        }
        return this.mSessionManager.startSession(userId, hostIp, remembered);
    }

    public void setSessionDuration(long milliseconds) {
        this.mSessionManager.setSessionDuration(milliseconds);
    }

    public long getSessionDuration() {
        return this.mSessionManager.getSessionDuration();
    }

    public void eraseAllSessions() throws SessionManagerException {
        this.mSessionManager.eraseAllSessions();
    }

    public boolean isSessionValid(String authId, String hostIp) throws SessionManagerException {
        return this.mSessionManager.isSessionValid(authId, hostIp);
    }

    public boolean continueSession(String authId) throws SessionManagerException {
        return this.mSessionManager.continueSession(authId);
    }

    public long getSessionUserId(String authId) throws SessionManagerException {
        return this.mSessionManager.getSessionUserId(authId);
    }

    public void purgeSessions() throws SessionManagerException {
        this.mSessionManager.purgeSessions();
    }

    public boolean eraseSession(String authId) throws SessionManagerException {
        return this.mSessionManager.eraseSession(authId);
    }

    public boolean wasRemembered(String authId) throws SessionManagerException {
        return this.mSessionManager.wasRemembered(authId);
    }

    public boolean eraseUserSessions(long userId) throws SessionManagerException {
        return this.mSessionManager.eraseUserSessions(userId);
    }

    public long countSessions() throws SessionManagerException {
        return this.mSessionManager.countSessions();
    }

    public boolean listSessions(ListSessions processor) throws SessionManagerException {
        return this.mSessionManager.listSessions(processor);
    }
}

