/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.sessionmanagers;

import com.uwyn.rife.authentication.ListSessions;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.authentication.sessionmanagers.MemorySession;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.StartSessionErrorException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.tools.UniqueID;
import com.uwyn.rife.tools.UniqueIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MemorySessions
implements SessionManager {
    private long mSessionDuration = RifeConfig.Authentication.getSessionDuration();
    private HashMap<String, MemorySession> mSessions = new HashMap();

    static /* synthetic */ void access$S1000001(MemorySessions memorySessions, HashMap hashMap) {
        memorySessions.mSessions = hashMap;
    }

    MemorySessions() {
    }

    public long getSessionDuration() {
        return this.mSessionDuration;
    }

    public void setSessionDuration(long milliseconds) {
        this.mSessionDuration = milliseconds;
    }

    public void purgeSessions() {
        new PurgeSessions().start();
    }

    public String startSession(long userId, String hostIp, boolean remembered) throws SessionManagerException {
        if (userId < (long)0 || hostIp == null || 0 == hostIp.length()) {
            throw new StartSessionErrorException(userId, hostIp);
        }
        UniqueID auth_id = UniqueIDGenerator.generate(hostIp);
        String auth_id_string = auth_id.toString();
        MemorySession session = new MemorySession(auth_id_string, userId, hostIp, remembered);
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            this.mSessions.put(auth_id_string, session);
        }
        return auth_id_string;
    }

    public boolean isSessionValid(String authId, String hostIp) throws SessionManagerException {
        if (authId == null || 0 == authId.length() || hostIp == null || 0 == hostIp.length()) {
            return false;
        }
        MemorySession session = this.getSession(authId);
        return session != null && session.getHostIp().equals(hostIp) && session.getStart() > System.currentTimeMillis() - this.getSessionDuration();
    }

    public long getSessionUserId(String authId) throws SessionManagerException {
        MemorySession session = this.mSessions.get(authId);
        if (session == null) {
            return -1;
        }
        return session.getUserId();
    }

    public boolean continueSession(String authId) throws SessionManagerException {
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            if (this.mSessions.containsKey(authId)) {
                MemorySession session = this.mSessions.get(authId);
                session.setStart(System.currentTimeMillis());
                this.mSessions.put(authId, session);
                return true;
            }
        }
        return false;
    }

    public boolean eraseSession(String authId) throws SessionManagerException {
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            if (this.mSessions.containsKey(authId)) {
                this.mSessions.remove(authId);
                return true;
            }
        }
        return false;
    }

    public boolean wasRemembered(String authId) throws SessionManagerException {
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            MemorySession session = this.mSessions.get(authId);
            if (session == null) {
                return false;
            }
            return session.getRemembered();
        }
    }

    public boolean eraseUserSessions(long userId) throws SessionManagerException {
        if (userId < (long)0) {
            return false;
        }
        boolean result = false;
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            ArrayList<String> sessions_to_erase = new ArrayList<String>();
            Iterator iterator = ((Collection)this.mSessions.entrySet()).iterator();
            while (iterator.hasNext()) {
                Map.Entry sessions_entry = (Map.Entry)iterator.next();
                if (userId != ((MemorySession)sessions_entry.getValue()).getUserId()) continue;
                sessions_to_erase.add((String)sessions_entry.getKey());
            }
            Iterator iterator2 = ((Collection)sessions_to_erase).iterator();
            while (iterator2.hasNext()) {
                String authid = (String)iterator2.next();
                this.mSessions.remove(authid);
            }
            if (sessions_to_erase.size() > 0) {
                result = true;
            }
        }
        return result;
    }

    public void eraseAllSessions() throws SessionManagerException {
        this.mSessions.clear();
    }

    public MemorySession getSession(String authId) {
        return this.mSessions.get(authId);
    }

    public long countSessions() {
        long valid_session_count = 0;
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            long expiration = System.currentTimeMillis() - this.getSessionDuration();
            Iterator<MemorySession> iterator = this.mSessions.values().iterator();
            while (iterator.hasNext()) {
                MemorySession session = iterator.next();
                if (session.getStart() <= expiration) continue;
                ++valid_session_count;
            }
        }
        return valid_session_count;
    }

    public boolean listSessions(ListSessions processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor can't be null");
        }
        boolean result = false;
        HashMap<String, MemorySession> hashMap = this.mSessions;
        synchronized (hashMap) {
            long expiration = System.currentTimeMillis() - this.getSessionDuration();
            Iterator<MemorySession> iterator = this.mSessions.values().iterator();
            while (iterator.hasNext()) {
                MemorySession session = iterator.next();
                if (session.getStart() <= expiration) continue;
                result = true;
                if (!processor.foundSession(session.getUserId(), session.getHostIp(), session.getAuthId())) break;
            }
        }
        return result;
    }

    private class PurgeSessions
    extends Thread {
        public void run() {
            ArrayList<String> stale_sessions = new ArrayList<String>();
            try {
                long expiration = System.currentTimeMillis() - MemorySessions.this.getSessionDuration();
                Iterator iterator = MemorySessions.this.mSessions.values().iterator();
                while (iterator.hasNext()) {
                    MemorySession session = (MemorySession)iterator.next();
                    if (session.getStart() > expiration) continue;
                    stale_sessions.add(session.getAuthId());
                }
            }
            catch (ConcurrentModificationException e) {
                int old_priority = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                try {
                    PurgeSessions purgeSessions = this;
                    synchronized (purgeSessions) {
                        stale_sessions = null;
                        MemorySessions.this.purgeSessions();
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var8_9
                    }
                }
                finally {
                    Thread.currentThread().setPriority(old_priority);
                }
            }
            if (stale_sessions != null) {
                Iterator iterator = ((Collection)stale_sessions).iterator();
                while (iterator.hasNext()) {
                    String authid = (String)iterator.next();
                    MemorySessions.this.mSessions.remove(authid);
                }
            }
        }

        static /* synthetic */ MemorySessions access$0(PurgeSessions purgeSessions) {
            return purgeSessions.MemorySessions.this;
        }
    }
}

