/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.remembermanagers;

import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.exceptions.RememberManagerException;
import com.uwyn.rife.config.RifeConfig;
import java.util.Random;

public class PurgingRememberManager
implements RememberManager {
    private int mRememberPurgeFrequency = RifeConfig.Authentication.getRememberPurgeFrequency();
    private int mRememberPurgeScale = RifeConfig.Authentication.getRememberPurgeScale();
    private Random mRandom = new Random();
    private RememberManager mRememberManager = null;

    public PurgingRememberManager(RememberManager rememberManager) {
        if (rememberManager == null) {
            throw new IllegalArgumentException("rememberManager can't be null");
        }
        this.mRememberManager = rememberManager;
    }

    public RememberManager getRememberManager() {
        return this.mRememberManager;
    }

    public int getRememberPurgeFrequency() {
        return this.mRememberPurgeFrequency;
    }

    public void setRememberPurgeFrequency(int frequency) {
        this.mRememberPurgeFrequency = frequency;
    }

    public int getRememberPurgeScale() {
        return this.mRememberPurgeScale;
    }

    public void setRememberPurgeScale(int scale) {
        this.mRememberPurgeScale = scale;
    }

    public long getRememberDuration() {
        return this.mRememberManager.getRememberDuration();
    }

    public void setRememberDuration(long milliseconds) {
        this.mRememberManager.setRememberDuration(milliseconds);
    }

    public String createRememberId(long userId, String hostIp) throws RememberManagerException {
        int purge_decision = -1;
        Random random = this.mRandom;
        synchronized (random) {
            purge_decision = this.mRandom.nextInt(this.mRememberPurgeScale);
        }
        if (purge_decision <= this.mRememberPurgeFrequency) {
            this.purgeRememberIds();
        }
        return this.mRememberManager.createRememberId(userId, hostIp);
    }

    public boolean eraseRememberId(String rememberId) throws RememberManagerException {
        return this.mRememberManager.eraseRememberId(rememberId);
    }

    public boolean eraseUserRememberIds(long userId) throws RememberManagerException {
        return this.mRememberManager.eraseUserRememberIds(userId);
    }

    public void eraseAllRememberIds() throws RememberManagerException {
        this.mRememberManager.eraseAllRememberIds();
    }

    public long getRememberedUserId(String rememberId) throws RememberManagerException {
        return this.mRememberManager.getRememberedUserId(rememberId);
    }

    public void purgeRememberIds() throws RememberManagerException {
        this.mRememberManager.purgeRememberIds();
    }
}

