/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsersFactory;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.authentication.elements.exceptions.UnknownCredentialsClassException;
import com.uwyn.rife.authentication.elements.exceptions.UnknownDatasourceException;
import com.uwyn.rife.authentication.elements.exceptions.UnsupportedEncryptionException;
import com.uwyn.rife.authentication.remembermanagers.DatabaseRemember;
import com.uwyn.rife.authentication.remembermanagers.DatabaseRememberFactory;
import com.uwyn.rife.authentication.remembermanagers.PurgingRememberManager;
import com.uwyn.rife.authentication.sessionmanagers.DatabaseSessions;
import com.uwyn.rife.authentication.sessionmanagers.DatabaseSessionsFactory;
import com.uwyn.rife.authentication.sessionmanagers.PurgingSessionManager;
import com.uwyn.rife.authentication.sessionvalidators.DatabaseSessionValidator;
import com.uwyn.rife.authentication.sessionvalidators.DatabaseSessionValidatorFactory;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.StringEncryptor;

public class PurgingDatabaseAuthenticatedDeployer
extends AuthenticatedDeployer {
    public void deploy() {
        if (!this.getElementInfo().hasProperty("credentials_class")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "credentials_class");
        }
        if (!this.getElementInfo().hasProperty("datasource")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "datasource");
        }
        String credentials_class_name = this.getElementInfo().getPropertyString("credentials_class");
        Class<?> credentials_class = null;
        try {
            credentials_class = Class.forName(credentials_class_name);
            this.setCredentialsClass(credentials_class);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownCredentialsClassException(credentials_class_name, e);
        }
        String datasource_name = this.getElementInfo().getPropertyString("datasource");
        Datasource datasource = Datasources.getRepInstance().getDatasource(datasource_name);
        if (datasource == null) {
            throw new UnknownDatasourceException(datasource_name);
        }
        DatabaseSessions session_manager = DatabaseSessionsFactory.getInstance(datasource);
        PurgingSessionManager purging_session_manager = new PurgingSessionManager(session_manager);
        DatabaseRemember remember_manager = DatabaseRememberFactory.getInstance(datasource);
        PurgingRememberManager purging_remember_manager = new PurgingRememberManager(remember_manager);
        DatabaseSessionValidator validator = null;
        DatabaseUsers credentials_manager = null;
        if (this.getElementInfo().hasProperty("credentialsmanager_id")) {
            String credentialsmanager_id = this.getElementInfo().getPropertyString("credentialsmanager_id");
            validator = DatabaseSessionValidatorFactory.getInstance(datasource, credentialsmanager_id);
            credentials_manager = DatabaseUsersFactory.getInstance(datasource, credentialsmanager_id);
        } else {
            validator = DatabaseSessionValidatorFactory.getInstance(datasource);
            credentials_manager = DatabaseUsersFactory.getInstance(datasource);
        }
        validator.setCredentialsManager(credentials_manager);
        validator.setSessionManager(purging_session_manager);
        validator.setRememberManager(purging_remember_manager);
        this.setSessionValidator(validator);
        if (!this.getElementInfo().isPropertyEmpty("password_encryption")) {
            String encryption = this.getElementInfo().getPropertyString("password_encryption");
            StringEncryptor encryptor = StringEncryptor.getEncryptor(encryption);
            if (encryptor == null) {
                throw new UnsupportedEncryptionException(encryption);
            }
            credentials_manager.setPasswordEncryptor(encryptor);
        }
        if (!this.getElementInfo().isPropertyEmpty("session_duration")) {
            session_manager.setSessionDuration(Convert.toLong(this.getElementInfo().getProperty("session_duration"), 0L));
        }
        if (!this.getElementInfo().isPropertyEmpty("session_purge_frequency")) {
            purging_session_manager.setSessionPurgeFrequency(Convert.toInt(this.getElementInfo().getProperty("session_purge_frequency"), 0));
        }
        if (!this.getElementInfo().isPropertyEmpty("session_purge_scale")) {
            purging_session_manager.setSessionPurgeScale(Convert.toInt(this.getElementInfo().getProperty("session_purge_scale"), 0));
        }
        if (!this.getElementInfo().isPropertyEmpty("remember_duration")) {
            remember_manager.setRememberDuration(Convert.toLong(this.getElementInfo().getProperty("remember_duration"), 0L));
        }
        if (!this.getElementInfo().isPropertyEmpty("remember_purge_frequency")) {
            purging_remember_manager.setRememberPurgeFrequency(Convert.toInt(this.getElementInfo().getProperty("remember_purge_frequency"), 0));
        }
        if (!this.getElementInfo().isPropertyEmpty("remember_purge_scale")) {
            purging_remember_manager.setRememberPurgeScale(Convert.toInt(this.getElementInfo().getProperty("remember_purge_scale"), 0));
        }
    }
}

