/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.credentialsmanagers.MemoryUsers;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.authentication.elements.exceptions.UnknownCredentialsClassException;
import com.uwyn.rife.authentication.elements.exceptions.UnsupportedEncryptionException;
import com.uwyn.rife.authentication.sessionmanagers.MemorySessions;
import com.uwyn.rife.authentication.sessionmanagers.MemorySessionsFactory;
import com.uwyn.rife.authentication.sessionvalidators.MemorySessionValidator;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.StringEncryptor;

public class MemoryAuthenticatedDeployer
extends AuthenticatedDeployer {
    public void deploy() {
        if (!this.getElementInfo().hasProperty("credentials_class")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "credentials_class");
        }
        if (!this.getElementInfo().hasProperty("sessionmanager_id")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "sessionmanager_id");
        }
        String credentials_class_name = this.getElementInfo().getPropertyString("credentials_class");
        Class<?> credentials_class = null;
        try {
            credentials_class = Class.forName(credentials_class_name);
            this.setCredentialsClass(credentials_class);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownCredentialsClassException(credentials_class_name, e);
        }
        String sessionmanager_id = this.getElementInfo().getPropertyString("sessionmanager_id", "");
        MemorySessions session_manager = MemorySessionsFactory.getInstance(sessionmanager_id);
        MemorySessionValidator validator = new MemorySessionValidator();
        MemoryUsers credentials_manager = MemoryUsers.getRepInstance();
        validator.setCredentialsManager(credentials_manager);
        validator.setSessionManager(session_manager);
        validator.setRememberManager(null);
        this.setSessionValidator(validator);
        if (!this.getElementInfo().isPropertyEmpty("password_encryption")) {
            String encryption = this.getElementInfo().getPropertyString("password_encryption");
            StringEncryptor encryptor = StringEncryptor.getEncryptor(encryption);
            if (encryptor == null) {
                throw new UnsupportedEncryptionException(encryption);
            }
            credentials_manager.setPasswordEncryptor(encryptor);
        } else {
            credentials_manager.setPasswordEncryptor(null);
        }
        if (!this.getElementInfo().isPropertyEmpty("session_duration")) {
            session_manager.setSessionDuration(Convert.toLong(this.getElementInfo().getProperty("session_duration"), 0L));
        }
    }
}

