/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsersFactory;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.authentication.elements.exceptions.UnknownCredentialsClassException;
import com.uwyn.rife.authentication.elements.exceptions.UnknownDatasourceException;
import com.uwyn.rife.authentication.elements.exceptions.UnsupportedEncryptionException;
import com.uwyn.rife.authentication.remembermanagers.DatabaseRemember;
import com.uwyn.rife.authentication.remembermanagers.DatabaseRememberFactory;
import com.uwyn.rife.authentication.sessionmanagers.DatabaseSessions;
import com.uwyn.rife.authentication.sessionmanagers.DatabaseSessionsFactory;
import com.uwyn.rife.authentication.sessionvalidators.DatabaseSessionValidator;
import com.uwyn.rife.authentication.sessionvalidators.DatabaseSessionValidatorFactory;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.StringEncryptor;

public class DatabaseAuthenticatedDeployer
extends AuthenticatedDeployer {
    public void deploy() {
        if (!this.getElementInfo().hasProperty("credentials_class")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "credentials_class");
        }
        if (!this.getElementInfo().hasProperty("datasource")) {
            throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "datasource");
        }
        String credentials_class_name = this.getElementInfo().getPropertyString("credentials_class");
        Class<?> credentials_class = null;
        try {
            credentials_class = Class.forName(credentials_class_name);
            this.setCredentialsClass(credentials_class);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownCredentialsClassException(credentials_class_name, e);
        }
        String datasource_name = this.getElementInfo().getPropertyString("datasource");
        Datasource datasource = Datasources.getRepInstance().getDatasource(datasource_name);
        if (datasource == null) {
            throw new UnknownDatasourceException(datasource_name);
        }
        DatabaseSessions session_manager = DatabaseSessionsFactory.getInstance(datasource);
        DatabaseSessionValidator validator = null;
        DatabaseUsers credentials_manager = null;
        DatabaseRemember remember_manager = DatabaseRememberFactory.getInstance(datasource);
        if (this.getElementInfo().hasProperty("credentialsmanager_id")) {
            String credentialsmanager_id = this.getElementInfo().getPropertyString("credentialsmanager_id");
            validator = DatabaseSessionValidatorFactory.getInstance(datasource, credentialsmanager_id);
            credentials_manager = DatabaseUsersFactory.getInstance(datasource, credentialsmanager_id);
        } else {
            validator = DatabaseSessionValidatorFactory.getInstance(datasource);
            credentials_manager = DatabaseUsersFactory.getInstance(datasource);
        }
        validator.setCredentialsManager(credentials_manager);
        validator.setSessionManager(session_manager);
        validator.setRememberManager(remember_manager);
        this.setSessionValidator(validator);
        if (!this.getElementInfo().isPropertyEmpty("password_encryption")) {
            String encryption = this.getElementInfo().getPropertyString("password_encryption");
            StringEncryptor encryptor = StringEncryptor.getEncryptor(encryption);
            if (encryptor == null) {
                throw new UnsupportedEncryptionException(encryption);
            }
            credentials_manager.setPasswordEncryptor(encryptor);
        }
        if (!this.getElementInfo().isPropertyEmpty("session_duration")) {
            session_manager.setSessionDuration(Convert.toLong(this.getElementInfo().getProperty("session_duration"), 0L));
        }
    }
}

