/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.Credentials;
import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.SessionAttributes;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.SessionValidator;
import com.uwyn.rife.authentication.credentials.RememberMe;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.authentication.elements.Identified;
import com.uwyn.rife.authentication.elements.exceptions.UndefinedAuthenticationRememberManagerException;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.authentication.exceptions.RememberManagerException;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.authentication.exceptions.SessionValidatorException;
import com.uwyn.rife.engine.ElementDeployer;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.engine.exceptions.UnsupportedTemplateTypeException;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.site.ValidationFormatter;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.Convert;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Authenticated
extends Identified
implements SessionAttributes {
    protected String mTemplateName = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected Authenticated() {
    }

    public String getAuthenticatedElementId() {
        return this.getElementInfo().getId();
    }

    @Override
    public ElementInfo getAuthElement() {
        return this.getElementInfo();
    }

    public Class<Credentials> getCredentialsClass() {
        ElementDeployer deployer = this.getDeployer();
        if (deployer instanceof AuthenticatedDeployer) {
            return ((AuthenticatedDeployer)deployer).getCredentialsClass();
        }
        return null;
    }

    public SessionValidator getSessionValidator() {
        ElementDeployer deployer = this.getDeployer();
        if (deployer instanceof AuthenticatedDeployer) {
            return ((AuthenticatedDeployer)deployer).getSessionValidator();
        }
        return null;
    }

    protected void setTemplateName(String name) {
        this.mTemplateName = name;
    }

    protected void initializeAuthentication() {
    }

    protected void entrance(Template template2) {
    }

    protected void unvalidatedCredentials(Template template2, Credentials credentials) {
    }

    protected void validatedCredentials(Credentials credentials) {
    }

    protected void acceptedCredentials(Credentials credentials) {
    }

    protected void authenticated(long userId) {
    }

    protected void refusedCredentials(Template template2, Credentials credentials) {
        if (template2.hasValueId("error_area")) {
            String message = null;
            message = template2.hasBlock("INVALID_CREDENTIALS") ? template2.getBlock("INVALID_CREDENTIALS") : "INVALID_CREDENTIALS";
            ValidationFormatter.setErrorArea(template2, message);
        } else {
            credentials.addValidationError(new ValidationError.INVALID("credentials"));
        }
    }

    protected void sessionCreationError(Template template2, Credentials credentials) {
        if (template2.hasValueId("error_area")) {
            String message = null;
            message = template2.hasBlock("CANT_CREATE_SESSION") ? template2.getBlock("CANT_CREATE_SESSION") : "CANT_CREATE_SESSION";
            ValidationFormatter.setErrorArea(template2, message);
        } else {
            credentials.addValidationError(new ValidationError.UNEXPECTED("sessioncreation"));
        }
    }

    protected void sessionNotValid(String childTriggerName, String[] childTriggerValues, int validityId) {
    }

    private Template getTemplateInstance(String type, String name, String encoding) {
        TemplateFactory template_factory = TemplateFactory.getFactory(type);
        if (template_factory == null) {
            throw new UnsupportedTemplateTypeException(type);
        }
        Template template2 = template_factory.get(name, encoding, null);
        this.entrance(template2);
        return template2;
    }

    @Override
    public void processElement() {
        Template template2;
        Class<Credentials> credentials_class = this.getCredentialsClass();
        SessionValidator session_validator = this.getSessionValidator();
        if (!$assertionsDisabled && credentials_class == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && session_validator == null) {
            throw new AssertionError();
        }
        this.initializeAuthentication();
        if (!this.hasProperty("template_name") && this.mTemplateName == null) {
            throw new PropertyRequiredException(this.getDeclarationName(), "template_name");
        }
        if (!this.hasProperty("submission_name")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "submission_name");
        }
        if (!this.hasProperty("authvar_name")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "authvar_name");
        }
        if (!this.hasProperty("authvar_type")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "authvar_type");
        }
        if (!this.hasProperty("remembervar_name")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "remembervar_name");
        }
        if (!this.hasProperty("prohibit_remember")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "prohibit_remember");
        }
        String template_type = null;
        template_type = this.hasProperty("template_type") ? this.getPropertyString("template_type") : "enginehtml";
        String template_encoding = null;
        if (this.hasProperty("template_encoding")) {
            template_encoding = this.getPropertyString("template_encoding");
        }
        String template_name = null;
        template_name = this.mTemplateName != null ? this.mTemplateName : this.getPropertyString("template_name");
        String rememberid = null;
        String remembervar_name = this.getPropertyString("remembervar_name");
        if (this.getElementInfo().containsIncookie(remembervar_name) && this.hasCookie(remembervar_name)) {
            Cookie remembercookie = this.getCookie(remembervar_name);
            rememberid = remembercookie.getValue();
        }
        if (rememberid != null) {
            long userid = -1;
            try {
                RememberManager remember_manager = session_validator.getRememberManager();
                if (remember_manager == null) {
                    throw new UndefinedAuthenticationRememberManagerException();
                }
                userid = remember_manager.getRememberedUserId(rememberid);
                remember_manager.eraseRememberId(rememberid);
            }
            catch (RememberManagerException e) {
                throw new EngineException(e);
            }
            if (userid != (long)-1) {
                this.startNewSession(userid, true, true);
            }
        }
        if (this.hasSubmission(this.getPropertyString("submission_name"))) {
            Credentials credentials = this.getSubmissionBean(this.getPropertyString("submission_name"), credentials_class);
            if (!credentials.validate()) {
                template2 = this.getTemplateInstance(template_type, template_name, template_encoding);
                this.unvalidatedCredentials(template2, credentials);
                if (template2.hasValueId("error_area")) {
                    ValidationFormatter.setValidationErrors(template2, credentials.getValidationErrors());
                }
                this.generateForm(template2, credentials);
            } else {
                this.validatedCredentials(credentials);
                long userid = -1;
                try {
                    userid = session_validator.getCredentialsManager().verifyCredentials(credentials);
                }
                catch (CredentialsManagerException e) {
                    throw new EngineException(e);
                }
                if (userid >= (long)0) {
                    this.acceptedCredentials(credentials);
                    boolean remember = false;
                    if (credentials instanceof RememberMe) {
                        remember = ((RememberMe)((Object)credentials)).getRemember();
                    }
                    if (!this.startNewSession(userid, remember, false)) {
                        template2 = this.getTemplateInstance(template_type, template_name, template_encoding);
                        this.sessionCreationError(template2, credentials);
                    } else {
                        template2 = this.getTemplateInstance(template_type, template_name, template_encoding);
                    }
                } else {
                    template2 = this.getTemplateInstance(template_type, template_name, template_encoding);
                }
                this.refusedCredentials(template2, credentials);
                this.generateForm(template2, credentials);
            }
        } else {
            template2 = this.getTemplateInstance(template_type, template_name, template_encoding);
            this.generateEmptyForm(template2, credentials_class);
        }
        this.print(template2);
    }

    private boolean startNewSession(long userid, boolean remember, boolean remembered) {
        if (remember) {
            String rememberid = null;
            try {
                RememberManager remember_manager = this.getSessionValidator().getRememberManager();
                if (remember_manager == null) {
                    throw new UndefinedAuthenticationRememberManagerException();
                }
                rememberid = remember_manager.createRememberId(userid, this.getRemoteAddr());
            }
            catch (RememberManagerException e) {
                throw new EngineException(e);
            }
            if (rememberid != null) {
                Cookie remembercookie = new Cookie(this.getPropertyString("remembervar_name"), rememberid);
                remembercookie.setPath("/");
                remembercookie.setMaxAge(7776000);
                this.setCookie(remembercookie);
            }
        }
        String authid = null;
        try {
            authid = this.getSessionValidator().getSessionManager().startSession(userid, this.getRemoteAddr(), remembered);
        }
        catch (SessionManagerException e) {
            throw new EngineException(e);
        }
        if (authid == null) {
            return false;
        }
        this.authenticated(userid);
        if (this.getPropertyString("authvar_type").equals("input")) {
            this.setOutput(this.getPropertyString("authvar_name"), authid);
        } else if (this.getPropertyString("authvar_type").equals("cookie")) {
            Cookie authcookie = new Cookie(this.getPropertyString("authvar_name"), authid);
            authcookie.setPath("/");
            this.setCookie(authcookie);
        }
        return true;
    }

    @Override
    public boolean childTriggered(String name, String[] values) {
        boolean result = false;
        if (name.equals(this.getPropertyString("authvar_name"))) {
            SessionValidator session_validator = this.getSessionValidator();
            if (!$assertionsDisabled && session_validator == null) {
                throw new AssertionError();
            }
            String auth_id = values[0];
            int session_validity_id = -1;
            try {
                session_validity_id = session_validator.validateSession(auth_id, this.getRemoteAddr(), this);
            }
            catch (SessionValidatorException e) {
                throw new EngineException(e);
            }
            if (session_validator.isAccessAuthorized(session_validity_id)) {
                SessionManager session_manager = session_validator.getSessionManager();
                try {
                    if (Convert.toBoolean(this.getProperty("prohibit_remember"), false) && session_manager.wasRemembered(auth_id)) {
                        this.sessionNotValid(name, values, session_validity_id);
                    }
                    result = session_manager.continueSession(auth_id);
                }
                catch (SessionManagerException e) {
                    throw new EngineException(e);
                }
            } else {
                this.sessionNotValid(name, values, session_validity_id);
            }
        }
        if (!result) {
            return false;
        }
        this.setIdentityAttribute(name, values);
        return true;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.elements.Authenticated");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

