/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers.databasedrivers;

import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.databasedrivers.generic;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateLoginException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateRoleException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateUserIdException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.InstallCredentialsErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveCredentialsErrorException;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;

public class org_apache_derby_jdbc_EmbeddedDriver
extends generic {
    public org_apache_derby_jdbc_EmbeddedDriver(Datasource datasource) {
        super(datasource);
        this.mCreateTableRole.customAttribute("roleId", "GENERATED ALWAYS AS IDENTITY");
        this.mCreateTableRoleLink = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableRoleLink()).column("userId", Long.TYPE, CreateTable.NOTNULL).column("roleId", Integer.TYPE, CreateTable.NOTNULL).primaryKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_PK", new String[]{"userId", "roleId"}).foreignKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_UI_FK", this.mCreateTableUser.getTable(), "userId", "userId", null, CreateTable.CASCADE).foreignKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_RI_FK", this.mCreateTableRole.getTable(), "roleId", "roleId", null, CreateTable.CASCADE);
        this.mAddRole = new Insert(this.getDatasource()).into(this.mCreateTableRole.getTable()).fieldParameter("name");
        this.mGetFreeUserId = new Select(this.getDatasource()).field("CASE WHEN MAX(userId) IS NULL THEN 0 ELSE MAX(userId)+1 END AS freeUserId").from(this.mCreateTableUser.getTable());
    }

    public boolean install() {
        try {
            this.executeUpdate(this.mCreateTableRole);
            this.executeUpdate(this.mCreateTableUser);
            this.executeUpdate(this.mCreateTableRoleLink);
        }
        catch (DatabaseException e) {
            throw new InstallCredentialsErrorException(e);
        }
        return true;
    }

    public boolean remove() {
        try {
            this.executeUpdate(this.mDropTableRoleLink);
            this.executeUpdate(this.mDropTableUser);
            this.executeUpdate(this.mDropTableRole);
        }
        catch (DatabaseException e) {
            throw new RemoveCredentialsErrorException(e);
        }
        return true;
    }

    public DatabaseUsers addRole(String role) {
        if (role == null || 0 == role.length()) {
            throw new AddRoleErrorException(role);
        }
        try {
            if (0 == this.executeUpdate(this.mAddRole, new 1(role))) {
                throw new AddRoleErrorException(role);
            }
        }
        catch (DatabaseException e) {
            String message;
            if (e.getCause() != null && -1 != (message = e.getCause().getMessage().toUpperCase()).indexOf("AUTHROLE_NAME_UQ")) {
                throw new DuplicateRoleException(role);
            }
            throw new AddRoleErrorException(role, e);
        }
        return this;
    }

    public DatabaseUsers addUser(String login, RoleUserAttributes attributes) {
        try {
            this._addUser(this.mAddUserWithId, this.mGetFreeUserId, this.mGetRoleId, this.mAddRoleLink, login, attributes);
        }
        catch (CredentialsManagerException e) {
            if (e.getCause() != null && e.getCause().getCause() != null) {
                String message = e.getCause().getCause().getMessage().toUpperCase();
                if (-1 != message.indexOf("AUTHUSER_LOGIN_UQ")) {
                    throw new DuplicateLoginException(login);
                }
                if (-1 != message.indexOf("AUTHUSER_PK")) {
                    throw new DuplicateUserIdException(attributes.getUserId());
                }
            }
            throw e;
        }
        return this;
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$role;

        1(String string) {
            this.val$role = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("name", this.val$role);
        }

        static /* synthetic */ org_apache_derby_jdbc_EmbeddedDriver access$0(1 var0) {
            return var0.org_apache_derby_jdbc_EmbeddedDriver.this;
        }
    }
}

