/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers;

import com.uwyn.rife.authentication.CredentialsManager;
import com.uwyn.rife.authentication.SessionValidator;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUsersManager;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AuthenticatedElementNotFoundException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.NotAuthenticatedElementException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.NotRoleUsersManagedException;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.engine.ElementDeployer;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.Site;

public abstract class RoleUsersManagerRetriever {
    public static RoleUsersManager getRoleUsersManager(Site site, String authElementId, ElementInfo reference) {
        if (site == null) {
            throw new IllegalArgumentException("site can't be null");
        }
        if (authElementId == null) {
            throw new IllegalArgumentException("authElementId can't be null");
        }
        if (0 == authElementId.length()) {
            throw new IllegalArgumentException("authElementId can't be empty");
        }
        ElementInfo auth_elementinfo = site.resolveId(authElementId, reference);
        if (auth_elementinfo == null) {
            throw new AuthenticatedElementNotFoundException(authElementId);
        }
        ElementDeployer deployer = auth_elementinfo.getDeployer();
        if (deployer == null || !(deployer instanceof AuthenticatedDeployer)) {
            throw new NotAuthenticatedElementException(authElementId);
        }
        AuthenticatedDeployer auth_deployer = (AuthenticatedDeployer)deployer;
        SessionValidator validator = auth_deployer.getSessionValidator();
        CredentialsManager credentials = validator.getCredentialsManager();
        if (credentials == null || !(credentials instanceof RoleUsersManager)) {
            throw new NotRoleUsersManagedException(authElementId);
        }
        return (RoleUsersManager)((Object)credentials);
    }
}

