/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleUserAttributes
implements Cloneable {
    private long mUserId = -1;
    private boolean mAutomaticUserId = false;
    private String mPassword = null;
    private HashSet<String> mRoles = null;

    public RoleUserAttributes() {
    }

    public RoleUserAttributes(long userId, String password) {
        this.setUserId(userId);
        this.setPassword(password);
    }

    public RoleUserAttributes(long userId, String password, String[] roles) {
        this.setUserId(userId);
        this.setPassword(password);
        this.setRoles(roles);
    }

    public RoleUserAttributes(long userId, String password, Collection<String> roles) {
        this.setUserId(userId);
        this.setPassword(password);
        this.setRoles(roles);
    }

    public RoleUserAttributes(String password) {
        this.setPassword(password);
    }

    public RoleUserAttributes(String password, String[] roles) {
        this.setPassword(password);
        this.setRoles(roles);
    }

    public RoleUserAttributes(String password, Collection<String> roles) {
        this.setPassword(password);
        this.setRoles(roles);
    }

    public RoleUserAttributes(long userId) {
        this.setUserId(userId);
    }

    public RoleUserAttributes(long userId, String[] roles) {
        this.setUserId(userId);
        this.setRoles(roles);
    }

    public RoleUserAttributes(long userId, Collection<String> roles) {
        this.setUserId(userId);
        this.setRoles(roles);
    }

    public RoleUserAttributes(String[] roles) {
        this.setRoles(roles);
    }

    public RoleUserAttributes(Collection<String> roles) {
        this.setRoles(roles);
    }

    public void setUserId(long userId) {
        if (userId < (long)0) {
            throw new IllegalArgumentException("userId can't be negative.");
        }
        this.mUserId = userId;
    }

    public long getUserId() {
        return this.mUserId;
    }

    void setAutomaticUserId(boolean automatic) {
        this.mAutomaticUserId = automatic;
    }

    boolean isAutomaticUserId() {
        return this.mAutomaticUserId;
    }

    public void setPassword(String password) {
        if (password != null && 0 == password.length()) {
            throw new IllegalArgumentException("password can't be empty.");
        }
        this.mPassword = password;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setRoles(Collection<String> roles) {
        if (roles == null) {
            this.mRoles = null;
            return;
        }
        this.mRoles = new HashSet<String>(roles);
    }

    public void setRoles(String[] roles) {
        if (roles != null && roles.length > 0) {
            this.setRoles(new HashSet<String>(Arrays.asList(roles)));
        }
    }

    public void addRole(String role) {
        if (this.mRoles == null) {
            this.mRoles = new HashSet();
        }
        this.mRoles.add(role);
    }

    public Collection<String> getRoles() {
        if (this.mRoles == null) {
            this.mRoles = new HashSet();
        }
        return this.mRoles;
    }

    public boolean isInRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException("role can't be null.");
        }
        if (0 == role.length()) {
            throw new IllegalArgumentException("role can't be empty.");
        }
        if (this.mRoles == null) {
            return false;
        }
        return this.mRoles.contains(role);
    }

    public boolean isValid(String password) {
        if (password == null) {
            throw new IllegalArgumentException("password can't be null.");
        }
        if (0 == password.length()) {
            throw new IllegalArgumentException("password can't be empty.");
        }
        return this.mPassword != null && password.equals(this.mPassword);
    }

    public boolean isValid(String password, String role) {
        return this.isValid(password) && this.isInRole(role);
    }

    public synchronized RoleUserAttributes clone() {
        RoleUserAttributes new_attributes = null;
        try {
            new_attributes = (RoleUserAttributes)super.clone();
            if (this.mRoles != null) {
                new_attributes.mRoles = new HashSet<String>(this.mRoles);
            }
        }
        catch (CloneNotSupportedException e) {
            new_attributes = null;
        }
        return new_attributes;
    }

    public synchronized /* synthetic */ Object clone() {
        return this.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoleUserAttributes)) {
            return false;
        }
        RoleUserAttributes other_attributes = (RoleUserAttributes)other;
        if (this.getUserId() != other_attributes.getUserId()) {
            return false;
        }
        if (!this.getPassword().equals(other_attributes.getPassword())) {
            return false;
        }
        Collection<String> roles = this.getRoles();
        Collection<String> other_roles = other_attributes.getRoles();
        if (roles != null || other_roles != null) {
            if (roles == null || other_roles == null) {
                return false;
            }
            if (roles.size() != other_roles.size()) {
                return false;
            }
            for (String role : roles) {
                if (other_roles.contains(role)) continue;
                return false;
            }
        }
        return true;
    }
}

